/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFargateProfileResponse extends EksResponse implements
        ToCopyableBuilder<DeleteFargateProfileResponse.Builder, DeleteFargateProfileResponse> {
    private static final SdkField<FargateProfile> FARGATE_PROFILE_FIELD = SdkField
            .<FargateProfile> builder(MarshallingType.SDK_POJO).memberName("fargateProfile")
            .getter(getter(DeleteFargateProfileResponse::fargateProfile)).setter(setter(Builder::fargateProfile))
            .constructor(FargateProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FargateProfile fargateProfile;

    private DeleteFargateProfileResponse(BuilderImpl builder) {
        super(builder);
        this.fargateProfile = builder.fargateProfile;
    }

    /**
     * <p>
     * The deleted Fargate profile.
     * </p>
     * 
     * @return The deleted Fargate profile.
     */
    public final FargateProfile fargateProfile() {
        return fargateProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFargateProfileResponse)) {
            return false;
        }
        DeleteFargateProfileResponse other = (DeleteFargateProfileResponse) obj;
        return Objects.equals(fargateProfile(), other.fargateProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFargateProfileResponse").add("FargateProfile", fargateProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fargateProfile":
            return Optional.ofNullable(clazz.cast(fargateProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fargateProfile", FARGATE_PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFargateProfileResponse, T> g) {
        return obj -> g.apply((DeleteFargateProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFargateProfileResponse> {
        /**
         * <p>
         * The deleted Fargate profile.
         * </p>
         * 
         * @param fargateProfile
         *        The deleted Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfile(FargateProfile fargateProfile);

        /**
         * <p>
         * The deleted Fargate profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link FargateProfile.Builder} avoiding the need
         * to create one manually via {@link FargateProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FargateProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #fargateProfile(FargateProfile)}.
         * 
         * @param fargateProfile
         *        a consumer that will call methods on {@link FargateProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fargateProfile(FargateProfile)
         */
        default Builder fargateProfile(Consumer<FargateProfile.Builder> fargateProfile) {
            return fargateProfile(FargateProfile.builder().applyMutation(fargateProfile).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private FargateProfile fargateProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFargateProfileResponse model) {
            super(model);
            fargateProfile(model.fargateProfile);
        }

        public final FargateProfile.Builder getFargateProfile() {
            return fargateProfile != null ? fargateProfile.toBuilder() : null;
        }

        public final void setFargateProfile(FargateProfile.BuilderImpl fargateProfile) {
            this.fargateProfile = fargateProfile != null ? fargateProfile.build() : null;
        }

        @Override
        public final Builder fargateProfile(FargateProfile fargateProfile) {
            this.fargateProfile = fargateProfile;
            return this;
        }

        @Override
        public DeleteFargateProfileResponse build() {
            return new DeleteFargateProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
