/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterVersionsRequest extends EksRequest implements
        ToCopyableBuilder<DescribeClusterVersionsRequest.Builder, DescribeClusterVersionsRequest> {
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(DescribeClusterVersionsRequest::clusterType))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeClusterVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeClusterVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultOnly").getter(getter(DescribeClusterVersionsRequest::defaultOnly))
            .setter(setter(Builder::defaultOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("defaultOnly").build()).build();

    private static final SdkField<Boolean> INCLUDE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeAll").getter(getter(DescribeClusterVersionsRequest::includeAll))
            .setter(setter(Builder::includeAll))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeAll").build()).build();

    private static final SdkField<List<String>> CLUSTER_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clusterVersions")
            .getter(getter(DescribeClusterVersionsRequest::clusterVersions))
            .setter(setter(Builder::clusterVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeClusterVersionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_TYPE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DEFAULT_ONLY_FIELD, INCLUDE_ALL_FIELD, CLUSTER_VERSIONS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterType;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean defaultOnly;

    private final Boolean includeAll;

    private final List<String> clusterVersions;

    private final String status;

    private DescribeClusterVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterType = builder.clusterType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.defaultOnly = builder.defaultOnly;
        this.includeAll = builder.includeAll;
        this.clusterVersions = builder.clusterVersions;
        this.status = builder.status;
    }

    /**
     * <p>
     * The type of cluster to filter versions by.
     * </p>
     * 
     * @return The type of cluster to filter versions by.
     */
    public final String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * Maximum number of results to return.
     * </p>
     * 
     * @return Maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Pagination token for the next set of results.
     * </p>
     * 
     * @return Pagination token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filter to show only default versions.
     * </p>
     * 
     * @return Filter to show only default versions.
     */
    public final Boolean defaultOnly() {
        return defaultOnly;
    }

    /**
     * <p>
     * Include all available versions in the response.
     * </p>
     * 
     * @return Include all available versions in the response.
     */
    public final Boolean includeAll() {
        return includeAll;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterVersions() {
        return clusterVersions != null && !(clusterVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of specific cluster versions to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterVersions} method.
     * </p>
     * 
     * @return List of specific cluster versions to describe.
     */
    public final List<String> clusterVersions() {
        return clusterVersions;
    }

    /**
     * <p>
     * Filter versions by their current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter versions by their current status.
     * @see ClusterVersionStatus
     */
    public final ClusterVersionStatus status() {
        return ClusterVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * Filter versions by their current status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter versions by their current status.
     * @see ClusterVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOnly());
        hashCode = 31 * hashCode + Objects.hashCode(includeAll());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterVersions() ? clusterVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsRequest)) {
            return false;
        }
        DescribeClusterVersionsRequest other = (DescribeClusterVersionsRequest) obj;
        return Objects.equals(clusterType(), other.clusterType()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(defaultOnly(), other.defaultOnly())
                && Objects.equals(includeAll(), other.includeAll()) && hasClusterVersions() == other.hasClusterVersions()
                && Objects.equals(clusterVersions(), other.clusterVersions())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterVersionsRequest").add("ClusterType", clusterType())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("DefaultOnly", defaultOnly())
                .add("IncludeAll", includeAll()).add("ClusterVersions", hasClusterVersions() ? clusterVersions() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "defaultOnly":
            return Optional.ofNullable(clazz.cast(defaultOnly()));
        case "includeAll":
            return Optional.ofNullable(clazz.cast(includeAll()));
        case "clusterVersions":
            return Optional.ofNullable(clazz.cast(clusterVersions()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("defaultOnly", DEFAULT_ONLY_FIELD);
        map.put("includeAll", INCLUDE_ALL_FIELD);
        map.put("clusterVersions", CLUSTER_VERSIONS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsRequest, T> g) {
        return obj -> g.apply((DescribeClusterVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterVersionsRequest> {
        /**
         * <p>
         * The type of cluster to filter versions by.
         * </p>
         * 
         * @param clusterType
         *        The type of cluster to filter versions by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Pagination token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filter to show only default versions.
         * </p>
         * 
         * @param defaultOnly
         *        Filter to show only default versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOnly(Boolean defaultOnly);

        /**
         * <p>
         * Include all available versions in the response.
         * </p>
         * 
         * @param includeAll
         *        Include all available versions in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAll(Boolean includeAll);

        /**
         * <p>
         * List of specific cluster versions to describe.
         * </p>
         * 
         * @param clusterVersions
         *        List of specific cluster versions to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersions(Collection<String> clusterVersions);

        /**
         * <p>
         * List of specific cluster versions to describe.
         * </p>
         * 
         * @param clusterVersions
         *        List of specific cluster versions to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersions(String... clusterVersions);

        /**
         * <p>
         * Filter versions by their current status.
         * </p>
         * 
         * @param status
         *        Filter versions by their current status.
         * @see ClusterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filter versions by their current status.
         * </p>
         * 
         * @param status
         *        Filter versions by their current status.
         * @see ClusterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterVersionStatus
         */
        Builder status(ClusterVersionStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterType;

        private Integer maxResults;

        private String nextToken;

        private Boolean defaultOnly;

        private Boolean includeAll;

        private List<String> clusterVersions = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsRequest model) {
            super(model);
            clusterType(model.clusterType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            defaultOnly(model.defaultOnly);
            includeAll(model.includeAll);
            clusterVersions(model.clusterVersions);
            status(model.status);
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDefaultOnly() {
            return defaultOnly;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final Boolean getIncludeAll() {
            return includeAll;
        }

        public final void setIncludeAll(Boolean includeAll) {
            this.includeAll = includeAll;
        }

        @Override
        public final Builder includeAll(Boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public final Collection<String> getClusterVersions() {
            if (clusterVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return clusterVersions;
        }

        public final void setClusterVersions(Collection<String> clusterVersions) {
            this.clusterVersions = StringListCopier.copy(clusterVersions);
        }

        @Override
        public final Builder clusterVersions(Collection<String> clusterVersions) {
            this.clusterVersions = StringListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(String... clusterVersions) {
            clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterVersionsRequest build() {
            return new DescribeClusterVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
