/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfig.Builder, EncryptionConfig> {
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(EncryptionConfig::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Provider> PROVIDER_FIELD = SdkField.<Provider> builder(MarshallingType.SDK_POJO)
            .memberName("provider").getter(getter(EncryptionConfig::provider)).setter(setter(Builder::provider))
            .constructor(Provider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD,
            PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> resources;

    private final Provider provider;

    private EncryptionConfig(BuilderImpl builder) {
        this.resources = builder.resources;
        this.provider = builder.provider;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * Key Management Service (KMS) key. Either the ARN or the alias can be used.
     * </p>
     * 
     * @return Key Management Service (KMS) key. Either the ARN or the alias can be used.
     */
    public final Provider provider() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfig)) {
            return false;
        }
        EncryptionConfig other = (EncryptionConfig) obj;
        return hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(provider(), other.provider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfig").add("Resources", hasResources() ? resources() : null)
                .add("Provider", provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resources", RESOURCES_FIELD);
        map.put("provider", PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfig, T> g) {
        return obj -> g.apply((EncryptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfig> {
        /**
         * <p>
         * Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
         * </p>
         * 
         * @param resources
         *        Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
         * </p>
         * 
         * @param resources
         *        Specifies the resources to be encrypted. The only supported value is <code>secrets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * Key Management Service (KMS) key. Either the ARN or the alias can be used.
         * </p>
         * 
         * @param provider
         *        Key Management Service (KMS) key. Either the ARN or the alias can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(Provider provider);

        /**
         * <p>
         * Key Management Service (KMS) key. Either the ARN or the alias can be used.
         * </p>
         * This is a convenience method that creates an instance of the {@link Provider.Builder} avoiding the need to
         * create one manually via {@link Provider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Provider.Builder#build()} is called immediately and its result is
         * passed to {@link #provider(Provider)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link Provider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(Provider)
         */
        default Builder provider(Consumer<Provider.Builder> provider) {
            return provider(Provider.builder().applyMutation(provider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private Provider provider;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfig model) {
            resources(model.resources);
            provider(model.provider);
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = StringListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final Provider.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        public final void setProvider(Provider.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        public final Builder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public EncryptionConfig build() {
            return new EncryptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
