/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summarized description of the insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightSummary implements SdkPojo, Serializable, ToCopyableBuilder<InsightSummary.Builder, InsightSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(InsightSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(InsightSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(InsightSummary::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> KUBERNETES_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kubernetesVersion").getter(getter(InsightSummary::kubernetesVersion))
            .setter(setter(Builder::kubernetesVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesVersion").build()).build();

    private static final SdkField<Instant> LAST_REFRESH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRefreshTime").getter(getter(InsightSummary::lastRefreshTime))
            .setter(setter(Builder::lastRefreshTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTime").build()).build();

    private static final SdkField<Instant> LAST_TRANSITION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastTransitionTime").getter(getter(InsightSummary::lastTransitionTime))
            .setter(setter(Builder::lastTransitionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTransitionTime").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(InsightSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<InsightStatus> INSIGHT_STATUS_FIELD = SdkField
            .<InsightStatus> builder(MarshallingType.SDK_POJO).memberName("insightStatus")
            .getter(getter(InsightSummary::insightStatus)).setter(setter(Builder::insightStatus))
            .constructor(InsightStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insightStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CATEGORY_FIELD, KUBERNETES_VERSION_FIELD, LAST_REFRESH_TIME_FIELD, LAST_TRANSITION_TIME_FIELD, DESCRIPTION_FIELD,
            INSIGHT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String category;

    private final String kubernetesVersion;

    private final Instant lastRefreshTime;

    private final Instant lastTransitionTime;

    private final String description;

    private final InsightStatus insightStatus;

    private InsightSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.category = builder.category;
        this.kubernetesVersion = builder.kubernetesVersion;
        this.lastRefreshTime = builder.lastRefreshTime;
        this.lastTransitionTime = builder.lastTransitionTime;
        this.description = builder.description;
        this.insightStatus = builder.insightStatus;
    }

    /**
     * <p>
     * The ID of the insight.
     * </p>
     * 
     * @return The ID of the insight.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the insight.
     * </p>
     * 
     * @return The name of the insight.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The category of the insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the insight.
     * @see Category
     */
    public final Category category() {
        return Category.fromValue(category);
    }

    /**
     * <p>
     * The category of the insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link Category#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the insight.
     * @see Category
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The Kubernetes minor version associated with an insight if applicable.
     * </p>
     * 
     * @return The Kubernetes minor version associated with an insight if applicable.
     */
    public final String kubernetesVersion() {
        return kubernetesVersion;
    }

    /**
     * <p>
     * The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
     * </p>
     * 
     * @return The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
     */
    public final Instant lastRefreshTime() {
        return lastRefreshTime;
    }

    /**
     * <p>
     * The time the status of the insight last changed.
     * </p>
     * 
     * @return The time the status of the insight last changed.
     */
    public final Instant lastTransitionTime() {
        return lastTransitionTime;
    }

    /**
     * <p>
     * The description of the insight which includes alert criteria, remediation recommendation, and additional
     * resources (contains Markdown).
     * </p>
     * 
     * @return The description of the insight which includes alert criteria, remediation recommendation, and additional
     *         resources (contains Markdown).
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object containing more detail on the status of the insight.
     * </p>
     * 
     * @return An object containing more detail on the status of the insight.
     */
    public final InsightStatus insightStatus() {
        return insightStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastRefreshTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastTransitionTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(insightStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightSummary)) {
            return false;
        }
        InsightSummary other = (InsightSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(kubernetesVersion(), other.kubernetesVersion())
                && Objects.equals(lastRefreshTime(), other.lastRefreshTime())
                && Objects.equals(lastTransitionTime(), other.lastTransitionTime())
                && Objects.equals(description(), other.description()) && Objects.equals(insightStatus(), other.insightStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightSummary").add("Id", id()).add("Name", name()).add("Category", categoryAsString())
                .add("KubernetesVersion", kubernetesVersion()).add("LastRefreshTime", lastRefreshTime())
                .add("LastTransitionTime", lastTransitionTime()).add("Description", description())
                .add("InsightStatus", insightStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "kubernetesVersion":
            return Optional.ofNullable(clazz.cast(kubernetesVersion()));
        case "lastRefreshTime":
            return Optional.ofNullable(clazz.cast(lastRefreshTime()));
        case "lastTransitionTime":
            return Optional.ofNullable(clazz.cast(lastTransitionTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "insightStatus":
            return Optional.ofNullable(clazz.cast(insightStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("kubernetesVersion", KUBERNETES_VERSION_FIELD);
        map.put("lastRefreshTime", LAST_REFRESH_TIME_FIELD);
        map.put("lastTransitionTime", LAST_TRANSITION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("insightStatus", INSIGHT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightSummary, T> g) {
        return obj -> g.apply((InsightSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightSummary> {
        /**
         * <p>
         * The ID of the insight.
         * </p>
         * 
         * @param id
         *        The ID of the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the insight.
         * </p>
         * 
         * @param name
         *        The name of the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The category of the insight.
         * </p>
         * 
         * @param category
         *        The category of the insight.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the insight.
         * </p>
         * 
         * @param category
         *        The category of the insight.
         * @see Category
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Category
         */
        Builder category(Category category);

        /**
         * <p>
         * The Kubernetes minor version associated with an insight if applicable.
         * </p>
         * 
         * @param kubernetesVersion
         *        The Kubernetes minor version associated with an insight if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesVersion(String kubernetesVersion);

        /**
         * <p>
         * The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
         * </p>
         * 
         * @param lastRefreshTime
         *        The time Amazon EKS last successfully completed a refresh of this insight check on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRefreshTime(Instant lastRefreshTime);

        /**
         * <p>
         * The time the status of the insight last changed.
         * </p>
         * 
         * @param lastTransitionTime
         *        The time the status of the insight last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTransitionTime(Instant lastTransitionTime);

        /**
         * <p>
         * The description of the insight which includes alert criteria, remediation recommendation, and additional
         * resources (contains Markdown).
         * </p>
         * 
         * @param description
         *        The description of the insight which includes alert criteria, remediation recommendation, and
         *        additional resources (contains Markdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object containing more detail on the status of the insight.
         * </p>
         * 
         * @param insightStatus
         *        An object containing more detail on the status of the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightStatus(InsightStatus insightStatus);

        /**
         * <p>
         * An object containing more detail on the status of the insight.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightStatus.Builder} avoiding the need
         * to create one manually via {@link InsightStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #insightStatus(InsightStatus)}.
         * 
         * @param insightStatus
         *        a consumer that will call methods on {@link InsightStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightStatus(InsightStatus)
         */
        default Builder insightStatus(Consumer<InsightStatus.Builder> insightStatus) {
            return insightStatus(InsightStatus.builder().applyMutation(insightStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String category;

        private String kubernetesVersion;

        private Instant lastRefreshTime;

        private Instant lastTransitionTime;

        private String description;

        private InsightStatus insightStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightSummary model) {
            id(model.id);
            name(model.name);
            category(model.category);
            kubernetesVersion(model.kubernetesVersion);
            lastRefreshTime(model.lastRefreshTime);
            lastTransitionTime(model.lastTransitionTime);
            description(model.description);
            insightStatus(model.insightStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getKubernetesVersion() {
            return kubernetesVersion;
        }

        public final void setKubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
        }

        @Override
        public final Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            return this;
        }

        public final Instant getLastRefreshTime() {
            return lastRefreshTime;
        }

        public final void setLastRefreshTime(Instant lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
        }

        @Override
        public final Builder lastRefreshTime(Instant lastRefreshTime) {
            this.lastRefreshTime = lastRefreshTime;
            return this;
        }

        public final Instant getLastTransitionTime() {
            return lastTransitionTime;
        }

        public final void setLastTransitionTime(Instant lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
        }

        @Override
        public final Builder lastTransitionTime(Instant lastTransitionTime) {
            this.lastTransitionTime = lastTransitionTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InsightStatus.Builder getInsightStatus() {
            return insightStatus != null ? insightStatus.toBuilder() : null;
        }

        public final void setInsightStatus(InsightStatus.BuilderImpl insightStatus) {
            this.insightStatus = insightStatus != null ? insightStatus.build() : null;
        }

        @Override
        public final Builder insightStatus(InsightStatus insightStatus) {
            this.insightStatus = insightStatus;
            return this;
        }

        @Override
        public InsightSummary build() {
            return new InsightSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
