/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodegroupResponse extends EksResponse implements
        ToCopyableBuilder<CreateNodegroupResponse.Builder, CreateNodegroupResponse> {
    private static final SdkField<Nodegroup> NODEGROUP_FIELD = SdkField.<Nodegroup> builder(MarshallingType.SDK_POJO)
            .memberName("nodegroup").getter(getter(CreateNodegroupResponse::nodegroup)).setter(setter(Builder::nodegroup))
            .constructor(Nodegroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODEGROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Nodegroup nodegroup;

    private CreateNodegroupResponse(BuilderImpl builder) {
        super(builder);
        this.nodegroup = builder.nodegroup;
    }

    /**
     * <p>
     * The full description of your new node group.
     * </p>
     * 
     * @return The full description of your new node group.
     */
    public final Nodegroup nodegroup() {
        return nodegroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodegroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodegroupResponse)) {
            return false;
        }
        CreateNodegroupResponse other = (CreateNodegroupResponse) obj;
        return Objects.equals(nodegroup(), other.nodegroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodegroupResponse").add("Nodegroup", nodegroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodegroup":
            return Optional.ofNullable(clazz.cast(nodegroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodegroup", NODEGROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateNodegroupResponse, T> g) {
        return obj -> g.apply((CreateNodegroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateNodegroupResponse> {
        /**
         * <p>
         * The full description of your new node group.
         * </p>
         * 
         * @param nodegroup
         *        The full description of your new node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroup(Nodegroup nodegroup);

        /**
         * <p>
         * The full description of your new node group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Nodegroup.Builder} avoiding the need to
         * create one manually via {@link Nodegroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Nodegroup.Builder#build()} is called immediately and its result
         * is passed to {@link #nodegroup(Nodegroup)}.
         * 
         * @param nodegroup
         *        a consumer that will call methods on {@link Nodegroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodegroup(Nodegroup)
         */
        default Builder nodegroup(Consumer<Nodegroup.Builder> nodegroup) {
            return nodegroup(Nodegroup.builder().applyMutation(nodegroup).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private Nodegroup nodegroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodegroupResponse model) {
            super(model);
            nodegroup(model.nodegroup);
        }

        public final Nodegroup.Builder getNodegroup() {
            return nodegroup != null ? nodegroup.toBuilder() : null;
        }

        public final void setNodegroup(Nodegroup.BuilderImpl nodegroup) {
            this.nodegroup = nodegroup != null ? nodegroup.build() : null;
        }

        @Override
        public final Builder nodegroup(Nodegroup nodegroup) {
            this.nodegroup = nodegroup;
            return this;
        }

        @Override
        public CreateNodegroupResponse build() {
            return new CreateNodegroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
