/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon EKS add-on. For more information, see <a
 * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS
 * User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Addon implements SdkPojo, Serializable, ToCopyableBuilder<Addon.Builder, Addon> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(Addon::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(Addon::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Addon::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(Addon::addonVersion)).setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<AddonHealth> HEALTH_FIELD = SdkField.<AddonHealth> builder(MarshallingType.SDK_POJO)
            .memberName("health").getter(getter(Addon::health)).setter(setter(Builder::health)).constructor(AddonHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<String> ADDON_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonArn").getter(getter(Addon::addonArn)).setter(setter(Builder::addonArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Addon::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(Addon::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountRoleArn").getter(getter(Addon::serviceAccountRoleArn))
            .setter(setter(Builder::serviceAccountRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountRoleArn").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Addon::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PUBLISHER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publisher").getter(getter(Addon::publisher)).setter(setter(Builder::publisher))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(Addon::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<MarketplaceInformation> MARKETPLACE_INFORMATION_FIELD = SdkField
            .<MarketplaceInformation> builder(MarshallingType.SDK_POJO).memberName("marketplaceInformation")
            .getter(getter(Addon::marketplaceInformation)).setter(setter(Builder::marketplaceInformation))
            .constructor(MarketplaceInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceInformation").build())
            .build();

    private static final SdkField<String> CONFIGURATION_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationValues").getter(getter(Addon::configurationValues))
            .setter(setter(Builder::configurationValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationValues").build())
            .build();

    private static final SdkField<List<String>> POD_IDENTITY_ASSOCIATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("podIdentityAssociations")
            .getter(getter(Addon::podIdentityAssociations))
            .setter(setter(Builder::podIdentityAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podIdentityAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD,
            CLUSTER_NAME_FIELD, STATUS_FIELD, ADDON_VERSION_FIELD, HEALTH_FIELD, ADDON_ARN_FIELD, CREATED_AT_FIELD,
            MODIFIED_AT_FIELD, SERVICE_ACCOUNT_ROLE_ARN_FIELD, TAGS_FIELD, PUBLISHER_FIELD, OWNER_FIELD,
            MARKETPLACE_INFORMATION_FIELD, CONFIGURATION_VALUES_FIELD, POD_IDENTITY_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addonName;

    private final String clusterName;

    private final String status;

    private final String addonVersion;

    private final AddonHealth health;

    private final String addonArn;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String serviceAccountRoleArn;

    private final Map<String, String> tags;

    private final String publisher;

    private final String owner;

    private final MarketplaceInformation marketplaceInformation;

    private final String configurationValues;

    private final List<String> podIdentityAssociations;

    private Addon(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.clusterName = builder.clusterName;
        this.status = builder.status;
        this.addonVersion = builder.addonVersion;
        this.health = builder.health;
        this.addonArn = builder.addonArn;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
        this.tags = builder.tags;
        this.publisher = builder.publisher;
        this.owner = builder.owner;
        this.marketplaceInformation = builder.marketplaceInformation;
        this.configurationValues = builder.configurationValues;
        this.podIdentityAssociations = builder.podIdentityAssociations;
    }

    /**
     * <p>
     * The name of the add-on.
     * </p>
     * 
     * @return The name of the add-on.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The status of the add-on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AddonStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the add-on.
     * @see AddonStatus
     */
    public final AddonStatus status() {
        return AddonStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the add-on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AddonStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the add-on.
     * @see AddonStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The version of the add-on.
     * </p>
     * 
     * @return The version of the add-on.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    /**
     * <p>
     * An object that represents the health of the add-on.
     * </p>
     * 
     * @return An object that represents the health of the add-on.
     */
    public final AddonHealth health() {
        return health;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the add-on.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the add-on.
     */
    public final String addonArn() {
        return addonArn;
    }

    /**
     * <p>
     * The Unix epoch timestamp at object creation.
     * </p>
     * 
     * @return The Unix epoch timestamp at object creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp for the last modification to the object.
     * </p>
     * 
     * @return The Unix epoch timestamp for the last modification to the object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes <code>ServiceAccount</code> object
     * that the add-on uses.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes <code>ServiceAccount</code>
     *         object that the add-on uses.
     */
    public final String serviceAccountRoleArn() {
        return serviceAccountRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The publisher of the add-on.
     * </p>
     * 
     * @return The publisher of the add-on.
     */
    public final String publisher() {
        return publisher;
    }

    /**
     * <p>
     * The owner of the add-on.
     * </p>
     * 
     * @return The owner of the add-on.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
     * </p>
     * 
     * @return Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
     */
    public final MarketplaceInformation marketplaceInformation() {
        return marketplaceInformation;
    }

    /**
     * <p>
     * The configuration values that you provided.
     * </p>
     * 
     * @return The configuration values that you provided.
     */
    public final String configurationValues() {
        return configurationValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the PodIdentityAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPodIdentityAssociations() {
        return podIdentityAssociations != null && !(podIdentityAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role to a
     * service account in a namespace in the cluster.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an
     * IAM Role to an Amazon EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPodIdentityAssociations} method.
     * </p>
     * 
     * @return An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role to
     *         a service account in a namespace in the cluster.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an Amazon
     *         EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
     */
    public final List<String> podIdentityAssociations() {
        return podIdentityAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(health());
        hashCode = 31 * hashCode + Objects.hashCode(addonArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publisher());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceInformation());
        hashCode = 31 * hashCode + Objects.hashCode(configurationValues());
        hashCode = 31 * hashCode + Objects.hashCode(hasPodIdentityAssociations() ? podIdentityAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Addon)) {
            return false;
        }
        Addon other = (Addon) obj;
        return Objects.equals(addonName(), other.addonName()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(addonVersion(), other.addonVersion()) && Objects.equals(health(), other.health())
                && Objects.equals(addonArn(), other.addonArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt())
                && Objects.equals(serviceAccountRoleArn(), other.serviceAccountRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(publisher(), other.publisher())
                && Objects.equals(owner(), other.owner())
                && Objects.equals(marketplaceInformation(), other.marketplaceInformation())
                && Objects.equals(configurationValues(), other.configurationValues())
                && hasPodIdentityAssociations() == other.hasPodIdentityAssociations()
                && Objects.equals(podIdentityAssociations(), other.podIdentityAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Addon").add("AddonName", addonName()).add("ClusterName", clusterName())
                .add("Status", statusAsString()).add("AddonVersion", addonVersion()).add("Health", health())
                .add("AddonArn", addonArn()).add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt())
                .add("ServiceAccountRoleArn", serviceAccountRoleArn()).add("Tags", hasTags() ? tags() : null)
                .add("Publisher", publisher()).add("Owner", owner()).add("MarketplaceInformation", marketplaceInformation())
                .add("ConfigurationValues", configurationValues())
                .add("PodIdentityAssociations", hasPodIdentityAssociations() ? podIdentityAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "health":
            return Optional.ofNullable(clazz.cast(health()));
        case "addonArn":
            return Optional.ofNullable(clazz.cast(addonArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "serviceAccountRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccountRoleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "publisher":
            return Optional.ofNullable(clazz.cast(publisher()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "marketplaceInformation":
            return Optional.ofNullable(clazz.cast(marketplaceInformation()));
        case "configurationValues":
            return Optional.ofNullable(clazz.cast(configurationValues()));
        case "podIdentityAssociations":
            return Optional.ofNullable(clazz.cast(podIdentityAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addonName", ADDON_NAME_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("addonVersion", ADDON_VERSION_FIELD);
        map.put("health", HEALTH_FIELD);
        map.put("addonArn", ADDON_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("serviceAccountRoleArn", SERVICE_ACCOUNT_ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("marketplaceInformation", MARKETPLACE_INFORMATION_FIELD);
        map.put("configurationValues", CONFIGURATION_VALUES_FIELD);
        map.put("podIdentityAssociations", POD_IDENTITY_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Addon, T> g) {
        return obj -> g.apply((Addon) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Addon> {
        /**
         * <p>
         * The name of the add-on.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The status of the add-on.
         * </p>
         * 
         * @param status
         *        The status of the add-on.
         * @see AddonStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddonStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the add-on.
         * </p>
         * 
         * @param status
         *        The status of the add-on.
         * @see AddonStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddonStatus
         */
        Builder status(AddonStatus status);

        /**
         * <p>
         * The version of the add-on.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * An object that represents the health of the add-on.
         * </p>
         * 
         * @param health
         *        An object that represents the health of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder health(AddonHealth health);

        /**
         * <p>
         * An object that represents the health of the add-on.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddonHealth.Builder} avoiding the need to
         * create one manually via {@link AddonHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddonHealth.Builder#build()} is called immediately and its result
         * is passed to {@link #health(AddonHealth)}.
         * 
         * @param health
         *        a consumer that will call methods on {@link AddonHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #health(AddonHealth)
         */
        default Builder health(Consumer<AddonHealth.Builder> health) {
            return health(AddonHealth.builder().applyMutation(health).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the add-on.
         * </p>
         * 
         * @param addonArn
         *        The Amazon Resource Name (ARN) of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonArn(String addonArn);

        /**
         * <p>
         * The Unix epoch timestamp at object creation.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp at object creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix epoch timestamp for the last modification to the object.
         * </p>
         * 
         * @param modifiedAt
         *        The Unix epoch timestamp for the last modification to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes <code>ServiceAccount</code>
         * object that the add-on uses.
         * </p>
         * 
         * @param serviceAccountRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes
         *        <code>ServiceAccount</code> object that the add-on uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountRoleArn(String serviceAccountRoleArn);

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The publisher of the add-on.
         * </p>
         * 
         * @param publisher
         *        The publisher of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisher(String publisher);

        /**
         * <p>
         * The owner of the add-on.
         * </p>
         * 
         * @param owner
         *        The owner of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
         * </p>
         * 
         * @param marketplaceInformation
         *        Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceInformation(MarketplaceInformation marketplaceInformation);

        /**
         * <p>
         * Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
         * </p>
         * This is a convenience method that creates an instance of the {@link MarketplaceInformation.Builder} avoiding
         * the need to create one manually via {@link MarketplaceInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketplaceInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #marketplaceInformation(MarketplaceInformation)}.
         * 
         * @param marketplaceInformation
         *        a consumer that will call methods on {@link MarketplaceInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketplaceInformation(MarketplaceInformation)
         */
        default Builder marketplaceInformation(Consumer<MarketplaceInformation.Builder> marketplaceInformation) {
            return marketplaceInformation(MarketplaceInformation.builder().applyMutation(marketplaceInformation).build());
        }

        /**
         * <p>
         * The configuration values that you provided.
         * </p>
         * 
         * @param configurationValues
         *        The configuration values that you provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationValues(String configurationValues);

        /**
         * <p>
         * An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role to a
         * service account in a namespace in the cluster.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach
         * an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param podIdentityAssociations
         *        An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role
         *        to a service account in a namespace in the cluster.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an
         *        Amazon EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podIdentityAssociations(Collection<String> podIdentityAssociations);

        /**
         * <p>
         * An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role to a
         * service account in a namespace in the cluster.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach
         * an IAM Role to an Amazon EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param podIdentityAssociations
         *        An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity association maps a role
         *        to a service account in a namespace in the cluster.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html">Attach an IAM Role to an
         *        Amazon EKS add-on using Pod Identity</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podIdentityAssociations(String... podIdentityAssociations);
    }

    static final class BuilderImpl implements Builder {
        private String addonName;

        private String clusterName;

        private String status;

        private String addonVersion;

        private AddonHealth health;

        private String addonArn;

        private Instant createdAt;

        private Instant modifiedAt;

        private String serviceAccountRoleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String publisher;

        private String owner;

        private MarketplaceInformation marketplaceInformation;

        private String configurationValues;

        private List<String> podIdentityAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Addon model) {
            addonName(model.addonName);
            clusterName(model.clusterName);
            status(model.status);
            addonVersion(model.addonVersion);
            health(model.health);
            addonArn(model.addonArn);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            serviceAccountRoleArn(model.serviceAccountRoleArn);
            tags(model.tags);
            publisher(model.publisher);
            owner(model.owner);
            marketplaceInformation(model.marketplaceInformation);
            configurationValues(model.configurationValues);
            podIdentityAssociations(model.podIdentityAssociations);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AddonStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final AddonHealth.Builder getHealth() {
            return health != null ? health.toBuilder() : null;
        }

        public final void setHealth(AddonHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(AddonHealth health) {
            this.health = health;
            return this;
        }

        public final String getAddonArn() {
            return addonArn;
        }

        public final void setAddonArn(String addonArn) {
            this.addonArn = addonArn;
        }

        @Override
        public final Builder addonArn(String addonArn) {
            this.addonArn = addonArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getServiceAccountRoleArn() {
            return serviceAccountRoleArn;
        }

        public final void setServiceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
        }

        @Override
        public final Builder serviceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPublisher() {
            return publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final MarketplaceInformation.Builder getMarketplaceInformation() {
            return marketplaceInformation != null ? marketplaceInformation.toBuilder() : null;
        }

        public final void setMarketplaceInformation(MarketplaceInformation.BuilderImpl marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation != null ? marketplaceInformation.build() : null;
        }

        @Override
        public final Builder marketplaceInformation(MarketplaceInformation marketplaceInformation) {
            this.marketplaceInformation = marketplaceInformation;
            return this;
        }

        public final String getConfigurationValues() {
            return configurationValues;
        }

        public final void setConfigurationValues(String configurationValues) {
            this.configurationValues = configurationValues;
        }

        @Override
        public final Builder configurationValues(String configurationValues) {
            this.configurationValues = configurationValues;
            return this;
        }

        public final Collection<String> getPodIdentityAssociations() {
            if (podIdentityAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return podIdentityAssociations;
        }

        public final void setPodIdentityAssociations(Collection<String> podIdentityAssociations) {
            this.podIdentityAssociations = StringListCopier.copy(podIdentityAssociations);
        }

        @Override
        public final Builder podIdentityAssociations(Collection<String> podIdentityAssociations) {
            this.podIdentityAssociations = StringListCopier.copy(podIdentityAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder podIdentityAssociations(String... podIdentityAssociations) {
            podIdentityAssociations(Arrays.asList(podIdentityAssociations));
            return this;
        }

        @Override
        public Addon build() {
            return new Addon(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
