/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary information about deprecated resource usage for an insight check in the <code>UPGRADE_READINESS</code>
 * category.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeprecationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<DeprecationDetail.Builder, DeprecationDetail> {
    private static final SdkField<String> USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("usage")
            .getter(getter(DeprecationDetail::usage)).setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final SdkField<String> REPLACED_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replacedWith").getter(getter(DeprecationDetail::replacedWith)).setter(setter(Builder::replacedWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacedWith").build()).build();

    private static final SdkField<String> STOP_SERVING_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stopServingVersion").getter(getter(DeprecationDetail::stopServingVersion))
            .setter(setter(Builder::stopServingVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopServingVersion").build())
            .build();

    private static final SdkField<String> START_SERVING_REPLACEMENT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("startServingReplacementVersion")
            .getter(getter(DeprecationDetail::startServingReplacementVersion))
            .setter(setter(Builder::startServingReplacementVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startServingReplacementVersion")
                    .build()).build();

    private static final SdkField<List<ClientStat>> CLIENT_STATS_FIELD = SdkField
            .<List<ClientStat>> builder(MarshallingType.LIST)
            .memberName("clientStats")
            .getter(getter(DeprecationDetail::clientStats))
            .setter(setter(Builder::clientStats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientStats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientStat> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientStat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD,
            REPLACED_WITH_FIELD, STOP_SERVING_VERSION_FIELD, START_SERVING_REPLACEMENT_VERSION_FIELD, CLIENT_STATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String usage;

    private final String replacedWith;

    private final String stopServingVersion;

    private final String startServingReplacementVersion;

    private final List<ClientStat> clientStats;

    private DeprecationDetail(BuilderImpl builder) {
        this.usage = builder.usage;
        this.replacedWith = builder.replacedWith;
        this.stopServingVersion = builder.stopServingVersion;
        this.startServingReplacementVersion = builder.startServingReplacementVersion;
        this.clientStats = builder.clientStats;
    }

    /**
     * <p>
     * The deprecated version of the resource.
     * </p>
     * 
     * @return The deprecated version of the resource.
     */
    public final String usage() {
        return usage;
    }

    /**
     * <p>
     * The newer version of the resource to migrate to if applicable.
     * </p>
     * 
     * @return The newer version of the resource to migrate to if applicable.
     */
    public final String replacedWith() {
        return replacedWith;
    }

    /**
     * <p>
     * The version of the software where the deprecated resource version will stop being served.
     * </p>
     * 
     * @return The version of the software where the deprecated resource version will stop being served.
     */
    public final String stopServingVersion() {
        return stopServingVersion;
    }

    /**
     * <p>
     * The version of the software where the newer resource version became available to migrate to if applicable.
     * </p>
     * 
     * @return The version of the software where the newer resource version became available to migrate to if
     *         applicable.
     */
    public final String startServingReplacementVersion() {
        return startServingReplacementVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientStats property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientStats() {
        return clientStats != null && !(clientStats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about Kubernetes clients using the deprecated resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientStats} method.
     * </p>
     * 
     * @return Details about Kubernetes clients using the deprecated resources.
     */
    public final List<ClientStat> clientStats() {
        return clientStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        hashCode = 31 * hashCode + Objects.hashCode(replacedWith());
        hashCode = 31 * hashCode + Objects.hashCode(stopServingVersion());
        hashCode = 31 * hashCode + Objects.hashCode(startServingReplacementVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientStats() ? clientStats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecationDetail)) {
            return false;
        }
        DeprecationDetail other = (DeprecationDetail) obj;
        return Objects.equals(usage(), other.usage()) && Objects.equals(replacedWith(), other.replacedWith())
                && Objects.equals(stopServingVersion(), other.stopServingVersion())
                && Objects.equals(startServingReplacementVersion(), other.startServingReplacementVersion())
                && hasClientStats() == other.hasClientStats() && Objects.equals(clientStats(), other.clientStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeprecationDetail").add("Usage", usage()).add("ReplacedWith", replacedWith())
                .add("StopServingVersion", stopServingVersion())
                .add("StartServingReplacementVersion", startServingReplacementVersion())
                .add("ClientStats", hasClientStats() ? clientStats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "replacedWith":
            return Optional.ofNullable(clazz.cast(replacedWith()));
        case "stopServingVersion":
            return Optional.ofNullable(clazz.cast(stopServingVersion()));
        case "startServingReplacementVersion":
            return Optional.ofNullable(clazz.cast(startServingReplacementVersion()));
        case "clientStats":
            return Optional.ofNullable(clazz.cast(clientStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("usage", USAGE_FIELD);
        map.put("replacedWith", REPLACED_WITH_FIELD);
        map.put("stopServingVersion", STOP_SERVING_VERSION_FIELD);
        map.put("startServingReplacementVersion", START_SERVING_REPLACEMENT_VERSION_FIELD);
        map.put("clientStats", CLIENT_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeprecationDetail, T> g) {
        return obj -> g.apply((DeprecationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeprecationDetail> {
        /**
         * <p>
         * The deprecated version of the resource.
         * </p>
         * 
         * @param usage
         *        The deprecated version of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(String usage);

        /**
         * <p>
         * The newer version of the resource to migrate to if applicable.
         * </p>
         * 
         * @param replacedWith
         *        The newer version of the resource to migrate to if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacedWith(String replacedWith);

        /**
         * <p>
         * The version of the software where the deprecated resource version will stop being served.
         * </p>
         * 
         * @param stopServingVersion
         *        The version of the software where the deprecated resource version will stop being served.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopServingVersion(String stopServingVersion);

        /**
         * <p>
         * The version of the software where the newer resource version became available to migrate to if applicable.
         * </p>
         * 
         * @param startServingReplacementVersion
         *        The version of the software where the newer resource version became available to migrate to if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startServingReplacementVersion(String startServingReplacementVersion);

        /**
         * <p>
         * Details about Kubernetes clients using the deprecated resources.
         * </p>
         * 
         * @param clientStats
         *        Details about Kubernetes clients using the deprecated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientStats(Collection<ClientStat> clientStats);

        /**
         * <p>
         * Details about Kubernetes clients using the deprecated resources.
         * </p>
         * 
         * @param clientStats
         *        Details about Kubernetes clients using the deprecated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientStats(ClientStat... clientStats);

        /**
         * <p>
         * Details about Kubernetes clients using the deprecated resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.ClientStat.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.eks.model.ClientStat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.ClientStat.Builder#build()} is called immediately and its
         * result is passed to {@link #clientStats(List<ClientStat>)}.
         * 
         * @param clientStats
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.ClientStat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientStats(java.util.Collection<ClientStat>)
         */
        Builder clientStats(Consumer<ClientStat.Builder>... clientStats);
    }

    static final class BuilderImpl implements Builder {
        private String usage;

        private String replacedWith;

        private String stopServingVersion;

        private String startServingReplacementVersion;

        private List<ClientStat> clientStats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecationDetail model) {
            usage(model.usage);
            replacedWith(model.replacedWith);
            stopServingVersion(model.stopServingVersion);
            startServingReplacementVersion(model.startServingReplacementVersion);
            clientStats(model.clientStats);
        }

        public final String getUsage() {
            return usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public final String getReplacedWith() {
            return replacedWith;
        }

        public final void setReplacedWith(String replacedWith) {
            this.replacedWith = replacedWith;
        }

        @Override
        public final Builder replacedWith(String replacedWith) {
            this.replacedWith = replacedWith;
            return this;
        }

        public final String getStopServingVersion() {
            return stopServingVersion;
        }

        public final void setStopServingVersion(String stopServingVersion) {
            this.stopServingVersion = stopServingVersion;
        }

        @Override
        public final Builder stopServingVersion(String stopServingVersion) {
            this.stopServingVersion = stopServingVersion;
            return this;
        }

        public final String getStartServingReplacementVersion() {
            return startServingReplacementVersion;
        }

        public final void setStartServingReplacementVersion(String startServingReplacementVersion) {
            this.startServingReplacementVersion = startServingReplacementVersion;
        }

        @Override
        public final Builder startServingReplacementVersion(String startServingReplacementVersion) {
            this.startServingReplacementVersion = startServingReplacementVersion;
            return this;
        }

        public final List<ClientStat.Builder> getClientStats() {
            List<ClientStat.Builder> result = ClientStatsCopier.copyToBuilder(this.clientStats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientStats(Collection<ClientStat.BuilderImpl> clientStats) {
            this.clientStats = ClientStatsCopier.copyFromBuilder(clientStats);
        }

        @Override
        public final Builder clientStats(Collection<ClientStat> clientStats) {
            this.clientStats = ClientStatsCopier.copy(clientStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientStats(ClientStat... clientStats) {
            clientStats(Arrays.asList(clientStats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientStats(Consumer<ClientStat.Builder>... clientStats) {
            clientStats(Stream.of(clientStats).map(c -> ClientStat.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeprecationDetail build() {
            return new DeprecationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
