/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
 * </p>
 * <p>
 * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the
 * Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and edge
 * locations.
 * </p>
 * <p>
 * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
 * </p>
 * <p>
 * It must satisfy the following requirements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24, maximum allowed
 * size is /8. Publicly-routable addresses aren't supported.
 * </p>
 * </li>
 * <li>
 * <p>
 * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
 * Kubernetes service IP range.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemotePodNetwork implements SdkPojo, Serializable,
        ToCopyableBuilder<RemotePodNetwork.Builder, RemotePodNetwork> {
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cidrs")
            .getter(getter(RemotePodNetwork::cidrs))
            .setter(setter(Builder::cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> cidrs;

    private RemotePodNetwork(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cidrs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCidrs() {
        return cidrs != null && !(cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
     * </p>
     * <p>
     * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend the
     * Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for on-premises and
     * edge locations.
     * </p>
     * <p>
     * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
     * </p>
     * <p>
     * It must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24, maximum
     * allowed size is /8. Publicly-routable addresses aren't supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
     * Kubernetes service IP range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrs} method.
     * </p>
     * 
     * @return A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
     *         <p>
     *         These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
     *         recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
     *         available for on-premises and edge locations.
     *         </p>
     *         <p>
     *         Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
     *         <code> 10.2.0.0/16</code>).
     *         </p>
     *         <p>
     *         It must satisfy the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24,
     *         maximum allowed size is /8. Publicly-routable addresses aren't supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of
     *         the Kubernetes service IP range.
     *         </p>
     *         </li>
     */
    public final List<String> cidrs() {
        return cidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrs() ? cidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemotePodNetwork)) {
            return false;
        }
        RemotePodNetwork other = (RemotePodNetwork) obj;
        return hasCidrs() == other.hasCidrs() && Objects.equals(cidrs(), other.cidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemotePodNetwork").add("Cidrs", hasCidrs() ? cidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cidrs":
            return Optional.ofNullable(clazz.cast(cidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cidrs", CIDRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemotePodNetwork, T> g) {
        return obj -> g.apply((RemotePodNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemotePodNetwork> {
        /**
         * <p>
         * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend
         * the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for
         * on-premises and edge locations.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cidrs
         *        A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
         *        recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
         *        available for on-premises and edge locations.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.
         * </p>
         * <p>
         * These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We recommend
         * the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't available for
         * on-premises and edge locations.
         * </p>
         * <p>
         * Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example, <code> 10.2.0.0/16</code>).
         * </p>
         * <p>
         * It must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24, maximum
         * allowed size is /8. Publicly-routable addresses aren't supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block of the
         * Kubernetes service IP range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cidrs
         *        A network CIDR that can contain pods that run Kubernetes webhooks on hybrid nodes.</p>
         *        <p>
         *        These CIDR blocks are determined by configuring your Container Network Interface (CNI) plugin. We
         *        recommend the Calico CNI or Cilium CNI. Note that the Amazon VPC CNI plugin for Kubernetes isn't
         *        available for on-premises and edge locations.
         *        </p>
         *        <p>
         *        Enter one or more IPv4 CIDR blocks in decimal dotted-quad notation (for example,
         *        <code> 10.2.0.0/16</code>).
         *        </p>
         *        <p>
         *        It must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Each block must be within an <code>IPv4</code> RFC-1918 network range. Minimum allowed size is /24,
         *        maximum allowed size is /8. Publicly-routable addresses aren't supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each block cannot overlap with the range of the VPC CIDR blocks for your EKS resources, or the block
         *        of the Kubernetes service IP range.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemotePodNetwork model) {
            cidrs(model.cidrs);
        }

        public final Collection<String> getCidrs() {
            if (cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrs;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        @Override
        public RemotePodNetwork build() {
            return new RemotePodNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
