/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterConfigRequest extends EksRequest implements
        ToCopyableBuilder<UpdateClusterConfigRequest.Builder, UpdateClusterConfigRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateClusterConfigRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField
            .<VpcConfigRequest> builder(MarshallingType.SDK_POJO).memberName("resourcesVpcConfig")
            .getter(getter(UpdateClusterConfigRequest::resourcesVpcConfig)).setter(setter(Builder::resourcesVpcConfig))
            .constructor(VpcConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build())
            .build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .memberName("logging").getter(getter(UpdateClusterConfigRequest::logging)).setter(setter(Builder::logging))
            .constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateClusterConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<UpdateAccessConfigRequest> ACCESS_CONFIG_FIELD = SdkField
            .<UpdateAccessConfigRequest> builder(MarshallingType.SDK_POJO).memberName("accessConfig")
            .getter(getter(UpdateClusterConfigRequest::accessConfig)).setter(setter(Builder::accessConfig))
            .constructor(UpdateAccessConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfig").build()).build();

    private static final SdkField<UpgradePolicyRequest> UPGRADE_POLICY_FIELD = SdkField
            .<UpgradePolicyRequest> builder(MarshallingType.SDK_POJO).memberName("upgradePolicy")
            .getter(getter(UpdateClusterConfigRequest::upgradePolicy)).setter(setter(Builder::upgradePolicy))
            .constructor(UpgradePolicyRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upgradePolicy").build()).build();

    private static final SdkField<ZonalShiftConfigRequest> ZONAL_SHIFT_CONFIG_FIELD = SdkField
            .<ZonalShiftConfigRequest> builder(MarshallingType.SDK_POJO).memberName("zonalShiftConfig")
            .getter(getter(UpdateClusterConfigRequest::zonalShiftConfig)).setter(setter(Builder::zonalShiftConfig))
            .constructor(ZonalShiftConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftConfig").build()).build();

    private static final SdkField<ComputeConfigRequest> COMPUTE_CONFIG_FIELD = SdkField
            .<ComputeConfigRequest> builder(MarshallingType.SDK_POJO).memberName("computeConfig")
            .getter(getter(UpdateClusterConfigRequest::computeConfig)).setter(setter(Builder::computeConfig))
            .constructor(ComputeConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfig").build()).build();

    private static final SdkField<KubernetesNetworkConfigRequest> KUBERNETES_NETWORK_CONFIG_FIELD = SdkField
            .<KubernetesNetworkConfigRequest> builder(MarshallingType.SDK_POJO).memberName("kubernetesNetworkConfig")
            .getter(getter(UpdateClusterConfigRequest::kubernetesNetworkConfig)).setter(setter(Builder::kubernetesNetworkConfig))
            .constructor(KubernetesNetworkConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNetworkConfig").build())
            .build();

    private static final SdkField<StorageConfigRequest> STORAGE_CONFIG_FIELD = SdkField
            .<StorageConfigRequest> builder(MarshallingType.SDK_POJO).memberName("storageConfig")
            .getter(getter(UpdateClusterConfigRequest::storageConfig)).setter(setter(Builder::storageConfig))
            .constructor(StorageConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfig").build()).build();

    private static final SdkField<RemoteNetworkConfigRequest> REMOTE_NETWORK_CONFIG_FIELD = SdkField
            .<RemoteNetworkConfigRequest> builder(MarshallingType.SDK_POJO).memberName("remoteNetworkConfig")
            .getter(getter(UpdateClusterConfigRequest::remoteNetworkConfig)).setter(setter(Builder::remoteNetworkConfig))
            .constructor(RemoteNetworkConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteNetworkConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ACCESS_CONFIG_FIELD, UPGRADE_POLICY_FIELD,
            ZONAL_SHIFT_CONFIG_FIELD, COMPUTE_CONFIG_FIELD, KUBERNETES_NETWORK_CONFIG_FIELD, STORAGE_CONFIG_FIELD,
            REMOTE_NETWORK_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final VpcConfigRequest resourcesVpcConfig;

    private final Logging logging;

    private final String clientRequestToken;

    private final UpdateAccessConfigRequest accessConfig;

    private final UpgradePolicyRequest upgradePolicy;

    private final ZonalShiftConfigRequest zonalShiftConfig;

    private final ComputeConfigRequest computeConfig;

    private final KubernetesNetworkConfigRequest kubernetesNetworkConfig;

    private final StorageConfigRequest storageConfig;

    private final RemoteNetworkConfigRequest remoteNetworkConfig;

    private UpdateClusterConfigRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
        this.accessConfig = builder.accessConfig;
        this.upgradePolicy = builder.upgradePolicy;
        this.zonalShiftConfig = builder.zonalShiftConfig;
        this.computeConfig = builder.computeConfig;
        this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
        this.storageConfig = builder.storageConfig;
        this.remoteNetworkConfig = builder.remoteNetworkConfig;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster to update.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster to update.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ResourcesVpcConfig property for this object.
     * 
     * @return The value of the ResourcesVpcConfig property for this object.
     */
    public final VpcConfigRequest resourcesVpcConfig() {
        return resourcesVpcConfig;
    }

    /**
     * <p>
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By default,
     * cluster control plane logs aren't exported to CloudWatch Logs . For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane
     * logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     * </p>
     * </note>
     * 
     * @return Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By
     *         default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster
     *         control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
     *         <p>
     *         CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs.
     *         For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     *         </p>
     */
    public final Logging logging() {
        return logging;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The access configuration for the cluster.
     * </p>
     * 
     * @return The access configuration for the cluster.
     */
    public final UpdateAccessConfigRequest accessConfig() {
        return accessConfig;
    }

    /**
     * <p>
     * You can enable or disable extended support for clusters currently on standard support. You cannot disable
     * extended support once it starts. You must enable extended support before your cluster exits standard support.
     * </p>
     * 
     * @return You can enable or disable extended support for clusters currently on standard support. You cannot disable
     *         extended support once it starts. You must enable extended support before your cluster exits standard
     *         support.
     */
    public final UpgradePolicyRequest upgradePolicy() {
        return upgradePolicy;
    }

    /**
     * <p>
     * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures
     * zonal autoshift for the cluster.
     * </p>
     * <p>
     * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a
     * temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal shift
     * expires or you cancel it. You can extend the zonal shift if necessary.
     * </p>
     * <p>
     * You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by enabling
     * <i>zonal autoshift</i>. This shift updates the flow of east-to-west network traffic in your cluster to only
     * consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or NLB handling
     * ingress traffic for applications in your EKS cluster will automatically route traffic to targets in the healthy
     * AZs. For more information about zonal shift in EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html">Learn about Amazon Application Recovery
     * Controller (ARC) Zonal Shift in Amazon EKS</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services
     *         configures zonal autoshift for the cluster.</p>
     *         <p>
     *         Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to
     *         be a temporary measure that allows you to move traffic for a resource away from an impaired AZ until the
     *         zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
     *         </p>
     *         <p>
     *         You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by
     *         enabling <i>zonal autoshift</i>. This shift updates the flow of east-to-west network traffic in your
     *         cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally,
     *         any ALB or NLB handling ingress traffic for applications in your EKS cluster will automatically route
     *         traffic to targets in the healthy AZs. For more information about zonal shift in EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html">Learn about Amazon Application
     *         Recovery Controller (ARC) Zonal Shift in Amazon EKS</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final ZonalShiftConfigRequest zonalShiftConfig() {
        return zonalShiftConfig;
    }

    /**
     * <p>
     * Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the
     * capability.
     * </p>
     * 
     * @return Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the
     *         capability.
     */
    public final ComputeConfigRequest computeConfig() {
        return computeConfig;
    }

    /**
     * Returns the value of the KubernetesNetworkConfig property for this object.
     * 
     * @return The value of the KubernetesNetworkConfig property for this object.
     */
    public final KubernetesNetworkConfigRequest kubernetesNetworkConfig() {
        return kubernetesNetworkConfig;
    }

    /**
     * <p>
     * Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example, enable the
     * capability.
     * </p>
     * 
     * @return Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example,
     *         enable the capability.
     */
    public final StorageConfigRequest storageConfig() {
        return storageConfig;
    }

    /**
     * Returns the value of the RemoteNetworkConfig property for this object.
     * 
     * @return The value of the RemoteNetworkConfig property for this object.
     */
    public final RemoteNetworkConfigRequest remoteNetworkConfig() {
        return remoteNetworkConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(upgradePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(remoteNetworkConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigRequest)) {
            return false;
        }
        UpdateClusterConfigRequest other = (UpdateClusterConfigRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(resourcesVpcConfig(), other.resourcesVpcConfig())
                && Objects.equals(logging(), other.logging()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(accessConfig(), other.accessConfig()) && Objects.equals(upgradePolicy(), other.upgradePolicy())
                && Objects.equals(zonalShiftConfig(), other.zonalShiftConfig())
                && Objects.equals(computeConfig(), other.computeConfig())
                && Objects.equals(kubernetesNetworkConfig(), other.kubernetesNetworkConfig())
                && Objects.equals(storageConfig(), other.storageConfig())
                && Objects.equals(remoteNetworkConfig(), other.remoteNetworkConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterConfigRequest").add("Name", name()).add("ResourcesVpcConfig", resourcesVpcConfig())
                .add("Logging", logging()).add("ClientRequestToken", clientRequestToken()).add("AccessConfig", accessConfig())
                .add("UpgradePolicy", upgradePolicy()).add("ZonalShiftConfig", zonalShiftConfig())
                .add("ComputeConfig", computeConfig()).add("KubernetesNetworkConfig", kubernetesNetworkConfig())
                .add("StorageConfig", storageConfig()).add("RemoteNetworkConfig", remoteNetworkConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourcesVpcConfig":
            return Optional.ofNullable(clazz.cast(resourcesVpcConfig()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "accessConfig":
            return Optional.ofNullable(clazz.cast(accessConfig()));
        case "upgradePolicy":
            return Optional.ofNullable(clazz.cast(upgradePolicy()));
        case "zonalShiftConfig":
            return Optional.ofNullable(clazz.cast(zonalShiftConfig()));
        case "computeConfig":
            return Optional.ofNullable(clazz.cast(computeConfig()));
        case "kubernetesNetworkConfig":
            return Optional.ofNullable(clazz.cast(kubernetesNetworkConfig()));
        case "storageConfig":
            return Optional.ofNullable(clazz.cast(storageConfig()));
        case "remoteNetworkConfig":
            return Optional.ofNullable(clazz.cast(remoteNetworkConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("resourcesVpcConfig", RESOURCES_VPC_CONFIG_FIELD);
        map.put("logging", LOGGING_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("accessConfig", ACCESS_CONFIG_FIELD);
        map.put("upgradePolicy", UPGRADE_POLICY_FIELD);
        map.put("zonalShiftConfig", ZONAL_SHIFT_CONFIG_FIELD);
        map.put("computeConfig", COMPUTE_CONFIG_FIELD);
        map.put("kubernetesNetworkConfig", KUBERNETES_NETWORK_CONFIG_FIELD);
        map.put("storageConfig", STORAGE_CONFIG_FIELD);
        map.put("remoteNetworkConfig", REMOTE_NETWORK_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterConfigRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster to update.
         * </p>
         * 
         * @param name
         *        The name of the Amazon EKS cluster to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ResourcesVpcConfig property for this object.
         *
         * @param resourcesVpcConfig
         *        The new value for the ResourcesVpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig);

        /**
         * Sets the value of the ResourcesVpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfigRequest.Builder} avoiding the
         * need to create one manually via {@link VpcConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfigRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesVpcConfig(VpcConfigRequest)}.
         * 
         * @param resourcesVpcConfig
         *        a consumer that will call methods on {@link VpcConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesVpcConfig(VpcConfigRequest)
         */
        default Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return resourcesVpcConfig(VpcConfigRequest.builder().applyMutation(resourcesVpcConfig).build());
        }

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By
         * default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note>
         * 
         * @param logging
         *        Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By
         *        default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster
         *        control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
         *        <p>
         *        CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane
         *        logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch
         *        Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs . By
         * default, cluster control plane logs aren't exported to CloudWatch Logs . For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Logging.Builder} avoiding the
         * need to create one manually via {@link Logging#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The access configuration for the cluster.
         * </p>
         * 
         * @param accessConfig
         *        The access configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfig(UpdateAccessConfigRequest accessConfig);

        /**
         * <p>
         * The access configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateAccessConfigRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateAccessConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateAccessConfigRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #accessConfig(UpdateAccessConfigRequest)}.
         * 
         * @param accessConfig
         *        a consumer that will call methods on {@link UpdateAccessConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfig(UpdateAccessConfigRequest)
         */
        default Builder accessConfig(Consumer<UpdateAccessConfigRequest.Builder> accessConfig) {
            return accessConfig(UpdateAccessConfigRequest.builder().applyMutation(accessConfig).build());
        }

        /**
         * <p>
         * You can enable or disable extended support for clusters currently on standard support. You cannot disable
         * extended support once it starts. You must enable extended support before your cluster exits standard support.
         * </p>
         * 
         * @param upgradePolicy
         *        You can enable or disable extended support for clusters currently on standard support. You cannot
         *        disable extended support once it starts. You must enable extended support before your cluster exits
         *        standard support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradePolicy(UpgradePolicyRequest upgradePolicy);

        /**
         * <p>
         * You can enable or disable extended support for clusters currently on standard support. You cannot disable
         * extended support once it starts. You must enable extended support before your cluster exits standard support.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpgradePolicyRequest.Builder} avoiding
         * the need to create one manually via {@link UpgradePolicyRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpgradePolicyRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #upgradePolicy(UpgradePolicyRequest)}.
         * 
         * @param upgradePolicy
         *        a consumer that will call methods on {@link UpgradePolicyRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upgradePolicy(UpgradePolicyRequest)
         */
        default Builder upgradePolicy(Consumer<UpgradePolicyRequest.Builder> upgradePolicy) {
            return upgradePolicy(UpgradePolicyRequest.builder().applyMutation(upgradePolicy).build());
        }

        /**
         * <p>
         * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures
         * zonal autoshift for the cluster.
         * </p>
         * <p>
         * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a
         * temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal
         * shift expires or you cancel it. You can extend the zonal shift if necessary.
         * </p>
         * <p>
         * You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by
         * enabling <i>zonal autoshift</i>. This shift updates the flow of east-to-west network traffic in your cluster
         * to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or
         * NLB handling ingress traffic for applications in your EKS cluster will automatically route traffic to targets
         * in the healthy AZs. For more information about zonal shift in EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html">Learn about Amazon Application
         * Recovery Controller (ARC) Zonal Shift in Amazon EKS</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param zonalShiftConfig
         *        Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services
         *        configures zonal autoshift for the cluster.</p>
         *        <p>
         *        Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed
         *        to be a temporary measure that allows you to move traffic for a resource away from an impaired AZ
         *        until the zonal shift expires or you cancel it. You can extend the zonal shift if necessary.
         *        </p>
         *        <p>
         *        You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you
         *        by enabling <i>zonal autoshift</i>. This shift updates the flow of east-to-west network traffic in
         *        your cluster to only consider network endpoints for Pods running on worker nodes in healthy AZs.
         *        Additionally, any ALB or NLB handling ingress traffic for applications in your EKS cluster will
         *        automatically route traffic to targets in the healthy AZs. For more information about zonal shift in
         *        EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html">Learn about Amazon
         *        Application Recovery Controller (ARC) Zonal Shift in Amazon EKS</a> in the <i> <i>Amazon EKS User
         *        Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftConfig(ZonalShiftConfigRequest zonalShiftConfig);

        /**
         * <p>
         * Enable or disable ARC zonal shift for the cluster. If zonal shift is enabled, Amazon Web Services configures
         * zonal autoshift for the cluster.
         * </p>
         * <p>
         * Zonal shift is a feature of Amazon Application Recovery Controller (ARC). ARC zonal shift is designed to be a
         * temporary measure that allows you to move traffic for a resource away from an impaired AZ until the zonal
         * shift expires or you cancel it. You can extend the zonal shift if necessary.
         * </p>
         * <p>
         * You can start a zonal shift for an EKS cluster, or you can allow Amazon Web Services to do it for you by
         * enabling <i>zonal autoshift</i>. This shift updates the flow of east-to-west network traffic in your cluster
         * to only consider network endpoints for Pods running on worker nodes in healthy AZs. Additionally, any ALB or
         * NLB handling ingress traffic for applications in your EKS cluster will automatically route traffic to targets
         * in the healthy AZs. For more information about zonal shift in EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/zone-shift.html">Learn about Amazon Application
         * Recovery Controller (ARC) Zonal Shift in Amazon EKS</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZonalShiftConfigRequest.Builder} avoiding
         * the need to create one manually via {@link ZonalShiftConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZonalShiftConfigRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #zonalShiftConfig(ZonalShiftConfigRequest)}.
         * 
         * @param zonalShiftConfig
         *        a consumer that will call methods on {@link ZonalShiftConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zonalShiftConfig(ZonalShiftConfigRequest)
         */
        default Builder zonalShiftConfig(Consumer<ZonalShiftConfigRequest.Builder> zonalShiftConfig) {
            return zonalShiftConfig(ZonalShiftConfigRequest.builder().applyMutation(zonalShiftConfig).build());
        }

        /**
         * <p>
         * Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the
         * capability.
         * </p>
         * 
         * @param computeConfig
         *        Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable
         *        the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfig(ComputeConfigRequest computeConfig);

        /**
         * <p>
         * Update the configuration of the compute capability of your EKS Auto Mode cluster. For example, enable the
         * capability.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfigRequest.Builder} avoiding
         * the need to create one manually via {@link ComputeConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfigRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #computeConfig(ComputeConfigRequest)}.
         * 
         * @param computeConfig
         *        a consumer that will call methods on {@link ComputeConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfig(ComputeConfigRequest)
         */
        default Builder computeConfig(Consumer<ComputeConfigRequest.Builder> computeConfig) {
            return computeConfig(ComputeConfigRequest.builder().applyMutation(computeConfig).build());
        }

        /**
         * Sets the value of the KubernetesNetworkConfig property for this object.
         *
         * @param kubernetesNetworkConfig
         *        The new value for the KubernetesNetworkConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig);

        /**
         * Sets the value of the KubernetesNetworkConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KubernetesNetworkConfigRequest.Builder}
         * avoiding the need to create one manually via {@link KubernetesNetworkConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesNetworkConfigRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #kubernetesNetworkConfig(KubernetesNetworkConfigRequest)}.
         * 
         * @param kubernetesNetworkConfig
         *        a consumer that will call methods on {@link KubernetesNetworkConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesNetworkConfig(KubernetesNetworkConfigRequest)
         */
        default Builder kubernetesNetworkConfig(Consumer<KubernetesNetworkConfigRequest.Builder> kubernetesNetworkConfig) {
            return kubernetesNetworkConfig(KubernetesNetworkConfigRequest.builder().applyMutation(kubernetesNetworkConfig)
                    .build());
        }

        /**
         * <p>
         * Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example, enable
         * the capability.
         * </p>
         * 
         * @param storageConfig
         *        Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example,
         *        enable the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfig(StorageConfigRequest storageConfig);

        /**
         * <p>
         * Update the configuration of the block storage capability of your EKS Auto Mode cluster. For example, enable
         * the capability.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfigRequest.Builder} avoiding
         * the need to create one manually via {@link StorageConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfigRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfig(StorageConfigRequest)}.
         * 
         * @param storageConfig
         *        a consumer that will call methods on {@link StorageConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfig(StorageConfigRequest)
         */
        default Builder storageConfig(Consumer<StorageConfigRequest.Builder> storageConfig) {
            return storageConfig(StorageConfigRequest.builder().applyMutation(storageConfig).build());
        }

        /**
         * Sets the value of the RemoteNetworkConfig property for this object.
         *
         * @param remoteNetworkConfig
         *        The new value for the RemoteNetworkConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteNetworkConfig(RemoteNetworkConfigRequest remoteNetworkConfig);

        /**
         * Sets the value of the RemoteNetworkConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RemoteNetworkConfigRequest.Builder}
         * avoiding the need to create one manually via {@link RemoteNetworkConfigRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteNetworkConfigRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #remoteNetworkConfig(RemoteNetworkConfigRequest)}.
         * 
         * @param remoteNetworkConfig
         *        a consumer that will call methods on {@link RemoteNetworkConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteNetworkConfig(RemoteNetworkConfigRequest)
         */
        default Builder remoteNetworkConfig(Consumer<RemoteNetworkConfigRequest.Builder> remoteNetworkConfig) {
            return remoteNetworkConfig(RemoteNetworkConfigRequest.builder().applyMutation(remoteNetworkConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private VpcConfigRequest resourcesVpcConfig;

        private Logging logging;

        private String clientRequestToken;

        private UpdateAccessConfigRequest accessConfig;

        private UpgradePolicyRequest upgradePolicy;

        private ZonalShiftConfigRequest zonalShiftConfig;

        private ComputeConfigRequest computeConfig;

        private KubernetesNetworkConfigRequest kubernetesNetworkConfig;

        private StorageConfigRequest storageConfig;

        private RemoteNetworkConfigRequest remoteNetworkConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigRequest model) {
            super(model);
            name(model.name);
            resourcesVpcConfig(model.resourcesVpcConfig);
            logging(model.logging);
            clientRequestToken(model.clientRequestToken);
            accessConfig(model.accessConfig);
            upgradePolicy(model.upgradePolicy);
            zonalShiftConfig(model.zonalShiftConfig);
            computeConfig(model.computeConfig);
            kubernetesNetworkConfig(model.kubernetesNetworkConfig);
            storageConfig(model.storageConfig);
            remoteNetworkConfig(model.remoteNetworkConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return resourcesVpcConfig != null ? resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final UpdateAccessConfigRequest.Builder getAccessConfig() {
            return accessConfig != null ? accessConfig.toBuilder() : null;
        }

        public final void setAccessConfig(UpdateAccessConfigRequest.BuilderImpl accessConfig) {
            this.accessConfig = accessConfig != null ? accessConfig.build() : null;
        }

        @Override
        public final Builder accessConfig(UpdateAccessConfigRequest accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        public final UpgradePolicyRequest.Builder getUpgradePolicy() {
            return upgradePolicy != null ? upgradePolicy.toBuilder() : null;
        }

        public final void setUpgradePolicy(UpgradePolicyRequest.BuilderImpl upgradePolicy) {
            this.upgradePolicy = upgradePolicy != null ? upgradePolicy.build() : null;
        }

        @Override
        public final Builder upgradePolicy(UpgradePolicyRequest upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            return this;
        }

        public final ZonalShiftConfigRequest.Builder getZonalShiftConfig() {
            return zonalShiftConfig != null ? zonalShiftConfig.toBuilder() : null;
        }

        public final void setZonalShiftConfig(ZonalShiftConfigRequest.BuilderImpl zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig != null ? zonalShiftConfig.build() : null;
        }

        @Override
        public final Builder zonalShiftConfig(ZonalShiftConfigRequest zonalShiftConfig) {
            this.zonalShiftConfig = zonalShiftConfig;
            return this;
        }

        public final ComputeConfigRequest.Builder getComputeConfig() {
            return computeConfig != null ? computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfigRequest.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfigRequest computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final KubernetesNetworkConfigRequest.Builder getKubernetesNetworkConfig() {
            return kubernetesNetworkConfig != null ? kubernetesNetworkConfig.toBuilder() : null;
        }

        public final void setKubernetesNetworkConfig(KubernetesNetworkConfigRequest.BuilderImpl kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig != null ? kubernetesNetworkConfig.build() : null;
        }

        @Override
        public final Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        public final StorageConfigRequest.Builder getStorageConfig() {
            return storageConfig != null ? storageConfig.toBuilder() : null;
        }

        public final void setStorageConfig(StorageConfigRequest.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public final Builder storageConfig(StorageConfigRequest storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public final RemoteNetworkConfigRequest.Builder getRemoteNetworkConfig() {
            return remoteNetworkConfig != null ? remoteNetworkConfig.toBuilder() : null;
        }

        public final void setRemoteNetworkConfig(RemoteNetworkConfigRequest.BuilderImpl remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig != null ? remoteNetworkConfig.build() : null;
        }

        @Override
        public final Builder remoteNetworkConfig(RemoteNetworkConfigRequest remoteNetworkConfig) {
            this.remoteNetworkConfig = remoteNetworkConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigRequest build() {
            return new UpdateClusterConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
