/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodegroupConfigRequest extends EksRequest implements
        ToCopyableBuilder<UpdateNodegroupConfigRequest.Builder, UpdateNodegroupConfigRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateNodegroupConfigRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupName").getter(getter(UpdateNodegroupConfigRequest::nodegroupName))
            .setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodegroupName").build()).build();

    private static final SdkField<UpdateLabelsPayload> LABELS_FIELD = SdkField
            .<UpdateLabelsPayload> builder(MarshallingType.SDK_POJO).memberName("labels")
            .getter(getter(UpdateNodegroupConfigRequest::labels)).setter(setter(Builder::labels))
            .constructor(UpdateLabelsPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build()).build();

    private static final SdkField<UpdateTaintsPayload> TAINTS_FIELD = SdkField
            .<UpdateTaintsPayload> builder(MarshallingType.SDK_POJO).memberName("taints")
            .getter(getter(UpdateNodegroupConfigRequest::taints)).setter(setter(Builder::taints))
            .constructor(UpdateTaintsPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taints").build()).build();

    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<NodegroupScalingConfig> builder(MarshallingType.SDK_POJO).memberName("scalingConfig")
            .getter(getter(UpdateNodegroupConfigRequest::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(NodegroupScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()).build();

    private static final SdkField<NodegroupUpdateConfig> UPDATE_CONFIG_FIELD = SdkField
            .<NodegroupUpdateConfig> builder(MarshallingType.SDK_POJO).memberName("updateConfig")
            .getter(getter(UpdateNodegroupConfigRequest::updateConfig)).setter(setter(Builder::updateConfig))
            .constructor(NodegroupUpdateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfig").build()).build();

    private static final SdkField<NodeRepairConfig> NODE_REPAIR_CONFIG_FIELD = SdkField
            .<NodeRepairConfig> builder(MarshallingType.SDK_POJO).memberName("nodeRepairConfig")
            .getter(getter(UpdateNodegroupConfigRequest::nodeRepairConfig)).setter(setter(Builder::nodeRepairConfig))
            .constructor(NodeRepairConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRepairConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateNodegroupConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, LABELS_FIELD, TAINTS_FIELD, SCALING_CONFIG_FIELD, UPDATE_CONFIG_FIELD,
            NODE_REPAIR_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String nodegroupName;

    private final UpdateLabelsPayload labels;

    private final UpdateTaintsPayload taints;

    private final NodegroupScalingConfig scalingConfig;

    private final NodegroupUpdateConfig updateConfig;

    private final NodeRepairConfig nodeRepairConfig;

    private final String clientRequestToken;

    private UpdateNodegroupConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.labels = builder.labels;
        this.taints = builder.taints;
        this.scalingConfig = builder.scalingConfig;
        this.updateConfig = builder.updateConfig;
        this.nodeRepairConfig = builder.nodeRepairConfig;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the managed node group to update.
     * </p>
     * 
     * @return The name of the managed node group to update.
     */
    public final String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.
     * </p>
     * 
     * @return The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.
     */
    public final UpdateLabelsPayload labels() {
        return labels;
    }

    /**
     * <p>
     * The Kubernetes taints to be applied to the nodes in the node group after the update. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on
     * managed node groups</a>.
     * </p>
     * 
     * @return The Kubernetes taints to be applied to the nodes in the node group after the update. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints
     *         on managed node groups</a>.
     */
    public final UpdateTaintsPayload taints() {
        return taints;
    }

    /**
     * <p>
     * The scaling configuration details for the Auto Scaling group after the update.
     * </p>
     * 
     * @return The scaling configuration details for the Auto Scaling group after the update.
     */
    public final NodegroupScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * <p>
     * The node group update configuration.
     * </p>
     * 
     * @return The node group update configuration.
     */
    public final NodegroupUpdateConfig updateConfig() {
        return updateConfig;
    }

    /**
     * <p>
     * The node auto repair configuration for the node group.
     * </p>
     * 
     * @return The node auto repair configuration for the node group.
     */
    public final NodeRepairConfig nodeRepairConfig() {
        return nodeRepairConfig;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        hashCode = 31 * hashCode + Objects.hashCode(taints());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(updateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRepairConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodegroupConfigRequest)) {
            return false;
        }
        UpdateNodegroupConfigRequest other = (UpdateNodegroupConfigRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodegroupName(), other.nodegroupName())
                && Objects.equals(labels(), other.labels()) && Objects.equals(taints(), other.taints())
                && Objects.equals(scalingConfig(), other.scalingConfig()) && Objects.equals(updateConfig(), other.updateConfig())
                && Objects.equals(nodeRepairConfig(), other.nodeRepairConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNodegroupConfigRequest").add("ClusterName", clusterName())
                .add("NodegroupName", nodegroupName()).add("Labels", labels()).add("Taints", taints())
                .add("ScalingConfig", scalingConfig()).add("UpdateConfig", updateConfig())
                .add("NodeRepairConfig", nodeRepairConfig()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "taints":
            return Optional.ofNullable(clazz.cast(taints()));
        case "scalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "updateConfig":
            return Optional.ofNullable(clazz.cast(updateConfig()));
        case "nodeRepairConfig":
            return Optional.ofNullable(clazz.cast(nodeRepairConfig()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", CLUSTER_NAME_FIELD);
        map.put("nodegroupName", NODEGROUP_NAME_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("taints", TAINTS_FIELD);
        map.put("scalingConfig", SCALING_CONFIG_FIELD);
        map.put("updateConfig", UPDATE_CONFIG_FIELD);
        map.put("nodeRepairConfig", NODE_REPAIR_CONFIG_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodegroupConfigRequest, T> g) {
        return obj -> g.apply((UpdateNodegroupConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodegroupConfigRequest> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the managed node group to update.
         * </p>
         * 
         * @param nodegroupName
         *        The name of the managed node group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.
         * </p>
         * 
         * @param labels
         *        The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(UpdateLabelsPayload labels);

        /**
         * <p>
         * The Kubernetes <code>labels</code> to apply to the nodes in the node group after the update.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateLabelsPayload.Builder} avoiding the
         * need to create one manually via {@link UpdateLabelsPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateLabelsPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #labels(UpdateLabelsPayload)}.
         * 
         * @param labels
         *        a consumer that will call methods on {@link UpdateLabelsPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(UpdateLabelsPayload)
         */
        default Builder labels(Consumer<UpdateLabelsPayload.Builder> labels) {
            return labels(UpdateLabelsPayload.builder().applyMutation(labels).build());
        }

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group after the update. For more information,
         * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         * taints on managed node groups</a>.
         * </p>
         * 
         * @param taints
         *        The Kubernetes taints to be applied to the nodes in the node group after the update. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         *        taints on managed node groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taints(UpdateTaintsPayload taints);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group after the update. For more information,
         * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         * taints on managed node groups</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateTaintsPayload.Builder} avoiding the
         * need to create one manually via {@link UpdateTaintsPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateTaintsPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #taints(UpdateTaintsPayload)}.
         * 
         * @param taints
         *        a consumer that will call methods on {@link UpdateTaintsPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taints(UpdateTaintsPayload)
         */
        default Builder taints(Consumer<UpdateTaintsPayload.Builder> taints) {
            return taints(UpdateTaintsPayload.builder().applyMutation(taints).build());
        }

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group after the update.
         * </p>
         * 
         * @param scalingConfig
         *        The scaling configuration details for the Auto Scaling group after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(NodegroupScalingConfig scalingConfig);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group after the update.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupScalingConfig.Builder} avoiding
         * the need to create one manually via {@link NodegroupScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfig(NodegroupScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link NodegroupScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(NodegroupScalingConfig)
         */
        default Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return scalingConfig(NodegroupScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * 
         * @param updateConfig
         *        The node group update configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateConfig(NodegroupUpdateConfig updateConfig);

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupUpdateConfig.Builder} avoiding
         * the need to create one manually via {@link NodegroupUpdateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupUpdateConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #updateConfig(NodegroupUpdateConfig)}.
         * 
         * @param updateConfig
         *        a consumer that will call methods on {@link NodegroupUpdateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateConfig(NodegroupUpdateConfig)
         */
        default Builder updateConfig(Consumer<NodegroupUpdateConfig.Builder> updateConfig) {
            return updateConfig(NodegroupUpdateConfig.builder().applyMutation(updateConfig).build());
        }

        /**
         * <p>
         * The node auto repair configuration for the node group.
         * </p>
         * 
         * @param nodeRepairConfig
         *        The node auto repair configuration for the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRepairConfig(NodeRepairConfig nodeRepairConfig);

        /**
         * <p>
         * The node auto repair configuration for the node group.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeRepairConfig.Builder} avoiding the
         * need to create one manually via {@link NodeRepairConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeRepairConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeRepairConfig(NodeRepairConfig)}.
         * 
         * @param nodeRepairConfig
         *        a consumer that will call methods on {@link NodeRepairConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeRepairConfig(NodeRepairConfig)
         */
        default Builder nodeRepairConfig(Consumer<NodeRepairConfig.Builder> nodeRepairConfig) {
            return nodeRepairConfig(NodeRepairConfig.builder().applyMutation(nodeRepairConfig).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private UpdateLabelsPayload labels;

        private UpdateTaintsPayload taints;

        private NodegroupScalingConfig scalingConfig;

        private NodegroupUpdateConfig updateConfig;

        private NodeRepairConfig nodeRepairConfig;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodegroupConfigRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            labels(model.labels);
            taints(model.taints);
            scalingConfig(model.scalingConfig);
            updateConfig(model.updateConfig);
            nodeRepairConfig(model.nodeRepairConfig);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final UpdateLabelsPayload.Builder getLabels() {
            return labels != null ? labels.toBuilder() : null;
        }

        public final void setLabels(UpdateLabelsPayload.BuilderImpl labels) {
            this.labels = labels != null ? labels.build() : null;
        }

        @Override
        public final Builder labels(UpdateLabelsPayload labels) {
            this.labels = labels;
            return this;
        }

        public final UpdateTaintsPayload.Builder getTaints() {
            return taints != null ? taints.toBuilder() : null;
        }

        public final void setTaints(UpdateTaintsPayload.BuilderImpl taints) {
            this.taints = taints != null ? taints.build() : null;
        }

        @Override
        public final Builder taints(UpdateTaintsPayload taints) {
            this.taints = taints;
            return this;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final NodegroupUpdateConfig.Builder getUpdateConfig() {
            return updateConfig != null ? updateConfig.toBuilder() : null;
        }

        public final void setUpdateConfig(NodegroupUpdateConfig.BuilderImpl updateConfig) {
            this.updateConfig = updateConfig != null ? updateConfig.build() : null;
        }

        @Override
        public final Builder updateConfig(NodegroupUpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        public final NodeRepairConfig.Builder getNodeRepairConfig() {
            return nodeRepairConfig != null ? nodeRepairConfig.toBuilder() : null;
        }

        public final void setNodeRepairConfig(NodeRepairConfig.BuilderImpl nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig != null ? nodeRepairConfig.build() : null;
        }

        @Override
        public final Builder nodeRepairConfig(NodeRepairConfig nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodegroupConfigRequest build() {
            return new UpdateNodegroupConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
