/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPoliciesResponse extends EksResponse implements
        ToCopyableBuilder<ListAccessPoliciesResponse.Builder, ListAccessPoliciesResponse> {
    private static final SdkField<List<AccessPolicy>> ACCESS_POLICIES_FIELD = SdkField
            .<List<AccessPolicy>> builder(MarshallingType.LIST)
            .memberName("accessPolicies")
            .getter(getter(ListAccessPoliciesResponse::accessPolicies))
            .setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AccessPolicy> accessPolicies;

    private final String nextToken;

    private ListAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicies = builder.accessPolicies;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessPolicies() {
        return accessPolicies != null && !(accessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessPolicies} method.
     * </p>
     * 
     * @return The list of available access policies. You can't view the contents of an access policy using the API. To
     *         view the contents, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
     *         >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     */
    public final List<AccessPolicy> accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated request, where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is null when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPolicies() ? accessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPoliciesResponse)) {
            return false;
        }
        ListAccessPoliciesResponse other = (ListAccessPoliciesResponse) obj;
        return hasAccessPolicies() == other.hasAccessPolicies() && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPoliciesResponse")
                .add("AccessPolicies", hasAccessPolicies() ? accessPolicies() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPolicies", ACCESS_POLICIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPoliciesResponse, T> g) {
        return obj -> g.apply((ListAccessPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessPoliciesResponse> {
        /**
         * <p>
         * The list of available access policies. You can't view the contents of an access policy using the API. To view
         * the contents, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
         * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param accessPolicies
         *        The list of available access policies. You can't view the contents of an access policy using the API.
         *        To view the contents, see <a href=
         *        "https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
         *        >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(Collection<AccessPolicy> accessPolicies);

        /**
         * <p>
         * The list of available access policies. You can't view the contents of an access policy using the API. To view
         * the contents, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
         * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param accessPolicies
         *        The list of available access policies. You can't view the contents of an access policy using the API.
         *        To view the contents, see <a href=
         *        "https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
         *        >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(AccessPolicy... accessPolicies);

        /**
         * <p>
         * The list of available access policies. You can't view the contents of an access policy using the API. To view
         * the contents, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
         * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.AccessPolicy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.AccessPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.AccessPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPolicies(List<AccessPolicy>)}.
         * 
         * @param accessPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.AccessPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicies(java.util.Collection<AccessPolicy>)
         */
        Builder accessPolicies(Consumer<AccessPolicy.Builder>... accessPolicies);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
         * was used and the results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the <code>nextToken</code> value. This value is null when there are no more
         * results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated request, where
         *        <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         *        continues from the end of the previous results that returned the <code>nextToken</code> value. This
         *        value is null when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<AccessPolicy> accessPolicies = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPoliciesResponse model) {
            super(model);
            accessPolicies(model.accessPolicies);
            nextToken(model.nextToken);
        }

        public final List<AccessPolicy.Builder> getAccessPolicies() {
            List<AccessPolicy.Builder> result = AccessPoliciesListCopier.copyToBuilder(this.accessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPolicies(Collection<AccessPolicy.BuilderImpl> accessPolicies) {
            this.accessPolicies = AccessPoliciesListCopier.copyFromBuilder(accessPolicies);
        }

        @Override
        public final Builder accessPolicies(Collection<AccessPolicy> accessPolicies) {
            this.accessPolicies = AccessPoliciesListCopier.copy(accessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicies(AccessPolicy... accessPolicies) {
            accessPolicies(Arrays.asList(accessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPolicies(Consumer<AccessPolicy.Builder>... accessPolicies) {
            accessPolicies(Stream.of(accessPolicies).map(c -> AccessPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessPoliciesResponse build() {
            return new ListAccessPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
