/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response object containing network access configuration for the Argo CD capability's managed API server endpoint.
 * If VPC endpoint IDs are present, public access is blocked and the Argo CD server is only accessible through the
 * specified VPC endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArgoCdNetworkAccessConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ArgoCdNetworkAccessConfigResponse.Builder, ArgoCdNetworkAccessConfigResponse> {
    private static final SdkField<List<String>> VPCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vpceIds")
            .getter(getter(ArgoCdNetworkAccessConfigResponse::vpceIds))
            .setter(setter(Builder::vpceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> vpceIds;

    private ArgoCdNetworkAccessConfigResponse(BuilderImpl builder) {
        this.vpceIds = builder.vpceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVpceIds() {
        return vpceIds != null && !(vpceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC endpoint provides
     * private connectivity from a specific VPC to the Argo CD server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpceIds} method.
     * </p>
     * 
     * @return The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC endpoint
     *         provides private connectivity from a specific VPC to the Argo CD server.
     */
    public final List<String> vpceIds() {
        return vpceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVpceIds() ? vpceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArgoCdNetworkAccessConfigResponse)) {
            return false;
        }
        ArgoCdNetworkAccessConfigResponse other = (ArgoCdNetworkAccessConfigResponse) obj;
        return hasVpceIds() == other.hasVpceIds() && Objects.equals(vpceIds(), other.vpceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArgoCdNetworkAccessConfigResponse").add("VpceIds", hasVpceIds() ? vpceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpceIds":
            return Optional.ofNullable(clazz.cast(vpceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpceIds", VPCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArgoCdNetworkAccessConfigResponse, T> g) {
        return obj -> g.apply((ArgoCdNetworkAccessConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArgoCdNetworkAccessConfigResponse> {
        /**
         * <p>
         * The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC endpoint
         * provides private connectivity from a specific VPC to the Argo CD server.
         * </p>
         * 
         * @param vpceIds
         *        The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC
         *        endpoint provides private connectivity from a specific VPC to the Argo CD server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceIds(Collection<String> vpceIds);

        /**
         * <p>
         * The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC endpoint
         * provides private connectivity from a specific VPC to the Argo CD server.
         * </p>
         * 
         * @param vpceIds
         *        The list of VPC endpoint IDs associated with the managed Argo CD API server endpoint. Each VPC
         *        endpoint provides private connectivity from a specific VPC to the Argo CD server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpceIds(String... vpceIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> vpceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArgoCdNetworkAccessConfigResponse model) {
            vpceIds(model.vpceIds);
        }

        public final Collection<String> getVpceIds() {
            if (vpceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpceIds;
        }

        public final void setVpceIds(Collection<String> vpceIds) {
            this.vpceIds = StringListCopier.copy(vpceIds);
        }

        @Override
        public final Builder vpceIds(Collection<String> vpceIds) {
            this.vpceIds = StringListCopier.copy(vpceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceIds(String... vpceIds) {
            vpceIds(Arrays.asList(vpceIds));
            return this;
        }

        @Override
        public ArgoCdNetworkAccessConfigResponse build() {
            return new ArgoCdNetworkAccessConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
