/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the resource being evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightResourceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightResourceDetail.Builder, InsightResourceDetail> {
    private static final SdkField<InsightStatus> INSIGHT_STATUS_FIELD = SdkField
            .<InsightStatus> builder(MarshallingType.SDK_POJO).memberName("insightStatus")
            .getter(getter(InsightResourceDetail::insightStatus)).setter(setter(Builder::insightStatus))
            .constructor(InsightStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insightStatus").build()).build();

    private static final SdkField<String> KUBERNETES_RESOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kubernetesResourceUri").getter(getter(InsightResourceDetail::kubernetesResourceUri))
            .setter(setter(Builder::kubernetesResourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesResourceUri").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(InsightResourceDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_STATUS_FIELD,
            KUBERNETES_RESOURCE_URI_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InsightStatus insightStatus;

    private final String kubernetesResourceUri;

    private final String arn;

    private InsightResourceDetail(BuilderImpl builder) {
        this.insightStatus = builder.insightStatus;
        this.kubernetesResourceUri = builder.kubernetesResourceUri;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * An object containing more detail on the status of the insight resource.
     * </p>
     * 
     * @return An object containing more detail on the status of the insight resource.
     */
    public final InsightStatus insightStatus() {
        return insightStatus;
    }

    /**
     * <p>
     * The Kubernetes resource URI if applicable.
     * </p>
     * 
     * @return The Kubernetes resource URI if applicable.
     */
    public final String kubernetesResourceUri() {
        return kubernetesResourceUri;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) if applicable.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) if applicable.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insightStatus());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesResourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightResourceDetail)) {
            return false;
        }
        InsightResourceDetail other = (InsightResourceDetail) obj;
        return Objects.equals(insightStatus(), other.insightStatus())
                && Objects.equals(kubernetesResourceUri(), other.kubernetesResourceUri()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightResourceDetail").add("InsightStatus", insightStatus())
                .add("KubernetesResourceUri", kubernetesResourceUri()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "insightStatus":
            return Optional.ofNullable(clazz.cast(insightStatus()));
        case "kubernetesResourceUri":
            return Optional.ofNullable(clazz.cast(kubernetesResourceUri()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("insightStatus", INSIGHT_STATUS_FIELD);
        map.put("kubernetesResourceUri", KUBERNETES_RESOURCE_URI_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightResourceDetail, T> g) {
        return obj -> g.apply((InsightResourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightResourceDetail> {
        /**
         * <p>
         * An object containing more detail on the status of the insight resource.
         * </p>
         * 
         * @param insightStatus
         *        An object containing more detail on the status of the insight resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightStatus(InsightStatus insightStatus);

        /**
         * <p>
         * An object containing more detail on the status of the insight resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsightStatus.Builder} avoiding the need
         * to create one manually via {@link InsightStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #insightStatus(InsightStatus)}.
         * 
         * @param insightStatus
         *        a consumer that will call methods on {@link InsightStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightStatus(InsightStatus)
         */
        default Builder insightStatus(Consumer<InsightStatus.Builder> insightStatus) {
            return insightStatus(InsightStatus.builder().applyMutation(insightStatus).build());
        }

        /**
         * <p>
         * The Kubernetes resource URI if applicable.
         * </p>
         * 
         * @param kubernetesResourceUri
         *        The Kubernetes resource URI if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesResourceUri(String kubernetesResourceUri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) if applicable.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private InsightStatus insightStatus;

        private String kubernetesResourceUri;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(InsightResourceDetail model) {
            insightStatus(model.insightStatus);
            kubernetesResourceUri(model.kubernetesResourceUri);
            arn(model.arn);
        }

        public final InsightStatus.Builder getInsightStatus() {
            return insightStatus != null ? insightStatus.toBuilder() : null;
        }

        public final void setInsightStatus(InsightStatus.BuilderImpl insightStatus) {
            this.insightStatus = insightStatus != null ? insightStatus.build() : null;
        }

        @Override
        public final Builder insightStatus(InsightStatus insightStatus) {
            this.insightStatus = insightStatus;
            return this;
        }

        public final String getKubernetesResourceUri() {
            return kubernetesResourceUri;
        }

        public final void setKubernetesResourceUri(String kubernetesResourceUri) {
            this.kubernetesResourceUri = kubernetesResourceUri;
        }

        @Override
        public final Builder kubernetesResourceUri(String kubernetesResourceUri) {
            this.kubernetesResourceUri = kubernetesResourceUri;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public InsightResourceDetail build() {
            return new InsightResourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
