/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPodIdentityAssociationsResponse extends EksResponse implements
        ToCopyableBuilder<ListPodIdentityAssociationsResponse.Builder, ListPodIdentityAssociationsResponse> {
    private static final SdkField<List<PodIdentityAssociationSummary>> ASSOCIATIONS_FIELD = SdkField
            .<List<PodIdentityAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(ListPodIdentityAssociationsResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PodIdentityAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PodIdentityAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPodIdentityAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PodIdentityAssociationSummary> associations;

    private final String nextToken;

    private ListPodIdentityAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of summarized descriptions of the associations that are in the cluster and match any filters that you
     * provided.
     * </p>
     * <p>
     * Each summary is simplified by removing these fields compared to the full <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
     * <code>PodIdentityAssociation</code> </a>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The IAM role: <code>roleArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp that the association was created at: <code>createdAt</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The tags on the association: <code>tags</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The list of summarized descriptions of the associations that are in the cluster and match any filters
     *         that you provided.</p>
     *         <p>
     *         Each summary is simplified by removing these fields compared to the full <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
     *         <code>PodIdentityAssociation</code> </a>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The IAM role: <code>roleArn</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The timestamp that the association was created at: <code>createdAt</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The tags on the association: <code>tags</code>
     *         </p>
     *         </li>
     */
    public final List<PodIdentityAssociationSummary> associations() {
        return associations;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListPodIdentityAssociations</code> request. When
     * the results of a <code>ListPodIdentityAssociations</code> request exceed <code>maxResults</code>, you can use
     * this value to retrieve the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListPodIdentityAssociations</code> request.
     *         When the results of a <code>ListPodIdentityAssociations</code> request exceed <code>maxResults</code>,
     *         you can use this value to retrieve the next page of results. This value is <code>null</code> when there
     *         are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPodIdentityAssociationsResponse)) {
            return false;
        }
        ListPodIdentityAssociationsResponse other = (ListPodIdentityAssociationsResponse) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPodIdentityAssociationsResponse")
                .add("Associations", hasAssociations() ? associations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPodIdentityAssociationsResponse, T> g) {
        return obj -> g.apply((ListPodIdentityAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPodIdentityAssociationsResponse> {
        /**
         * <p>
         * The list of summarized descriptions of the associations that are in the cluster and match any filters that
         * you provided.
         * </p>
         * <p>
         * Each summary is simplified by removing these fields compared to the full <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
         * <code>PodIdentityAssociation</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IAM role: <code>roleArn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The timestamp that the association was created at: <code>createdAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The tags on the association: <code>tags</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param associations
         *        The list of summarized descriptions of the associations that are in the cluster and match any filters
         *        that you provided.</p>
         *        <p>
         *        Each summary is simplified by removing these fields compared to the full <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
         *        <code>PodIdentityAssociation</code> </a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The IAM role: <code>roleArn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The timestamp that the association was created at: <code>createdAt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The tags on the association: <code>tags</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<PodIdentityAssociationSummary> associations);

        /**
         * <p>
         * The list of summarized descriptions of the associations that are in the cluster and match any filters that
         * you provided.
         * </p>
         * <p>
         * Each summary is simplified by removing these fields compared to the full <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
         * <code>PodIdentityAssociation</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IAM role: <code>roleArn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The timestamp that the association was created at: <code>createdAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The tags on the association: <code>tags</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param associations
         *        The list of summarized descriptions of the associations that are in the cluster and match any filters
         *        that you provided.</p>
         *        <p>
         *        Each summary is simplified by removing these fields compared to the full <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
         *        <code>PodIdentityAssociation</code> </a>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The IAM role: <code>roleArn</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The timestamp that the association was created at: <code>createdAt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The tags on the association: <code>tags</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(PodIdentityAssociationSummary... associations);

        /**
         * <p>
         * The list of summarized descriptions of the associations that are in the cluster and match any filters that
         * you provided.
         * </p>
         * <p>
         * Each summary is simplified by removing these fields compared to the full <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_PodIdentityAssociation.html">
         * <code>PodIdentityAssociation</code> </a>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The IAM role: <code>roleArn</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The timestamp that the association was created at: <code>createdAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The tags on the association: <code>tags</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<PodIdentityAssociationSummary>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<PodIdentityAssociationSummary>)
         */
        Builder associations(Consumer<PodIdentityAssociationSummary.Builder>... associations);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListPodIdentityAssociations</code> request.
         * When the results of a <code>ListPodIdentityAssociations</code> request exceed <code>maxResults</code>, you
         * can use this value to retrieve the next page of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListPodIdentityAssociations</code>
         *        request. When the results of a <code>ListPodIdentityAssociations</code> request exceed
         *        <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<PodIdentityAssociationSummary> associations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPodIdentityAssociationsResponse model) {
            super(model);
            associations(model.associations);
            nextToken(model.nextToken);
        }

        public final List<PodIdentityAssociationSummary.Builder> getAssociations() {
            List<PodIdentityAssociationSummary.Builder> result = PodIdentityAssociationSummariesCopier
                    .copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<PodIdentityAssociationSummary.BuilderImpl> associations) {
            this.associations = PodIdentityAssociationSummariesCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<PodIdentityAssociationSummary> associations) {
            this.associations = PodIdentityAssociationSummariesCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(PodIdentityAssociationSummary... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<PodIdentityAssociationSummary.Builder>... associations) {
            associations(Stream.of(associations).map(c -> PodIdentityAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPodIdentityAssociationsResponse build() {
            return new ListPodIdentityAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
