/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify granular overrides for specific repair actions. These overrides control the repair action and the repair
 * delay time before a node is considered eligible for repair. If you use this, you must specify all the values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeRepairConfigOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeRepairConfigOverrides.Builder, NodeRepairConfigOverrides> {
    private static final SdkField<String> NODE_MONITORING_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeMonitoringCondition").getter(getter(NodeRepairConfigOverrides::nodeMonitoringCondition))
            .setter(setter(Builder::nodeMonitoringCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeMonitoringCondition").build())
            .build();

    private static final SdkField<String> NODE_UNHEALTHY_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeUnhealthyReason").getter(getter(NodeRepairConfigOverrides::nodeUnhealthyReason))
            .setter(setter(Builder::nodeUnhealthyReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeUnhealthyReason").build())
            .build();

    private static final SdkField<Integer> MIN_REPAIR_WAIT_TIME_MINS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minRepairWaitTimeMins").getter(getter(NodeRepairConfigOverrides::minRepairWaitTimeMins))
            .setter(setter(Builder::minRepairWaitTimeMins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minRepairWaitTimeMins").build())
            .build();

    private static final SdkField<String> REPAIR_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repairAction").getter(getter(NodeRepairConfigOverrides::repairActionAsString))
            .setter(setter(Builder::repairAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repairAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NODE_MONITORING_CONDITION_FIELD, NODE_UNHEALTHY_REASON_FIELD, MIN_REPAIR_WAIT_TIME_MINS_FIELD, REPAIR_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeMonitoringCondition;

    private final String nodeUnhealthyReason;

    private final Integer minRepairWaitTimeMins;

    private final String repairAction;

    private NodeRepairConfigOverrides(BuilderImpl builder) {
        this.nodeMonitoringCondition = builder.nodeMonitoringCondition;
        this.nodeUnhealthyReason = builder.nodeUnhealthyReason;
        this.minRepairWaitTimeMins = builder.minRepairWaitTimeMins;
        this.repairAction = builder.repairAction;
    }

    /**
     * <p>
     * Specify an unhealthy condition reported by the node monitoring agent that this override would apply to.
     * </p>
     * 
     * @return Specify an unhealthy condition reported by the node monitoring agent that this override would apply to.
     */
    public final String nodeMonitoringCondition() {
        return nodeMonitoringCondition;
    }

    /**
     * <p>
     * Specify a reason reported by the node monitoring agent that this override would apply to.
     * </p>
     * 
     * @return Specify a reason reported by the node monitoring agent that this override would apply to.
     */
    public final String nodeUnhealthyReason() {
        return nodeUnhealthyReason;
    }

    /**
     * <p>
     * Specify the minimum time in minutes to wait before attempting to repair a node with this specific
     * <code>nodeMonitoringCondition</code> and <code>nodeUnhealthyReason</code>.
     * </p>
     * 
     * @return Specify the minimum time in minutes to wait before attempting to repair a node with this specific
     *         <code>nodeMonitoringCondition</code> and <code>nodeUnhealthyReason</code>.
     */
    public final Integer minRepairWaitTimeMins() {
        return minRepairWaitTimeMins;
    }

    /**
     * <p>
     * Specify the repair action to take for nodes when all of the specified conditions are met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repairAction} will
     * return {@link RepairAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repairActionAsString}.
     * </p>
     * 
     * @return Specify the repair action to take for nodes when all of the specified conditions are met.
     * @see RepairAction
     */
    public final RepairAction repairAction() {
        return RepairAction.fromValue(repairAction);
    }

    /**
     * <p>
     * Specify the repair action to take for nodes when all of the specified conditions are met.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repairAction} will
     * return {@link RepairAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repairActionAsString}.
     * </p>
     * 
     * @return Specify the repair action to take for nodes when all of the specified conditions are met.
     * @see RepairAction
     */
    public final String repairActionAsString() {
        return repairAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeMonitoringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUnhealthyReason());
        hashCode = 31 * hashCode + Objects.hashCode(minRepairWaitTimeMins());
        hashCode = 31 * hashCode + Objects.hashCode(repairActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRepairConfigOverrides)) {
            return false;
        }
        NodeRepairConfigOverrides other = (NodeRepairConfigOverrides) obj;
        return Objects.equals(nodeMonitoringCondition(), other.nodeMonitoringCondition())
                && Objects.equals(nodeUnhealthyReason(), other.nodeUnhealthyReason())
                && Objects.equals(minRepairWaitTimeMins(), other.minRepairWaitTimeMins())
                && Objects.equals(repairActionAsString(), other.repairActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeRepairConfigOverrides").add("NodeMonitoringCondition", nodeMonitoringCondition())
                .add("NodeUnhealthyReason", nodeUnhealthyReason()).add("MinRepairWaitTimeMins", minRepairWaitTimeMins())
                .add("RepairAction", repairActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeMonitoringCondition":
            return Optional.ofNullable(clazz.cast(nodeMonitoringCondition()));
        case "nodeUnhealthyReason":
            return Optional.ofNullable(clazz.cast(nodeUnhealthyReason()));
        case "minRepairWaitTimeMins":
            return Optional.ofNullable(clazz.cast(minRepairWaitTimeMins()));
        case "repairAction":
            return Optional.ofNullable(clazz.cast(repairActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeMonitoringCondition", NODE_MONITORING_CONDITION_FIELD);
        map.put("nodeUnhealthyReason", NODE_UNHEALTHY_REASON_FIELD);
        map.put("minRepairWaitTimeMins", MIN_REPAIR_WAIT_TIME_MINS_FIELD);
        map.put("repairAction", REPAIR_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeRepairConfigOverrides, T> g) {
        return obj -> g.apply((NodeRepairConfigOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeRepairConfigOverrides> {
        /**
         * <p>
         * Specify an unhealthy condition reported by the node monitoring agent that this override would apply to.
         * </p>
         * 
         * @param nodeMonitoringCondition
         *        Specify an unhealthy condition reported by the node monitoring agent that this override would apply
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeMonitoringCondition(String nodeMonitoringCondition);

        /**
         * <p>
         * Specify a reason reported by the node monitoring agent that this override would apply to.
         * </p>
         * 
         * @param nodeUnhealthyReason
         *        Specify a reason reported by the node monitoring agent that this override would apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUnhealthyReason(String nodeUnhealthyReason);

        /**
         * <p>
         * Specify the minimum time in minutes to wait before attempting to repair a node with this specific
         * <code>nodeMonitoringCondition</code> and <code>nodeUnhealthyReason</code>.
         * </p>
         * 
         * @param minRepairWaitTimeMins
         *        Specify the minimum time in minutes to wait before attempting to repair a node with this specific
         *        <code>nodeMonitoringCondition</code> and <code>nodeUnhealthyReason</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minRepairWaitTimeMins(Integer minRepairWaitTimeMins);

        /**
         * <p>
         * Specify the repair action to take for nodes when all of the specified conditions are met.
         * </p>
         * 
         * @param repairAction
         *        Specify the repair action to take for nodes when all of the specified conditions are met.
         * @see RepairAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepairAction
         */
        Builder repairAction(String repairAction);

        /**
         * <p>
         * Specify the repair action to take for nodes when all of the specified conditions are met.
         * </p>
         * 
         * @param repairAction
         *        Specify the repair action to take for nodes when all of the specified conditions are met.
         * @see RepairAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepairAction
         */
        Builder repairAction(RepairAction repairAction);
    }

    static final class BuilderImpl implements Builder {
        private String nodeMonitoringCondition;

        private String nodeUnhealthyReason;

        private Integer minRepairWaitTimeMins;

        private String repairAction;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRepairConfigOverrides model) {
            nodeMonitoringCondition(model.nodeMonitoringCondition);
            nodeUnhealthyReason(model.nodeUnhealthyReason);
            minRepairWaitTimeMins(model.minRepairWaitTimeMins);
            repairAction(model.repairAction);
        }

        public final String getNodeMonitoringCondition() {
            return nodeMonitoringCondition;
        }

        public final void setNodeMonitoringCondition(String nodeMonitoringCondition) {
            this.nodeMonitoringCondition = nodeMonitoringCondition;
        }

        @Override
        public final Builder nodeMonitoringCondition(String nodeMonitoringCondition) {
            this.nodeMonitoringCondition = nodeMonitoringCondition;
            return this;
        }

        public final String getNodeUnhealthyReason() {
            return nodeUnhealthyReason;
        }

        public final void setNodeUnhealthyReason(String nodeUnhealthyReason) {
            this.nodeUnhealthyReason = nodeUnhealthyReason;
        }

        @Override
        public final Builder nodeUnhealthyReason(String nodeUnhealthyReason) {
            this.nodeUnhealthyReason = nodeUnhealthyReason;
            return this;
        }

        public final Integer getMinRepairWaitTimeMins() {
            return minRepairWaitTimeMins;
        }

        public final void setMinRepairWaitTimeMins(Integer minRepairWaitTimeMins) {
            this.minRepairWaitTimeMins = minRepairWaitTimeMins;
        }

        @Override
        public final Builder minRepairWaitTimeMins(Integer minRepairWaitTimeMins) {
            this.minRepairWaitTimeMins = minRepairWaitTimeMins;
            return this;
        }

        public final String getRepairAction() {
            return repairAction;
        }

        public final void setRepairAction(String repairAction) {
            this.repairAction = repairAction;
        }

        @Override
        public final Builder repairAction(String repairAction) {
            this.repairAction = repairAction;
            return this;
        }

        @Override
        public final Builder repairAction(RepairAction repairAction) {
            this.repairAction(repairAction == null ? null : repairAction.toString());
            return this;
        }

        @Override
        public NodeRepairConfigOverrides build() {
            return new NodeRepairConfigOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
