/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to RBAC role mappings for an Argo CD capability. You can add, update, or remove role mappings in a single
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoleMappings implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateRoleMappings.Builder, UpdateRoleMappings> {
    private static final SdkField<List<ArgoCdRoleMapping>> ADD_OR_UPDATE_ROLE_MAPPINGS_FIELD = SdkField
            .<List<ArgoCdRoleMapping>> builder(MarshallingType.LIST)
            .memberName("addOrUpdateRoleMappings")
            .getter(getter(UpdateRoleMappings::addOrUpdateRoleMappings))
            .setter(setter(Builder::addOrUpdateRoleMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOrUpdateRoleMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArgoCdRoleMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArgoCdRoleMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ArgoCdRoleMapping>> REMOVE_ROLE_MAPPINGS_FIELD = SdkField
            .<List<ArgoCdRoleMapping>> builder(MarshallingType.LIST)
            .memberName("removeRoleMappings")
            .getter(getter(UpdateRoleMappings::removeRoleMappings))
            .setter(setter(Builder::removeRoleMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeRoleMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArgoCdRoleMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArgoCdRoleMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_OR_UPDATE_ROLE_MAPPINGS_FIELD, REMOVE_ROLE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ArgoCdRoleMapping> addOrUpdateRoleMappings;

    private final List<ArgoCdRoleMapping> removeRoleMappings;

    private UpdateRoleMappings(BuilderImpl builder) {
        this.addOrUpdateRoleMappings = builder.addOrUpdateRoleMappings;
        this.removeRoleMappings = builder.removeRoleMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOrUpdateRoleMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddOrUpdateRoleMappings() {
        return addOrUpdateRoleMappings != null && !(addOrUpdateRoleMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of role mappings to add or update. If a mapping for the specified role already exists, it will be updated
     * with the new identities. If it doesn't exist, a new mapping will be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOrUpdateRoleMappings} method.
     * </p>
     * 
     * @return A list of role mappings to add or update. If a mapping for the specified role already exists, it will be
     *         updated with the new identities. If it doesn't exist, a new mapping will be created.
     */
    public final List<ArgoCdRoleMapping> addOrUpdateRoleMappings() {
        return addOrUpdateRoleMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveRoleMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveRoleMappings() {
        return removeRoleMappings != null && !(removeRoleMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role (
     * <code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from that role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveRoleMappings} method.
     * </p>
     * 
     * @return A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role (
     *         <code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from that
     *         role.
     */
    public final List<ArgoCdRoleMapping> removeRoleMappings() {
        return removeRoleMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOrUpdateRoleMappings() ? addOrUpdateRoleMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveRoleMappings() ? removeRoleMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoleMappings)) {
            return false;
        }
        UpdateRoleMappings other = (UpdateRoleMappings) obj;
        return hasAddOrUpdateRoleMappings() == other.hasAddOrUpdateRoleMappings()
                && Objects.equals(addOrUpdateRoleMappings(), other.addOrUpdateRoleMappings())
                && hasRemoveRoleMappings() == other.hasRemoveRoleMappings()
                && Objects.equals(removeRoleMappings(), other.removeRoleMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoleMappings")
                .add("AddOrUpdateRoleMappings", hasAddOrUpdateRoleMappings() ? addOrUpdateRoleMappings() : null)
                .add("RemoveRoleMappings", hasRemoveRoleMappings() ? removeRoleMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addOrUpdateRoleMappings":
            return Optional.ofNullable(clazz.cast(addOrUpdateRoleMappings()));
        case "removeRoleMappings":
            return Optional.ofNullable(clazz.cast(removeRoleMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addOrUpdateRoleMappings", ADD_OR_UPDATE_ROLE_MAPPINGS_FIELD);
        map.put("removeRoleMappings", REMOVE_ROLE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoleMappings, T> g) {
        return obj -> g.apply((UpdateRoleMappings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateRoleMappings> {
        /**
         * <p>
         * A list of role mappings to add or update. If a mapping for the specified role already exists, it will be
         * updated with the new identities. If it doesn't exist, a new mapping will be created.
         * </p>
         * 
         * @param addOrUpdateRoleMappings
         *        A list of role mappings to add or update. If a mapping for the specified role already exists, it will
         *        be updated with the new identities. If it doesn't exist, a new mapping will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrUpdateRoleMappings(Collection<ArgoCdRoleMapping> addOrUpdateRoleMappings);

        /**
         * <p>
         * A list of role mappings to add or update. If a mapping for the specified role already exists, it will be
         * updated with the new identities. If it doesn't exist, a new mapping will be created.
         * </p>
         * 
         * @param addOrUpdateRoleMappings
         *        A list of role mappings to add or update. If a mapping for the specified role already exists, it will
         *        be updated with the new identities. If it doesn't exist, a new mapping will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrUpdateRoleMappings(ArgoCdRoleMapping... addOrUpdateRoleMappings);

        /**
         * <p>
         * A list of role mappings to add or update. If a mapping for the specified role already exists, it will be
         * updated with the new identities. If it doesn't exist, a new mapping will be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #addOrUpdateRoleMappings(List<ArgoCdRoleMapping>)}.
         * 
         * @param addOrUpdateRoleMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOrUpdateRoleMappings(java.util.Collection<ArgoCdRoleMapping>)
         */
        Builder addOrUpdateRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... addOrUpdateRoleMappings);

        /**
         * <p>
         * A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role (
         * <code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from that role.
         * </p>
         * 
         * @param removeRoleMappings
         *        A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role
         *        (<code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from
         *        that role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRoleMappings(Collection<ArgoCdRoleMapping> removeRoleMappings);

        /**
         * <p>
         * A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role (
         * <code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from that role.
         * </p>
         * 
         * @param removeRoleMappings
         *        A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role
         *        (<code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from
         *        that role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRoleMappings(ArgoCdRoleMapping... removeRoleMappings);

        /**
         * <p>
         * A list of role mappings to remove from the RBAC configuration. Each mapping specifies an Argo CD role (
         * <code>ADMIN</code>, <code>EDITOR</code>, or <code>VIEWER</code>) and the identities to remove from that role.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #removeRoleMappings(List<ArgoCdRoleMapping>)}.
         * 
         * @param removeRoleMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.ArgoCdRoleMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeRoleMappings(java.util.Collection<ArgoCdRoleMapping>)
         */
        Builder removeRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... removeRoleMappings);
    }

    static final class BuilderImpl implements Builder {
        private List<ArgoCdRoleMapping> addOrUpdateRoleMappings = DefaultSdkAutoConstructList.getInstance();

        private List<ArgoCdRoleMapping> removeRoleMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoleMappings model) {
            addOrUpdateRoleMappings(model.addOrUpdateRoleMappings);
            removeRoleMappings(model.removeRoleMappings);
        }

        public final List<ArgoCdRoleMapping.Builder> getAddOrUpdateRoleMappings() {
            List<ArgoCdRoleMapping.Builder> result = ArgoCdRoleMappingListCopier.copyToBuilder(this.addOrUpdateRoleMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOrUpdateRoleMappings(Collection<ArgoCdRoleMapping.BuilderImpl> addOrUpdateRoleMappings) {
            this.addOrUpdateRoleMappings = ArgoCdRoleMappingListCopier.copyFromBuilder(addOrUpdateRoleMappings);
        }

        @Override
        public final Builder addOrUpdateRoleMappings(Collection<ArgoCdRoleMapping> addOrUpdateRoleMappings) {
            this.addOrUpdateRoleMappings = ArgoCdRoleMappingListCopier.copy(addOrUpdateRoleMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateRoleMappings(ArgoCdRoleMapping... addOrUpdateRoleMappings) {
            addOrUpdateRoleMappings(Arrays.asList(addOrUpdateRoleMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOrUpdateRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... addOrUpdateRoleMappings) {
            addOrUpdateRoleMappings(Stream.of(addOrUpdateRoleMappings)
                    .map(c -> ArgoCdRoleMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ArgoCdRoleMapping.Builder> getRemoveRoleMappings() {
            List<ArgoCdRoleMapping.Builder> result = ArgoCdRoleMappingListCopier.copyToBuilder(this.removeRoleMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveRoleMappings(Collection<ArgoCdRoleMapping.BuilderImpl> removeRoleMappings) {
            this.removeRoleMappings = ArgoCdRoleMappingListCopier.copyFromBuilder(removeRoleMappings);
        }

        @Override
        public final Builder removeRoleMappings(Collection<ArgoCdRoleMapping> removeRoleMappings) {
            this.removeRoleMappings = ArgoCdRoleMappingListCopier.copy(removeRoleMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRoleMappings(ArgoCdRoleMapping... removeRoleMappings) {
            removeRoleMappings(Arrays.asList(removeRoleMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRoleMappings(Consumer<ArgoCdRoleMapping.Builder>... removeRoleMappings) {
            removeRoleMappings(Stream.of(removeRoleMappings).map(c -> ArgoCdRoleMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateRoleMappings build() {
            return new UpdateRoleMappings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
