/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eksauth;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityRequest;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityResponse;

/**
 * Service client for accessing Amazon EKS Auth asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod Identity
 * Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EksAuthAsyncClient extends AwsClient {
    String SERVICE_NAME = "eks-auth";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "eks-auth";

    /**
     * <p>
     * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod
     * Identity Agent.
     * </p>
     * <p>
     * We recommend that applications use the Amazon Web Services SDKs to connect to Amazon Web Services services; if
     * credentials from an EKS Pod Identity association are available in the pod, the latest versions of the SDKs use
     * them automatically.
     * </p>
     *
     * @param assumeRoleForPodIdentityRequest
     * @return A Java Future containing the result of the AssumeRoleForPodIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because your request rate is too high. Reduce the
     *         frequency of requests.</li>
     *         <li>InvalidRequestException This exception is thrown if the request contains a semantic error. The
     *         precise meaning will depend on the API, and will be documented in the error message.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The IAM
     *         principal making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidTokenException The specified Kubernetes service account token is invalid.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExpiredTokenException The specified Kubernetes service account token is expired.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Back off and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EksAuthException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EksAuthAsyncClient.AssumeRoleForPodIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeRoleForPodIdentityResponse> assumeRoleForPodIdentity(
            AssumeRoleForPodIdentityRequest assumeRoleForPodIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod
     * Identity Agent.
     * </p>
     * <p>
     * We recommend that applications use the Amazon Web Services SDKs to connect to Amazon Web Services services; if
     * credentials from an EKS Pod Identity association are available in the pod, the latest versions of the SDKs use
     * them automatically.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssumeRoleForPodIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link AssumeRoleForPodIdentityRequest#builder()}
     * </p>
     *
     * @param assumeRoleForPodIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssumeRoleForPodIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request was denied because your request rate is too high. Reduce the
     *         frequency of requests.</li>
     *         <li>InvalidRequestException This exception is thrown if the request contains a semantic error. The
     *         precise meaning will depend on the API, and will be documented in the error message.</li>
     *         <li>AccessDeniedException You don't have permissions to perform the requested operation. The IAM
     *         principal making the request must have at least one IAM permissions policy attached that grants the
     *         required permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access management</a> in the <i>IAM
     *         User Guide</i>.</li>
     *         <li>InternalServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidTokenException The specified Kubernetes service account token is invalid.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExpiredTokenException The specified Kubernetes service account token is expired.</li>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ServiceUnavailableException The service is unavailable. Back off and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EksAuthException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample EksAuthAsyncClient.AssumeRoleForPodIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssumeRoleForPodIdentityResponse> assumeRoleForPodIdentity(
            Consumer<AssumeRoleForPodIdentityRequest.Builder> assumeRoleForPodIdentityRequest) {
        return assumeRoleForPodIdentity(AssumeRoleForPodIdentityRequest.builder().applyMutation(assumeRoleForPodIdentityRequest)
                .build());
    }

    @Override
    default EksAuthServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EksAuthAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EksAuthAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EksAuthAsyncClient}.
     */
    static EksAuthAsyncClientBuilder builder() {
        return new DefaultEksAuthAsyncClientBuilder();
    }
}
