/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eksauth.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeRoleForPodIdentityResponse extends EksAuthResponse implements
        ToCopyableBuilder<AssumeRoleForPodIdentityResponse.Builder, AssumeRoleForPodIdentityResponse> {
    private static final SdkField<Subject> SUBJECT_FIELD = SdkField.<Subject> builder(MarshallingType.SDK_POJO)
            .memberName("subject").getter(getter(AssumeRoleForPodIdentityResponse::subject)).setter(setter(Builder::subject))
            .constructor(Subject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> AUDIENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audience").getter(getter(AssumeRoleForPodIdentityResponse::audience)).setter(setter(Builder::audience))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audience").build()).build();

    private static final SdkField<PodIdentityAssociation> POD_IDENTITY_ASSOCIATION_FIELD = SdkField
            .<PodIdentityAssociation> builder(MarshallingType.SDK_POJO).memberName("podIdentityAssociation")
            .getter(getter(AssumeRoleForPodIdentityResponse::podIdentityAssociation))
            .setter(setter(Builder::podIdentityAssociation)).constructor(PodIdentityAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podIdentityAssociation").build())
            .build();

    private static final SdkField<AssumedRoleUser> ASSUMED_ROLE_USER_FIELD = SdkField
            .<AssumedRoleUser> builder(MarshallingType.SDK_POJO).memberName("assumedRoleUser")
            .getter(getter(AssumeRoleForPodIdentityResponse::assumedRoleUser)).setter(setter(Builder::assumedRoleUser))
            .constructor(AssumedRoleUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assumedRoleUser").build()).build();

    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.<Credentials> builder(MarshallingType.SDK_POJO)
            .memberName("credentials").getter(getter(AssumeRoleForPodIdentityResponse::credentials))
            .setter(setter(Builder::credentials)).constructor(Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, AUDIENCE_FIELD,
            POD_IDENTITY_ASSOCIATION_FIELD, ASSUMED_ROLE_USER_FIELD, CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Subject subject;

    private final String audience;

    private final PodIdentityAssociation podIdentityAssociation;

    private final AssumedRoleUser assumedRoleUser;

    private final Credentials credentials;

    private AssumeRoleForPodIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.audience = builder.audience;
        this.podIdentityAssociation = builder.podIdentityAssociation;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     * 
     * @return The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public final Subject subject() {
        return subject;
    }

    /**
     * <p>
     * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>.
     * </p>
     * 
     * @return The identity that is allowed to use the credentials. This value is always
     *         <code>pods.eks.amazonaws.com</code>.
     */
    public final String audience() {
        return audience;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     */
    public final PodIdentityAssociation podIdentityAssociation() {
        return podIdentityAssociation;
    }

    /**
     * <p>
     * An object with the permanent IAM role identity and the temporary session name.
     * </p>
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @return An object with the permanent IAM role identity and the temporary session name.</p>
     *         <p>
     *         The ARN of the IAM role that the temporary credentials authenticate to.
     *         </p>
     *         <p>
     *         The session name of the temporary session requested to STS. The value is a unique identifier that
     *         contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
     *         assumed. The role ID is generated by IAM when the role is created. The role session name part of the
     *         value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */
    public final AssumedRoleUser assumedRoleUser() {
        return assumedRoleUser;
    }

    /**
     * <p>
     * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * </p>
     * 
     * @return The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     */
    public final Credentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(audience());
        hashCode = 31 * hashCode + Objects.hashCode(podIdentityAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleForPodIdentityResponse)) {
            return false;
        }
        AssumeRoleForPodIdentityResponse other = (AssumeRoleForPodIdentityResponse) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(audience(), other.audience())
                && Objects.equals(podIdentityAssociation(), other.podIdentityAssociation())
                && Objects.equals(assumedRoleUser(), other.assumedRoleUser())
                && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumeRoleForPodIdentityResponse").add("Subject", subject()).add("Audience", audience())
                .add("PodIdentityAssociation", podIdentityAssociation()).add("AssumedRoleUser", assumedRoleUser())
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "audience":
            return Optional.ofNullable(clazz.cast(audience()));
        case "podIdentityAssociation":
            return Optional.ofNullable(clazz.cast(podIdentityAssociation()));
        case "assumedRoleUser":
            return Optional.ofNullable(clazz.cast(assumedRoleUser()));
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subject", SUBJECT_FIELD);
        map.put("audience", AUDIENCE_FIELD);
        map.put("podIdentityAssociation", POD_IDENTITY_ASSOCIATION_FIELD);
        map.put("assumedRoleUser", ASSUMED_ROLE_USER_FIELD);
        map.put("credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeRoleForPodIdentityResponse, T> g) {
        return obj -> g.apply((AssumeRoleForPodIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksAuthResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssumeRoleForPodIdentityResponse> {
        /**
         * <p>
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         * </p>
         * 
         * @param subject
         *        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(Subject subject);

        /**
         * <p>
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         * </p>
         * This is a convenience method that creates an instance of the {@link Subject.Builder} avoiding the need to
         * create one manually via {@link Subject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Subject.Builder#build()} is called immediately and its result is
         * passed to {@link #subject(Subject)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link Subject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(Subject)
         */
        default Builder subject(Consumer<Subject.Builder> subject) {
            return subject(Subject.builder().applyMutation(subject).build());
        }

        /**
         * <p>
         * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>
         * .
         * </p>
         * 
         * @param audience
         *        The identity that is allowed to use the credentials. This value is always
         *        <code>pods.eks.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
         * </p>
         * 
         * @param podIdentityAssociation
         *        The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podIdentityAssociation(PodIdentityAssociation podIdentityAssociation);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
         * </p>
         * This is a convenience method that creates an instance of the {@link PodIdentityAssociation.Builder} avoiding
         * the need to create one manually via {@link PodIdentityAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PodIdentityAssociation.Builder#build()} is called immediately and
         * its result is passed to {@link #podIdentityAssociation(PodIdentityAssociation)}.
         * 
         * @param podIdentityAssociation
         *        a consumer that will call methods on {@link PodIdentityAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #podIdentityAssociation(PodIdentityAssociation)
         */
        default Builder podIdentityAssociation(Consumer<PodIdentityAssociation.Builder> podIdentityAssociation) {
            return podIdentityAssociation(PodIdentityAssociation.builder().applyMutation(podIdentityAssociation).build());
        }

        /**
         * <p>
         * An object with the permanent IAM role identity and the temporary session name.
         * </p>
         * <p>
         * The ARN of the IAM role that the temporary credentials authenticate to.
         * </p>
         * <p>
         * The session name of the temporary session requested to STS. The value is a unique identifier that contains
         * the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role
         * ID is generated by IAM when the role is created. The role session name part of the value follows this format:
         * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
         * </p>
         * 
         * @param assumedRoleUser
         *        An object with the permanent IAM role identity and the temporary session name.</p>
         *        <p>
         *        The ARN of the IAM role that the temporary credentials authenticate to.
         *        </p>
         *        <p>
         *        The session name of the temporary session requested to STS. The value is a unique identifier that
         *        contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
         *        assumed. The role ID is generated by IAM when the role is created. The role session name part of the
         *        value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRoleUser(AssumedRoleUser assumedRoleUser);

        /**
         * <p>
         * An object with the permanent IAM role identity and the temporary session name.
         * </p>
         * <p>
         * The ARN of the IAM role that the temporary credentials authenticate to.
         * </p>
         * <p>
         * The session name of the temporary session requested to STS. The value is a unique identifier that contains
         * the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role
         * ID is generated by IAM when the role is created. The role session name part of the value follows this format:
         * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
         * </p>
         * This is a convenience method that creates an instance of the {@link AssumedRoleUser.Builder} avoiding the
         * need to create one manually via {@link AssumedRoleUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssumedRoleUser.Builder#build()} is called immediately and its
         * result is passed to {@link #assumedRoleUser(AssumedRoleUser)}.
         * 
         * @param assumedRoleUser
         *        a consumer that will call methods on {@link AssumedRoleUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assumedRoleUser(AssumedRoleUser)
         */
        default Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return assumedRoleUser(AssumedRoleUser.builder().applyMutation(assumedRoleUser).build());
        }

        /**
         * <p>
         * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
         * </p>
         * 
         * @param credentials
         *        The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link Credentials.Builder} avoiding the need to
         * create one manually via {@link Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }
    }

    static final class BuilderImpl extends EksAuthResponse.BuilderImpl implements Builder {
        private Subject subject;

        private String audience;

        private PodIdentityAssociation podIdentityAssociation;

        private AssumedRoleUser assumedRoleUser;

        private Credentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleForPodIdentityResponse model) {
            super(model);
            subject(model.subject);
            audience(model.audience);
            podIdentityAssociation(model.podIdentityAssociation);
            assumedRoleUser(model.assumedRoleUser);
            credentials(model.credentials);
        }

        public final Subject.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        public final void setSubject(Subject.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public final String getAudience() {
            return audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final PodIdentityAssociation.Builder getPodIdentityAssociation() {
            return podIdentityAssociation != null ? podIdentityAssociation.toBuilder() : null;
        }

        public final void setPodIdentityAssociation(PodIdentityAssociation.BuilderImpl podIdentityAssociation) {
            this.podIdentityAssociation = podIdentityAssociation != null ? podIdentityAssociation.build() : null;
        }

        @Override
        public final Builder podIdentityAssociation(PodIdentityAssociation podIdentityAssociation) {
            this.podIdentityAssociation = podIdentityAssociation;
            return this;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return assumedRoleUser != null ? assumedRoleUser.toBuilder() : null;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public AssumeRoleForPodIdentityResponse build() {
            return new AssumeRoleForPodIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
