/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateUserGroupRequest.Builder, CreateUserGroupRequest> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(CreateUserGroupRequest::userGroupId)).setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateUserGroupRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(CreateUserGroupRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateUserGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD,
            ENGINE_FIELD, USER_IDS_FIELD, TAGS_FIELD));

    private final String userGroupId;

    private final String engine;

    private final List<String> userIds;

    private final List<Tag> tags;

    private CreateUserGroupRequest(BuilderImpl builder) {
        super(builder);
        this.userGroupId = builder.userGroupId;
        this.engine = builder.engine;
        this.userIds = builder.userIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the user group.
     * </p>
     * 
     * @return The ID of the user group.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * <p>
     * The current supported value is Redis.
     * </p>
     * 
     * @return The current supported value is Redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * Returns true if the UserIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs that belong to the user group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user IDs that belong to the user group.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag
     * value, although null is accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by
     *         a tag value, although null is accepted.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserGroupRequest)) {
            return false;
        }
        CreateUserGroupRequest other = (CreateUserGroupRequest) obj;
        return Objects.equals(userGroupId(), other.userGroupId()) && Objects.equals(engine(), other.engine())
                && hasUserIds() == other.hasUserIds() && Objects.equals(userIds(), other.userIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserGroupRequest").add("UserGroupId", userGroupId()).add("Engine", engine())
                .add("UserIds", hasUserIds() ? userIds() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserGroupRequest, T> g) {
        return obj -> g.apply((CreateUserGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserGroupRequest> {
        /**
         * <p>
         * The ID of the user group.
         * </p>
         * 
         * @param userGroupId
         *        The ID of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * The current supported value is Redis.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String userGroupId;

        private String engine;

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserGroupRequest model) {
            super(model);
            userGroupId(model.userGroupId);
            engine(model.engine);
            userIds(model.userIds);
            tags(model.tags);
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListInputCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListInputCopier.copy(userIds);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserGroupRequest build() {
            return new CreateUserGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
