/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAllowedNodeTypeModificationsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ListAllowedNodeTypeModificationsRequest.Builder, ListAllowedNodeTypeModificationsRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(ListAllowedNodeTypeModificationsRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(ListAllowedNodeTypeModificationsRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            REPLICATION_GROUP_ID_FIELD));

    private final String cacheClusterId;

    private final String replicationGroupId;

    private ListAllowedNodeTypeModificationsRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.replicationGroupId = builder.replicationGroupId;
    }

    /**
     * <p>
     * The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to
     * identify the current node type of this cluster and from that to create a list of node types you can scale up to.
     * </p>
     * <important>
     * <p>
     * You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.
     * </p>
     * </important>
     * 
     * @return The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the
     *         cluster id to identify the current node type of this cluster and from that to create a list of node types
     *         you can scale up to.</p> <important>
     *         <p>
     *         You must provide a value for either the <code>CacheClusterId</code> or the
     *         <code>ReplicationGroupId</code>.
     *         </p>
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group
     * id to identify the current node type being used by this replication group, and from that to create a list of node
     * types you can scale up to.
     * </p>
     * <important>
     * <p>
     * You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.
     * </p>
     * </important>
     * 
     * @return The name of the replication group want to scale up to a larger node type. ElastiCache uses the
     *         replication group id to identify the current node type being used by this replication group, and from
     *         that to create a list of node types you can scale up to.</p> <important>
     *         <p>
     *         You must provide a value for either the <code>CacheClusterId</code> or the
     *         <code>ReplicationGroupId</code>.
     *         </p>
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedNodeTypeModificationsRequest)) {
            return false;
        }
        ListAllowedNodeTypeModificationsRequest other = (ListAllowedNodeTypeModificationsRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(replicationGroupId(), other.replicationGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAllowedNodeTypeModificationsRequest").add("CacheClusterId", cacheClusterId())
                .add("ReplicationGroupId", replicationGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedNodeTypeModificationsRequest, T> g) {
        return obj -> g.apply((ListAllowedNodeTypeModificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAllowedNodeTypeModificationsRequest> {
        /**
         * <p>
         * The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id
         * to identify the current node type of this cluster and from that to create a list of node types you can scale
         * up to.
         * </p>
         * <important>
         * <p>
         * You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.
         * </p>
         * </important>
         * 
         * @param cacheClusterId
         *        The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the
         *        cluster id to identify the current node type of this cluster and from that to create a list of node
         *        types you can scale up to.</p> <important>
         *        <p>
         *        You must provide a value for either the <code>CacheClusterId</code> or the
         *        <code>ReplicationGroupId</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication
         * group id to identify the current node type being used by this replication group, and from that to create a
         * list of node types you can scale up to.
         * </p>
         * <important>
         * <p>
         * You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.
         * </p>
         * </important>
         * 
         * @param replicationGroupId
         *        The name of the replication group want to scale up to a larger node type. ElastiCache uses the
         *        replication group id to identify the current node type being used by this replication group, and from
         *        that to create a list of node types you can scale up to.</p> <important>
         *        <p>
         *        You must provide a value for either the <code>CacheClusterId</code> or the
         *        <code>ReplicationGroupId</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private String replicationGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedNodeTypeModificationsRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            replicationGroupId(model.replicationGroupId);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAllowedNodeTypeModificationsRequest build() {
            return new ListAllowedNodeTypeModificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
