/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ModifyCacheParameterGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCacheParameterGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyCacheParameterGroupRequest.Builder, ModifyCacheParameterGroupRequest> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(ModifyCacheParameterGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<List<ParameterNameValue>> PARAMETER_NAME_VALUES_FIELD = SdkField
            .<List<ParameterNameValue>> builder(MarshallingType.LIST)
            .memberName("ParameterNameValues")
            .getter(getter(ModifyCacheParameterGroupRequest::parameterNameValues))
            .setter(setter(Builder::parameterNameValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ParameterNameValue")
                            .memberFieldInfo(
                                    SdkField.<ParameterNameValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterNameValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ParameterNameValue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_PARAMETER_GROUP_NAME_FIELD, PARAMETER_NAME_VALUES_FIELD));

    private final String cacheParameterGroupName;

    private final List<ParameterNameValue> parameterNameValues;

    private ModifyCacheParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    /**
     * <p>
     * The name of the cache parameter group to modify.
     * </p>
     * 
     * @return The name of the cache parameter group to modify.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * Returns true if the ParameterNameValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasParameterNameValues() {
        return parameterNameValues != null && !(parameterNameValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameter names and values for the parameter update. You must supply at least one parameter name and
     * value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameterNameValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of parameter names and values for the parameter update. You must supply at least one parameter
     *         name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per
     *         request.
     */
    public final List<ParameterNameValue> parameterNameValues() {
        return parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterNameValues() ? parameterNameValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheParameterGroupRequest)) {
            return false;
        }
        ModifyCacheParameterGroupRequest other = (ModifyCacheParameterGroupRequest) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && hasParameterNameValues() == other.hasParameterNameValues()
                && Objects.equals(parameterNameValues(), other.parameterNameValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCacheParameterGroupRequest").add("CacheParameterGroupName", cacheParameterGroupName())
                .add("ParameterNameValues", hasParameterNameValues() ? parameterNameValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "ParameterNameValues":
            return Optional.ofNullable(clazz.cast(parameterNameValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCacheParameterGroupRequest, T> g) {
        return obj -> g.apply((ModifyCacheParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCacheParameterGroupRequest> {
        /**
         * <p>
         * The name of the cache parameter group to modify.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * An array of parameter names and values for the parameter update. You must supply at least one parameter name
         * and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of parameter names and values for the parameter update. You must supply at least one
         *        parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be
         *        modified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues);

        /**
         * <p>
         * An array of parameter names and values for the parameter update. You must supply at least one parameter name
         * and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.
         * </p>
         * 
         * @param parameterNameValues
         *        An array of parameter names and values for the parameter update. You must supply at least one
         *        parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be
         *        modified per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(ParameterNameValue... parameterNameValues);

        /**
         * <p>
         * An array of parameter names and values for the parameter update. You must supply at least one parameter name
         * and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ParameterNameValue>.Builder} avoiding the
         * need to create one manually via {@link List<ParameterNameValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParameterNameValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterNameValues(List<ParameterNameValue>)}.
         * 
         * @param parameterNameValues
         *        a consumer that will call methods on {@link List<ParameterNameValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterNameValues(List<ParameterNameValue>)
         */
        Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheParameterGroupRequest model) {
            super(model);
            cacheParameterGroupName(model.cacheParameterGroupName);
            parameterNameValues(model.parameterNameValues);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        public final List<ParameterNameValue.Builder> getParameterNameValues() {
            List<ParameterNameValue.Builder> result = ParameterNameValueListCopier.copyToBuilder(this.parameterNameValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue... parameterNameValues) {
            parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues) {
            parameterNameValues(Stream.of(parameterNameValues).map(c -> ParameterNameValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCacheParameterGroupRequest build() {
            return new ModifyCacheParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
