/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(User::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(User::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(User::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(User::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(User::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIds")
            .getter(getter(User::userGroupIds))
            .setter(setter(Builder::userGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Authentication> AUTHENTICATION_FIELD = SdkField
            .<Authentication> builder(MarshallingType.SDK_POJO).memberName("Authentication").getter(getter(User::authentication))
            .setter(setter(Builder::authentication)).constructor(Authentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(User::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_NAME_FIELD, STATUS_FIELD, ENGINE_FIELD, ACCESS_STRING_FIELD, USER_GROUP_IDS_FIELD, AUTHENTICATION_FIELD,
            ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String userName;

    private final String status;

    private final String engine;

    private final String accessString;

    private final List<String> userGroupIds;

    private final Authentication authentication;

    private final String arn;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.status = builder.status;
        this.engine = builder.engine;
        this.accessString = builder.accessString;
        this.userGroupIds = builder.userGroupIds;
        this.authentication = builder.authentication;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The username of the user.
     * </p>
     * 
     * @return The username of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Indicates the user status. Can be "active", "modifying" or "deleting".
     * </p>
     * 
     * @return Indicates the user status. Can be "active", "modifying" or "deleting".
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The current supported value is Redis.
     * </p>
     * 
     * @return The current supported value is Redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    /**
     * Returns true if the UserGroupIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserGroupIds() {
        return userGroupIds != null && !(userGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of the user group IDs the user belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of the user group IDs the user belongs to.
     */
    public final List<String> userGroupIds() {
        return userGroupIds;
    }

    /**
     * <p>
     * Denotes whether the user requires a password to authenticate.
     * </p>
     * 
     * @return Denotes whether the user requires a password to authenticate.
     */
    public final Authentication authentication() {
        return authentication;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIds() ? userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(status(), other.status()) && Objects.equals(engine(), other.engine())
                && Objects.equals(accessString(), other.accessString()) && hasUserGroupIds() == other.hasUserGroupIds()
                && Objects.equals(userGroupIds(), other.userGroupIds())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("UserId", userId()).add("UserName", userName()).add("Status", status())
                .add("Engine", engine()).add("AccessString", accessString())
                .add("UserGroupIds", hasUserGroupIds() ? userGroupIds() : null).add("Authentication", authentication())
                .add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        case "UserGroupIds":
            return Optional.ofNullable(clazz.cast(userGroupIds()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The username of the user.
         * </p>
         * 
         * @param userName
         *        The username of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Indicates the user status. Can be "active", "modifying" or "deleting".
         * </p>
         * 
         * @param status
         *        Indicates the user status. Can be "active", "modifying" or "deleting".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The current supported value is Redis.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        /**
         * <p>
         * Returns a list of the user group IDs the user belongs to.
         * </p>
         * 
         * @param userGroupIds
         *        Returns a list of the user group IDs the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(Collection<String> userGroupIds);

        /**
         * <p>
         * Returns a list of the user group IDs the user belongs to.
         * </p>
         * 
         * @param userGroupIds
         *        Returns a list of the user group IDs the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(String... userGroupIds);

        /**
         * <p>
         * Denotes whether the user requires a password to authenticate.
         * </p>
         * 
         * @param authentication
         *        Denotes whether the user requires a password to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(Authentication authentication);

        /**
         * <p>
         * Denotes whether the user requires a password to authenticate.
         * </p>
         * This is a convenience that creates an instance of the {@link Authentication.Builder} avoiding the need to
         * create one manually via {@link Authentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link Authentication.Builder#build()} is called immediately and its
         * result is passed to {@link #authentication(Authentication)}.
         * 
         * @param authentication
         *        a consumer that will call methods on {@link Authentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authentication(Authentication)
         */
        default Builder authentication(Consumer<Authentication.Builder> authentication) {
            return authentication(Authentication.builder().applyMutation(authentication).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String userName;

        private String status;

        private String engine;

        private String accessString;

        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Authentication authentication;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            userId(model.userId);
            userName(model.userName);
            status(model.status);
            engine(model.engine);
            accessString(model.accessString);
            userGroupIds(model.userGroupIds);
            authentication(model.authentication);
            arn(model.arn);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getAccessString() {
            return accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        public final Collection<String> getUserGroupIds() {
            if (userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIds;
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String... userGroupIds) {
            userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
        }

        public final Authentication.Builder getAuthentication() {
            return authentication != null ? authentication.toBuilder() : null;
        }

        @Override
        public final Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final void setAuthentication(Authentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
