/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of one of the following operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>ModifyCacheParameterGroup</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ResetCacheParameterGroup</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCacheParameterGroupResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<ModifyCacheParameterGroupResponse.Builder, ModifyCacheParameterGroupResponse> {
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(ModifyCacheParameterGroupResponse::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CACHE_PARAMETER_GROUP_NAME_FIELD));

    private final String cacheParameterGroupName;

    private ModifyCacheParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the cache parameter group.
     * </p>
     * 
     * @return The name of the cache parameter group.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheParameterGroupResponse)) {
            return false;
        }
        ModifyCacheParameterGroupResponse other = (ModifyCacheParameterGroupResponse) obj;
        return Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCacheParameterGroupResponse").add("CacheParameterGroupName", cacheParameterGroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCacheParameterGroupResponse, T> g) {
        return obj -> g.apply((ModifyCacheParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyCacheParameterGroupResponse> {
        /**
         * <p>
         * The name of the cache parameter group.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String cacheParameterGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheParameterGroupResponse model) {
            super(model);
            cacheParameterGroupName(model.cacheParameterGroupName);
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public ModifyCacheParameterGroupResponse build() {
            return new ModifyCacheParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
