/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single node within a node group (shard).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeGroupMember implements SdkPojo, Serializable, ToCopyableBuilder<NodeGroupMember.Builder, NodeGroupMember> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(NodeGroupMember::cacheClusterId)).setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeId").getter(getter(NodeGroupMember::cacheNodeId)).setter(setter(Builder::cacheNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()).build();

    private static final SdkField<Endpoint> READ_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("ReadEndpoint").getter(getter(NodeGroupMember::readEndpoint)).setter(setter(Builder::readEndpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadEndpoint").build()).build();

    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredAvailabilityZone").getter(getter(NodeGroupMember::preferredAvailabilityZone))
            .setter(setter(Builder::preferredAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build())
            .build();

    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredOutpostArn").getter(getter(NodeGroupMember::preferredOutpostArn))
            .setter(setter(Builder::preferredOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build())
            .build();

    private static final SdkField<String> CURRENT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentRole").getter(getter(NodeGroupMember::currentRole)).setter(setter(Builder::currentRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            CACHE_NODE_ID_FIELD, READ_ENDPOINT_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_OUTPOST_ARN_FIELD,
            CURRENT_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheClusterId;

    private final String cacheNodeId;

    private final Endpoint readEndpoint;

    private final String preferredAvailabilityZone;

    private final String preferredOutpostArn;

    private final String currentRole;

    private NodeGroupMember(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.readEndpoint = builder.readEndpoint;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.currentRole = builder.currentRole;
    }

    /**
     * <p>
     * The ID of the cluster to which the node belongs.
     * </p>
     * 
     * @return The ID of the cluster to which the node belongs.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
     * </p>
     * 
     * @return The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
     */
    public final String cacheNodeId() {
        return cacheNodeId;
    }

    /**
     * <p>
     * The information required for client programs to connect to a node for read operations. The read endpoint is only
     * applicable on Redis (cluster mode disabled) clusters.
     * </p>
     * 
     * @return The information required for client programs to connect to a node for read operations. The read endpoint
     *         is only applicable on Redis (cluster mode disabled) clusters.
     */
    public final Endpoint readEndpoint() {
        return readEndpoint;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the node is located.
     * </p>
     * 
     * @return The name of the Availability Zone in which the node is located.
     */
    public final String preferredAvailabilityZone() {
        return preferredAvailabilityZone;
    }

    /**
     * <p>
     * The outpost ARN of the node group member.
     * </p>
     * 
     * @return The outpost ARN of the node group member.
     */
    public final String preferredOutpostArn() {
        return preferredOutpostArn;
    }

    /**
     * <p>
     * The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>. This member is
     * only applicable for Redis (cluster mode disabled) replication groups.
     * </p>
     * 
     * @return The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>. This
     *         member is only applicable for Redis (cluster mode disabled) replication groups.
     */
    public final String currentRole() {
        return currentRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(readEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMember)) {
            return false;
        }
        NodeGroupMember other = (NodeGroupMember) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId()) && Objects.equals(cacheNodeId(), other.cacheNodeId())
                && Objects.equals(readEndpoint(), other.readEndpoint())
                && Objects.equals(preferredAvailabilityZone(), other.preferredAvailabilityZone())
                && Objects.equals(preferredOutpostArn(), other.preferredOutpostArn())
                && Objects.equals(currentRole(), other.currentRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeGroupMember").add("CacheClusterId", cacheClusterId()).add("CacheNodeId", cacheNodeId())
                .add("ReadEndpoint", readEndpoint()).add("PreferredAvailabilityZone", preferredAvailabilityZone())
                .add("PreferredOutpostArn", preferredOutpostArn()).add("CurrentRole", currentRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "CacheNodeId":
            return Optional.ofNullable(clazz.cast(cacheNodeId()));
        case "ReadEndpoint":
            return Optional.ofNullable(clazz.cast(readEndpoint()));
        case "PreferredAvailabilityZone":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZone()));
        case "PreferredOutpostArn":
            return Optional.ofNullable(clazz.cast(preferredOutpostArn()));
        case "CurrentRole":
            return Optional.ofNullable(clazz.cast(currentRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupMember, T> g) {
        return obj -> g.apply((NodeGroupMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeGroupMember> {
        /**
         * <p>
         * The ID of the cluster to which the node belongs.
         * </p>
         * 
         * @param cacheClusterId
         *        The ID of the cluster to which the node belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
         * </p>
         * 
         * @param cacheNodeId
         *        The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeId(String cacheNodeId);

        /**
         * <p>
         * The information required for client programs to connect to a node for read operations. The read endpoint is
         * only applicable on Redis (cluster mode disabled) clusters.
         * </p>
         * 
         * @param readEndpoint
         *        The information required for client programs to connect to a node for read operations. The read
         *        endpoint is only applicable on Redis (cluster mode disabled) clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readEndpoint(Endpoint readEndpoint);

        /**
         * <p>
         * The information required for client programs to connect to a node for read operations. The read endpoint is
         * only applicable on Redis (cluster mode disabled) clusters.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #readEndpoint(Endpoint)}.
         * 
         * @param readEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readEndpoint(Endpoint)
         */
        default Builder readEndpoint(Consumer<Endpoint.Builder> readEndpoint) {
            return readEndpoint(Endpoint.builder().applyMutation(readEndpoint).build());
        }

        /**
         * <p>
         * The name of the Availability Zone in which the node is located.
         * </p>
         * 
         * @param preferredAvailabilityZone
         *        The name of the Availability Zone in which the node is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZone(String preferredAvailabilityZone);

        /**
         * <p>
         * The outpost ARN of the node group member.
         * </p>
         * 
         * @param preferredOutpostArn
         *        The outpost ARN of the node group member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredOutpostArn(String preferredOutpostArn);

        /**
         * <p>
         * The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>. This member
         * is only applicable for Redis (cluster mode disabled) replication groups.
         * </p>
         * 
         * @param currentRole
         *        The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>. This
         *        member is only applicable for Redis (cluster mode disabled) replication groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRole(String currentRole);
    }

    static final class BuilderImpl implements Builder {
        private String cacheClusterId;

        private String cacheNodeId;

        private Endpoint readEndpoint;

        private String preferredAvailabilityZone;

        private String preferredOutpostArn;

        private String currentRole;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMember model) {
            cacheClusterId(model.cacheClusterId);
            cacheNodeId(model.cacheNodeId);
            readEndpoint(model.readEndpoint);
            preferredAvailabilityZone(model.preferredAvailabilityZone);
            preferredOutpostArn(model.preferredOutpostArn);
            currentRole(model.currentRole);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getCacheNodeId() {
            return cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final Endpoint.Builder getReadEndpoint() {
            return readEndpoint != null ? readEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder readEndpoint(Endpoint readEndpoint) {
            this.readEndpoint = readEndpoint;
            return this;
        }

        public final void setReadEndpoint(Endpoint.BuilderImpl readEndpoint) {
            this.readEndpoint = readEndpoint != null ? readEndpoint.build() : null;
        }

        public final String getPreferredAvailabilityZone() {
            return preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        public final String getPreferredOutpostArn() {
            return preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        public final String getCurrentRole() {
            return currentRole;
        }

        @Override
        public final Builder currentRole(String currentRole) {
            this.currentRole = currentRole;
            return this;
        }

        public final void setCurrentRole(String currentRole) {
            this.currentRole = currentRole;
        }

        @Override
        public NodeGroupMember build() {
            return new NodeGroupMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
