/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeCacheClusters</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCacheClustersResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeCacheClustersResponse.Builder, DescribeCacheClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeCacheClustersResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<CacheCluster>> CACHE_CLUSTERS_FIELD = SdkField
            .<List<CacheCluster>> builder(MarshallingType.LIST)
            .memberName("CacheClusters")
            .getter(getter(DescribeCacheClustersResponse::cacheClusters))
            .setter(setter(Builder::cacheClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheCluster")
                            .memberFieldInfo(
                                    SdkField.<CacheCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheCluster").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CACHE_CLUSTERS_FIELD));

    private final String marker;

    private final List<CacheCluster> cacheClusters;

    private DescribeCacheClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheClusters = builder.cacheClusters;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheClusters() {
        return cacheClusters != null && !(cacheClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of clusters. Each item in the list contains detailed information about one cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheClusters} method.
     * </p>
     * 
     * @return A list of clusters. Each item in the list contains detailed information about one cluster.
     */
    public final List<CacheCluster> cacheClusters() {
        return cacheClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheClusters() ? cacheClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResponse)) {
            return false;
        }
        DescribeCacheClustersResponse other = (DescribeCacheClustersResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasCacheClusters() == other.hasCacheClusters()
                && Objects.equals(cacheClusters(), other.cacheClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCacheClustersResponse").add("Marker", marker())
                .add("CacheClusters", hasCacheClusters() ? cacheClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CacheClusters":
            return Optional.ofNullable(clazz.cast(cacheClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheClustersResponse, T> g) {
        return obj -> g.apply((DescribeCacheClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCacheClustersResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * 
         * @param cacheClusters
         *        A list of clusters. Each item in the list contains detailed information about one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusters(Collection<CacheCluster> cacheClusters);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * 
         * @param cacheClusters
         *        A list of clusters. Each item in the list contains detailed information about one cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusters(CacheCluster... cacheClusters);

        /**
         * <p>
         * A list of clusters. Each item in the list contains detailed information about one cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CacheCluster>.Builder} avoiding the
         * need to create one manually via {@link List<CacheCluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CacheCluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheClusters(List<CacheCluster>)}.
         * 
         * @param cacheClusters
         *        a consumer that will call methods on {@link List<CacheCluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheClusters(List<CacheCluster>)
         */
        Builder cacheClusters(Consumer<CacheCluster.Builder>... cacheClusters);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<CacheCluster> cacheClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheClustersResponse model) {
            super(model);
            marker(model.marker);
            cacheClusters(model.cacheClusters);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<CacheCluster.Builder> getCacheClusters() {
            List<CacheCluster.Builder> result = CacheClusterListCopier.copyToBuilder(this.cacheClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheClusters(Collection<CacheCluster.BuilderImpl> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copyFromBuilder(cacheClusters);
        }

        @Override
        public final Builder cacheClusters(Collection<CacheCluster> cacheClusters) {
            this.cacheClusters = CacheClusterListCopier.copy(cacheClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(CacheCluster... cacheClusters) {
            cacheClusters(Arrays.asList(cacheClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusters(Consumer<CacheCluster.Builder>... cacheClusters) {
            cacheClusters(Stream.of(cacheClusters).map(c -> CacheCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCacheClustersResponse build() {
            return new DescribeCacheClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
