/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUpdateActionsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeUpdateActionsResponse.Builder, DescribeUpdateActionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeUpdateActionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<UpdateAction>> UPDATE_ACTIONS_FIELD = SdkField
            .<List<UpdateAction>> builder(MarshallingType.LIST)
            .memberName("UpdateActions")
            .getter(getter(DescribeUpdateActionsResponse::updateActions))
            .setter(setter(Builder::updateActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UpdateAction")
                            .memberFieldInfo(
                                    SdkField.<UpdateAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UpdateAction").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            UPDATE_ACTIONS_FIELD));

    private final String marker;

    private final List<UpdateAction> updateActions;

    private DescribeUpdateActionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.updateActions = builder.updateActions;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpdateActions() {
        return updateActions != null && !(updateActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of update actions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateActions} method.
     * </p>
     * 
     * @return Returns a list of update actions
     */
    public final List<UpdateAction> updateActions() {
        return updateActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateActions() ? updateActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateActionsResponse)) {
            return false;
        }
        DescribeUpdateActionsResponse other = (DescribeUpdateActionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasUpdateActions() == other.hasUpdateActions()
                && Objects.equals(updateActions(), other.updateActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUpdateActionsResponse").add("Marker", marker())
                .add("UpdateActions", hasUpdateActions() ? updateActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "UpdateActions":
            return Optional.ofNullable(clazz.cast(updateActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateActionsResponse, T> g) {
        return obj -> g.apply((DescribeUpdateActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUpdateActionsResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * 
         * @param updateActions
         *        Returns a list of update actions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActions(Collection<UpdateAction> updateActions);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * 
         * @param updateActions
         *        Returns a list of update actions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActions(UpdateAction... updateActions);

        /**
         * <p>
         * Returns a list of update actions
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UpdateAction>.Builder} avoiding the
         * need to create one manually via {@link List<UpdateAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #updateActions(List<UpdateAction>)}.
         * 
         * @param updateActions
         *        a consumer that will call methods on {@link List<UpdateAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateActions(List<UpdateAction>)
         */
        Builder updateActions(Consumer<UpdateAction.Builder>... updateActions);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<UpdateAction> updateActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateActionsResponse model) {
            super(model);
            marker(model.marker);
            updateActions(model.updateActions);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<UpdateAction.Builder> getUpdateActions() {
            List<UpdateAction.Builder> result = UpdateActionListCopier.copyToBuilder(this.updateActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateActions(Collection<UpdateAction.BuilderImpl> updateActions) {
            this.updateActions = UpdateActionListCopier.copyFromBuilder(updateActions);
        }

        @Override
        public final Builder updateActions(Collection<UpdateAction> updateActions) {
            this.updateActions = UpdateActionListCopier.copy(updateActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(UpdateAction... updateActions) {
            updateActions(Arrays.asList(updateActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActions(Consumer<UpdateAction.Builder>... updateActions) {
            updateActions(Stream.of(updateActions).map(c -> UpdateAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeUpdateActionsResponse build() {
            return new DescribeUpdateActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
