/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ModifyCacheCluster</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCacheClusterRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyCacheClusterRequest.Builder, ModifyCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(ModifyCacheClusterRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumCacheNodes").getter(getter(ModifyCacheClusterRequest::numCacheNodes))
            .setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheNodeIdsToRemove")
            .getter(getter(ModifyCacheClusterRequest::cacheNodeIdsToRemove))
            .setter(setter(Builder::cacheNodeIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeId").build()).build()).build()).build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AZMode")
            .getter(getter(ModifyCacheClusterRequest::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZMode").build()).build();

    private static final SdkField<List<String>> NEW_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewAvailabilityZones")
            .getter(getter(ModifyCacheClusterRequest::newAvailabilityZones))
            .setter(setter(Builder::newAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PreferredAvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PreferredAvailabilityZone").build()).build()).build()).build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheSecurityGroupNames")
            .getter(getter(ModifyCacheClusterRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ModifyCacheClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyCacheClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(ModifyCacheClusterRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(ModifyCacheClusterRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicStatus").getter(getter(ModifyCacheClusterRequest::notificationTopicStatus))
            .setter(setter(Builder::notificationTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyCacheClusterRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyCacheClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyCacheClusterRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ModifyCacheClusterRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(ModifyCacheClusterRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(ModifyCacheClusterRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(ModifyCacheClusterRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<String> AUTH_TOKEN_UPDATE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthTokenUpdateStrategy").getter(getter(ModifyCacheClusterRequest::authTokenUpdateStrategyAsString))
            .setter(setter(Builder::authTokenUpdateStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenUpdateStrategy").build())
            .build();

    private static final SdkField<List<LogDeliveryConfigurationRequest>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(ModifyCacheClusterRequest::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfigurationRequest")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfigurationRequest").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            NUM_CACHE_NODES_FIELD, CACHE_NODE_IDS_TO_REMOVE_FIELD, AZ_MODE_FIELD, NEW_AVAILABILITY_ZONES_FIELD,
            CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            NOTIFICATION_TOPIC_ARN_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, NOTIFICATION_TOPIC_STATUS_FIELD,
            APPLY_IMMEDIATELY_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_FIELD, AUTH_TOKEN_UPDATE_STRATEGY_FIELD,
            LOG_DELIVERY_CONFIGURATIONS_FIELD));

    private final String cacheClusterId;

    private final Integer numCacheNodes;

    private final List<String> cacheNodeIdsToRemove;

    private final String azMode;

    private final List<String> newAvailabilityZones;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final String preferredMaintenanceWindow;

    private final String notificationTopicArn;

    private final String cacheParameterGroupName;

    private final String notificationTopicStatus;

    private final Boolean applyImmediately;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String cacheNodeType;

    private final String authToken;

    private final String authTokenUpdateStrategy;

    private final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations;

    private ModifyCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.azMode = builder.azMode;
        this.newAvailabilityZones = builder.newAvailabilityZones;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.authToken = builder.authToken;
        this.authTokenUpdateStrategy = builder.authTokenUpdateStrategy;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
    }

    /**
     * <p>
     * The cluster identifier. This value is stored as a lowercase string.
     * </p>
     * 
     * @return The cluster identifier. This value is stored as a lowercase string.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater
     * than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be
     * zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If
     * the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.
     * </p>
     * <p>
     * If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs
     * of the specific cache nodes to remove.
     * </p>
     * <p>
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1
     * and 40.
     * </p>
     * <note>
     * <p>
     * Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see
     * <code>ApplyImmediately</code>).
     * </p>
     * <p>
     * A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by
     * adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest
     * request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of
     * cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation
     * to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3
     * nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with
     * flexible cache node placement, a request to add nodes does not automatically override a previous pending
     * operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly
     * cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache
     * nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to
     * the number of cache nodes currently in the cluster.
     * </p>
     * </note>
     * 
     * @return The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is
     *         greater than the sum of the number of current cache nodes and the number of cache nodes pending creation
     *         (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes,
     *         nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove
     *         requests are canceled.</p>
     *         <p>
     *         If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide
     *         the IDs of the specific cache nodes to remove.
     *         </p>
     *         <p>
     *         For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
     *         between 1 and 40.
     *         </p>
     *         <note>
     *         <p>
     *         Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see
     *         <code>ApplyImmediately</code>).
     *         </p>
     *         <p>
     *         A pending operation to modify the number of cache nodes in a cluster during its maintenance window,
     *         whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The
     *         customer's latest request to add or remove nodes to the cluster overrides any previous pending operations
     *         to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would
     *         override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would
     *         override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now
     *         be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes
     *         does not automatically override a previous pending operation to add nodes. The customer can modify the
     *         previous pending operation to add more nodes or explicitly cancel the pending request and retry the new
     *         request. To cancel pending operations to modify the number of cache nodes in a cluster, use the
     *         <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache
     *         nodes currently in the cluster.
     *         </p>
     */
    public final Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheNodeIdsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove != null && !(cacheNodeIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is
     * only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache
     * node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the
     * cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.
     * </p>
     * <p>
     * For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this
     * <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheNodeIdsToRemove} method.
     * </p>
     * 
     * @return A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This
     *         parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes.
     *         The number of cache node IDs supplied in this parameter must match the difference between the existing
     *         number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of
     *         <code>NumCacheNodes</code> in the request.</p>
     *         <p>
     *         For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in
     *         this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
     */
    public final List<String> cacheNodeIdsToRemove() {
        return cacheNodeIdsToRemove;
    }

    /**
     * <p>
     * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or
     * created across multiple Availability Zones.
     * </p>
     * <p>
     * Valid values: <code>single-az</code> | <code>cross-az</code>.
     * </p>
     * <p>
     * This option is only supported for Memcached clusters.
     * </p>
     * <note>
     * <p>
     * You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
     * Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current
     * Availability Zone.
     * </p>
     * <p>
     * Only newly created nodes are located in different Availability Zones.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone
     *         or created across multiple Availability Zones.</p>
     *         <p>
     *         Valid values: <code>single-az</code> | <code>cross-az</code>.
     *         </p>
     *         <p>
     *         This option is only supported for Memcached clusters.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
     *         Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their
     *         current Availability Zone.
     *         </p>
     *         <p>
     *         Only newly created nodes are located in different Availability Zones.
     *         </p>
     * @see AZMode
     */
    public final AZMode azMode() {
        return AZMode.fromValue(azMode);
    }

    /**
     * <p>
     * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or
     * created across multiple Availability Zones.
     * </p>
     * <p>
     * Valid values: <code>single-az</code> | <code>cross-az</code>.
     * </p>
     * <p>
     * This option is only supported for Memcached clusters.
     * </p>
     * <note>
     * <p>
     * You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
     * Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current
     * Availability Zone.
     * </p>
     * <p>
     * Only newly created nodes are located in different Availability Zones.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone
     *         or created across multiple Availability Zones.</p>
     *         <p>
     *         Valid values: <code>single-az</code> | <code>cross-az</code>.
     *         </p>
     *         <p>
     *         This option is only supported for Memcached clusters.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
     *         Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their
     *         current Availability Zone.
     *         </p>
     *         <p>
     *         Only newly created nodes are located in different Availability Zones.
     *         </p>
     * @see AZMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewAvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewAvailabilityZones() {
        return newAvailabilityZones != null && !(newAvailabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * This option is only supported on Memcached clusters.
     * </p>
     * </note>
     * <p>
     * The list of Availability Zones where the new Memcached cache nodes are created.
     * </p>
     * <p>
     * This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number
     * of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of
     * Availability Zones supplied in this list must match the cache nodes being added in this request.
     * </p>
     * <p>
     * Scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2)
     * and optionally specify two Availability Zones for the two new nodes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to
     * add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone
     * for the new node.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all
     * pending operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes
     * pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.
     * </p>
     * <p>
     * If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only
     * newly created nodes can be located in different Availability Zones. For guidance on how to move existing
     * Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node
     * Considerations for Memcached</a>.
     * </p>
     * <p>
     * <b>Impact of new add/remove requests upon pending requests</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Scenario-1
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Action: Delete
     * </p>
     * </li>
     * <li>
     * <p>
     * New Request: Delete
     * </p>
     * </li>
     * <li>
     * <p>
     * Result: The new delete, pending or immediate, replaces the pending delete.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scenario-2
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Action: Delete
     * </p>
     * </li>
     * <li>
     * <p>
     * New Request: Create
     * </p>
     * </li>
     * <li>
     * <p>
     * Result: The new create, pending or immediate, replaces the pending delete.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scenario-3
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Action: Create
     * </p>
     * </li>
     * <li>
     * <p>
     * New Request: Delete
     * </p>
     * </li>
     * <li>
     * <p>
     * Result: The new delete, pending or immediate, replaces the pending create.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Scenario-4
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Action: Create
     * </p>
     * </li>
     * <li>
     * <p>
     * New Request: Create
     * </p>
     * </li>
     * <li>
     * <p>
     * Result: The new create is added to the pending create.
     * </p>
     * <important>
     * <p>
     * <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed
     * immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.
     * </p>
     * </important></li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewAvailabilityZones} method.
     * </p>
     * 
     * @return <p>
     *         This option is only supported on Memcached clusters.
     *         </p>
     *         </note>
     *         <p>
     *         The list of Availability Zones where the new Memcached cache nodes are created.
     *         </p>
     *         <p>
     *         This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of
     *         the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The
     *         number of Availability Zones supplied in this list must match the cache nodes being added in this
     *         request.
     *         </p>
     *         <p>
     *         Scenarios:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code>
     *         (3 + 2) and optionally specify two Availability Zones for the two new nodes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and
     *         want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an
     *         Availability Zone for the new node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to
     *         cancel all pending operations.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any
     *         nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.
     *         </p>
     *         <p>
     *         If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability
     *         Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to
     *         move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone
     *         Considerations</b> section of <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache
     *         Node Considerations for Memcached</a>.
     *         </p>
     *         <p>
     *         <b>Impact of new add/remove requests upon pending requests</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Scenario-1
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Action: Delete
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         New Request: Delete
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Result: The new delete, pending or immediate, replaces the pending delete.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scenario-2
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Action: Delete
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         New Request: Create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Result: The new create, pending or immediate, replaces the pending delete.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scenario-3
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Action: Create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         New Request: Delete
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Result: The new delete, pending or immediate, replaces the pending create.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Scenario-4
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Action: Create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         New Request: Create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Result: The new create is added to the pending create.
     *         </p>
     *         <important>
     *         <p>
     *         <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed
     *         immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.
     *         </p>
     *         </important></li>
     *         </ul>
     *         </li>
     */
    public final List<String> newAvailabilityZones() {
        return newAvailabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheSecurityGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon
     * as possible.
     * </p>
     * <p>
     * You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheSecurityGroupNames} method.
     * </p>
     * 
     * @return A list of cache security group names to authorize on this cluster. This change is asynchronously applied
     *         as soon as possible.</p>
     *         <p>
     *         You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     *         </p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
     */
    public final List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the VPC Security Groups associated with the cluster.
     * </p>
     * <p>
     * This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return Specifies the VPC Security Groups associated with the cluster.</p>
     *         <p>
     *         This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon
     *         VPC).
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be same as the cluster owner.
     *         </p>
     */
    public final String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as
     * possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for
     * this request.
     * </p>
     * 
     * @return The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as
     *         soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as
     *         <code>true</code> for this request.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>
     * .
     * </p>
     * <p>
     * Valid values: <code>active</code> | <code>inactive</code>
     * </p>
     * 
     * @return The status of the Amazon SNS notification topic. Notifications are sent only if the status is
     *         <code>active</code>.</p>
     *         <p>
     *         Valid values: <code>active</code> | <code>inactive</code>
     */
    public final String notificationTopicStatus() {
        return notificationTopicStatus;
    }

    /**
     * <p>
     * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be
     * applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     * setting for the cluster.
     * </p>
     * <p>
     * If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure
     * reboot, whichever occurs first.
     * </p>
     * <important>
     * <p>
     * If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending
     * modification is replaced by the newer modification.
     * </p>
     * </important>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If <code>true</code>, this parameter causes the modifications in this request and any pending
     *         modifications to be applied, asynchronously and as soon as possible, regardless of the
     *         <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
     *         <p>
     *         If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next
     *         failure reboot, whichever occurs first.
     *         </p>
     *         <important>
     *         <p>
     *         If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending
     *         modification is replaced by the newer modification.
     *         </p>
     *         </important>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The upgraded version of the cache engine to be run on the cache nodes.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an
     * earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.
     * </p>
     * 
     * @return The upgraded version of the cache engine to be run on the cache nodes.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
     *         want to use an earlier engine version, you must delete the existing cluster and create it anew with the
     *         earlier engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *         the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example,
     * if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     * before being deleted.
     * </p>
     * <note>
     * <p>
     * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     * </p>
     * </note>
     * 
     * @return The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
     *         example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
     *         for 5 days before being deleted.</p> <note>
     *         <p>
     *         If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     *         </p>
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A valid cache node type that you want to scale this cluster up to.
     * </p>
     * 
     * @return A valid cache node type that you want to scale this cluster up to.
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified
     * with the <code>auth-token-update</code> parameter. Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain any of the following characters: '/', '"', or '@', '%'
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     * </p>
     * 
     * @return Reserved parameter. The password used to access a password protected server. This parameter must be
     *         specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain any of the following characters: '/', '"', or '@', '%'
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public final AuthTokenUpdateStrategyType authTokenUpdateStrategy() {
        return AuthTokenUpdateStrategyType.fromValue(authTokenUpdateStrategy);
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public final String authTokenUpdateStrategyAsString() {
        return authTokenUpdateStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Specifies the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheNodeIdsToRemove() ? cacheNodeIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNewAvailabilityZones() ? newAvailabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenUpdateStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId()) && Objects.equals(numCacheNodes(), other.numCacheNodes())
                && hasCacheNodeIdsToRemove() == other.hasCacheNodeIdsToRemove()
                && Objects.equals(cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && hasNewAvailabilityZones() == other.hasNewAvailabilityZones()
                && Objects.equals(newAvailabilityZones(), other.newAvailabilityZones())
                && hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames()
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(notificationTopicStatus(), other.notificationTopicStatus())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(authTokenUpdateStrategyAsString(), other.authTokenUpdateStrategyAsString())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCacheClusterRequest").add("CacheClusterId", cacheClusterId())
                .add("NumCacheNodes", numCacheNodes())
                .add("CacheNodeIdsToRemove", hasCacheNodeIdsToRemove() ? cacheNodeIdsToRemove() : null)
                .add("AZMode", azModeAsString())
                .add("NewAvailabilityZones", hasNewAvailabilityZones() ? newAvailabilityZones() : null)
                .add("CacheSecurityGroupNames", hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("NotificationTopicArn", notificationTopicArn()).add("CacheParameterGroupName", cacheParameterGroupName())
                .add("NotificationTopicStatus", notificationTopicStatus()).add("ApplyImmediately", applyImmediately())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("CacheNodeType", cacheNodeType()).add("AuthToken", authToken())
                .add("AuthTokenUpdateStrategy", authTokenUpdateStrategyAsString())
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "CacheNodeIdsToRemove":
            return Optional.ofNullable(clazz.cast(cacheNodeIdsToRemove()));
        case "AZMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "NewAvailabilityZones":
            return Optional.ofNullable(clazz.cast(newAvailabilityZones()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "NotificationTopicStatus":
            return Optional.ofNullable(clazz.cast(notificationTopicStatus()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "AuthTokenUpdateStrategy":
            return Optional.ofNullable(clazz.cast(authTokenUpdateStrategyAsString()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCacheClusterRequest, T> g) {
        return obj -> g.apply((ModifyCacheClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCacheClusterRequest> {
        /**
         * <p>
         * The cluster identifier. This value is stored as a lowercase string.
         * </p>
         * 
         * @param cacheClusterId
         *        The cluster identifier. This value is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is
         * greater than the sum of the number of current cache nodes and the number of cache nodes pending creation
         * (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes,
         * nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove
         * requests are canceled.
         * </p>
         * <p>
         * If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the
         * IDs of the specific cache nodes to remove.
         * </p>
         * <p>
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between
         * 1 and 40.
         * </p>
         * <note>
         * <p>
         * Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see
         * <code>ApplyImmediately</code>).
         * </p>
         * <p>
         * A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether
         * by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's
         * latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the
         * number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous
         * pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending
         * operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different
         * Availability Zones with flexible cache node placement, a request to add nodes does not automatically override
         * a previous pending operation to add nodes. The customer can modify the previous pending operation to add more
         * nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to
         * modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set
         * <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.
         * </p>
         * </note>
         * 
         * @param numCacheNodes
         *        The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is
         *        greater than the sum of the number of current cache nodes and the number of cache nodes pending
         *        creation (which may be zero), more nodes are added. If the value is less than the number of existing
         *        cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any
         *        pending add or remove requests are canceled.</p>
         *        <p>
         *        If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to
         *        provide the IDs of the specific cache nodes to remove.
         *        </p>
         *        <p>
         *        For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be
         *        between 1 and 40.
         *        </p>
         *        <note>
         *        <p>
         *        Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see
         *        <code>ApplyImmediately</code>).
         *        </p>
         *        <p>
         *        A pending operation to modify the number of cache nodes in a cluster during its maintenance window,
         *        whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The
         *        customer's latest request to add or remove nodes to the cluster overrides any previous pending
         *        operations to modify the number of cache nodes in the cluster. For example, a request to remove 2
         *        nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2
         *        nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache
         *        nodes may now be provisioned in different Availability Zones with flexible cache node placement, a
         *        request to add nodes does not automatically override a previous pending operation to add nodes. The
         *        customer can modify the previous pending operation to add more nodes or explicitly cancel the pending
         *        request and retry the new request. To cancel pending operations to modify the number of cache nodes in
         *        a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to
         *        the number of cache nodes currently in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter
         * is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of
         * cache node IDs supplied in this parameter must match the difference between the existing number of cache
         * nodes in the cluster or pending cache nodes, whichever is greater, and the value of
         * <code>NumCacheNodes</code> in the request.
         * </p>
         * <p>
         * For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this
         * <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This
         *        parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache
         *        nodes. The number of cache node IDs supplied in this parameter must match the difference between the
         *        existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the
         *        value of <code>NumCacheNodes</code> in the request.</p>
         *        <p>
         *        For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in
         *        this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove);

        /**
         * <p>
         * A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter
         * is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of
         * cache node IDs supplied in this parameter must match the difference between the existing number of cache
         * nodes in the cluster or pending cache nodes, whichever is greater, and the value of
         * <code>NumCacheNodes</code> in the request.
         * </p>
         * <p>
         * For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this
         * <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
         * </p>
         * 
         * @param cacheNodeIdsToRemove
         *        A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This
         *        parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache
         *        nodes. The number of cache node IDs supplied in this parameter must match the difference between the
         *        existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the
         *        value of <code>NumCacheNodes</code> in the request.</p>
         *        <p>
         *        For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in
         *        this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove);

        /**
         * <p>
         * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or
         * created across multiple Availability Zones.
         * </p>
         * <p>
         * Valid values: <code>single-az</code> | <code>cross-az</code>.
         * </p>
         * <p>
         * This option is only supported for Memcached clusters.
         * </p>
         * <note>
         * <p>
         * You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
         * Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current
         * Availability Zone.
         * </p>
         * <p>
         * Only newly created nodes are located in different Availability Zones.
         * </p>
         * </note>
         * 
         * @param azMode
         *        Specifies whether the new nodes in this Memcached cluster are all created in a single Availability
         *        Zone or created across multiple Availability Zones.</p>
         *        <p>
         *        Valid values: <code>single-az</code> | <code>cross-az</code>.
         *        </p>
         *        <p>
         *        This option is only supported for Memcached clusters.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in
         *        different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain
         *        in their current Availability Zone.
         *        </p>
         *        <p>
         *        Only newly created nodes are located in different Availability Zones.
         *        </p>
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or
         * created across multiple Availability Zones.
         * </p>
         * <p>
         * Valid values: <code>single-az</code> | <code>cross-az</code>.
         * </p>
         * <p>
         * This option is only supported for Memcached clusters.
         * </p>
         * <note>
         * <p>
         * You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different
         * Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current
         * Availability Zone.
         * </p>
         * <p>
         * Only newly created nodes are located in different Availability Zones.
         * </p>
         * </note>
         * 
         * @param azMode
         *        Specifies whether the new nodes in this Memcached cluster are all created in a single Availability
         *        Zone or created across multiple Availability Zones.</p>
         *        <p>
         *        Valid values: <code>single-az</code> | <code>cross-az</code>.
         *        </p>
         *        <p>
         *        This option is only supported for Memcached clusters.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in
         *        different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain
         *        in their current Availability Zone.
         *        </p>
         *        <p>
         *        Only newly created nodes are located in different Availability Zones.
         *        </p>
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(AZMode azMode);

        /**
         * <note>
         * <p>
         * This option is only supported on Memcached clusters.
         * </p>
         * </note>
         * <p>
         * The list of Availability Zones where the new Memcached cache nodes are created.
         * </p>
         * <p>
         * This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the
         * number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number
         * of Availability Zones supplied in this list must match the cache nodes being added in this request.
         * </p>
         * <p>
         * Scenarios:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 +
         * 2) and optionally specify two Availability Zones for the two new nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want
         * to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability
         * Zone for the new node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel
         * all pending operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes
         * pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.
         * </p>
         * <p>
         * If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.
         * Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing
         * Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of
         * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache
         * Node Considerations for Memcached</a>.
         * </p>
         * <p>
         * <b>Impact of new add/remove requests upon pending requests</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Scenario-1
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new delete, pending or immediate, replaces the pending delete.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-2
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new create, pending or immediate, replaces the pending delete.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-3
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new delete, pending or immediate, replaces the pending create.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-4
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new create is added to the pending create.
         * </p>
         * <important>
         * <p>
         * <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed
         * immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.
         * </p>
         * </important></li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param newAvailabilityZones
         *        <p>
         *        This option is only supported on Memcached clusters.
         *        </p>
         *        </note>
         *        <p>
         *        The list of Availability Zones where the new Memcached cache nodes are created.
         *        </p>
         *        <p>
         *        This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of
         *        the number of active cache nodes and the number of cache nodes pending creation (which may be zero).
         *        The number of Availability Zones supplied in this list must match the cache nodes being added in this
         *        request.
         *        </p>
         *        <p>
         *        Scenarios:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify
         *        <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new
         *        nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and
         *        want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an
         *        Availability Zone for the new node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to
         *        cancel all pending operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel
         *        any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current
         *        nodes.
         *        </p>
         *        <p>
         *        If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability
         *        Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to
         *        move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone
         *        Considerations</b> section of <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html"
         *        >Cache Node Considerations for Memcached</a>.
         *        </p>
         *        <p>
         *        <b>Impact of new add/remove requests upon pending requests</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Scenario-1
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new delete, pending or immediate, replaces the pending delete.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-2
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new create, pending or immediate, replaces the pending delete.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-3
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new delete, pending or immediate, replaces the pending create.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-4
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new create is added to the pending create.
         *        </p>
         *        <important>
         *        <p>
         *        <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are
         *        performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are
         *        pending.
         *        </p>
         *        </important></li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAvailabilityZones(Collection<String> newAvailabilityZones);

        /**
         * <note>
         * <p>
         * This option is only supported on Memcached clusters.
         * </p>
         * </note>
         * <p>
         * The list of Availability Zones where the new Memcached cache nodes are created.
         * </p>
         * <p>
         * This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the
         * number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number
         * of Availability Zones supplied in this list must match the cache nodes being added in this request.
         * </p>
         * <p>
         * Scenarios:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 +
         * 2) and optionally specify two Availability Zones for the two new nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want
         * to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability
         * Zone for the new node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel
         * all pending operations.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes
         * pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.
         * </p>
         * <p>
         * If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.
         * Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing
         * Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of
         * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache
         * Node Considerations for Memcached</a>.
         * </p>
         * <p>
         * <b>Impact of new add/remove requests upon pending requests</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * Scenario-1
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new delete, pending or immediate, replaces the pending delete.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-2
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new create, pending or immediate, replaces the pending delete.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-3
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Delete
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new delete, pending or immediate, replaces the pending create.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Scenario-4
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Action: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * New Request: Create
         * </p>
         * </li>
         * <li>
         * <p>
         * Result: The new create is added to the pending create.
         * </p>
         * <important>
         * <p>
         * <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed
         * immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.
         * </p>
         * </important></li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param newAvailabilityZones
         *        <p>
         *        This option is only supported on Memcached clusters.
         *        </p>
         *        </note>
         *        <p>
         *        The list of Availability Zones where the new Memcached cache nodes are created.
         *        </p>
         *        <p>
         *        This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of
         *        the number of active cache nodes and the number of cache nodes pending creation (which may be zero).
         *        The number of Availability Zones supplied in this list must match the cache nodes being added in this
         *        request.
         *        </p>
         *        <p>
         *        Scenarios:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify
         *        <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new
         *        nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and
         *        want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an
         *        Availability Zone for the new node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to
         *        cancel all pending operations.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel
         *        any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current
         *        nodes.
         *        </p>
         *        <p>
         *        If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability
         *        Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to
         *        move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone
         *        Considerations</b> section of <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html"
         *        >Cache Node Considerations for Memcached</a>.
         *        </p>
         *        <p>
         *        <b>Impact of new add/remove requests upon pending requests</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Scenario-1
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new delete, pending or immediate, replaces the pending delete.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-2
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new create, pending or immediate, replaces the pending delete.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-3
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Delete
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new delete, pending or immediate, replaces the pending create.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Scenario-4
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Action: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        New Request: Create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Result: The new create is added to the pending create.
         *        </p>
         *        <important>
         *        <p>
         *        <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are
         *        performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are
         *        pending.
         *        </p>
         *        </important></li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAvailabilityZones(String... newAvailabilityZones);

        /**
         * <p>
         * A list of cache security group names to authorize on this cluster. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud
         * (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize on this cluster. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        You can use this parameter only with clusters that are created outside of an Amazon Virtual Private
         *        Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of cache security group names to authorize on this cluster. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud
         * (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize on this cluster. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        You can use this parameter only with clusters that are created outside of an Amazon Virtual Private
         *        Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the cluster.
         * </p>
         * <p>
         * This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the cluster.</p>
         *        <p>
         *        This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the cluster.
         * </p>
         * <p>
         * This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the cluster.</p>
         *        <p>
         *        This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be same as the cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be same as the cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon
         * as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code>
         * for this request.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to apply to this cluster. This change is asynchronously applied
         *        as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as
         *        <code>true</code> for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The status of the Amazon SNS notification topic. Notifications are sent only if the status is
         * <code>active</code>.
         * </p>
         * <p>
         * Valid values: <code>active</code> | <code>inactive</code>
         * </p>
         * 
         * @param notificationTopicStatus
         *        The status of the Amazon SNS notification topic. Notifications are sent only if the status is
         *        <code>active</code>.</p>
         *        <p>
         *        Valid values: <code>active</code> | <code>inactive</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicStatus(String notificationTopicStatus);

        /**
         * <p>
         * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications
         * to be applied, asynchronously and as soon as possible, regardless of the
         * <code>PreferredMaintenanceWindow</code> setting for the cluster.
         * </p>
         * <p>
         * If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure
         * reboot, whichever occurs first.
         * </p>
         * <important>
         * <p>
         * If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending
         * modification is replaced by the newer modification.
         * </p>
         * </important>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        If <code>true</code>, this parameter causes the modifications in this request and any pending
         *        modifications to be applied, asynchronously and as soon as possible, regardless of the
         *        <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
         *        <p>
         *        If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next
         *        failure reboot, whichever occurs first.
         *        </p>
         *        <important>
         *        <p>
         *        If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending
         *        modification is replaced by the newer modification.
         *        </p>
         *        </important>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The upgraded version of the cache engine to be run on the cache nodes.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
         * want to use an earlier engine version, you must delete the existing cluster and create it anew with the
         * earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the cache engine to be run on the cache nodes.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If
         *        you want to use an earlier engine version, you must delete the existing cluster and create it anew
         *        with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
         * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *         If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in
         *        to the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for
         * 5 days before being deleted.
         * </p>
         * <note>
         * <p>
         * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         * </p>
         * </note>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p> <note>
         *        <p>
         *        If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A valid cache node type that you want to scale this cluster up to.
         * </p>
         * 
         * @param cacheNodeType
         *        A valid cache node type that you want to scale this cluster up to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified
         * with the <code>auth-token-update</code> parameter. Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain any of the following characters: '/', '"', or '@', '%'
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * </p>
         * 
         * @param authToken
         *        Reserved parameter. The password used to access a password protected server. This parameter must be
         *        specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain any of the following characters: '/', '"', or '@', '%'
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(String authTokenUpdateStrategy);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <LogDeliveryConfigurationRequest>.Builder} avoiding the need to create one manually via {@link List
         * <LogDeliveryConfigurationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogDeliveryConfigurationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<LogDeliveryConfigurationRequest>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on {@link List<LogDeliveryConfigurationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(List<LogDeliveryConfigurationRequest>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private Integer numCacheNodes;

        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private String azMode;

        private List<String> newAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private String notificationTopicArn;

        private String cacheParameterGroupName;

        private String notificationTopicStatus;

        private Boolean applyImmediately;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String cacheNodeType;

        private String authToken;

        private String authTokenUpdateStrategy;

        private List<LogDeliveryConfigurationRequest> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCacheClusterRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            numCacheNodes(model.numCacheNodes);
            cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            azMode(model.azMode);
            newAvailabilityZones(model.newAvailabilityZones);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            notificationTopicArn(model.notificationTopicArn);
            cacheParameterGroupName(model.cacheParameterGroupName);
            notificationTopicStatus(model.notificationTopicStatus);
            applyImmediately(model.applyImmediately);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            cacheNodeType(model.cacheNodeType);
            authToken(model.authToken);
            authTokenUpdateStrategy(model.authTokenUpdateStrategy);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            if (cacheNodeIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheNodeIdsToRemove;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String... cacheNodeIdsToRemove) {
            cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final Collection<String> getNewAvailabilityZones() {
            if (newAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return newAvailabilityZones;
        }

        public final void setNewAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
        }

        @Override
        public final Builder newAvailabilityZones(Collection<String> newAvailabilityZones) {
            this.newAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(newAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newAvailabilityZones(String... newAvailabilityZones) {
            newAvailabilityZones(Arrays.asList(newAvailabilityZones));
            return this;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheSecurityGroupNames;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getNotificationTopicStatus() {
            return notificationTopicStatus;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final String getAuthTokenUpdateStrategy() {
            return authTokenUpdateStrategy;
        }

        public final void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
        }

        @Override
        public final Builder authTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
            return this;
        }

        @Override
        public final Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy(authTokenUpdateStrategy == null ? null : authTokenUpdateStrategy.toString());
            return this;
        }

        public final List<LogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfigurationRequest.Builder> result = LogDeliveryConfigurationRequestListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<LogDeliveryConfigurationRequest.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCacheClusterRequest build() {
            return new ModifyCacheClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
