/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log delivery configurations being modified
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingLogDeliveryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingLogDeliveryConfiguration.Builder, PendingLogDeliveryConfiguration> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(PendingLogDeliveryConfiguration::logTypeAsString))
            .setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(PendingLogDeliveryConfiguration::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()).build();

    private static final SdkField<DestinationDetails> DESTINATION_DETAILS_FIELD = SdkField
            .<DestinationDetails> builder(MarshallingType.SDK_POJO).memberName("DestinationDetails")
            .getter(getter(PendingLogDeliveryConfiguration::destinationDetails)).setter(setter(Builder::destinationDetails))
            .constructor(DestinationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDetails").build())
            .build();

    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFormat").getter(getter(PendingLogDeliveryConfiguration::logFormatAsString))
            .setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD,
            DESTINATION_TYPE_FIELD, DESTINATION_DETAILS_FIELD, LOG_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logType;

    private final String destinationType;

    private final DestinationDetails destinationDetails;

    private final String logFormat;

    private PendingLogDeliveryConfiguration(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destinationType = builder.destinationType;
        this.destinationDetails = builder.destinationDetails;
        this.logFormat = builder.logFormat;
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     * </p>
     * 
     * @return Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     */
    public final DestinationDetails destinationDetails() {
        return destinationDetails;
    }

    /**
     * <p>
     * Returns the log format, either JSON or TEXT
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Returns the log format, either JSON or TEXT
     * @see LogFormat
     */
    public final LogFormat logFormat() {
        return LogFormat.fromValue(logFormat);
    }

    /**
     * <p>
     * Returns the log format, either JSON or TEXT
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Returns the log format, either JSON or TEXT
     * @see LogFormat
     */
    public final String logFormatAsString() {
        return logFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingLogDeliveryConfiguration)) {
            return false;
        }
        PendingLogDeliveryConfiguration other = (PendingLogDeliveryConfiguration) obj;
        return Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationDetails(), other.destinationDetails())
                && Objects.equals(logFormatAsString(), other.logFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingLogDeliveryConfiguration").add("LogType", logTypeAsString())
                .add("DestinationType", destinationTypeAsString()).add("DestinationDetails", destinationDetails())
                .add("LogFormat", logFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DestinationDetails":
            return Optional.ofNullable(clazz.cast(destinationDetails()));
        case "LogFormat":
            return Optional.ofNullable(clazz.cast(logFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingLogDeliveryConfiguration, T> g) {
        return obj -> g.apply((PendingLogDeliveryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingLogDeliveryConfiguration> {
        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
         * </p>
         * 
         * @param destinationType
         *        Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
         * </p>
         * 
         * @param destinationType
         *        Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * 
         * @param destinationDetails
         *        Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDetails(DestinationDetails destinationDetails);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationDetails.Builder} avoiding the
         * need to create one manually via {@link DestinationDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationDetails(DestinationDetails)}.
         * 
         * @param destinationDetails
         *        a consumer that will call methods on {@link DestinationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDetails(DestinationDetails)
         */
        default Builder destinationDetails(Consumer<DestinationDetails.Builder> destinationDetails) {
            return destinationDetails(DestinationDetails.builder().applyMutation(destinationDetails).build());
        }

        /**
         * <p>
         * Returns the log format, either JSON or TEXT
         * </p>
         * 
         * @param logFormat
         *        Returns the log format, either JSON or TEXT
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(String logFormat);

        /**
         * <p>
         * Returns the log format, either JSON or TEXT
         * </p>
         * 
         * @param logFormat
         *        Returns the log format, either JSON or TEXT
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(LogFormat logFormat);
    }

    static final class BuilderImpl implements Builder {
        private String logType;

        private String destinationType;

        private DestinationDetails destinationDetails;

        private String logFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingLogDeliveryConfiguration model) {
            logType(model.logType);
            destinationType(model.destinationType);
            destinationDetails(model.destinationDetails);
            logFormat(model.logFormat);
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final DestinationDetails.Builder getDestinationDetails() {
            return destinationDetails != null ? destinationDetails.toBuilder() : null;
        }

        public final void setDestinationDetails(DestinationDetails.BuilderImpl destinationDetails) {
            this.destinationDetails = destinationDetails != null ? destinationDetails.build() : null;
        }

        @Override
        public final Builder destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public final String getLogFormat() {
            return logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormat logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        @Override
        public PendingLogDeliveryConfiguration build() {
            return new PendingLogDeliveryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
