/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedCacheNodesOfferingsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeReservedCacheNodesOfferingsRequest.Builder, DescribeReservedCacheNodesOfferingsRequest> {
    private static final SdkField<String> RESERVED_CACHE_NODES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedCacheNodesOfferingId")
            .getter(getter(DescribeReservedCacheNodesOfferingsRequest::reservedCacheNodesOfferingId))
            .setter(setter(Builder::reservedCacheNodesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferingId")
                    .build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(DescribeReservedCacheNodesOfferingsRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(DescribeReservedCacheNodesOfferingsRequest::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(DescribeReservedCacheNodesOfferingsRequest::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(DescribeReservedCacheNodesOfferingsRequest::offeringType))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeReservedCacheNodesOfferingsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedCacheNodesOfferingsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_CACHE_NODES_OFFERING_ID_FIELD, CACHE_NODE_TYPE_FIELD, DURATION_FIELD, PRODUCT_DESCRIPTION_FIELD,
            OFFERING_TYPE_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String reservedCacheNodesOfferingId;

    private final String cacheNodeType;

    private final String duration;

    private final String productDescription;

    private final String offeringType;

    private final Integer maxRecords;

    private final String marker;

    private DescribeReservedCacheNodesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.cacheNodeType = builder.cacheNodeType;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The offering identifier filter value. Use this parameter to show only the available offering that matches the
     * specified reservation identifier.
     * </p>
     * <p>
     * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     * </p>
     * 
     * @return The offering identifier filter value. Use this parameter to show only the available offering that matches
     *         the specified reservation identifier.</p>
     *         <p>
     *         Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     */
    public final String reservedCacheNodesOfferingId() {
        return reservedCacheNodesOfferingId;
    }

    /**
     * <p>
     * The cache node type filter value. Use this parameter to show only the available offerings matching the specified
     * cache node type.
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized with data tiering:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).
     * </p>
     * <p>
     * <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>,
     * <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward).
     * </p>
     * <p>
     * <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The cache node type filter value. Use this parameter to show only the available offerings matching the
     *         specified cache node type.</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *         <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *         <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
     *         <code>cache.t4g.medium</code>
     *         </p>
     *         <p>
     *         <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *         <code>cache.t3.medium</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized with data tiering:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).
     *         </p>
     *         <p>
     *         <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>,
     *         <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward).
     *         </p>
     *         <p>
     *         <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     *         <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     *         <code>cache.r6g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *         Redis version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given
     * duration.
     * </p>
     * <p>
     * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     * </p>
     * 
     * @return Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a
     *         given duration.</p>
     *         <p>
     *         Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     */
    public final String duration() {
        return duration;
    }

    /**
     * <p>
     * The product description filter value. Use this parameter to show only the available offerings matching the
     * specified product description.
     * </p>
     * 
     * @return The product description filter value. Use this parameter to show only the available offerings matching
     *         the specified product description.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The offering type filter value. Use this parameter to show only the available offerings matching the specified
     * offering type.
     * </p>
     * <p>
     * Valid Values:
     * <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code>
     * </p>
     * 
     * @return The offering type filter value. Use this parameter to show only the available offerings matching the
     *         specified offering type.</p>
     *         <p>
     *         Valid Values:
     *         <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code>
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: minimum 20; maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
     *         retrieved.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: minimum 20; maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsRequest)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsRequest other = (DescribeReservedCacheNodesOfferingsRequest) obj;
        return Objects.equals(reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(duration(), other.duration())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(offeringType(), other.offeringType()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedCacheNodesOfferingsRequest")
                .add("ReservedCacheNodesOfferingId", reservedCacheNodesOfferingId()).add("CacheNodeType", cacheNodeType())
                .add("Duration", duration()).add("ProductDescription", productDescription()).add("OfferingType", offeringType())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCacheNodesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedCacheNodesOfferingId()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCacheNodesOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedCacheNodesOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsRequest> {
        /**
         * <p>
         * The offering identifier filter value. Use this parameter to show only the available offering that matches the
         * specified reservation identifier.
         * </p>
         * <p>
         * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * </p>
         * 
         * @param reservedCacheNodesOfferingId
         *        The offering identifier filter value. Use this parameter to show only the available offering that
         *        matches the specified reservation identifier.</p>
         *        <p>
         *        Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId);

        /**
         * <p>
         * The cache node type filter value. Use this parameter to show only the available offerings matching the
         * specified cache node type.
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
         * 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
         * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
         * <code>cache.m6g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
         * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
         * </p>
         * <p>
         * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized with data tiering:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).
         * </p>
         * <p>
         * <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>,
         * <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
         * 1.5.16 onward).
         * </p>
         * <p>
         * <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
         * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
         * <code>cache.r6g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
         * version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The cache node type filter value. Use this parameter to show only the available offerings matching the
         *        specified cache node type.</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
         *        version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
         *        version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
         *        <code>cache.t4g.medium</code>
         *        </p>
         *        <p>
         *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
         *        <code>cache.t3.medium</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized with data tiering:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).
         *        </p>
         *        <p>
         *        <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>,
         *        <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
         *        version 1.5.16 onward).
         *        </p>
         *        <p>
         *        <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
         *        <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
         *        <code>cache.r6g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
         *        on Redis version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a
         * given duration.
         * </p>
         * <p>
         * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * </p>
         * 
         * @param duration
         *        Duration filter value, specified in years or seconds. Use this parameter to show only reservations for
         *        a given duration.</p>
         *        <p>
         *        Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * The product description filter value. Use this parameter to show only the available offerings matching the
         * specified product description.
         * </p>
         * 
         * @param productDescription
         *        The product description filter value. Use this parameter to show only the available offerings matching
         *        the specified product description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The offering type filter value. Use this parameter to show only the available offerings matching the
         * specified offering type.
         * </p>
         * <p>
         * Valid Values:
         * <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code>
         * </p>
         * 
         * @param offeringType
         *        The offering type filter value. Use this parameter to show only the available offerings matching the
         *        specified offering type.</p>
         *        <p>
         *        Valid Values:
         *        <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: minimum 20; maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can
         *        be retrieved.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: minimum 20; maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String reservedCacheNodesOfferingId;

        private String cacheNodeType;

        private String duration;

        private String productDescription;

        private String offeringType;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsRequest model) {
            super(model);
            reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            cacheNodeType(model.cacheNodeType);
            duration(model.duration);
            productDescription(model.productDescription);
            offeringType(model.offeringType);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReservedCacheNodesOfferingId() {
            return reservedCacheNodesOfferingId;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getDuration() {
            return duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedCacheNodesOfferingsRequest build() {
            return new DescribeReservedCacheNodesOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
