/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ModifyReplicationGroups</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyReplicationGroupRequest.Builder, ModifyReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(ModifyReplicationGroupRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupDescription")
            .getter(getter(ModifyReplicationGroupRequest::replicationGroupDescription))
            .setter(setter(Builder::replicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryClusterId").getter(getter(ModifyReplicationGroupRequest::primaryClusterId))
            .setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshottingClusterId").getter(getter(ModifyReplicationGroupRequest::snapshottingClusterId))
            .setter(setter(Builder::snapshottingClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build())
            .build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFailoverEnabled").getter(getter(ModifyReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZEnabled").getter(getter(ModifyReplicationGroupRequest::multiAZEnabled))
            .setter(setter(Builder::multiAZEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZEnabled").build()).build();

    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeGroupId").getter(getter(ModifyReplicationGroupRequest::nodeGroupId))
            .setter(setter(Builder::nodeGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()).build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheSecurityGroupNames")
            .getter(getter(ModifyReplicationGroupRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ModifyReplicationGroupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyReplicationGroupRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(ModifyReplicationGroupRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(ModifyReplicationGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> NOTIFICATION_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicStatus").getter(getter(ModifyReplicationGroupRequest::notificationTopicStatus))
            .setter(setter(Builder::notificationTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicStatus").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyReplicationGroupRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyReplicationGroupRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ModifyReplicationGroupRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ModifyReplicationGroupRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(ModifyReplicationGroupRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(ModifyReplicationGroupRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(ModifyReplicationGroupRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<String> AUTH_TOKEN_UPDATE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthTokenUpdateStrategy").getter(getter(ModifyReplicationGroupRequest::authTokenUpdateStrategyAsString))
            .setter(setter(Builder::authTokenUpdateStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenUpdateStrategy").build())
            .build();

    private static final SdkField<List<String>> USER_GROUP_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIdsToAdd")
            .getter(getter(ModifyReplicationGroupRequest::userGroupIdsToAdd))
            .setter(setter(Builder::userGroupIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIdsToRemove")
            .getter(getter(ModifyReplicationGroupRequest::userGroupIdsToRemove))
            .setter(setter(Builder::userGroupIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REMOVE_USER_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveUserGroups").getter(getter(ModifyReplicationGroupRequest::removeUserGroups))
            .setter(setter(Builder::removeUserGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveUserGroups").build()).build();

    private static final SdkField<List<LogDeliveryConfigurationRequest>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(ModifyReplicationGroupRequest::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfigurationRequest")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfigurationRequest").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_DESCRIPTION_FIELD, PRIMARY_CLUSTER_ID_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD,
            AUTOMATIC_FAILOVER_ENABLED_FIELD, MULTI_AZ_ENABLED_FIELD, NODE_GROUP_ID_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD,
            SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_TOPIC_ARN_FIELD,
            CACHE_PARAMETER_GROUP_NAME_FIELD, NOTIFICATION_TOPIC_STATUS_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_VERSION_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CACHE_NODE_TYPE_FIELD,
            AUTH_TOKEN_FIELD, AUTH_TOKEN_UPDATE_STRATEGY_FIELD, USER_GROUP_IDS_TO_ADD_FIELD, USER_GROUP_IDS_TO_REMOVE_FIELD,
            REMOVE_USER_GROUPS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD));

    private final String replicationGroupId;

    private final String replicationGroupDescription;

    private final String primaryClusterId;

    private final String snapshottingClusterId;

    private final Boolean automaticFailoverEnabled;

    private final Boolean multiAZEnabled;

    private final String nodeGroupId;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final String preferredMaintenanceWindow;

    private final String notificationTopicArn;

    private final String cacheParameterGroupName;

    private final String notificationTopicStatus;

    private final Boolean applyImmediately;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String cacheNodeType;

    private final String authToken;

    private final String authTokenUpdateStrategy;

    private final List<String> userGroupIdsToAdd;

    private final List<String> userGroupIdsToRemove;

    private final Boolean removeUserGroups;

    private final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations;

    private ModifyReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.primaryClusterId = builder.primaryClusterId;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.multiAZEnabled = builder.multiAZEnabled;
        this.nodeGroupId = builder.nodeGroupId;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.notificationTopicStatus = builder.notificationTopicStatus;
        this.applyImmediately = builder.applyImmediately;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.cacheNodeType = builder.cacheNodeType;
        this.authToken = builder.authToken;
        this.authTokenUpdateStrategy = builder.authTokenUpdateStrategy;
        this.userGroupIdsToAdd = builder.userGroupIdsToAdd;
        this.userGroupIdsToRemove = builder.userGroupIdsToRemove;
        this.removeUserGroups = builder.removeUserGroups;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
    }

    /**
     * <p>
     * The identifier of the replication group to modify.
     * </p>
     * 
     * @return The identifier of the replication group to modify.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * A description for the replication group. Maximum length is 255 characters.
     * </p>
     * 
     * @return A description for the replication group. Maximum length is 255 characters.
     */
    public final String replicationGroupDescription() {
        return replicationGroupDescription;
    }

    /**
     * <p>
     * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified
     * cluster in the specified replication group to the primary role. The nodes of all other clusters in the
     * replication group are read replicas.
     * </p>
     * 
     * @return For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
     *         specified cluster in the specified replication group to the primary role. The nodes of all other clusters
     *         in the replication group are read replicas.
     */
    public final String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set
     * for Redis (cluster mode enabled) replication groups.
     * </p>
     * 
     * @return The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot
     *         be set for Redis (cluster mode enabled) replication groups.
     */
    public final String snapshottingClusterId() {
        return snapshottingClusterId;
    }

    /**
     * <p>
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     * encounters a failure.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Determines whether a read replica is automatically promoted to read/write primary if the existing primary
     *         encounters a failure.</p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     */
    public final Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    /**
     * <p>
     * A flag to indicate MultiAZ is enabled.
     * </p>
     * 
     * @return A flag to indicate MultiAZ is enabled.
     */
    public final Boolean multiAZEnabled() {
        return multiAZEnabled;
    }

    /**
     * <p>
     * Deprecated. This parameter is not used.
     * </p>
     * 
     * @return Deprecated. This parameter is not used.
     * @deprecated
     */
    @Deprecated
    public final String nodeGroupId() {
        return nodeGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheSecurityGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group names to authorize for the clusters in this replication group. This change is
     * asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual
     * Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheSecurityGroupNames} method.
     * </p>
     * 
     * @return A list of cache security group names to authorize for the clusters in this replication group. This change
     *         is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This parameter can be used only with replication group containing clusters running outside of an Amazon
     *         Virtual Private Cloud (Amazon VPC).
     *         </p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
     */
    public final List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the VPC Security Groups associated with the clusters in the replication group.
     * </p>
     * <p>
     * This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private
     * Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
     *         <p>
     *         This parameter can be used only with replication group containing clusters running in an Amazon Virtual
     *         Private Cloud (Amazon VPC).
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be same as the replication group owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be same as the replication group owner.
     *         </p>
     */
    public final String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     * The name of the cache parameter group to apply to all of the clusters in this replication group. This change is
     * asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is
     * specified as <code>true</code> for this request.
     * </p>
     * 
     * @return The name of the cache parameter group to apply to all of the clusters in this replication group. This
     *         change is asynchronously applied as soon as possible for parameters when the
     *         <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the
     * status is <code>active</code>.
     * </p>
     * <p>
     * Valid values: <code>active</code> | <code>inactive</code>
     * </p>
     * 
     * @return The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if
     *         the status is <code>active</code>.</p>
     *         <p>
     *         Valid values: <code>active</code> | <code>inactive</code>
     */
    public final String notificationTopicStatus() {
        return notificationTopicStatus;
    }

    /**
     * <p>
     * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be
     * applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code>
     * setting for the replication group.
     * </p>
     * <p>
     * If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot,
     * or the next failure reboot, whichever occurs first.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If <code>true</code>, this parameter causes the modifications in this request and any pending
     *         modifications to be applied, asynchronously and as soon as possible, regardless of the
     *         <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
     *         <p>
     *         If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance
     *         reboot, or the next failure reboot, whichever occurs first.
     *         </p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The upgraded version of the cache engine to be run on the clusters in the replication group.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an
     * earlier engine version, you must delete the existing replication group and create it anew with the earlier engine
     * version.
     * </p>
     * 
     * @return The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
     *         want to use an earlier engine version, you must delete the existing replication group and create it anew
     *         with the earlier engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *         the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For
     * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5
     * days before being deleted.
     * </p>
     * <p>
     * <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting
     *         them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today
     *         is retained for 5 days before being deleted.</p>
     *         <p>
     *         <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard)
     * specified by <code>SnapshottingClusterId</code>.
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group
     *         (shard) specified by <code>SnapshottingClusterId</code>.</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A valid cache node type that you want to scale this replication group to.
     * </p>
     * 
     * @return A valid cache node type that you want to scale this replication group to.
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified
     * with the <code>auth-token-update-strategy </code> parameter. Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain any of the following characters: '/', '"', or '@', '%'
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     * </p>
     * 
     * @return Reserved parameter. The password used to access a password protected server. This parameter must be
     *         specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain any of the following characters: '/', '"', or '@', '%'
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public final AuthTokenUpdateStrategyType authTokenUpdateStrategy() {
        return AuthTokenUpdateStrategyType.fromValue(authTokenUpdateStrategy);
    }

    /**
     * <p>
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     * <code>auth-token</code> parameter. Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Rotate
     * </p>
     * </li>
     * <li>
     * <p>
     * Set
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
     * AUTH</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authTokenUpdateStrategy} will return {@link AuthTokenUpdateStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authTokenUpdateStrategyAsString}.
     * </p>
     * 
     * @return Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
     *         <code>auth-token</code> parameter. Possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Rotate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
     *         Redis AUTH</a>
     * @see AuthTokenUpdateStrategyType
     */
    public final String authTokenUpdateStrategyAsString() {
        return authTokenUpdateStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIdsToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIdsToAdd() {
        return userGroupIdsToAdd != null && !(userGroupIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the user group you are associating with the replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIdsToAdd} method.
     * </p>
     * 
     * @return The ID of the user group you are associating with the replication group.
     */
    public final List<String> userGroupIdsToAdd() {
        return userGroupIdsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIdsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIdsToRemove() {
        return userGroupIdsToRemove != null && !(userGroupIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can
     * access the replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIdsToRemove} method.
     * </p>
     * 
     * @return The ID of the user group to disassociate from the replication group, meaning the users in the group no
     *         longer can access the replication group.
     */
    public final List<String> userGroupIdsToRemove() {
        return userGroupIdsToRemove;
    }

    /**
     * <p>
     * Removes the user group associated with this replication group.
     * </p>
     * 
     * @return Removes the user group associated with this replication group.
     */
    public final Boolean removeUserGroups() {
        return removeUserGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Specifies the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenUpdateStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIdsToAdd() ? userGroupIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIdsToRemove() ? userGroupIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(removeUserGroups());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupRequest)) {
            return false;
        }
        ModifyReplicationGroupRequest other = (ModifyReplicationGroupRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupDescription(), other.replicationGroupDescription())
                && Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(snapshottingClusterId(), other.snapshottingClusterId())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled())
                && Objects.equals(multiAZEnabled(), other.multiAZEnabled()) && Objects.equals(nodeGroupId(), other.nodeGroupId())
                && hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames()
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(notificationTopicStatus(), other.notificationTopicStatus())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(authTokenUpdateStrategyAsString(), other.authTokenUpdateStrategyAsString())
                && hasUserGroupIdsToAdd() == other.hasUserGroupIdsToAdd()
                && Objects.equals(userGroupIdsToAdd(), other.userGroupIdsToAdd())
                && hasUserGroupIdsToRemove() == other.hasUserGroupIdsToRemove()
                && Objects.equals(userGroupIdsToRemove(), other.userGroupIdsToRemove())
                && Objects.equals(removeUserGroups(), other.removeUserGroups())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReplicationGroupRequest").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupDescription", replicationGroupDescription()).add("PrimaryClusterId", primaryClusterId())
                .add("SnapshottingClusterId", snapshottingClusterId())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).add("MultiAZEnabled", multiAZEnabled())
                .add("NodeGroupId", nodeGroupId())
                .add("CacheSecurityGroupNames", hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("NotificationTopicArn", notificationTopicArn()).add("CacheParameterGroupName", cacheParameterGroupName())
                .add("NotificationTopicStatus", notificationTopicStatus()).add("ApplyImmediately", applyImmediately())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("CacheNodeType", cacheNodeType()).add("AuthToken", authToken())
                .add("AuthTokenUpdateStrategy", authTokenUpdateStrategyAsString())
                .add("UserGroupIdsToAdd", hasUserGroupIdsToAdd() ? userGroupIdsToAdd() : null)
                .add("UserGroupIdsToRemove", hasUserGroupIdsToRemove() ? userGroupIdsToRemove() : null)
                .add("RemoveUserGroups", removeUserGroups())
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationGroupDescription()));
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "SnapshottingClusterId":
            return Optional.ofNullable(clazz.cast(snapshottingClusterId()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        case "MultiAZEnabled":
            return Optional.ofNullable(clazz.cast(multiAZEnabled()));
        case "NodeGroupId":
            return Optional.ofNullable(clazz.cast(nodeGroupId()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "NotificationTopicStatus":
            return Optional.ofNullable(clazz.cast(notificationTopicStatus()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "AuthTokenUpdateStrategy":
            return Optional.ofNullable(clazz.cast(authTokenUpdateStrategyAsString()));
        case "UserGroupIdsToAdd":
            return Optional.ofNullable(clazz.cast(userGroupIdsToAdd()));
        case "UserGroupIdsToRemove":
            return Optional.ofNullable(clazz.cast(userGroupIdsToRemove()));
        case "RemoveUserGroups":
            return Optional.ofNullable(clazz.cast(removeUserGroups()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationGroupRequest, T> g) {
        return obj -> g.apply((ModifyReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyReplicationGroupRequest> {
        /**
         * <p>
         * The identifier of the replication group to modify.
         * </p>
         * 
         * @param replicationGroupId
         *        The identifier of the replication group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * A description for the replication group. Maximum length is 255 characters.
         * </p>
         * 
         * @param replicationGroupDescription
         *        A description for the replication group. Maximum length is 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupDescription(String replicationGroupDescription);

        /**
         * <p>
         * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
         * specified cluster in the specified replication group to the primary role. The nodes of all other clusters in
         * the replication group are read replicas.
         * </p>
         * 
         * @param primaryClusterId
         *        For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the
         *        specified cluster in the specified replication group to the primary role. The nodes of all other
         *        clusters in the replication group are read replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be
         * set for Redis (cluster mode enabled) replication groups.
         * </p>
         * 
         * @param snapshottingClusterId
         *        The cluster ID that is used as the daily snapshot source for the replication group. This parameter
         *        cannot be set for Redis (cluster mode enabled) replication groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshottingClusterId(String snapshottingClusterId);

        /**
         * <p>
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary
         * encounters a failure.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param automaticFailoverEnabled
         *        Determines whether a read replica is automatically promoted to read/write primary if the existing
         *        primary encounters a failure.</p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        /**
         * <p>
         * A flag to indicate MultiAZ is enabled.
         * </p>
         * 
         * @param multiAZEnabled
         *        A flag to indicate MultiAZ is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZEnabled(Boolean multiAZEnabled);

        /**
         * <p>
         * Deprecated. This parameter is not used.
         * </p>
         * 
         * @param nodeGroupId
         *        Deprecated. This parameter is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder nodeGroupId(String nodeGroupId);

        /**
         * <p>
         * A list of cache security group names to authorize for the clusters in this replication group. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running outside of an Amazon
         * Virtual Private Cloud (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize for the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running outside of an
         *        Amazon Virtual Private Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of cache security group names to authorize for the clusters in this replication group. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running outside of an Amazon
         * Virtual Private Cloud (Amazon VPC).
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to authorize for the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running outside of an
         *        Amazon Virtual Private Cloud (Amazon VPC).
         *        </p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running in an Amazon Virtual
         * Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running in an Amazon
         *        Virtual Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         * </p>
         * <p>
         * This parameter can be used only with replication group containing clusters running in an Amazon Virtual
         * Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
         *        <p>
         *        This parameter can be used only with replication group containing clusters running in an Amazon
         *        Virtual Private Cloud (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be same as the replication group owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be same as the replication group owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         * The name of the cache parameter group to apply to all of the clusters in this replication group. This change
         * is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter
         * is specified as <code>true</code> for this request.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the cache parameter group to apply to all of the clusters in this replication group. This
         *        change is asynchronously applied as soon as possible for parameters when the
         *        <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the
         * status is <code>active</code>.
         * </p>
         * <p>
         * Valid values: <code>active</code> | <code>inactive</code>
         * </p>
         * 
         * @param notificationTopicStatus
         *        The status of the Amazon SNS notification topic for the replication group. Notifications are sent only
         *        if the status is <code>active</code>.</p>
         *        <p>
         *        Valid values: <code>active</code> | <code>inactive</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicStatus(String notificationTopicStatus);

        /**
         * <p>
         * If <code>true</code>, this parameter causes the modifications in this request and any pending modifications
         * to be applied, asynchronously and as soon as possible, regardless of the
         * <code>PreferredMaintenanceWindow</code> setting for the replication group.
         * </p>
         * <p>
         * If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance
         * reboot, or the next failure reboot, whichever occurs first.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        If <code>true</code>, this parameter causes the modifications in this request and any pending
         *        modifications to be applied, asynchronously and as soon as possible, regardless of the
         *        <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
         *        <p>
         *        If <code>false</code>, changes to the nodes in the replication group are applied on the next
         *        maintenance reboot, or the next failure reboot, whichever occurs first.
         *        </p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The upgraded version of the cache engine to be run on the clusters in the replication group.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
         * want to use an earlier engine version, you must delete the existing replication group and create it anew with
         * the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If
         *        you want to use an earlier engine version, you must delete the existing replication group and create
         *        it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
         * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *         If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in
         *        to the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them.
         * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
         * for 5 days before being deleted.
         * </p>
         * <p>
         * <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic node group (shard) snapshots before
         *        deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was
         *        taken today is retained for 5 days before being deleted.</p>
         *        <p>
         *        <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group
         * (shard) specified by <code>SnapshottingClusterId</code>.
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node
         *        group (shard) specified by <code>SnapshottingClusterId</code>.</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A valid cache node type that you want to scale this replication group to.
         * </p>
         * 
         * @param cacheNodeType
         *        A valid cache node type that you want to scale this replication group to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified
         * with the <code>auth-token-update-strategy </code> parameter. Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain any of the following characters: '/', '"', or '@', '%'
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * </p>
         * 
         * @param authToken
         *        Reserved parameter. The password used to access a password protected server. This parameter must be
         *        specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain any of the following characters: '/', '"', or '@', '%'
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(String authTokenUpdateStrategy);

        /**
         * <p>
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         * <code>auth-token</code> parameter. Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Rotate
         * </p>
         * </li>
         * <li>
         * <p>
         * Set
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis
         * AUTH</a>
         * </p>
         * 
         * @param authTokenUpdateStrategy
         *        Specifies the strategy to use to update the AUTH token. This parameter must be specified with the
         *        <code>auth-token</code> parameter. Possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Rotate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with
         *        Redis AUTH</a>
         * @see AuthTokenUpdateStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStrategyType
         */
        Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy);

        /**
         * <p>
         * The ID of the user group you are associating with the replication group.
         * </p>
         * 
         * @param userGroupIdsToAdd
         *        The ID of the user group you are associating with the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToAdd(Collection<String> userGroupIdsToAdd);

        /**
         * <p>
         * The ID of the user group you are associating with the replication group.
         * </p>
         * 
         * @param userGroupIdsToAdd
         *        The ID of the user group you are associating with the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToAdd(String... userGroupIdsToAdd);

        /**
         * <p>
         * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer
         * can access the replication group.
         * </p>
         * 
         * @param userGroupIdsToRemove
         *        The ID of the user group to disassociate from the replication group, meaning the users in the group no
         *        longer can access the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToRemove(Collection<String> userGroupIdsToRemove);

        /**
         * <p>
         * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer
         * can access the replication group.
         * </p>
         * 
         * @param userGroupIdsToRemove
         *        The ID of the user group to disassociate from the replication group, meaning the users in the group no
         *        longer can access the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIdsToRemove(String... userGroupIdsToRemove);

        /**
         * <p>
         * Removes the user group associated with this replication group.
         * </p>
         * 
         * @param removeUserGroups
         *        Removes the user group associated with this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeUserGroups(Boolean removeUserGroups);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<LogDeliveryConfigurationRequest>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<LogDeliveryConfigurationRequest>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupDescription;

        private String primaryClusterId;

        private String snapshottingClusterId;

        private Boolean automaticFailoverEnabled;

        private Boolean multiAZEnabled;

        private String nodeGroupId;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private String notificationTopicArn;

        private String cacheParameterGroupName;

        private String notificationTopicStatus;

        private Boolean applyImmediately;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String cacheNodeType;

        private String authToken;

        private String authTokenUpdateStrategy;

        private List<String> userGroupIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroupIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private Boolean removeUserGroups;

        private List<LogDeliveryConfigurationRequest> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            replicationGroupDescription(model.replicationGroupDescription);
            primaryClusterId(model.primaryClusterId);
            snapshottingClusterId(model.snapshottingClusterId);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
            multiAZEnabled(model.multiAZEnabled);
            nodeGroupId(model.nodeGroupId);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            notificationTopicArn(model.notificationTopicArn);
            cacheParameterGroupName(model.cacheParameterGroupName);
            notificationTopicStatus(model.notificationTopicStatus);
            applyImmediately(model.applyImmediately);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            cacheNodeType(model.cacheNodeType);
            authToken(model.authToken);
            authTokenUpdateStrategy(model.authTokenUpdateStrategy);
            userGroupIdsToAdd(model.userGroupIdsToAdd);
            userGroupIdsToRemove(model.userGroupIdsToRemove);
            removeUserGroups(model.removeUserGroups);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupDescription() {
            return replicationGroupDescription;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final String getSnapshottingClusterId() {
            return snapshottingClusterId;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final Boolean getMultiAZEnabled() {
            return multiAZEnabled;
        }

        public final void setMultiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
        }

        @Override
        public final Builder multiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
            return this;
        }

        @Deprecated
        public final String getNodeGroupId() {
            return nodeGroupId;
        }

        @Deprecated
        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        @Override
        @Deprecated
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheSecurityGroupNames;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getNotificationTopicStatus() {
            return notificationTopicStatus;
        }

        public final void setNotificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
        }

        @Override
        public final Builder notificationTopicStatus(String notificationTopicStatus) {
            this.notificationTopicStatus = notificationTopicStatus;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final String getAuthTokenUpdateStrategy() {
            return authTokenUpdateStrategy;
        }

        public final void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
        }

        @Override
        public final Builder authTokenUpdateStrategy(String authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy = authTokenUpdateStrategy;
            return this;
        }

        @Override
        public final Builder authTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
            this.authTokenUpdateStrategy(authTokenUpdateStrategy == null ? null : authTokenUpdateStrategy.toString());
            return this;
        }

        public final Collection<String> getUserGroupIdsToAdd() {
            if (userGroupIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIdsToAdd;
        }

        public final void setUserGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
        }

        @Override
        public final Builder userGroupIdsToAdd(Collection<String> userGroupIdsToAdd) {
            this.userGroupIdsToAdd = UserGroupIdListCopier.copy(userGroupIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToAdd(String... userGroupIdsToAdd) {
            userGroupIdsToAdd(Arrays.asList(userGroupIdsToAdd));
            return this;
        }

        public final Collection<String> getUserGroupIdsToRemove() {
            if (userGroupIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIdsToRemove;
        }

        public final void setUserGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
        }

        @Override
        public final Builder userGroupIdsToRemove(Collection<String> userGroupIdsToRemove) {
            this.userGroupIdsToRemove = UserGroupIdListCopier.copy(userGroupIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIdsToRemove(String... userGroupIdsToRemove) {
            userGroupIdsToRemove(Arrays.asList(userGroupIdsToRemove));
            return this;
        }

        public final Boolean getRemoveUserGroups() {
            return removeUserGroups;
        }

        public final void setRemoveUserGroups(Boolean removeUserGroups) {
            this.removeUserGroups = removeUserGroups;
        }

        @Override
        public final Builder removeUserGroups(Boolean removeUserGroups) {
            this.removeUserGroups = removeUserGroups;
            return this;
        }

        public final List<LogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfigurationRequest.Builder> result = LogDeliveryConfigurationRequestListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<LogDeliveryConfigurationRequest.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupRequest build() {
            return new ModifyReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
