/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID of the outpost subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubnetOutpost implements SdkPojo, Serializable, ToCopyableBuilder<SubnetOutpost.Builder, SubnetOutpost> {
    private static final SdkField<String> SUBNET_OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetOutpostArn").getter(getter(SubnetOutpost::subnetOutpostArn))
            .setter(setter(Builder::subnetOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetOutpostArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_OUTPOST_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetOutpostArn;

    private SubnetOutpost(BuilderImpl builder) {
        this.subnetOutpostArn = builder.subnetOutpostArn;
    }

    /**
     * <p>
     * The outpost ARN of the subnet.
     * </p>
     * 
     * @return The outpost ARN of the subnet.
     */
    public final String subnetOutpostArn() {
        return subnetOutpostArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetOutpostArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetOutpost)) {
            return false;
        }
        SubnetOutpost other = (SubnetOutpost) obj;
        return Objects.equals(subnetOutpostArn(), other.subnetOutpostArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubnetOutpost").add("SubnetOutpostArn", subnetOutpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetOutpostArn":
            return Optional.ofNullable(clazz.cast(subnetOutpostArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubnetOutpost, T> g) {
        return obj -> g.apply((SubnetOutpost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubnetOutpost> {
        /**
         * <p>
         * The outpost ARN of the subnet.
         * </p>
         * 
         * @param subnetOutpostArn
         *        The outpost ARN of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetOutpostArn(String subnetOutpostArn);
    }

    static final class BuilderImpl implements Builder {
        private String subnetOutpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetOutpost model) {
            subnetOutpostArn(model.subnetOutpostArn);
        }

        public final String getSubnetOutpostArn() {
            return subnetOutpostArn;
        }

        public final void setSubnetOutpostArn(String subnetOutpostArn) {
            this.subnetOutpostArn = subnetOutpostArn;
        }

        @Override
        public final Builder subnetOutpostArn(String subnetOutpostArn) {
            this.subnetOutpostArn = subnetOutpostArn;
            return this;
        }

        @Override
        public SubnetOutpost build() {
            return new SubnetOutpost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
