/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateReplicationGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateReplicationGroupRequest.Builder, CreateReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(CreateReplicationGroupRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupDescription")
            .getter(getter(CreateReplicationGroupRequest::replicationGroupDescription))
            .setter(setter(Builder::replicationGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription")
                    .build()).build();

    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalReplicationGroupId").getter(getter(CreateReplicationGroupRequest::globalReplicationGroupId))
            .setter(setter(Builder::globalReplicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build())
            .build();

    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryClusterId").getter(getter(CreateReplicationGroupRequest::primaryClusterId))
            .setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFailoverEnabled").getter(getter(CreateReplicationGroupRequest::automaticFailoverEnabled))
            .setter(setter(Builder::automaticFailoverEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZEnabled").getter(getter(CreateReplicationGroupRequest::multiAZEnabled))
            .setter(setter(Builder::multiAZEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZEnabled").build()).build();

    private static final SdkField<Integer> NUM_CACHE_CLUSTERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumCacheClusters").getter(getter(CreateReplicationGroupRequest::numCacheClusters))
            .setter(setter(Builder::numCacheClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheClusters").build()).build();

    private static final SdkField<List<String>> PREFERRED_CACHE_CLUSTER_A_ZS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PreferredCacheClusterAZs")
            .getter(getter(CreateReplicationGroupRequest::preferredCacheClusterAZs))
            .setter(setter(Builder::preferredCacheClusterAZs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredCacheClusterAZs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> NUM_NODE_GROUPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumNodeGroups").getter(getter(CreateReplicationGroupRequest::numNodeGroups))
            .setter(setter(Builder::numNodeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumNodeGroups").build()).build();

    private static final SdkField<Integer> REPLICAS_PER_NODE_GROUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicasPerNodeGroup").getter(getter(CreateReplicationGroupRequest::replicasPerNodeGroup))
            .setter(setter(Builder::replicasPerNodeGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicasPerNodeGroup").build())
            .build();

    private static final SdkField<List<NodeGroupConfiguration>> NODE_GROUP_CONFIGURATION_FIELD = SdkField
            .<List<NodeGroupConfiguration>> builder(MarshallingType.LIST)
            .memberName("NodeGroupConfiguration")
            .getter(getter(CreateReplicationGroupRequest::nodeGroupConfiguration))
            .setter(setter(Builder::nodeGroupConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroupConfiguration")
                            .memberFieldInfo(
                                    SdkField.<NodeGroupConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeGroupConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroupConfiguration").build()).build()).build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(CreateReplicationGroupRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateReplicationGroupRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateReplicationGroupRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(CreateReplicationGroupRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSubnetGroupName").getter(getter(CreateReplicationGroupRequest::cacheSubnetGroupName))
            .setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheSecurityGroupNames")
            .getter(getter(CreateReplicationGroupRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateReplicationGroupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateReplicationGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotArns")
            .getter(getter(CreateReplicationGroupRequest::snapshotArns))
            .setter(setter(Builder::snapshotArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotArn").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(CreateReplicationGroupRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateReplicationGroupRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateReplicationGroupRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(CreateReplicationGroupRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateReplicationGroupRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(CreateReplicationGroupRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(CreateReplicationGroupRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(CreateReplicationGroupRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(CreateReplicationGroupRequest::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AtRestEncryptionEnabled").getter(getter(CreateReplicationGroupRequest::atRestEncryptionEnabled))
            .setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateReplicationGroupRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIds")
            .getter(getter(CreateReplicationGroupRequest::userGroupIds))
            .setter(setter(Builder::userGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LogDeliveryConfigurationRequest>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(CreateReplicationGroupRequest::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfigurationRequest")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfigurationRequest").build()).build()).build())
            .build();

    private static final SdkField<Boolean> DATA_TIERING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataTieringEnabled").getter(getter(CreateReplicationGroupRequest::dataTieringEnabled))
            .setter(setter(Builder::dataTieringEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTieringEnabled").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CreateReplicationGroupRequest::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpDiscovery").getter(getter(CreateReplicationGroupRequest::ipDiscoveryAsString))
            .setter(setter(Builder::ipDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()).build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryptionMode").getter(getter(CreateReplicationGroupRequest::transitEncryptionModeAsString))
            .setter(setter(Builder::transitEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build())
            .build();

    private static final SdkField<String> CLUSTER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterMode").getter(getter(CreateReplicationGroupRequest::clusterModeAsString))
            .setter(setter(Builder::clusterMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMode").build()).build();

    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheSnapshotName")
            .getter(getter(CreateReplicationGroupRequest::serverlessCacheSnapshotName))
            .setter(setter(Builder::serverlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            REPLICATION_GROUP_DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_ID_FIELD, PRIMARY_CLUSTER_ID_FIELD,
            AUTOMATIC_FAILOVER_ENABLED_FIELD, MULTI_AZ_ENABLED_FIELD, NUM_CACHE_CLUSTERS_FIELD,
            PREFERRED_CACHE_CLUSTER_A_ZS_FIELD, NUM_NODE_GROUPS_FIELD, REPLICAS_PER_NODE_GROUP_FIELD,
            NODE_GROUP_CONFIGURATION_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD,
            SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            PORT_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD,
            KMS_KEY_ID_FIELD, USER_GROUP_IDS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, DATA_TIERING_ENABLED_FIELD,
            NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD, CLUSTER_MODE_FIELD,
            SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD));

    private final String replicationGroupId;

    private final String replicationGroupDescription;

    private final String globalReplicationGroupId;

    private final String primaryClusterId;

    private final Boolean automaticFailoverEnabled;

    private final Boolean multiAZEnabled;

    private final Integer numCacheClusters;

    private final List<String> preferredCacheClusterAZs;

    private final Integer numNodeGroups;

    private final Integer replicasPerNodeGroup;

    private final List<NodeGroupConfiguration> nodeGroupConfiguration;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupName;

    private final String cacheSubnetGroupName;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final List<String> snapshotArns;

    private final String snapshotName;

    private final String preferredMaintenanceWindow;

    private final Integer port;

    private final String notificationTopicArn;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String authToken;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String kmsKeyId;

    private final List<String> userGroupIds;

    private final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations;

    private final Boolean dataTieringEnabled;

    private final String networkType;

    private final String ipDiscovery;

    private final String transitEncryptionMode;

    private final String clusterMode;

    private final String serverlessCacheSnapshotName;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.multiAZEnabled = builder.multiAZEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.userGroupIds = builder.userGroupIds;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.dataTieringEnabled = builder.dataTieringEnabled;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.clusterMode = builder.clusterMode;
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The replication group identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 40 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     * 
     * @return A user-created description for the replication group.
     */
    public final String replicationGroupDescription() {
        return replicationGroupDescription;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */
    public final String globalReplicationGroupId() {
        return globalReplicationGroupId;
    }

    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     * 
     * @return The identifier of the cluster that serves as the primary for this replication group. This cluster must
     *         already exist and have a status of <code>available</code>.</p>
     *         <p>
     *         This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     *         <code>ReplicasPerNodeGroup</code> is specified.
     */
    public final String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *         primary fails.</p>
     *         <p>
     *         <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
     *         groups.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean automaticFailoverEnabled() {
        return automaticFailoverEnabled;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     * 
     * @return A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *         Multi-AZ</a>.
     */
    public final Boolean multiAZEnabled() {
        return multiAZEnabled;
    }

    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     * 
     * @return The number of clusters this replication group initially has.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>ReplicasPerNodeGroup</code> instead.
     *         </p>
     *         <p>
     *         If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
     *         least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it
     *         will default to 1), or you can explicitly set it to a value between 2 and 6.
     *         </p>
     *         <p>
     *         The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */
    public final Integer numCacheClusters() {
        return numCacheClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreferredCacheClusterAZs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPreferredCacheClusterAZs() {
        return preferredCacheClusterAZs != null && !(preferredCacheClusterAZs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreferredCacheClusterAZs} method.
     * </p>
     * 
     * @return A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *         Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *         created in the first AZ in the list.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>NodeGroupConfiguration</code> instead.
     *         </p>
     *         <note>
     *         <p>
     *         If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters
     *         in Availability Zones associated with the subnets in the selected subnet group.
     *         </p>
     *         <p>
     *         The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: system chosen Availability Zones.
     */
    public final List<String> preferredCacheClusterAZs() {
        return preferredCacheClusterAZs;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
     *         enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
     *         1.</p>
     *         <p>
     *         Default: 1
     */
    public final Integer numNodeGroups() {
        return numNodeGroups;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     * 
     * @return An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values
     *         are 0 to 5.
     */
    public final Integer replicasPerNodeGroup() {
        return replicasPerNodeGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeGroupConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeGroupConfiguration() {
        return nodeGroupConfiguration != null && !(nodeGroupConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeGroupConfiguration} method.
     * </p>
     * 
     * @return A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *         following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *         <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *         <p>
     *         If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *         you can use this parameter to individually configure each node group (shard), or you can omit this
     *         parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb
     *         file. You must configure each node group (shard) using this parameter because you must specify the slots
     *         for each node group.
     */
    public final List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return nodeGroupConfiguration;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16
     * onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The compute and memory capacity of the nodes in the node group (shard).</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *         <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *         <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *         <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *         <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version
     *         1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     *         </p>
     *         <p>
     *         <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *         <code>cache.t3.medium</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *         <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *         <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *         <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *         <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *         Redis version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
     * <code>Redis</code>.
     * </p>
     * 
     * @return The name of the cache engine to be used for the clusters in this replication group. The value must be set
     *         to <code>Redis</code>.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     * 
     * @return The version number of the cache engine to be used for the clusters in this replication group. To view the
     *         supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade
     *         to an earlier engine version. If you want to use an earlier engine version, you must delete the existing
     *         cluster or replication group and create it anew with the earlier engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the parameter group to associate with this replication group. If this argument is omitted,
     *         the default cache parameter group for the specified engine is used.</p>
     *         <p>
     *         If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
     *         parameter group, we recommend that you specify the parameter group by name.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode disabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode enabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     *         </p>
     *         </li>
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @return The name of the cache subnet group to be used for the replication group.</p> <important>
     *         <p>
     *         If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *         start creating a cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *         Groups</a>.
     *         </p>
     */
    public final String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheSecurityGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheSecurityGroupNames} method.
     * </p>
     * 
     * @return A list of cache security group names to associate with this replication group.
     */
    public final List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return One or more Amazon VPC security groups associated with this replication group.</p>
     *         <p>
     *         Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     *         <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     *         <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *         <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotArns() {
        return snapshotArns != null && !(snapshotArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotArns} method.
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
     *         Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name
     *         in the ARN cannot contain any commas. The new replication group will have the number of node groups
     *         (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured
     *         by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *         <p>
     *         Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    public final List<String> snapshotArns() {
        return snapshotArns;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     * 
     * @return The name of a snapshot from which to restore data into the new replication group. The snapshot status
     *         changes to <code>restoring</code> while the new replication group is being created.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     * 
     * @return The port number on which each member of the replication group accepts connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be the same as the cluster owner.
     *         </p>
     */
    public final String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *         the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic snapshots before deleting them. For example,
     *         if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5
     *         days before being deleted.</p>
     *         <p>
     *         Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @return <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *         <p>
     *         <code>AuthToken</code> can be specified only on replication groups where
     *         <code>TransitEncryptionEnabled</code> is <code>true</code>.
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     *         </important>
     *         <p>
     *         Password constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *         special characters cannot be used in the AUTH token.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *         http://redis.io/commands/AUTH.
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *         <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *         being created in an Amazon VPC.
     *         </p>
     *         <p>
     *         If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *         created. To enable encryption at rest on a replication group you must set
     *         <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the disk in the cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIds() {
        return userGroupIds != null && !(userGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIds} method.
     * </p>
     * 
     * @return The user group to associate with the replication group.
     */
    public final List<String> userGroupIds() {
        return userGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Specifies the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
     *         This parameter must be set to true when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     */
    public final Boolean dataTieringEnabled() {
        return dataTieringEnabled;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *         on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *         on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when creating a replication group, either <code>ipv4</code> |
     *         <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *         engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *         system</a>.
     * @see IpDiscovery
     */
    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(ipDiscovery);
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when creating a replication group, either <code>ipv4</code> |
     *         <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *         engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *         system</a>.
     * @see IpDiscovery
     */
    public final String ipDiscoveryAsString() {
        return ipDiscovery;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *         <p>
     *         When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *         <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *         and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *         connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *         </p>
     *         <p>
     *         Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *         you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *         <code>TransitEncryptionMode</code> to <code>required</code>.
     *         </p>
     *         <p>
     *         This process will not trigger the replacement of the replication group.
     * @see TransitEncryptionMode
     */
    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(transitEncryptionMode);
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *         <p>
     *         When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *         <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *         and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *         connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *         </p>
     *         <p>
     *         Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *         you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *         <code>TransitEncryptionMode</code> to <code>required</code>.
     *         </p>
     *         <p>
     *         This process will not trigger the replacement of the replication group.
     * @see TransitEncryptionMode
     */
    public final String transitEncryptionModeAsString() {
        return transitEncryptionMode;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *         cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *         complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final ClusterMode clusterMode() {
        return ClusterMode.fromValue(clusterMode);
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *         cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *         complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final String clusterModeAsString() {
        return clusterMode;
    }

    /**
     * <p>
     * The name of the snapshot used to create a replication group. Available for Redis only.
     * </p>
     * 
     * @return The name of the snapshot used to create a replication group. Available for Redis only.
     */
    public final String serverlessCacheSnapshotName() {
        return serverlessCacheSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(numCacheClusters());
        hashCode = 31 * hashCode + Objects.hashCode(hasPreferredCacheClusterAZs() ? preferredCacheClusterAZs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(replicasPerNodeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeGroupConfiguration() ? nodeGroupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotArns() ? snapshotArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIds() ? userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataTieringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(replicationGroupDescription(), other.replicationGroupDescription())
                && Objects.equals(globalReplicationGroupId(), other.globalReplicationGroupId())
                && Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(automaticFailoverEnabled(), other.automaticFailoverEnabled())
                && Objects.equals(multiAZEnabled(), other.multiAZEnabled())
                && Objects.equals(numCacheClusters(), other.numCacheClusters())
                && hasPreferredCacheClusterAZs() == other.hasPreferredCacheClusterAZs()
                && Objects.equals(preferredCacheClusterAZs(), other.preferredCacheClusterAZs())
                && Objects.equals(numNodeGroups(), other.numNodeGroups())
                && Objects.equals(replicasPerNodeGroup(), other.replicasPerNodeGroup())
                && hasNodeGroupConfiguration() == other.hasNodeGroupConfiguration()
                && Objects.equals(nodeGroupConfiguration(), other.nodeGroupConfiguration())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames()
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasSnapshotArns() == other.hasSnapshotArns()
                && Objects.equals(snapshotArns(), other.snapshotArns()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(port(), other.port()) && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasUserGroupIds() == other.hasUserGroupIds()
                && Objects.equals(userGroupIds(), other.userGroupIds())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(dataTieringEnabled(), other.dataTieringEnabled())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(ipDiscoveryAsString(), other.ipDiscoveryAsString())
                && Objects.equals(transitEncryptionModeAsString(), other.transitEncryptionModeAsString())
                && Objects.equals(clusterModeAsString(), other.clusterModeAsString())
                && Objects.equals(serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationGroupRequest").add("ReplicationGroupId", replicationGroupId())
                .add("ReplicationGroupDescription", replicationGroupDescription())
                .add("GlobalReplicationGroupId", globalReplicationGroupId()).add("PrimaryClusterId", primaryClusterId())
                .add("AutomaticFailoverEnabled", automaticFailoverEnabled()).add("MultiAZEnabled", multiAZEnabled())
                .add("NumCacheClusters", numCacheClusters())
                .add("PreferredCacheClusterAZs", hasPreferredCacheClusterAZs() ? preferredCacheClusterAZs() : null)
                .add("NumNodeGroups", numNodeGroups()).add("ReplicasPerNodeGroup", replicasPerNodeGroup())
                .add("NodeGroupConfiguration", hasNodeGroupConfiguration() ? nodeGroupConfiguration() : null)
                .add("CacheNodeType", cacheNodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("CacheParameterGroupName", cacheParameterGroupName()).add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheSecurityGroupNames", hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("SnapshotArns", hasSnapshotArns() ? snapshotArns() : null)
                .add("SnapshotName", snapshotName()).add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("Port", port()).add("NotificationTopicArn", notificationTopicArn())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("AuthToken", authToken()).add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("KmsKeyId", kmsKeyId())
                .add("UserGroupIds", hasUserGroupIds() ? userGroupIds() : null)
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("DataTieringEnabled", dataTieringEnabled()).add("NetworkType", networkTypeAsString())
                .add("IpDiscovery", ipDiscoveryAsString()).add("TransitEncryptionMode", transitEncryptionModeAsString())
                .add("ClusterMode", clusterModeAsString()).add("ServerlessCacheSnapshotName", serverlessCacheSnapshotName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "ReplicationGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationGroupDescription()));
        case "GlobalReplicationGroupId":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupId()));
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "AutomaticFailoverEnabled":
            return Optional.ofNullable(clazz.cast(automaticFailoverEnabled()));
        case "MultiAZEnabled":
            return Optional.ofNullable(clazz.cast(multiAZEnabled()));
        case "NumCacheClusters":
            return Optional.ofNullable(clazz.cast(numCacheClusters()));
        case "PreferredCacheClusterAZs":
            return Optional.ofNullable(clazz.cast(preferredCacheClusterAZs()));
        case "NumNodeGroups":
            return Optional.ofNullable(clazz.cast(numNodeGroups()));
        case "ReplicasPerNodeGroup":
            return Optional.ofNullable(clazz.cast(replicasPerNodeGroup()));
        case "NodeGroupConfiguration":
            return Optional.ofNullable(clazz.cast(nodeGroupConfiguration()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SnapshotArns":
            return Optional.ofNullable(clazz.cast(snapshotArns()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "UserGroupIds":
            return Optional.ofNullable(clazz.cast(userGroupIds()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "DataTieringEnabled":
            return Optional.ofNullable(clazz.cast(dataTieringEnabled()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "IpDiscovery":
            return Optional.ofNullable(clazz.cast(ipDiscoveryAsString()));
        case "TransitEncryptionMode":
            return Optional.ofNullable(clazz.cast(transitEncryptionModeAsString()));
        case "ClusterMode":
            return Optional.ofNullable(clazz.cast(clusterModeAsString()));
        case "ServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateReplicationGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        /**
         * <p>
         * The replication group identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A name must contain from 1 to 40 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * A name cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationGroupId
         *        The replication group identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A name must contain from 1 to 40 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A name cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * A user-created description for the replication group.
         * </p>
         * 
         * @param replicationGroupDescription
         *        A user-created description for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupDescription(String replicationGroupDescription);

        /**
         * <p>
         * The name of the Global datastore
         * </p>
         * 
         * @param globalReplicationGroupId
         *        The name of the Global datastore
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupId(String globalReplicationGroupId);

        /**
         * <p>
         * The identifier of the cluster that serves as the primary for this replication group. This cluster must
         * already exist and have a status of <code>available</code>.
         * </p>
         * <p>
         * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
         * <code>ReplicasPerNodeGroup</code> is specified.
         * </p>
         * 
         * @param primaryClusterId
         *        The identifier of the cluster that serves as the primary for this replication group. This cluster must
         *        already exist and have a status of <code>available</code>.</p>
         *        <p>
         *        This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
         *        <code>ReplicasPerNodeGroup</code> is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
         * fails.
         * </p>
         * <p>
         * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param automaticFailoverEnabled
         *        Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
         *        primary fails.</p>
         *        <p>
         *        <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
         *        groups.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled);

        /**
         * <p>
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
         * Multi-AZ</a>.
         * </p>
         * 
         * @param multiAZEnabled
         *        A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see
         *        <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing
         *        Downtime: Multi-AZ</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZEnabled(Boolean multiAZEnabled);

        /**
         * <p>
         * The number of clusters this replication group initially has.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>ReplicasPerNodeGroup</code> instead.
         * </p>
         * <p>
         * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least
         * 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will
         * default to 1), or you can explicitly set it to a value between 2 and 6.
         * </p>
         * <p>
         * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * </p>
         * 
         * @param numCacheClusters
         *        The number of clusters this replication group initially has.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>ReplicasPerNodeGroup</code> instead.
         *        </p>
         *        <p>
         *        If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
         *        least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter
         *        (it will default to 1), or you can explicitly set it to a value between 2 and 6.
         *        </p>
         *        <p>
         *        The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheClusters(Integer numCacheClusters);

        /**
         * <p>
         * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
         * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created
         * in the first AZ in the list.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>NodeGroupConfiguration</code> instead.
         * </p>
         * <note>
         * <p>
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
         * Availability Zones associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         * </p>
         * </note>
         * <p>
         * Default: system chosen Availability Zones.
         * </p>
         * 
         * @param preferredCacheClusterAZs
         *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of
         *        the Availability Zones in the list is the order in which clusters are allocated. The primary cluster
         *        is created in the first AZ in the list.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>NodeGroupConfiguration</code> instead.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate
         *        clusters in Availability Zones associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: system chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs);

        /**
         * <p>
         * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
         * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created
         * in the first AZ in the list.
         * </p>
         * <p>
         * This parameter is not used if there is more than one node group (shard). You should use
         * <code>NodeGroupConfiguration</code> instead.
         * </p>
         * <note>
         * <p>
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
         * Availability Zones associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         * </p>
         * </note>
         * <p>
         * Default: system chosen Availability Zones.
         * </p>
         * 
         * @param preferredCacheClusterAZs
         *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of
         *        the Availability Zones in the list is the order in which clusters are allocated. The primary cluster
         *        is created in the first AZ in the list.</p>
         *        <p>
         *        This parameter is not used if there is more than one node group (shard). You should use
         *        <code>NodeGroupConfiguration</code> instead.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate
         *        clusters in Availability Zones associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: system chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredCacheClusterAZs(String... preferredCacheClusterAZs);

        /**
         * <p>
         * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
         * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param numNodeGroups
         *        An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
         *        enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
         *        1.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numNodeGroups(Integer numNodeGroups);

        /**
         * <p>
         * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are
         * 0 to 5.
         * </p>
         * 
         * @param replicasPerNodeGroup
         *        An optional parameter that specifies the number of replica nodes in each node group (shard). Valid
         *        values are 0 to 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicasPerNodeGroup(Integer replicasPerNodeGroup);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must
         * configure each node group (shard) using this parameter because you must specify the slots for each node
         * group.
         * </p>
         * 
         * @param nodeGroupConfiguration
         *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
         *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
         *        <p>
         *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication
         *        group, you can use this parameter to individually configure each node group (shard), or you can omit
         *        this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3
         *        rdb file. You must configure each node group (shard) using this parameter because you must specify the
         *        slots for each node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must
         * configure each node group (shard) using this parameter because you must specify the slots for each node
         * group.
         * </p>
         * 
         * @param nodeGroupConfiguration
         *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
         *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
         *        <p>
         *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication
         *        group, you can use this parameter to individually configure each node group (shard), or you can omit
         *        this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3
         *        rdb file. You must configure each node group (shard) using this parameter because you must specify the
         *        slots for each node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroupConfiguration(NodeGroupConfiguration... nodeGroupConfiguration);

        /**
         * <p>
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
         * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
         * <code>ReplicaCount</code>, and <code>Slots</code>.
         * </p>
         * <p>
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you
         * can use this parameter to individually configure each node group (shard), or you can omit this parameter.
         * However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must
         * configure each node group (shard) using this parameter because you must specify the slots for each node
         * group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeGroupConfiguration(List<NodeGroupConfiguration>)}.
         * 
         * @param nodeGroupConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroupConfiguration(java.util.Collection<NodeGroupConfiguration>)
         */
        Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder>... nodeGroupConfiguration);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the node group (shard).
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
         * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
         * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
         * <code>cache.m6g.16xlarge</code>
         * </p>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version
         * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
         * </p>
         * <p>
         * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
         * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
         * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
         * <code>cache.r6g.16xlarge</code>
         * </p>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
         * version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The compute and memory capacity of the nodes in the node group (shard).</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         *        <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         *        <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
         *        version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine
         *        version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
         *        <code>cache.t4g.medium</code>
         *        </p>
         *        <p>
         *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
         *        <code>cache.t3.medium</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         *        <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         *        <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
         *        version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
         *        <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
         *        <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
         *        on Redis version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
         * <code>Redis</code>.
         * </p>
         * 
         * @param engine
         *        The name of the cache engine to be used for the clusters in this replication group. The value must be
         *        set to <code>Redis</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the cache engine to be used for the clusters in this replication group. To view the
         * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to
         * an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster
         * or replication group and create it anew with the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the cache engine to be used for the clusters in this replication group. To view
         *        the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot
         *        downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete
         *        the existing cluster or replication group and create it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the parameter group to associate with this replication group. If this argument is omitted, the
         * default cache parameter group for the specified engine is used.
         * </p>
         * <p>
         * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
         * parameter group, we recommend that you specify the parameter group by name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To create a Redis (cluster mode disabled) replication group, use
         * <code>CacheParameterGroupName=default.redis3.2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a Redis (cluster mode enabled) replication group, use
         * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheParameterGroupName
         *        The name of the parameter group to associate with this replication group. If this argument is omitted,
         *        the default cache parameter group for the specified engine is used.</p>
         *        <p>
         *        If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a
         *        default parameter group, we recommend that you specify the parameter group by name.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To create a Redis (cluster mode disabled) replication group, use
         *        <code>CacheParameterGroupName=default.redis3.2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a Redis (cluster mode enabled) replication group, use
         *        <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the cache subnet group to be used for the replication group.
         * </p>
         * <important>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
         * creating a cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
         * Groups</a>.
         * </p>
         * </important>
         * 
         * @param cacheSubnetGroupName
         *        The name of the cache subnet group to be used for the replication group.</p> <important>
         *        <p>
         *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
         *        start creating a cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and
         *        Subnet Groups</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A list of cache security group names to associate with this replication group.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to associate with this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of cache security group names to associate with this replication group.
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of cache security group names to associate with this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * One or more Amazon VPC security groups associated with this replication group.
         * </p>
         * <p>
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more Amazon VPC security groups associated with this replication group.</p>
         *        <p>
         *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more Amazon VPC security groups associated with this replication group.
         * </p>
         * <p>
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more Amazon VPC security groups associated with this replication group.</p>
         *        <p>
         *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
         *        <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following:
         *        Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         *        <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
         *        <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following:
         *        Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         *        <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
         * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
         * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
         * S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN
         * cannot contain any commas. The new replication group will have the number of node groups (console: shards)
         * specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
         * <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.
         * </p>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
         *        Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object
         *        name in the ARN cannot contain any commas. The new replication group will have the number of node
         *        groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups
         *        configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(Collection<String> snapshotArns);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
         * S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN
         * cannot contain any commas. The new replication group will have the number of node groups (console: shards)
         * specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
         * <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.
         * </p>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
         *        Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object
         *        name in the ARN cannot contain any commas. The new replication group will have the number of node
         *        groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups
         *        configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(String... snapshotArns);

        /**
         * <p>
         * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes
         * to <code>restoring</code> while the new replication group is being created.
         * </p>
         * 
         * @param snapshotName
         *        The name of a snapshot from which to restore data into the new replication group. The snapshot status
         *        changes to <code>restoring</code> while the new replication group is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The port number on which each member of the replication group accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which each member of the replication group accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications
         * are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
         *        notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be the same as the cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
         * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *         If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in
         *        to the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
         * you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
         * before being deleted.
         * </p>
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cluster).
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p>
         *        <p>
         *        Default: 0 (i.e., automatic backups are disabled for this cluster).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * <b>Reserved parameter.</b> The password used to access a password protected server.
         * </p>
         * <p>
         * <code>AuthToken</code> can be specified only on replication groups where
         * <code>TransitEncryptionEnabled</code> is <code>true</code>.
         * </p>
         * <important>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         * </p>
         * </important>
         * <p>
         * Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
         * special characters cannot be used in the AUTH token.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         * http://redis.io/commands/AUTH.
         * </p>
         * 
         * @param authToken
         *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
         *        <p>
         *        <code>AuthToken</code> can be specified only on replication groups where
         *        <code>TransitEncryptionEnabled</code> is <code>true</code>.
         *        </p>
         *        <important>
         *        <p>
         *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         *        </p>
         *        </important>
         *        <p>
         *        Password constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other
         *        printable special characters cannot be used in the AUTH token.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         *        http://redis.io/commands/AUTH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to <code>true</code>.
         * </p>
         * <p>
         * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
         * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
         * being created in an Amazon VPC.
         * </p>
         * <p>
         * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * <important>
         * <p>
         * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         * </p>
         * </important>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
         *        <p>
         *        This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
         *        <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster
         *        is being created in an Amazon VPC.
         *        </p>
         *        <p>
         *        If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         *        </p>
         *        <important>
         *        <p>
         *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
         *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created.
         * To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
         * <code>true</code> when you create the replication group.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
         *        created. To enable encryption at rest on a replication group you must set
         *        <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
         *        <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the disk in the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the disk in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The user group to associate with the replication group.
         * </p>
         * 
         * @param userGroupIds
         *        The user group to associate with the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(Collection<String> userGroupIds);

        /**
         * <p>
         * The user group to associate with the replication group.
         * </p>
         * 
         * @param userGroupIds
         *        The user group to associate with the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(String... userGroupIds);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<LogDeliveryConfigurationRequest>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<LogDeliveryConfigurationRequest>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
         * parameter must be set to true when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTieringEnabled
         *        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
         *        This parameter must be set to true when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTieringEnabled(Boolean dataTieringEnabled);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on
         * the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on
         * the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>.
         * IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on
         * all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when creating a replication group, either <code>ipv4</code> |
         *        <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
         *        engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
         *        system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(String ipDiscovery);

        /**
         * <p>
         * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>.
         * IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on
         * all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when creating a replication group, either <code>ipv4</code> |
         *        <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
         *        engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
         *        system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(IpDiscovery ipDiscovery);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * <p>
         * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
         * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
         * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
         * connections you can modify the value to <code>required</code> to allow encrypted connections only.
         * </p>
         * <p>
         * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you
         * to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
         * <code>TransitEncryptionMode</code> to <code>required</code>.
         * </p>
         * <p>
         * This process will not trigger the replacement of the replication group.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
         *        <p>
         *        When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
         *        <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both
         *        encrypted and unencrypted connections at the same time. Once you migrate all your Redis clients to use
         *        encrypted connections you can modify the value to <code>required</code> to allow encrypted connections
         *        only.
         *        </p>
         *        <p>
         *        Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that
         *        requires you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that
         *        you can set <code>TransitEncryptionMode</code> to <code>required</code>.
         *        </p>
         *        <p>
         *        This process will not trigger the replacement of the replication group.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(String transitEncryptionMode);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * <p>
         * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
         * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
         * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
         * connections you can modify the value to <code>required</code> to allow encrypted connections only.
         * </p>
         * <p>
         * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you
         * to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
         * <code>TransitEncryptionMode</code> to <code>required</code>.
         * </p>
         * <p>
         * This process will not trigger the replacement of the replication group.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
         *        <p>
         *        When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
         *        <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both
         *        encrypted and unencrypted connections at the same time. Once you migrate all your Redis clients to use
         *        encrypted connections you can modify the value to <code>required</code> to allow encrypted connections
         *        only.
         *        </p>
         *        <p>
         *        Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that
         *        requires you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that
         *        you can set <code>TransitEncryptionMode</code> to <code>required</code>.
         *        </p>
         *        <p>
         *        This process will not trigger the replacement of the replication group.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster
         * mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster
         * mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode
         *        enabled and cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled,
         *        you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(String clusterMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster
         * mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster
         * mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode
         *        enabled and cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled,
         *        you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(ClusterMode clusterMode);

        /**
         * <p>
         * The name of the snapshot used to create a replication group. Available for Redis only.
         * </p>
         * 
         * @param serverlessCacheSnapshotName
         *        The name of the snapshot used to create a replication group. Available for Redis only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String replicationGroupId;

        private String replicationGroupDescription;

        private String globalReplicationGroupId;

        private String primaryClusterId;

        private Boolean automaticFailoverEnabled;

        private Boolean multiAZEnabled;

        private Integer numCacheClusters;

        private List<String> preferredCacheClusterAZs = DefaultSdkAutoConstructList.getInstance();

        private Integer numNodeGroups;

        private Integer replicasPerNodeGroup;

        private List<NodeGroupConfiguration> nodeGroupConfiguration = DefaultSdkAutoConstructList.getInstance();

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheParameterGroupName;

        private String cacheSubnetGroupName;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();

        private String snapshotName;

        private String preferredMaintenanceWindow;

        private Integer port;

        private String notificationTopicArn;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String authToken;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String kmsKeyId;

        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<LogDeliveryConfigurationRequest> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean dataTieringEnabled;

        private String networkType;

        private String ipDiscovery;

        private String transitEncryptionMode;

        private String clusterMode;

        private String serverlessCacheSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            super(model);
            replicationGroupId(model.replicationGroupId);
            replicationGroupDescription(model.replicationGroupDescription);
            globalReplicationGroupId(model.globalReplicationGroupId);
            primaryClusterId(model.primaryClusterId);
            automaticFailoverEnabled(model.automaticFailoverEnabled);
            multiAZEnabled(model.multiAZEnabled);
            numCacheClusters(model.numCacheClusters);
            preferredCacheClusterAZs(model.preferredCacheClusterAZs);
            numNodeGroups(model.numNodeGroups);
            replicasPerNodeGroup(model.replicasPerNodeGroup);
            nodeGroupConfiguration(model.nodeGroupConfiguration);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            snapshotArns(model.snapshotArns);
            snapshotName(model.snapshotName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            port(model.port);
            notificationTopicArn(model.notificationTopicArn);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            authToken(model.authToken);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            kmsKeyId(model.kmsKeyId);
            userGroupIds(model.userGroupIds);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            dataTieringEnabled(model.dataTieringEnabled);
            networkType(model.networkType);
            ipDiscovery(model.ipDiscovery);
            transitEncryptionMode(model.transitEncryptionMode);
            clusterMode(model.clusterMode);
            serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupDescription() {
            return replicationGroupDescription;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final String getGlobalReplicationGroupId() {
            return globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return automaticFailoverEnabled;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final Boolean getMultiAZEnabled() {
            return multiAZEnabled;
        }

        public final void setMultiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
        }

        @Override
        public final Builder multiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
            return this;
        }

        public final Integer getNumCacheClusters() {
            return numCacheClusters;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            if (preferredCacheClusterAZs instanceof SdkAutoConstructList) {
                return null;
            }
            return preferredCacheClusterAZs;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String... preferredCacheClusterAZs) {
            preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final Integer getNumNodeGroups() {
            return numNodeGroups;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final Integer getReplicasPerNodeGroup() {
            return replicasPerNodeGroup;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final List<NodeGroupConfiguration.Builder> getNodeGroupConfiguration() {
            List<NodeGroupConfiguration.Builder> result = NodeGroupConfigurationListCopier
                    .copyToBuilder(this.nodeGroupConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration.BuilderImpl> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copyFromBuilder(nodeGroupConfiguration);
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration... nodeGroupConfiguration) {
            nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder>... nodeGroupConfiguration) {
            nodeGroupConfiguration(Stream.of(nodeGroupConfiguration)
                    .map(c -> NodeGroupConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheSecurityGroupNames;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSnapshotArns() {
            if (snapshotArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotArns;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String... snapshotArns) {
            snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getUserGroupIds() {
            if (userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIds;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListInputCopier.copy(userGroupIds);
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListInputCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String... userGroupIds) {
            userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final List<LogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfigurationRequest.Builder> result = LogDeliveryConfigurationRequestListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<LogDeliveryConfigurationRequest.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDataTieringEnabled() {
            return dataTieringEnabled;
        }

        public final void setDataTieringEnabled(Boolean dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
        }

        @Override
        public final Builder dataTieringEnabled(Boolean dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public final String getTransitEncryptionMode() {
            return transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final String getClusterMode() {
            return clusterMode;
        }

        public final void setClusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
        }

        @Override
        public final Builder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        @Override
        public final Builder clusterMode(ClusterMode clusterMode) {
            this.clusterMode(clusterMode == null ? null : clusterMode.toString());
            return this;
        }

        public final String getServerlessCacheSnapshotName() {
            return serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
