/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyUserRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyUserRequest.Builder, ModifyUserRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(ModifyUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(ModifyUserRequest::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final SdkField<String> APPEND_ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppendAccessString").getter(getter(ModifyUserRequest::appendAccessString))
            .setter(setter(Builder::appendAccessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendAccessString").build())
            .build();

    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Passwords")
            .getter(getter(ModifyUserRequest::passwords))
            .setter(setter(Builder::passwords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NO_PASSWORD_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoPasswordRequired").getter(getter(ModifyUserRequest::noPasswordRequired))
            .setter(setter(Builder::noPasswordRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoPasswordRequired").build())
            .build();

    private static final SdkField<AuthenticationMode> AUTHENTICATION_MODE_FIELD = SdkField
            .<AuthenticationMode> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMode")
            .getter(getter(ModifyUserRequest::authenticationMode)).setter(setter(Builder::authenticationMode))
            .constructor(AuthenticationMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            ACCESS_STRING_FIELD, APPEND_ACCESS_STRING_FIELD, PASSWORDS_FIELD, NO_PASSWORD_REQUIRED_FIELD,
            AUTHENTICATION_MODE_FIELD));

    private final String userId;

    private final String accessString;

    private final String appendAccessString;

    private final List<String> passwords;

    private final Boolean noPasswordRequired;

    private final AuthenticationMode authenticationMode;

    private ModifyUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.accessString = builder.accessString;
        this.appendAccessString = builder.appendAccessString;
        this.passwords = builder.passwords;
        this.noPasswordRequired = builder.noPasswordRequired;
        this.authenticationMode = builder.authenticationMode;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    /**
     * <p>
     * Adds additional user permissions to the access string.
     * </p>
     * 
     * @return Adds additional user permissions to the access string.
     */
    public final String appendAccessString() {
        return appendAccessString;
    }

    /**
     * For responses, this returns true if the service returned a value for the Passwords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPasswords() {
        return passwords != null && !(passwords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The passwords belonging to the user. You are allowed up to two.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPasswords} method.
     * </p>
     * 
     * @return The passwords belonging to the user. You are allowed up to two.
     */
    public final List<String> passwords() {
        return passwords;
    }

    /**
     * <p>
     * Indicates no password is required for the user.
     * </p>
     * 
     * @return Indicates no password is required for the user.
     */
    public final Boolean noPasswordRequired() {
        return noPasswordRequired;
    }

    /**
     * <p>
     * Specifies how to authenticate the user.
     * </p>
     * 
     * @return Specifies how to authenticate the user.
     */
    public final AuthenticationMode authenticationMode() {
        return authenticationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        hashCode = 31 * hashCode + Objects.hashCode(appendAccessString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPasswords() ? passwords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(noPasswordRequired());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserRequest)) {
            return false;
        }
        ModifyUserRequest other = (ModifyUserRequest) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(accessString(), other.accessString())
                && Objects.equals(appendAccessString(), other.appendAccessString()) && hasPasswords() == other.hasPasswords()
                && Objects.equals(passwords(), other.passwords())
                && Objects.equals(noPasswordRequired(), other.noPasswordRequired())
                && Objects.equals(authenticationMode(), other.authenticationMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyUserRequest").add("UserId", userId()).add("AccessString", accessString())
                .add("AppendAccessString", appendAccessString()).add("Passwords", hasPasswords() ? passwords() : null)
                .add("NoPasswordRequired", noPasswordRequired()).add("AuthenticationMode", authenticationMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        case "AppendAccessString":
            return Optional.ofNullable(clazz.cast(appendAccessString()));
        case "Passwords":
            return Optional.ofNullable(clazz.cast(passwords()));
        case "NoPasswordRequired":
            return Optional.ofNullable(clazz.cast(noPasswordRequired()));
        case "AuthenticationMode":
            return Optional.ofNullable(clazz.cast(authenticationMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserRequest, T> g) {
        return obj -> g.apply((ModifyUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyUserRequest> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        /**
         * <p>
         * Adds additional user permissions to the access string.
         * </p>
         * 
         * @param appendAccessString
         *        Adds additional user permissions to the access string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendAccessString(String appendAccessString);

        /**
         * <p>
         * The passwords belonging to the user. You are allowed up to two.
         * </p>
         * 
         * @param passwords
         *        The passwords belonging to the user. You are allowed up to two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(Collection<String> passwords);

        /**
         * <p>
         * The passwords belonging to the user. You are allowed up to two.
         * </p>
         * 
         * @param passwords
         *        The passwords belonging to the user. You are allowed up to two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(String... passwords);

        /**
         * <p>
         * Indicates no password is required for the user.
         * </p>
         * 
         * @param noPasswordRequired
         *        Indicates no password is required for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noPasswordRequired(Boolean noPasswordRequired);

        /**
         * <p>
         * Specifies how to authenticate the user.
         * </p>
         * 
         * @param authenticationMode
         *        Specifies how to authenticate the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMode(AuthenticationMode authenticationMode);

        /**
         * <p>
         * Specifies how to authenticate the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMode.Builder} avoiding the
         * need to create one manually via {@link AuthenticationMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationMode.Builder#build()} is called immediately and its
         * result is passed to {@link #authenticationMode(AuthenticationMode)}.
         * 
         * @param authenticationMode
         *        a consumer that will call methods on {@link AuthenticationMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMode(AuthenticationMode)
         */
        default Builder authenticationMode(Consumer<AuthenticationMode.Builder> authenticationMode) {
            return authenticationMode(AuthenticationMode.builder().applyMutation(authenticationMode).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String userId;

        private String accessString;

        private String appendAccessString;

        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();

        private Boolean noPasswordRequired;

        private AuthenticationMode authenticationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserRequest model) {
            super(model);
            userId(model.userId);
            accessString(model.accessString);
            appendAccessString(model.appendAccessString);
            passwords(model.passwords);
            noPasswordRequired(model.noPasswordRequired);
            authenticationMode(model.authenticationMode);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getAccessString() {
            return accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final String getAppendAccessString() {
            return appendAccessString;
        }

        public final void setAppendAccessString(String appendAccessString) {
            this.appendAccessString = appendAccessString;
        }

        @Override
        public final Builder appendAccessString(String appendAccessString) {
            this.appendAccessString = appendAccessString;
            return this;
        }

        public final Collection<String> getPasswords() {
            if (passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return passwords;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String... passwords) {
            passwords(Arrays.asList(passwords));
            return this;
        }

        public final Boolean getNoPasswordRequired() {
            return noPasswordRequired;
        }

        public final void setNoPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
        }

        @Override
        public final Builder noPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public final AuthenticationMode.Builder getAuthenticationMode() {
            return authenticationMode != null ? authenticationMode.toBuilder() : null;
        }

        public final void setAuthenticationMode(AuthenticationMode.BuilderImpl authenticationMode) {
            this.authenticationMode = authenticationMode != null ? authenticationMode.build() : null;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUserRequest build() {
            return new ModifyUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
