/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all of the attributes of a specific cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheCluster implements SdkPojo, Serializable, ToCopyableBuilder<CacheCluster.Builder, CacheCluster> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(CacheCluster::cacheClusterId)).setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<Endpoint> CONFIGURATION_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationEndpoint").getter(getter(CacheCluster::configurationEndpoint))
            .setter(setter(Builder::configurationEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationEndpoint").build())
            .build();

    private static final SdkField<String> CLIENT_DOWNLOAD_LANDING_PAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientDownloadLandingPage").getter(getter(CacheCluster::clientDownloadLandingPage))
            .setter(setter(Builder::clientDownloadLandingPage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientDownloadLandingPage").build())
            .build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(CacheCluster::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CacheCluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CacheCluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterStatus").getter(getter(CacheCluster::cacheClusterStatus))
            .setter(setter(Builder::cacheClusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterStatus").build())
            .build();

    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumCacheNodes").getter(getter(CacheCluster::numCacheNodes)).setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredAvailabilityZone").getter(getter(CacheCluster::preferredAvailabilityZone))
            .setter(setter(Builder::preferredAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build())
            .build();

    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredOutpostArn").getter(getter(CacheCluster::preferredOutpostArn))
            .setter(setter(Builder::preferredOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build())
            .build();

    private static final SdkField<Instant> CACHE_CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CacheClusterCreateTime").getter(getter(CacheCluster::cacheClusterCreateTime))
            .setter(setter(Builder::cacheClusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterCreateTime").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CacheCluster::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<PendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(CacheCluster::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(PendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(CacheCluster::notificationConfiguration)).setter(setter(Builder::notificationConfiguration))
            .constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final SdkField<List<CacheSecurityGroupMembership>> CACHE_SECURITY_GROUPS_FIELD = SdkField
            .<List<CacheSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("CacheSecurityGroups")
            .getter(getter(CacheCluster::cacheSecurityGroups))
            .setter(setter(Builder::cacheSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<CacheSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroup").build()).build()).build()).build();

    private static final SdkField<CacheParameterGroupStatus> CACHE_PARAMETER_GROUP_FIELD = SdkField
            .<CacheParameterGroupStatus> builder(MarshallingType.SDK_POJO).memberName("CacheParameterGroup")
            .getter(getter(CacheCluster::cacheParameterGroup)).setter(setter(Builder::cacheParameterGroup))
            .constructor(CacheParameterGroupStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroup").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSubnetGroupName").getter(getter(CacheCluster::cacheSubnetGroupName))
            .setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<List<CacheNode>> CACHE_NODES_FIELD = SdkField
            .<List<CacheNode>> builder(MarshallingType.LIST)
            .memberName("CacheNodes")
            .getter(getter(CacheCluster::cacheNodes))
            .setter(setter(Builder::cacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNode")
                            .memberFieldInfo(
                                    SdkField.<CacheNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNode").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CacheCluster::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<List<SecurityGroupMembership>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CacheCluster::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(CacheCluster::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(CacheCluster::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(CacheCluster::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuthTokenEnabled").getter(getter(CacheCluster::authTokenEnabled))
            .setter(setter(Builder::authTokenEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()).build();

    private static final SdkField<Instant> AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("AuthTokenLastModifiedDate")
            .getter(getter(CacheCluster::authTokenLastModifiedDate)).setter(setter(Builder::authTokenLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenLastModifiedDate").build())
            .build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(CacheCluster::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AtRestEncryptionEnabled").getter(getter(CacheCluster::atRestEncryptionEnabled))
            .setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(CacheCluster::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<Boolean> REPLICATION_GROUP_LOG_DELIVERY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplicationGroupLogDeliveryEnabled")
            .getter(getter(CacheCluster::replicationGroupLogDeliveryEnabled))
            .setter(setter(Builder::replicationGroupLogDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupLogDeliveryEnabled")
                    .build()).build();

    private static final SdkField<List<LogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(CacheCluster::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfiguration")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfiguration").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CacheCluster::networkTypeAsString)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpDiscovery").getter(getter(CacheCluster::ipDiscoveryAsString)).setter(setter(Builder::ipDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()).build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryptionMode").getter(getter(CacheCluster::transitEncryptionModeAsString))
            .setter(setter(Builder::transitEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            CONFIGURATION_ENDPOINT_FIELD, CLIENT_DOWNLOAD_LANDING_PAGE_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, CACHE_CLUSTER_STATUS_FIELD, NUM_CACHE_NODES_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD,
            PREFERRED_OUTPOST_ARN_FIELD, CACHE_CLUSTER_CREATE_TIME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            PENDING_MODIFIED_VALUES_FIELD, NOTIFICATION_CONFIGURATION_FIELD, CACHE_SECURITY_GROUPS_FIELD,
            CACHE_PARAMETER_GROUP_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_NODES_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD,
            SECURITY_GROUPS_FIELD, REPLICATION_GROUP_ID_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD,
            AUTH_TOKEN_ENABLED_FIELD, AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD,
            AT_REST_ENCRYPTION_ENABLED_FIELD, ARN_FIELD, REPLICATION_GROUP_LOG_DELIVERY_ENABLED_FIELD,
            LOG_DELIVERY_CONFIGURATIONS_FIELD, NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheClusterId;

    private final Endpoint configurationEndpoint;

    private final String clientDownloadLandingPage;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheClusterStatus;

    private final Integer numCacheNodes;

    private final String preferredAvailabilityZone;

    private final String preferredOutpostArn;

    private final Instant cacheClusterCreateTime;

    private final String preferredMaintenanceWindow;

    private final PendingModifiedValues pendingModifiedValues;

    private final NotificationConfiguration notificationConfiguration;

    private final List<CacheSecurityGroupMembership> cacheSecurityGroups;

    private final CacheParameterGroupStatus cacheParameterGroup;

    private final String cacheSubnetGroupName;

    private final List<CacheNode> cacheNodes;

    private final Boolean autoMinorVersionUpgrade;

    private final List<SecurityGroupMembership> securityGroups;

    private final String replicationGroupId;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final Boolean authTokenEnabled;

    private final Instant authTokenLastModifiedDate;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String arn;

    private final Boolean replicationGroupLogDeliveryEnabled;

    private final List<LogDeliveryConfiguration> logDeliveryConfigurations;

    private final String networkType;

    private final String ipDiscovery;

    private final String transitEncryptionMode;

    private CacheCluster(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.clientDownloadLandingPage = builder.clientDownloadLandingPage;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
        this.cacheParameterGroup = builder.cacheParameterGroup;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheNodes = builder.cacheNodes;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.securityGroups = builder.securityGroups;
        this.replicationGroupId = builder.replicationGroupId;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.authTokenLastModifiedDate = builder.authTokenLastModifiedDate;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.arn = builder.arn;
        this.replicationGroupLogDeliveryEnabled = builder.replicationGroupLogDeliveryEnabled;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
        this.transitEncryptionMode = builder.transitEncryptionMode;
    }

    /**
     * <p>
     * The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.
     * </p>
     * 
     * @return The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the
     * cluster. The configuration endpoint will always have <code>.cfg</code> in it.
     * </p>
     * <p>
     * Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
     * </p>
     * 
     * @return Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the
     *         cluster. The configuration endpoint will always have <code>.cfg</code> in it.</p>
     *         <p>
     *         Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
     */
    public final Endpoint configurationEndpoint() {
        return configurationEndpoint;
    }

    /**
     * <p>
     * The URL of the web page where you can download the latest ElastiCache client library.
     * </p>
     * 
     * @return The URL of the web page where you can download the latest ElastiCache client library.
     */
    public final String clientDownloadLandingPage() {
        return clientDownloadLandingPage;
    }

    /**
     * <p>
     * The name of the compute and memory capacity node type for the cluster.
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version
     * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * OSS version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the compute and memory capacity node type for the cluster.</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *         <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *         <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *         <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *         <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine
     *         version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
     *         <code>cache.t4g.medium</code>
     *         </p>
     *         <p>
     *         <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *         <code>cache.t3.medium</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *         <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *         <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *         <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *         <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
     *         on Redis OSS version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this cluster.
     * </p>
     * 
     * @return The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the cache engine that is used in this cluster.
     * </p>
     * 
     * @return The version of the cache engine that is used in this cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The current state of this cluster, one of the following values: <code>available</code>, <code>creating</code>,
     * <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>, <code>modifying</code>,
     * <code>rebooting cluster nodes</code>, <code>restore-failed</code>, or <code>snapshotting</code>.
     * </p>
     * 
     * @return The current state of this cluster, one of the following values: <code>available</code>,
     *         <code>creating</code>, <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>,
     *         <code>modifying</code>, <code>rebooting cluster nodes</code>, <code>restore-failed</code>, or
     *         <code>snapshotting</code>.
     */
    public final String cacheClusterStatus() {
        return cacheClusterStatus;
    }

    /**
     * <p>
     * The number of cache nodes in the cluster.
     * </p>
     * <p>
     * For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between
     * 1 and 40.
     * </p>
     * 
     * @return The number of cache nodes in the cluster.</p>
     *         <p>
     *         For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be
     *         between 1 and 40.
     */
    public final Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are located in
     * different Availability Zones.
     * </p>
     * 
     * @return The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are
     *         located in different Availability Zones.
     */
    public final String preferredAvailabilityZone() {
        return preferredAvailabilityZone;
    }

    /**
     * <p>
     * The outpost ARN in which the cache cluster is created.
     * </p>
     * 
     * @return The outpost ARN in which the cache cluster is created.
     */
    public final String preferredOutpostArn() {
        return preferredOutpostArn;
    }

    /**
     * <p>
     * The date and time when the cluster was created.
     * </p>
     * 
     * @return The date and time when the cluster was created.
     */
    public final Instant cacheClusterCreateTime() {
        return cacheClusterCreateTime;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * Returns the value of the PendingModifiedValues property for this object.
     * 
     * @return The value of the PendingModifiedValues property for this object.
     */
    public final PendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to
     * subscribers using Amazon Simple Notification Service (SNS).
     * </p>
     * 
     * @return Describes a notification topic and its status. Notification topics are used for publishing ElastiCache
     *         events to subscribers using Amazon Simple Notification Service (SNS).
     */
    public final NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheSecurityGroups() {
        return cacheSecurityGroups != null && !(cacheSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache security group elements, composed of name and status sub-elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheSecurityGroups} method.
     * </p>
     * 
     * @return A list of cache security group elements, composed of name and status sub-elements.
     */
    public final List<CacheSecurityGroupMembership> cacheSecurityGroups() {
        return cacheSecurityGroups;
    }

    /**
     * <p>
     * Status of the cache parameter group.
     * </p>
     * 
     * @return Status of the cache parameter group.
     */
    public final CacheParameterGroupStatus cacheParameterGroup() {
        return cacheParameterGroup;
    }

    /**
     * <p>
     * The name of the cache subnet group associated with the cluster.
     * </p>
     * 
     * @return The name of the cache subnet group associated with the cluster.
     */
    public final String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheNodes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCacheNodes() {
        return cacheNodes != null && !(cacheNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache nodes that are members of the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheNodes} method.
     * </p>
     * 
     * @return A list of cache nodes that are members of the cluster.
     */
    public final List<CacheNode> cacheNodes() {
        return cacheNodes;
    }

    /**
     * <p>
     *  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to
     *         opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous
     *         versions. 
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC Security Groups associated with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return A list of VPC Security Groups associated with the cluster.
     */
    public final List<SecurityGroupMembership> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The replication group to which this cluster belongs. If this field is empty, the cluster is not associated with
     * any replication group.
     * </p>
     * 
     * @return The replication group to which this cluster belongs. If this field is empty, the cluster is not
     *         associated with any replication group.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example,
     * if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     * before being deleted.
     * </p>
     * <important>
     * <p>
     * If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     * </p>
     * </important>
     * 
     * @return The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
     *         example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
     *         for 5 days before being deleted.</p> <important>
     *         <p>
     *         If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     *         </p>
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your
     *         cluster.</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean authTokenEnabled() {
        return authTokenEnabled;
    }

    /**
     * <p>
     * The date the auth token was last modified
     * </p>
     * 
     * @return The date the auth token was last modified
     */
    public final Instant authTokenLastModifiedDate() {
        return authTokenLastModifiedDate;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at-rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
     * at-rest encryption on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you
     * create a cluster.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at-rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
     *         enable at-rest encryption on a cluster you must set <code>AtRestEncryptionEnabled</code> to
     *         <code>true</code> when you create a cluster.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the cache cluster.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the cache cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A boolean value indicating whether log delivery is enabled for the replication group.
     * </p>
     * 
     * @return A boolean value indicating whether log delivery is enabled for the replication group.
     */
    public final Boolean replicationGroupLogDeliveryEnabled() {
        return replicationGroupLogDeliveryEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Returns the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfiguration> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for
     * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on
     * the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     *         supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(ipDiscovery);
    }

    /**
     * <p>
     * The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for
     * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on
     * the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     *         supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final String ipDiscoveryAsString() {
        return ipDiscovery;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(transitEncryptionMode);
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final String transitEncryptionModeAsString() {
        return transitEncryptionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientDownloadLandingPage());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheSecurityGroups() ? cacheSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheNodes() ? cacheNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupLogDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(configurationEndpoint(), other.configurationEndpoint())
                && Objects.equals(clientDownloadLandingPage(), other.clientDownloadLandingPage())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheClusterStatus(), other.cacheClusterStatus())
                && Objects.equals(numCacheNodes(), other.numCacheNodes())
                && Objects.equals(preferredAvailabilityZone(), other.preferredAvailabilityZone())
                && Objects.equals(preferredOutpostArn(), other.preferredOutpostArn())
                && Objects.equals(cacheClusterCreateTime(), other.cacheClusterCreateTime())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration())
                && hasCacheSecurityGroups() == other.hasCacheSecurityGroups()
                && Objects.equals(cacheSecurityGroups(), other.cacheSecurityGroups())
                && Objects.equals(cacheParameterGroup(), other.cacheParameterGroup())
                && Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && hasCacheNodes() == other.hasCacheNodes() && Objects.equals(cacheNodes(), other.cacheNodes())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(authTokenEnabled(), other.authTokenEnabled())
                && Objects.equals(authTokenLastModifiedDate(), other.authTokenLastModifiedDate())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(arn(), other.arn())
                && Objects.equals(replicationGroupLogDeliveryEnabled(), other.replicationGroupLogDeliveryEnabled())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(ipDiscoveryAsString(), other.ipDiscoveryAsString())
                && Objects.equals(transitEncryptionModeAsString(), other.transitEncryptionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheCluster").add("CacheClusterId", cacheClusterId())
                .add("ConfigurationEndpoint", configurationEndpoint())
                .add("ClientDownloadLandingPage", clientDownloadLandingPage()).add("CacheNodeType", cacheNodeType())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("CacheClusterStatus", cacheClusterStatus())
                .add("NumCacheNodes", numCacheNodes()).add("PreferredAvailabilityZone", preferredAvailabilityZone())
                .add("PreferredOutpostArn", preferredOutpostArn()).add("CacheClusterCreateTime", cacheClusterCreateTime())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues())
                .add("NotificationConfiguration", notificationConfiguration())
                .add("CacheSecurityGroups", hasCacheSecurityGroups() ? cacheSecurityGroups() : null)
                .add("CacheParameterGroup", cacheParameterGroup()).add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheNodes", hasCacheNodes() ? cacheNodes() : null)
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("ReplicationGroupId", replicationGroupId()).add("SnapshotRetentionLimit", snapshotRetentionLimit())
                .add("SnapshotWindow", snapshotWindow()).add("AuthTokenEnabled", authTokenEnabled())
                .add("AuthTokenLastModifiedDate", authTokenLastModifiedDate())
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("ARN", arn())
                .add("ReplicationGroupLogDeliveryEnabled", replicationGroupLogDeliveryEnabled())
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("NetworkType", networkTypeAsString()).add("IpDiscovery", ipDiscoveryAsString())
                .add("TransitEncryptionMode", transitEncryptionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "ConfigurationEndpoint":
            return Optional.ofNullable(clazz.cast(configurationEndpoint()));
        case "ClientDownloadLandingPage":
            return Optional.ofNullable(clazz.cast(clientDownloadLandingPage()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheClusterStatus":
            return Optional.ofNullable(clazz.cast(cacheClusterStatus()));
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "PreferredAvailabilityZone":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZone()));
        case "PreferredOutpostArn":
            return Optional.ofNullable(clazz.cast(preferredOutpostArn()));
        case "CacheClusterCreateTime":
            return Optional.ofNullable(clazz.cast(cacheClusterCreateTime()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        case "CacheSecurityGroups":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroups()));
        case "CacheParameterGroup":
            return Optional.ofNullable(clazz.cast(cacheParameterGroup()));
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheNodes":
            return Optional.ofNullable(clazz.cast(cacheNodes()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "AuthTokenEnabled":
            return Optional.ofNullable(clazz.cast(authTokenEnabled()));
        case "AuthTokenLastModifiedDate":
            return Optional.ofNullable(clazz.cast(authTokenLastModifiedDate()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ReplicationGroupLogDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(replicationGroupLogDeliveryEnabled()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "IpDiscovery":
            return Optional.ofNullable(clazz.cast(ipDiscoveryAsString()));
        case "TransitEncryptionMode":
            return Optional.ofNullable(clazz.cast(transitEncryptionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheCluster, T> g) {
        return obj -> g.apply((CacheCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheCluster> {
        /**
         * <p>
         * The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.
         * </p>
         * 
         * @param cacheClusterId
         *        The user-supplied identifier of the cluster. This identifier is a unique key that identifies a
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the
         * cluster. The configuration endpoint will always have <code>.cfg</code> in it.
         * </p>
         * <p>
         * Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
         * </p>
         * 
         * @param configurationEndpoint
         *        Represents a Memcached cluster endpoint which can be used by an application to connect to any node in
         *        the cluster. The configuration endpoint will always have <code>.cfg</code> in it.</p>
         *        <p>
         *        Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationEndpoint(Endpoint configurationEndpoint);

        /**
         * <p>
         * Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the
         * cluster. The configuration endpoint will always have <code>.cfg</code> in it.
         * </p>
         * <p>
         * Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationEndpoint(Endpoint)}.
         * 
         * @param configurationEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationEndpoint(Endpoint)
         */
        default Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return configurationEndpoint(Endpoint.builder().applyMutation(configurationEndpoint).build());
        }

        /**
         * <p>
         * The URL of the web page where you can download the latest ElastiCache client library.
         * </p>
         * 
         * @param clientDownloadLandingPage
         *        The URL of the web page where you can download the latest ElastiCache client library.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientDownloadLandingPage(String clientDownloadLandingPage);

        /**
         * <p>
         * The name of the compute and memory capacity node type for the cluster.
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
         * version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         * <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         * <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         * </p>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version
         * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
         * </p>
         * <p>
         * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
         * version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
         * <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
         * <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
         * </p>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
         * Redis OSS version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The name of the compute and memory capacity node type for the cluster.</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         *        <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         *        <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached
         *        engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine
         *        version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
         *        <code>cache.t4g.medium</code>
         *        </p>
         *        <p>
         *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
         *        <code>cache.t3.medium</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         *        <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         *        <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached
         *        engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
         *        <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
         *        <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not
         *        supported on Redis OSS version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this cluster.
         * </p>
         * 
         * @param engine
         *        The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the cache engine that is used in this cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version of the cache engine that is used in this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The current state of this cluster, one of the following values: <code>available</code>, <code>creating</code>, <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>, <code>modifying</code>,
         * <code>rebooting cluster nodes</code>, <code>restore-failed</code>, or <code>snapshotting</code>.
         * </p>
         * 
         * @param cacheClusterStatus
         *        The current state of this cluster, one of the following values: <code>available</code>,
         *        <code>creating</code>, <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>,
         *        <code>modifying</code>, <code>rebooting cluster nodes</code>, <code>restore-failed</code>, or
         *        <code>snapshotting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterStatus(String cacheClusterStatus);

        /**
         * <p>
         * The number of cache nodes in the cluster.
         * </p>
         * <p>
         * For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be
         * between 1 and 40.
         * </p>
         * 
         * @param numCacheNodes
         *        The number of cache nodes in the cluster.</p>
         *        <p>
         *        For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must
         *        be between 1 and 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are
         * located in different Availability Zones.
         * </p>
         * 
         * @param preferredAvailabilityZone
         *        The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are
         *        located in different Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZone(String preferredAvailabilityZone);

        /**
         * <p>
         * The outpost ARN in which the cache cluster is created.
         * </p>
         * 
         * @param preferredOutpostArn
         *        The outpost ARN in which the cache cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredOutpostArn(String preferredOutpostArn);

        /**
         * <p>
         * The date and time when the cluster was created.
         * </p>
         * 
         * @param cacheClusterCreateTime
         *        The date and time when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterCreateTime(Instant cacheClusterCreateTime);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * Sets the value of the PendingModifiedValues property for this object.
         *
         * @param pendingModifiedValues
         *        The new value for the PendingModifiedValues property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues);

        /**
         * Sets the value of the PendingModifiedValues property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PendingModifiedValues.Builder} avoiding
         * the need to create one manually via {@link PendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PendingModifiedValues.Builder#build()} is called immediately and
         * its result is passed to {@link #pendingModifiedValues(PendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link PendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(PendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(PendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events
         * to subscribers using Amazon Simple Notification Service (SNS).
         * </p>
         * 
         * @param notificationConfiguration
         *        Describes a notification topic and its status. Notification topics are used for publishing ElastiCache
         *        events to subscribers using Amazon Simple Notification Service (SNS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events
         * to subscribers using Amazon Simple Notification Service (SNS).
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }

        /**
         * <p>
         * A list of cache security group elements, composed of name and status sub-elements.
         * </p>
         * 
         * @param cacheSecurityGroups
         *        A list of cache security group elements, composed of name and status sub-elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups);

        /**
         * <p>
         * A list of cache security group elements, composed of name and status sub-elements.
         * </p>
         * 
         * @param cacheSecurityGroups
         *        A list of cache security group elements, composed of name and status sub-elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroups(CacheSecurityGroupMembership... cacheSecurityGroups);

        /**
         * <p>
         * A list of cache security group elements, composed of name and status sub-elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cacheSecurityGroups(List<CacheSecurityGroupMembership>)}.
         * 
         * @param cacheSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheSecurityGroups(java.util.Collection<CacheSecurityGroupMembership>)
         */
        Builder cacheSecurityGroups(Consumer<CacheSecurityGroupMembership.Builder>... cacheSecurityGroups);

        /**
         * <p>
         * Status of the cache parameter group.
         * </p>
         * 
         * @param cacheParameterGroup
         *        Status of the cache parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup);

        /**
         * <p>
         * Status of the cache parameter group.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheParameterGroupStatus.Builder}
         * avoiding the need to create one manually via {@link CacheParameterGroupStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheParameterGroupStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #cacheParameterGroup(CacheParameterGroupStatus)}.
         * 
         * @param cacheParameterGroup
         *        a consumer that will call methods on {@link CacheParameterGroupStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheParameterGroup(CacheParameterGroupStatus)
         */
        default Builder cacheParameterGroup(Consumer<CacheParameterGroupStatus.Builder> cacheParameterGroup) {
            return cacheParameterGroup(CacheParameterGroupStatus.builder().applyMutation(cacheParameterGroup).build());
        }

        /**
         * <p>
         * The name of the cache subnet group associated with the cluster.
         * </p>
         * 
         * @param cacheSubnetGroupName
         *        The name of the cache subnet group associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A list of cache nodes that are members of the cluster.
         * </p>
         * 
         * @param cacheNodes
         *        A list of cache nodes that are members of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodes(Collection<CacheNode> cacheNodes);

        /**
         * <p>
         * A list of cache nodes that are members of the cluster.
         * </p>
         * 
         * @param cacheNodes
         *        A list of cache nodes that are members of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodes(CacheNode... cacheNodes);

        /**
         * <p>
         * A list of cache nodes that are members of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.CacheNode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.CacheNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.CacheNode.Builder#build()} is called immediately and
         * its result is passed to {@link #cacheNodes(List<CacheNode>)}.
         * 
         * @param cacheNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.CacheNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheNodes(java.util.Collection<CacheNode>)
         */
        Builder cacheNodes(Consumer<CacheNode.Builder>... cacheNodes);

        /**
         * <p>
         *  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to
         * the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *         If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to
         *        opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous
         *        versions. 
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * A list of VPC Security Groups associated with the cluster.
         * </p>
         * 
         * @param securityGroups
         *        A list of VPC Security Groups associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroupMembership> securityGroups);

        /**
         * <p>
         * A list of VPC Security Groups associated with the cluster.
         * </p>
         * 
         * @param securityGroups
         *        A list of VPC Security Groups associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroupMembership... securityGroups);

        /**
         * <p>
         * A list of VPC Security Groups associated with the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership.Builder#build()} is called
         * immediately and its result is passed to {@link #securityGroups(List<SecurityGroupMembership>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.SecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(java.util.Collection<SecurityGroupMembership>)
         */
        Builder securityGroups(Consumer<SecurityGroupMembership.Builder>... securityGroups);

        /**
         * <p>
         * The replication group to which this cluster belongs. If this field is empty, the cluster is not associated
         * with any replication group.
         * </p>
         * 
         * @param replicationGroupId
         *        The replication group to which this cluster belongs. If this field is empty, the cluster is not
         *        associated with any replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for
         * 5 days before being deleted.
         * </p>
         * <important>
         * <p>
         * If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         * </p>
         * </important>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p> <important>
         *        <p>
         *        If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your
         *        cluster.</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param authTokenEnabled
         *        A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenEnabled(Boolean authTokenEnabled);

        /**
         * <p>
         * The date the auth token was last modified
         * </p>
         * 
         * @param authTokenLastModifiedDate
         *        The date the auth token was last modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to <code>true</code>.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at-rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
         * at-rest encryption on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when
         * you create a cluster.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at-rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
         *        enable at-rest encryption on a cluster you must set <code>AtRestEncryptionEnabled</code> to
         *        <code>true</code> when you create a cluster.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the cache cluster.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the cache cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A boolean value indicating whether log delivery is enabled for the replication group.
         * </p>
         * 
         * @param replicationGroupLogDeliveryEnabled
         *        A boolean value indicating whether log delivery is enabled for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Returns the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Returns the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfiguration... logDeliveryConfigurations);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logDeliveryConfigurations(List<LogDeliveryConfiguration>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<LogDeliveryConfiguration>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported
         * for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         * built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         *        supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
         *        all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(String ipDiscovery);

        /**
         * <p>
         * The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported
         * for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         * built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         *        supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
         *        all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(IpDiscovery ipDiscovery);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(String transitEncryptionMode);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode);
    }

    static final class BuilderImpl implements Builder {
        private String cacheClusterId;

        private Endpoint configurationEndpoint;

        private String clientDownloadLandingPage;

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheClusterStatus;

        private Integer numCacheNodes;

        private String preferredAvailabilityZone;

        private String preferredOutpostArn;

        private Instant cacheClusterCreateTime;

        private String preferredMaintenanceWindow;

        private PendingModifiedValues pendingModifiedValues;

        private NotificationConfiguration notificationConfiguration;

        private List<CacheSecurityGroupMembership> cacheSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private CacheParameterGroupStatus cacheParameterGroup;

        private String cacheSubnetGroupName;

        private List<CacheNode> cacheNodes = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoMinorVersionUpgrade;

        private List<SecurityGroupMembership> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String replicationGroupId;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private Boolean authTokenEnabled;

        private Instant authTokenLastModifiedDate;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String arn;

        private Boolean replicationGroupLogDeliveryEnabled;

        private List<LogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String networkType;

        private String ipDiscovery;

        private String transitEncryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheCluster model) {
            cacheClusterId(model.cacheClusterId);
            configurationEndpoint(model.configurationEndpoint);
            clientDownloadLandingPage(model.clientDownloadLandingPage);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheClusterStatus(model.cacheClusterStatus);
            numCacheNodes(model.numCacheNodes);
            preferredAvailabilityZone(model.preferredAvailabilityZone);
            preferredOutpostArn(model.preferredOutpostArn);
            cacheClusterCreateTime(model.cacheClusterCreateTime);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            notificationConfiguration(model.notificationConfiguration);
            cacheSecurityGroups(model.cacheSecurityGroups);
            cacheParameterGroup(model.cacheParameterGroup);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheNodes(model.cacheNodes);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            securityGroups(model.securityGroups);
            replicationGroupId(model.replicationGroupId);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            authTokenEnabled(model.authTokenEnabled);
            authTokenLastModifiedDate(model.authTokenLastModifiedDate);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            arn(model.arn);
            replicationGroupLogDeliveryEnabled(model.replicationGroupLogDeliveryEnabled);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            networkType(model.networkType);
            ipDiscovery(model.ipDiscovery);
            transitEncryptionMode(model.transitEncryptionMode);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return configurationEndpoint != null ? configurationEndpoint.toBuilder() : null;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final String getClientDownloadLandingPage() {
            return clientDownloadLandingPage;
        }

        public final void setClientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
        }

        @Override
        public final Builder clientDownloadLandingPage(String clientDownloadLandingPage) {
            this.clientDownloadLandingPage = clientDownloadLandingPage;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheClusterStatus() {
            return cacheClusterStatus;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final String getPreferredAvailabilityZone() {
            return preferredAvailabilityZone;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final String getPreferredOutpostArn() {
            return preferredOutpostArn;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final Instant getCacheClusterCreateTime() {
            return cacheClusterCreateTime;
        }

        public final void setCacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final List<CacheSecurityGroupMembership.Builder> getCacheSecurityGroups() {
            List<CacheSecurityGroupMembership.Builder> result = CacheSecurityGroupMembershipListCopier
                    .copyToBuilder(this.cacheSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership.BuilderImpl> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copyFromBuilder(cacheSecurityGroups);
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupMembershipListCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroupMembership... cacheSecurityGroups) {
            cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(Consumer<CacheSecurityGroupMembership.Builder>... cacheSecurityGroups) {
            cacheSecurityGroups(Stream.of(cacheSecurityGroups)
                    .map(c -> CacheSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CacheParameterGroupStatus.Builder getCacheParameterGroup() {
            return cacheParameterGroup != null ? cacheParameterGroup.toBuilder() : null;
        }

        public final void setCacheParameterGroup(CacheParameterGroupStatus.BuilderImpl cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup != null ? cacheParameterGroup.build() : null;
        }

        @Override
        public final Builder cacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
            this.cacheParameterGroup = cacheParameterGroup;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final List<CacheNode.Builder> getCacheNodes() {
            List<CacheNode.Builder> result = CacheNodeListCopier.copyToBuilder(this.cacheNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheNodes(Collection<CacheNode.BuilderImpl> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copyFromBuilder(cacheNodes);
        }

        @Override
        public final Builder cacheNodes(Collection<CacheNode> cacheNodes) {
            this.cacheNodes = CacheNodeListCopier.copy(cacheNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodes(CacheNode... cacheNodes) {
            cacheNodes(Arrays.asList(cacheNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodes(Consumer<CacheNode.Builder>... cacheNodes) {
            cacheNodes(Stream.of(cacheNodes).map(c -> CacheNode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final List<SecurityGroupMembership.Builder> getSecurityGroups() {
            List<SecurityGroupMembership.Builder> result = SecurityGroupMembershipListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroupMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Boolean getAuthTokenEnabled() {
            return authTokenEnabled;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final Instant getAuthTokenLastModifiedDate() {
            return authTokenLastModifiedDate;
        }

        public final void setAuthTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
        }

        @Override
        public final Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getReplicationGroupLogDeliveryEnabled() {
            return replicationGroupLogDeliveryEnabled;
        }

        public final void setReplicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
            this.replicationGroupLogDeliveryEnabled = replicationGroupLogDeliveryEnabled;
        }

        @Override
        public final Builder replicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
            this.replicationGroupLogDeliveryEnabled = replicationGroupLogDeliveryEnabled;
            return this;
        }

        public final List<LogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfiguration.Builder> result = LogDeliveryConfigurationListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<LogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfiguration... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public final String getTransitEncryptionMode() {
            return transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        @Override
        public CacheCluster build() {
            return new CacheCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
