/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a CreateCacheCluster operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheClusterRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateCacheClusterRequest.Builder, CreateCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(CreateCacheClusterRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(CreateCacheClusterRequest::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> AZ_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AZMode")
            .getter(getter(CreateCacheClusterRequest::azModeAsString)).setter(setter(Builder::azMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AZMode").build()).build();

    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredAvailabilityZone").getter(getter(CreateCacheClusterRequest::preferredAvailabilityZone))
            .setter(setter(Builder::preferredAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build())
            .build();

    private static final SdkField<List<String>> PREFERRED_AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PreferredAvailabilityZones")
            .getter(getter(CreateCacheClusterRequest::preferredAvailabilityZones))
            .setter(setter(Builder::preferredAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PreferredAvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PreferredAvailabilityZone").build()).build()).build()).build();

    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumCacheNodes").getter(getter(CreateCacheClusterRequest::numCacheNodes))
            .setter(setter(Builder::numCacheNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(CreateCacheClusterRequest::cacheNodeType))
            .setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateCacheClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateCacheClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheParameterGroupName").getter(getter(CreateCacheClusterRequest::cacheParameterGroupName))
            .setter(setter(Builder::cacheParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build())
            .build();

    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSubnetGroupName").getter(getter(CreateCacheClusterRequest::cacheSubnetGroupName))
            .setter(setter(Builder::cacheSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build())
            .build();

    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheSecurityGroupNames")
            .getter(getter(CreateCacheClusterRequest::cacheSecurityGroupNames))
            .setter(setter(Builder::cacheSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateCacheClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCacheClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotArns")
            .getter(getter(CreateCacheClusterRequest::snapshotArns))
            .setter(setter(Builder::snapshotArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotArn").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(CreateCacheClusterRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(CreateCacheClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateCacheClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTopicArn").getter(getter(CreateCacheClusterRequest::notificationTopicArn))
            .setter(setter(Builder::notificationTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateCacheClusterRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(CreateCacheClusterRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(CreateCacheClusterRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(CreateCacheClusterRequest::authToken)).setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<String> OUTPOST_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostMode").getter(getter(CreateCacheClusterRequest::outpostModeAsString))
            .setter(setter(Builder::outpostMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostMode").build()).build();

    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredOutpostArn").getter(getter(CreateCacheClusterRequest::preferredOutpostArn))
            .setter(setter(Builder::preferredOutpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build())
            .build();

    private static final SdkField<List<String>> PREFERRED_OUTPOST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PreferredOutpostArns")
            .getter(getter(CreateCacheClusterRequest::preferredOutpostArns))
            .setter(setter(Builder::preferredOutpostArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PreferredOutpostArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PreferredOutpostArn").build()).build()).build()).build();

    private static final SdkField<List<LogDeliveryConfigurationRequest>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(CreateCacheClusterRequest::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfigurationRequest")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfigurationRequest").build()).build()).build())
            .build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(CreateCacheClusterRequest::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(CreateCacheClusterRequest::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpDiscovery").getter(getter(CreateCacheClusterRequest::ipDiscoveryAsString))
            .setter(setter(Builder::ipDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            REPLICATION_GROUP_ID_FIELD, AZ_MODE_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_AVAILABILITY_ZONES_FIELD,
            NUM_CACHE_NODES_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD,
            CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD,
            SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PORT_FIELD,
            NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD, OUTPOST_MODE_FIELD, PREFERRED_OUTPOST_ARN_FIELD,
            PREFERRED_OUTPOST_ARNS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD,
            NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD));

    private final String cacheClusterId;

    private final String replicationGroupId;

    private final String azMode;

    private final String preferredAvailabilityZone;

    private final List<String> preferredAvailabilityZones;

    private final Integer numCacheNodes;

    private final String cacheNodeType;

    private final String engine;

    private final String engineVersion;

    private final String cacheParameterGroupName;

    private final String cacheSubnetGroupName;

    private final List<String> cacheSecurityGroupNames;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final List<String> snapshotArns;

    private final String snapshotName;

    private final String preferredMaintenanceWindow;

    private final Integer port;

    private final String notificationTopicArn;

    private final Boolean autoMinorVersionUpgrade;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final String authToken;

    private final String outpostMode;

    private final String preferredOutpostArn;

    private final List<String> preferredOutpostArns;

    private final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations;

    private final Boolean transitEncryptionEnabled;

    private final String networkType;

    private final String ipDiscovery;

    private CreateCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.replicationGroupId = builder.replicationGroupId;
        this.azMode = builder.azMode;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredAvailabilityZones = builder.preferredAvailabilityZones;
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.outpostMode = builder.outpostMode;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.preferredOutpostArns = builder.preferredOutpostArns;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
    }

    /**
     * <p>
     * The node group (shard) identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * <b>Constraints:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 50 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         <b>Constraints:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 50 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster
     * is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary
     * that is not part of any replication group.
     * </p>
     * <p>
     * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is
     * created in Availability Zones that provide the best spread of read replicas across Availability Zones.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The ID of the replication group to which this cluster should belong. If this parameter is specified, the
     *         cluster is added to the specified replication group as a read replica; otherwise, the cluster is a
     *         standalone primary that is not part of any replication group.</p>
     *         <p>
     *         If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
     *         cluster is created in Availability Zones that provide the best spread of read replicas across
     *         Availability Zones.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across
     * multiple Availability Zones in the cluster's region.
     * </p>
     * <p>
     * This parameter is only supported for Memcached clusters.
     * </p>
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
     * <code>single-az</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
     *         created across multiple Availability Zones in the cluster's region.</p>
     *         <p>
     *         This parameter is only supported for Memcached clusters.
     *         </p>
     *         <p>
     *         If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
     *         assumes <code>single-az</code> mode.
     * @see AZMode
     */
    public final AZMode azMode() {
        return AZMode.fromValue(azMode);
    }

    /**
     * <p>
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across
     * multiple Availability Zones in the cluster's region.
     * </p>
     * <p>
     * This parameter is only supported for Memcached clusters.
     * </p>
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
     * <code>single-az</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #azMode} will
     * return {@link AZMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #azModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
     *         created across multiple Availability Zones in the cluster's region.</p>
     *         <p>
     *         This parameter is only supported for Memcached clusters.
     *         </p>
     *         <p>
     *         If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
     *         assumes <code>single-az</code> mode.
     * @see AZMode
     */
    public final String azModeAsString() {
        return azMode;
    }

    /**
     * <p>
     * The EC2 Availability Zone in which the cluster is created.
     * </p>
     * <p>
     * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your
     * nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
     * </p>
     * <p>
     * Default: System chosen Availability Zone.
     * </p>
     * 
     * @return The EC2 Availability Zone in which the cluster is created.</p>
     *         <p>
     *         All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create
     *         your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
     *         </p>
     *         <p>
     *         Default: System chosen Availability Zone.
     */
    public final String preferredAvailabilityZone() {
        return preferredAvailabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreferredAvailabilityZones property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPreferredAvailabilityZones() {
        return preferredAvailabilityZones != null && !(preferredAvailabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
     * important.
     * </p>
     * <p>
     * This option is only supported on Memcached.
     * </p>
     * <note>
     * <p>
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones
     * that are associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
     * </p>
     * </note>
     * <p>
     * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or
     * repeat the Availability Zone multiple times in the list.
     * </p>
     * <p>
     * Default: System chosen Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreferredAvailabilityZones} method.
     * </p>
     * 
     * @return A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is
     *         not important.</p>
     *         <p>
     *         This option is only supported on Memcached.
     *         </p>
     *         <note>
     *         <p>
     *         If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
     *         Zones that are associated with the subnets in the selected subnet group.
     *         </p>
     *         <p>
     *         The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
     *         </p>
     *         </note>
     *         <p>
     *         If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
     *         instead, or repeat the Availability Zone multiple times in the list.
     *         </p>
     *         <p>
     *         Default: System chosen Availability Zones.
     */
    public final List<String> preferredAvailabilityZones() {
        return preferredAvailabilityZones;
    }

    /**
     * <p>
     * The initial number of cache nodes that the cluster has.
     * </p>
     * <p>
     * For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between
     * 1 and 40.
     * </p>
     * <p>
     * If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request
     * form at <a
     * href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us
     * /elasticache-node-limit-request/</a>.
     * </p>
     * 
     * @return The initial number of cache nodes that the cluster has.</p>
     *         <p>
     *         For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be
     *         between 1 and 40.
     *         </p>
     *         <p>
     *         If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase
     *         Request form at <a
     *         href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon
     *         .com/contact-us/elasticache-node-limit-request/</a>.
     */
    public final Integer numCacheNodes() {
        return numCacheNodes;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version
     * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * OSS version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The compute and memory capacity of the nodes in the node group (shard).</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *         <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *         <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *         <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *         <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine
     *         version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
     *         <code>cache.t4g.medium</code>
     *         </p>
     *         <p>
     *         <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *         <code>cache.t3.medium</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *         <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *         <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *         <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *         <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported
     *         on Redis OSS version 2.8.22 and later.
     *         </p>
     *         </li>
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * The name of the cache engine to be used for this cluster.
     * </p>
     * <p>
     * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     * </p>
     * 
     * @return The name of the cache engine to be used for this cluster.</p>
     *         <p>
     *         Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for this cluster. To view the supported cache engine versions,
     * use the DescribeCacheEngineVersions operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an
     * earlier engine version, you must delete the existing cluster or replication group and create it anew with the
     * earlier engine version.
     * </p>
     * 
     * @return The version number of the cache engine to be used for this cluster. To view the supported cache engine
     *         versions, use the DescribeCacheEngineVersions operation.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
     *         want to use an earlier engine version, you must delete the existing cluster or replication group and
     *         create it anew with the earlier engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this cluster. If this argument is omitted, the default
     * parameter group for the specified engine is used. You cannot use any parameter group which has
     * <code>cluster-enabled='yes'</code> when creating a cluster.
     * </p>
     * 
     * @return The name of the parameter group to associate with this cluster. If this argument is omitted, the default
     *         parameter group for the specified engine is used. You cannot use any parameter group which has
     *         <code>cluster-enabled='yes'</code> when creating a cluster.
     */
    public final String cacheParameterGroupName() {
        return cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the subnet group to be used for the cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @return The name of the subnet group to be used for the cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     *         </p>
     *         <important>
     *         <p>
     *         If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *         start creating a cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *         Groups</a>.
     *         </p>
     */
    public final String cacheSubnetGroupName() {
        return cacheSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheSecurityGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCacheSecurityGroupNames() {
        return cacheSecurityGroupNames != null && !(cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group names to associate with this cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheSecurityGroupNames} method.
     * </p>
     * 
     * @return A list of security group names to associate with this cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     */
    public final List<String> cacheSecurityGroupNames() {
        return cacheSecurityGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more VPC security groups associated with the cluster.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return One or more VPC security groups associated with the cluster.</p>
     *         <p>
     *         Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to this resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotArns() {
        return snapshotArns != null && !(snapshotArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis OSS RDB
     * snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3
     * object name in the ARN cannot contain any commas.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotArns} method.
     * </p>
     * 
     * @return A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
     *         OSS RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard).
     *         The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    public final List<String> snapshotArns() {
        return snapshotArns;
    }

    /**
     * <p>
     * The name of a Redis OSS snapshot from which to restore data into the new node group (shard). The snapshot status
     * changes to <code>restoring</code> while the new node group (shard) is being created.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The name of a Redis OSS snapshot from which to restore data into the new node group (shard). The snapshot
     *         status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The port number on which each of the cache nodes accepts connections.
     * </p>
     * 
     * @return The port number on which each of the cache nodes accepts connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be the same as the cluster owner.
     *         </p>
     */
    public final String notificationTopicArn() {
        return notificationTopicArn;
    }

    /**
     * <p>
     *  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to
     *         opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous
     *         versions. 
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic snapshots before deleting them. For example,
     *         if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before
     *         being deleted.</p> <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @return <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *         <p>
     *         Password constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *         special characters cannot be used in the AUTH token.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *         http://redis.io/commands/AUTH.
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outpostMode} will
     * return {@link OutpostMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outpostModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
     * @see OutpostMode
     */
    public final OutpostMode outpostMode() {
        return OutpostMode.fromValue(outpostMode);
    }

    /**
     * <p>
     * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outpostMode} will
     * return {@link OutpostMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outpostModeAsString}.
     * </p>
     * 
     * @return Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
     * @see OutpostMode
     */
    public final String outpostModeAsString() {
        return outpostMode;
    }

    /**
     * <p>
     * The outpost ARN in which the cache cluster is created.
     * </p>
     * 
     * @return The outpost ARN in which the cache cluster is created.
     */
    public final String preferredOutpostArn() {
        return preferredOutpostArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PreferredOutpostArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPreferredOutpostArns() {
        return preferredOutpostArns != null && !(preferredOutpostArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outpost ARNs in which the cache cluster is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPreferredOutpostArns} method.
     * </p>
     * 
     * @return The outpost ARNs in which the cache cluster is created.
     */
    public final List<String> preferredOutpostArns() {
        return preferredOutpostArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Specifies the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to true.
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to true.
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     *         is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(ipDiscovery);
    }

    /**
     * <p>
     * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     *         is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final String ipDiscoveryAsString() {
        return ipDiscovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasPreferredAvailabilityZones() ? preferredAvailabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotArns() ? snapshotArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(outpostModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPreferredOutpostArns() ? preferredOutpostArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDiscoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheClusterRequest)) {
            return false;
        }
        CreateCacheClusterRequest other = (CreateCacheClusterRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(azModeAsString(), other.azModeAsString())
                && Objects.equals(preferredAvailabilityZone(), other.preferredAvailabilityZone())
                && hasPreferredAvailabilityZones() == other.hasPreferredAvailabilityZones()
                && Objects.equals(preferredAvailabilityZones(), other.preferredAvailabilityZones())
                && Objects.equals(numCacheNodes(), other.numCacheNodes())
                && Objects.equals(cacheNodeType(), other.cacheNodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(cacheParameterGroupName(), other.cacheParameterGroupName())
                && Objects.equals(cacheSubnetGroupName(), other.cacheSubnetGroupName())
                && hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames()
                && Objects.equals(cacheSecurityGroupNames(), other.cacheSecurityGroupNames())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasSnapshotArns() == other.hasSnapshotArns()
                && Objects.equals(snapshotArns(), other.snapshotArns()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(port(), other.port()) && Objects.equals(notificationTopicArn(), other.notificationTopicArn())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(outpostModeAsString(), other.outpostModeAsString())
                && Objects.equals(preferredOutpostArn(), other.preferredOutpostArn())
                && hasPreferredOutpostArns() == other.hasPreferredOutpostArns()
                && Objects.equals(preferredOutpostArns(), other.preferredOutpostArns())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(ipDiscoveryAsString(), other.ipDiscoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCacheClusterRequest").add("CacheClusterId", cacheClusterId())
                .add("ReplicationGroupId", replicationGroupId()).add("AZMode", azModeAsString())
                .add("PreferredAvailabilityZone", preferredAvailabilityZone())
                .add("PreferredAvailabilityZones", hasPreferredAvailabilityZones() ? preferredAvailabilityZones() : null)
                .add("NumCacheNodes", numCacheNodes()).add("CacheNodeType", cacheNodeType()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("CacheParameterGroupName", cacheParameterGroupName())
                .add("CacheSubnetGroupName", cacheSubnetGroupName())
                .add("CacheSecurityGroupNames", hasCacheSecurityGroupNames() ? cacheSecurityGroupNames() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("SnapshotArns", hasSnapshotArns() ? snapshotArns() : null)
                .add("SnapshotName", snapshotName()).add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("Port", port()).add("NotificationTopicArn", notificationTopicArn())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("AuthToken", authToken()).add("OutpostMode", outpostModeAsString())
                .add("PreferredOutpostArn", preferredOutpostArn())
                .add("PreferredOutpostArns", hasPreferredOutpostArns() ? preferredOutpostArns() : null)
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("TransitEncryptionEnabled", transitEncryptionEnabled()).add("NetworkType", networkTypeAsString())
                .add("IpDiscovery", ipDiscoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "AZMode":
            return Optional.ofNullable(clazz.cast(azModeAsString()));
        case "PreferredAvailabilityZone":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZone()));
        case "PreferredAvailabilityZones":
            return Optional.ofNullable(clazz.cast(preferredAvailabilityZones()));
        case "NumCacheNodes":
            return Optional.ofNullable(clazz.cast(numCacheNodes()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "CacheParameterGroupName":
            return Optional.ofNullable(clazz.cast(cacheParameterGroupName()));
        case "CacheSubnetGroupName":
            return Optional.ofNullable(clazz.cast(cacheSubnetGroupName()));
        case "CacheSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupNames()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SnapshotArns":
            return Optional.ofNullable(clazz.cast(snapshotArns()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "NotificationTopicArn":
            return Optional.ofNullable(clazz.cast(notificationTopicArn()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "OutpostMode":
            return Optional.ofNullable(clazz.cast(outpostModeAsString()));
        case "PreferredOutpostArn":
            return Optional.ofNullable(clazz.cast(preferredOutpostArn()));
        case "PreferredOutpostArns":
            return Optional.ofNullable(clazz.cast(preferredOutpostArns()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "IpDiscovery":
            return Optional.ofNullable(clazz.cast(ipDiscoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheClusterRequest, T> g) {
        return obj -> g.apply((CreateCacheClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCacheClusterRequest> {
        /**
         * <p>
         * The node group (shard) identifier. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * <b>Constraints:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * A name must contain from 1 to 50 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * A name cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheClusterId
         *        The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
         *        <p>
         *        <b>Constraints:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A name must contain from 1 to 50 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A name cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The ID of the replication group to which this cluster should belong. If this parameter is specified, the
         * cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone
         * primary that is not part of any replication group.
         * </p>
         * <p>
         * If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
         * cluster is created in Availability Zones that provide the best spread of read replicas across Availability
         * Zones.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param replicationGroupId
         *        The ID of the replication group to which this cluster should belong. If this parameter is specified,
         *        the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a
         *        standalone primary that is not part of any replication group.</p>
         *        <p>
         *        If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the
         *        cluster is created in Availability Zones that provide the best spread of read replicas across
         *        Availability Zones.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created
         * across multiple Availability Zones in the cluster's region.
         * </p>
         * <p>
         * This parameter is only supported for Memcached clusters.
         * </p>
         * <p>
         * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
         * <code>single-az</code> mode.
         * </p>
         * 
         * @param azMode
         *        Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
         *        created across multiple Availability Zones in the cluster's region.</p>
         *        <p>
         *        This parameter is only supported for Memcached clusters.
         *        </p>
         *        <p>
         *        If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
         *        assumes <code>single-az</code> mode.
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(String azMode);

        /**
         * <p>
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created
         * across multiple Availability Zones in the cluster's region.
         * </p>
         * <p>
         * This parameter is only supported for Memcached clusters.
         * </p>
         * <p>
         * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes
         * <code>single-az</code> mode.
         * </p>
         * 
         * @param azMode
         *        Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or
         *        created across multiple Availability Zones in the cluster's region.</p>
         *        <p>
         *        This parameter is only supported for Memcached clusters.
         *        </p>
         *        <p>
         *        If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache
         *        assumes <code>single-az</code> mode.
         * @see AZMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZMode
         */
        Builder azMode(AZMode azMode);

        /**
         * <p>
         * The EC2 Availability Zone in which the cluster is created.
         * </p>
         * <p>
         * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your
         * nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
         * </p>
         * <p>
         * Default: System chosen Availability Zone.
         * </p>
         * 
         * @param preferredAvailabilityZone
         *        The EC2 Availability Zone in which the cluster is created.</p>
         *        <p>
         *        All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to
         *        create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZone(String preferredAvailabilityZone);

        /**
         * <p>
         * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
         * important.
         * </p>
         * <p>
         * This option is only supported on Memcached.
         * </p>
         * <note>
         * <p>
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
         * Zones that are associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         * </p>
         * </note>
         * <p>
         * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead,
         * or repeat the Availability Zone multiple times in the list.
         * </p>
         * <p>
         * Default: System chosen Availability Zones.
         * </p>
         * 
         * @param preferredAvailabilityZones
         *        A list of the Availability Zones in which cache nodes are created. The order of the zones in the list
         *        is not important.</p>
         *        <p>
         *        This option is only supported on Memcached.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in
         *        Availability Zones that are associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
         *        instead, or repeat the Availability Zone multiple times in the list.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones);

        /**
         * <p>
         * A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not
         * important.
         * </p>
         * <p>
         * This option is only supported on Memcached.
         * </p>
         * <note>
         * <p>
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability
         * Zones that are associated with the subnets in the selected subnet group.
         * </p>
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         * </p>
         * </note>
         * <p>
         * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead,
         * or repeat the Availability Zone multiple times in the list.
         * </p>
         * <p>
         * Default: System chosen Availability Zones.
         * </p>
         * 
         * @param preferredAvailabilityZones
         *        A list of the Availability Zones in which cache nodes are created. The order of the zones in the list
         *        is not important.</p>
         *        <p>
         *        This option is only supported on Memcached.
         *        </p>
         *        <note>
         *        <p>
         *        If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in
         *        Availability Zones that are associated with the subnets in the selected subnet group.
         *        </p>
         *        <p>
         *        The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code>
         *        instead, or repeat the Availability Zone multiple times in the list.
         *        </p>
         *        <p>
         *        Default: System chosen Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredAvailabilityZones(String... preferredAvailabilityZones);

        /**
         * <p>
         * The initial number of cache nodes that the cluster has.
         * </p>
         * <p>
         * For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be
         * between 1 and 40.
         * </p>
         * <p>
         * If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase
         * Request form at <a
         * href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com
         * /contact-us/elasticache-node-limit-request/</a>.
         * </p>
         * 
         * @param numCacheNodes
         *        The initial number of cache nodes that the cluster has.</p>
         *        <p>
         *        For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must
         *        be between 1 and 40.
         *        </p>
         *        <p>
         *        If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit
         *        Increase Request form at <a
         *        href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http
         *        ://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numCacheNodes(Integer numCacheNodes);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the node group (shard).
         * </p>
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types
         * provide more memory and computational power at lower cost when compared to their equivalent previous
         * generation counterparts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * General purpose:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
         * version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         * <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         * <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         * </p>
         * <p>
         * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         * <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         * <code>cache.m5.24xlarge</code>
         * </p>
         * <p>
         * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         * <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         * </p>
         * <p>
         * <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version
         * 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
         * </p>
         * <p>
         * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
         * </p>
         * <p>
         * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>T1 node types:</b> <code>cache.t1.micro</code>
         * </p>
         * <p>
         * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
         * <code>cache.m1.xlarge</code>
         * </p>
         * <p>
         * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Compute optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * Memory optimized:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Current generation:
         * </p>
         * <p>
         * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         * </p>
         * <note>
         * <p>
         * For region availability, see <a href=
         * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         * >Supported Node Types</a>
         * </p>
         * </note>
         * <p>
         * <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine
         * version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
         * <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
         * <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
         * </p>
         * <p>
         * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         * <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         * <code>cache.r5.24xlarge</code>
         * </p>
         * <p>
         * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         * <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         * <code>cache.r4.16xlarge</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is
         * not supported for these types.)
         * </p>
         * <p>
         * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         * <code>cache.m2.4xlarge</code>
         * </p>
         * <p>
         * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         * <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * <b>Additional node type info</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * All current generation instance types are created in Amazon VPC by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
         * Redis OSS version 2.8.22 and later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cacheNodeType
         *        The compute and memory capacity of the nodes in the node group (shard).</p>
         *        <p>
         *        The following node types are supported by ElastiCache. Generally speaking, the current generation
         *        types provide more memory and computational power at lower cost when compared to their equivalent
         *        previous generation counterparts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        General purpose:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
         *        <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
         *        <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached
         *        engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
         *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
         *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
         *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
         *        <code>cache.m5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
         *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
         *        </p>
         *        <p>
         *        <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine
         *        version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>,
         *        <code>cache.t4g.medium</code>
         *        </p>
         *        <p>
         *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
         *        <code>cache.t3.medium</code>
         *        </p>
         *        <p>
         *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
         *        <code>cache.t2.medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>T1 node types:</b> <code>cache.t1.micro</code>
         *        </p>
         *        <p>
         *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
         *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
         *        </p>
         *        <p>
         *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
         *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Compute optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        Memory optimized:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Current generation:
         *        </p>
         *        <p>
         *        <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
         *        <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
         *        <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
         *        </p>
         *        <note>
         *        <p>
         *        For region availability, see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
         *        >Supported Node Types</a>
         *        </p>
         *        </note>
         *        <p>
         *        <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached
         *        engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
         *        <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
         *        <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
         *        </p>
         *        <p>
         *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
         *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
         *        <code>cache.r5.24xlarge</code>
         *        </p>
         *        <p>
         *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
         *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
         *        <code>cache.r4.16xlarge</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Previous generation: (not recommended. Existing clusters are still supported but creation of new
         *        clusters is not supported for these types.)
         *        </p>
         *        <p>
         *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
         *        <code>cache.m2.4xlarge</code>
         *        </p>
         *        <p>
         *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
         *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Additional node type info</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All current generation instance types are created in Amazon VPC by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not
         *        supported on Redis OSS version 2.8.22 and later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * The name of the cache engine to be used for this cluster.
         * </p>
         * <p>
         * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
         * </p>
         * 
         * @param engine
         *        The name of the cache engine to be used for this cluster.</p>
         *        <p>
         *        Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the cache engine to be used for this cluster. To view the supported cache engine
         * versions, use the DescribeCacheEngineVersions operation.
         * </p>
         * <p>
         * <b>Important:</b> You can upgrade to a newer engine version (see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         * >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you
         * want to use an earlier engine version, you must delete the existing cluster or replication group and create
         * it anew with the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the cache engine to be used for this cluster. To view the supported cache engine
         *        versions, use the DescribeCacheEngineVersions operation.</p>
         *        <p>
         *        <b>Important:</b> You can upgrade to a newer engine version (see <a href=
         *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
         *        >Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If
         *        you want to use an earlier engine version, you must delete the existing cluster or replication group
         *        and create it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the parameter group to associate with this cluster. If this argument is omitted, the default
         * parameter group for the specified engine is used. You cannot use any parameter group which has
         * <code>cluster-enabled='yes'</code> when creating a cluster.
         * </p>
         * 
         * @param cacheParameterGroupName
         *        The name of the parameter group to associate with this cluster. If this argument is omitted, the
         *        default parameter group for the specified engine is used. You cannot use any parameter group which has
         *        <code>cluster-enabled='yes'</code> when creating a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheParameterGroupName(String cacheParameterGroupName);

        /**
         * <p>
         * The name of the subnet group to be used for the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * <important>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
         * creating a cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
         * Groups</a>.
         * </p>
         * </important>
         * 
         * @param cacheSubnetGroupName
         *        The name of the subnet group to be used for the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         *        </p>
         *        <important>
         *        <p>
         *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
         *        start creating a cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and
         *        Subnet Groups</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSubnetGroupName(String cacheSubnetGroupName);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of security group names to associate with this cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon
         * VPC).
         * </p>
         * 
         * @param cacheSecurityGroupNames
         *        A list of security group names to associate with this cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud
         *        (Amazon VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames);

        /**
         * <p>
         * One or more VPC security groups associated with the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more VPC security groups associated with the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more VPC security groups associated with the cluster.
         * </p>
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * </p>
         * 
         * @param securityGroupIds
         *        One or more VPC security groups associated with the cluster.</p>
         *        <p>
         *        Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon
         *        VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A list of tags to be added to this resource.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis OSS
         * RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The
         * Amazon S3 object name in the ARN cannot contain any commas.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
         *        OSS RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group
         *        (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(Collection<String> snapshotArns);

        /**
         * <p>
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis OSS
         * RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The
         * Amazon S3 object name in the ARN cannot contain any commas.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * </p>
         * 
         * @param snapshotArns
         *        A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis
         *        OSS RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group
         *        (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(String... snapshotArns);

        /**
         * <p>
         * The name of a Redis OSS snapshot from which to restore data into the new node group (shard). The snapshot
         * status changes to <code>restoring</code> while the new node group (shard) is being created.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotName
         *        The name of a Redis OSS snapshot from which to restore data into the new node group (shard). The
         *        snapshot status changes to <code>restoring</code> while the new node group (shard) is being
         *        created.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The port number on which each of the cache nodes accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which each of the cache nodes accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications
         * are sent.
         * </p>
         * <note>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * </p>
         * </note>
         * 
         * @param notificationTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
         *        notifications are sent.</p> <note>
         *        <p>
         *        The Amazon SNS topic owner must be the same as the cluster owner.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTopicArn(String notificationTopicArn);

        /**
         * <p>
         *  If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to
         * the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *         If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to
         *        opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous
         *        versions. 
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
         * you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being
         * deleted.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5
         *        days before being deleted.</p> <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * <b>Reserved parameter.</b> The password used to access a password protected server.
         * </p>
         * <p>
         * Password constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be only printable ASCII characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 16 characters and no more than 128 characters in length.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
         * special characters cannot be used in the AUTH token.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         * http://redis.io/commands/AUTH.
         * </p>
         * 
         * @param authToken
         *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
         *        <p>
         *        Password constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be only printable ASCII characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 16 characters and no more than 128 characters in length.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other
         *        printable special characters cannot be used in the AUTH token.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
         *        http://redis.io/commands/AUTH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
         * </p>
         * 
         * @param outpostMode
         *        Specifies whether the nodes in the cluster are created in a single outpost or across multiple
         *        outposts.
         * @see OutpostMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutpostMode
         */
        Builder outpostMode(String outpostMode);

        /**
         * <p>
         * Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.
         * </p>
         * 
         * @param outpostMode
         *        Specifies whether the nodes in the cluster are created in a single outpost or across multiple
         *        outposts.
         * @see OutpostMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutpostMode
         */
        Builder outpostMode(OutpostMode outpostMode);

        /**
         * <p>
         * The outpost ARN in which the cache cluster is created.
         * </p>
         * 
         * @param preferredOutpostArn
         *        The outpost ARN in which the cache cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredOutpostArn(String preferredOutpostArn);

        /**
         * <p>
         * The outpost ARNs in which the cache cluster is created.
         * </p>
         * 
         * @param preferredOutpostArns
         *        The outpost ARNs in which the cache cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredOutpostArns(Collection<String> preferredOutpostArns);

        /**
         * <p>
         * The outpost ARNs in which the cache cluster is created.
         * </p>
         * 
         * @param preferredOutpostArns
         *        The outpost ARNs in which the cache cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredOutpostArns(String... preferredOutpostArns);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Specifies the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations);

        /**
         * <p>
         * Specifies the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<LogDeliveryConfigurationRequest>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<LogDeliveryConfigurationRequest>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to true.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
         * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>.
         *        IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version
         *        1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(String ipDiscovery);

        /**
         * <p>
         * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
         * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>.
         *        IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version
         *        1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(IpDiscovery ipDiscovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private String replicationGroupId;

        private String azMode;

        private String preferredAvailabilityZone;

        private List<String> preferredAvailabilityZones = DefaultSdkAutoConstructList.getInstance();

        private Integer numCacheNodes;

        private String cacheNodeType;

        private String engine;

        private String engineVersion;

        private String cacheParameterGroupName;

        private String cacheSubnetGroupName;

        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();

        private String snapshotName;

        private String preferredMaintenanceWindow;

        private Integer port;

        private String notificationTopicArn;

        private Boolean autoMinorVersionUpgrade;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private String authToken;

        private String outpostMode;

        private String preferredOutpostArn;

        private List<String> preferredOutpostArns = DefaultSdkAutoConstructList.getInstance();

        private List<LogDeliveryConfigurationRequest> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean transitEncryptionEnabled;

        private String networkType;

        private String ipDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheClusterRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            replicationGroupId(model.replicationGroupId);
            azMode(model.azMode);
            preferredAvailabilityZone(model.preferredAvailabilityZone);
            preferredAvailabilityZones(model.preferredAvailabilityZones);
            numCacheNodes(model.numCacheNodes);
            cacheNodeType(model.cacheNodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            cacheParameterGroupName(model.cacheParameterGroupName);
            cacheSubnetGroupName(model.cacheSubnetGroupName);
            cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            snapshotArns(model.snapshotArns);
            snapshotName(model.snapshotName);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            port(model.port);
            notificationTopicArn(model.notificationTopicArn);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            authToken(model.authToken);
            outpostMode(model.outpostMode);
            preferredOutpostArn(model.preferredOutpostArn);
            preferredOutpostArns(model.preferredOutpostArns);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            networkType(model.networkType);
            ipDiscovery(model.ipDiscovery);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getAzMode() {
            return azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(AZMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getPreferredAvailabilityZone() {
            return preferredAvailabilityZone;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final Collection<String> getPreferredAvailabilityZones() {
            if (preferredAvailabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return preferredAvailabilityZones;
        }

        public final void setPreferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
        }

        @Override
        public final Builder preferredAvailabilityZones(Collection<String> preferredAvailabilityZones) {
            this.preferredAvailabilityZones = PreferredAvailabilityZoneListCopier.copy(preferredAvailabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredAvailabilityZones(String... preferredAvailabilityZones) {
            preferredAvailabilityZones(Arrays.asList(preferredAvailabilityZones));
            return this;
        }

        public final Integer getNumCacheNodes() {
            return numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheSecurityGroupNames;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String... cacheSecurityGroupNames) {
            cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSnapshotArns() {
            if (snapshotArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotArns;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String... snapshotArns) {
            snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNotificationTopicArn() {
            return notificationTopicArn;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final String getOutpostMode() {
            return outpostMode;
        }

        public final void setOutpostMode(String outpostMode) {
            this.outpostMode = outpostMode;
        }

        @Override
        public final Builder outpostMode(String outpostMode) {
            this.outpostMode = outpostMode;
            return this;
        }

        @Override
        public final Builder outpostMode(OutpostMode outpostMode) {
            this.outpostMode(outpostMode == null ? null : outpostMode.toString());
            return this;
        }

        public final String getPreferredOutpostArn() {
            return preferredOutpostArn;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final Collection<String> getPreferredOutpostArns() {
            if (preferredOutpostArns instanceof SdkAutoConstructList) {
                return null;
            }
            return preferredOutpostArns;
        }

        public final void setPreferredOutpostArns(Collection<String> preferredOutpostArns) {
            this.preferredOutpostArns = PreferredOutpostArnListCopier.copy(preferredOutpostArns);
        }

        @Override
        public final Builder preferredOutpostArns(Collection<String> preferredOutpostArns) {
            this.preferredOutpostArns = PreferredOutpostArnListCopier.copy(preferredOutpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredOutpostArns(String... preferredOutpostArns) {
            preferredOutpostArns(Arrays.asList(preferredOutpostArns));
            return this;
        }

        public final List<LogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfigurationRequest.Builder> result = LogDeliveryConfigurationRequestListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<LogDeliveryConfigurationRequest.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<LogDeliveryConfigurationRequest.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheClusterRequest build() {
            return new CreateCacheClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
