/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerlessCacheRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateServerlessCacheRequest.Builder, CreateServerlessCacheRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(CreateServerlessCacheRequest::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateServerlessCacheRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateServerlessCacheRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(CreateServerlessCacheRequest::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField
            .<CacheUsageLimits> builder(MarshallingType.SDK_POJO).memberName("CacheUsageLimits")
            .getter(getter(CreateServerlessCacheRequest::cacheUsageLimits)).setter(setter(Builder::cacheUsageLimits))
            .constructor(CacheUsageLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateServerlessCacheRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateServerlessCacheRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_TO_RESTORE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotArnsToRestore")
            .getter(getter(CreateServerlessCacheRequest::snapshotArnsToRestore))
            .setter(setter(Builder::snapshotArnsToRestore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArnsToRestore").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotArn").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateServerlessCacheRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(CreateServerlessCacheRequest::userGroupId))
            .setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateServerlessCacheRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetId").build()).build()).build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(CreateServerlessCacheRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DailySnapshotTime").getter(getter(CreateServerlessCacheRequest::dailySnapshotTime))
            .setter(setter(Builder::dailySnapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            DESCRIPTION_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD, CACHE_USAGE_LIMITS_FIELD, KMS_KEY_ID_FIELD,
            SECURITY_GROUP_IDS_FIELD, SNAPSHOT_ARNS_TO_RESTORE_FIELD, TAGS_FIELD, USER_GROUP_ID_FIELD, SUBNET_IDS_FIELD,
            SNAPSHOT_RETENTION_LIMIT_FIELD, DAILY_SNAPSHOT_TIME_FIELD));

    private final String serverlessCacheName;

    private final String description;

    private final String engine;

    private final String majorEngineVersion;

    private final CacheUsageLimits cacheUsageLimits;

    private final String kmsKeyId;

    private final List<String> securityGroupIds;

    private final List<String> snapshotArnsToRestore;

    private final List<Tag> tags;

    private final String userGroupId;

    private final List<String> subnetIds;

    private final Integer snapshotRetentionLimit;

    private final String dailySnapshotTime;

    private CreateServerlessCacheRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.kmsKeyId = builder.kmsKeyId;
        this.securityGroupIds = builder.securityGroupIds;
        this.snapshotArnsToRestore = builder.snapshotArnsToRestore;
        this.tags = builder.tags;
        this.userGroupId = builder.userGroupId;
        this.subnetIds = builder.subnetIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
    }

    /**
     * <p>
     * User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * User-provided description for the serverless cache. The default is NULL, i.e. if no description is provided then
     * an empty string will be returned. The maximum length is 255 characters.
     * </p>
     * 
     * @return User-provided description for the serverless cache. The default is NULL, i.e. if no description is
     *         provided then an empty string will be returned. The maximum length is 255 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the cache engine to be used for creating the serverless cache.
     * </p>
     * 
     * @return The name of the cache engine to be used for creating the serverless cache.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the cache engine that will be used to create the serverless cache.
     * </p>
     * 
     * @return The version of the cache engine that will be used to create the serverless cache.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * <p>
     * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
     * </p>
     * 
     * @return Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
     */
    public final CacheUsageLimits cacheUsageLimits() {
        return cacheUsageLimits;
    }

    /**
     * <p>
     * ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key
     * is used.
     * </p>
     * 
     * @return ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default
     *         service key is used.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the one or more VPC security groups to be associated with the serverless cache. The security group will
     * authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the
     * VPC’s Default Security Group that is associated with the cluster VPC end-point.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of the one or more VPC security groups to be associated with the serverless cache. The security
     *         group will authorize traffic access for the VPC end-point (private-link). If no other information is
     *         given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotArnsToRestore property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSnapshotArnsToRestore() {
        return snapshotArnsToRestore != null && !(snapshotArnsToRestore instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS and
     * Serverless Memcached only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotArnsToRestore} method.
     * </p>
     * 
     * @return The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS
     *         and Serverless Memcached only.
     */
    public final List<String> snapshotArnsToRestore() {
        return snapshotArnsToRestore;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS only. Default
     * is NULL.
     * </p>
     * 
     * @return The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS only.
     *         Default is NULL.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All
     * the subnetIds must belong to the same VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be
     *         deployed. All the subnetIds must belong to the same VPC.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots
     * beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis OSS and
     * Serverless Memcached only.
     * </p>
     * 
     * @return The number of snapshots that will be retained for the serverless cache that is being created. As new
     *         snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available
     *         for Redis OSS and Serverless Memcached only.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time that snapshots will be created from the new serverless cache. By default this number is populated
     * with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Redis OSS and Serverless
     * Memcached only.
     * </p>
     * 
     * @return The daily time that snapshots will be created from the new serverless cache. By default this number is
     *         populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Redis OSS
     *         and Serverless Memcached only.
     */
    public final String dailySnapshotTime() {
        return dailySnapshotTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotArnsToRestore() ? snapshotArnsToRestore() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(dailySnapshotTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerlessCacheRequest)) {
            return false;
        }
        CreateServerlessCacheRequest other = (CreateServerlessCacheRequest) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(description(), other.description()) && Objects.equals(engine(), other.engine())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && Objects.equals(cacheUsageLimits(), other.cacheUsageLimits()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && hasSnapshotArnsToRestore() == other.hasSnapshotArnsToRestore()
                && Objects.equals(snapshotArnsToRestore(), other.snapshotArnsToRestore()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(userGroupId(), other.userGroupId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(dailySnapshotTime(), other.dailySnapshotTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServerlessCacheRequest").add("ServerlessCacheName", serverlessCacheName())
                .add("Description", description()).add("Engine", engine()).add("MajorEngineVersion", majorEngineVersion())
                .add("CacheUsageLimits", cacheUsageLimits()).add("KmsKeyId", kmsKeyId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SnapshotArnsToRestore", hasSnapshotArnsToRestore() ? snapshotArnsToRestore() : null)
                .add("Tags", hasTags() ? tags() : null).add("UserGroupId", userGroupId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("SnapshotRetentionLimit", snapshotRetentionLimit())
                .add("DailySnapshotTime", dailySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "CacheUsageLimits":
            return Optional.ofNullable(clazz.cast(cacheUsageLimits()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SnapshotArnsToRestore":
            return Optional.ofNullable(clazz.cast(snapshotArnsToRestore()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "DailySnapshotTime":
            return Optional.ofNullable(clazz.cast(dailySnapshotTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerlessCacheRequest, T> g) {
        return obj -> g.apply((CreateServerlessCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServerlessCacheRequest> {
        /**
         * <p>
         * User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param serverlessCacheName
         *        User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * User-provided description for the serverless cache. The default is NULL, i.e. if no description is provided
         * then an empty string will be returned. The maximum length is 255 characters.
         * </p>
         * 
         * @param description
         *        User-provided description for the serverless cache. The default is NULL, i.e. if no description is
         *        provided then an empty string will be returned. The maximum length is 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the cache engine to be used for creating the serverless cache.
         * </p>
         * 
         * @param engine
         *        The name of the cache engine to be used for creating the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the cache engine that will be used to create the serverless cache.
         * </p>
         * 
         * @param majorEngineVersion
         *        The version of the cache engine that will be used to create the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
         * </p>
         * 
         * @param cacheUsageLimits
         *        Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits);

        /**
         * <p>
         * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheUsageLimits.Builder} avoiding the
         * need to create one manually via {@link CacheUsageLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheUsageLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheUsageLimits(CacheUsageLimits)}.
         * 
         * @param cacheUsageLimits
         *        a consumer that will call methods on {@link CacheUsageLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheUsageLimits(CacheUsageLimits)
         */
        default Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return cacheUsageLimits(CacheUsageLimits.builder().applyMutation(cacheUsageLimits).build());
        }

        /**
         * <p>
         * ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service
         * key is used.
         * </p>
         * 
         * @param kmsKeyId
         *        ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default
         *        service key is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A list of the one or more VPC security groups to be associated with the serverless cache. The security group
         * will authorize traffic access for the VPC end-point (private-link). If no other information is given this
         * will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of the one or more VPC security groups to be associated with the serverless cache. The security
         *        group will authorize traffic access for the VPC end-point (private-link). If no other information is
         *        given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of the one or more VPC security groups to be associated with the serverless cache. The security group
         * will authorize traffic access for the VPC end-point (private-link). If no other information is given this
         * will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of the one or more VPC security groups to be associated with the serverless cache. The security
         *        group will authorize traffic access for the VPC end-point (private-link). If no other information is
         *        given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS and
         * Serverless Memcached only.
         * </p>
         * 
         * @param snapshotArnsToRestore
         *        The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS
         *        and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArnsToRestore(Collection<String> snapshotArnsToRestore);

        /**
         * <p>
         * The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS and
         * Serverless Memcached only.
         * </p>
         * 
         * @param snapshotArnsToRestore
         *        The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS
         *        and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArnsToRestore(String... snapshotArnsToRestore);

        /**
         * <p>
         * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         * </p>
         * 
         * @param tags
         *        The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         * </p>
         * 
         * @param tags
         *        The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS only.
         * Default is NULL.
         * </p>
         * 
         * @param userGroupId
         *        The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS
         *        only. Default is NULL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed.
         * All the subnetIds must belong to the same VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be
         *        deployed. All the subnetIds must belong to the same VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed.
         * All the subnetIds must belong to the same VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be
         *        deployed. All the subnetIds must belong to the same VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The number of snapshots that will be retained for the serverless cache that is being created. As new
         * snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for
         * Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of snapshots that will be retained for the serverless cache that is being created. As new
         *        snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis.
         *        Available for Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time that snapshots will be created from the new serverless cache. By default this number is
         * populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Redis OSS and
         * Serverless Memcached only.
         * </p>
         * 
         * @param dailySnapshotTime
         *        The daily time that snapshots will be created from the new serverless cache. By default this number is
         *        populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Redis
         *        OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySnapshotTime(String dailySnapshotTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheName;

        private String description;

        private String engine;

        private String majorEngineVersion;

        private CacheUsageLimits cacheUsageLimits;

        private String kmsKeyId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotArnsToRestore = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String userGroupId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Integer snapshotRetentionLimit;

        private String dailySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerlessCacheRequest model) {
            super(model);
            serverlessCacheName(model.serverlessCacheName);
            description(model.description);
            engine(model.engine);
            majorEngineVersion(model.majorEngineVersion);
            cacheUsageLimits(model.cacheUsageLimits);
            kmsKeyId(model.kmsKeyId);
            securityGroupIds(model.securityGroupIds);
            snapshotArnsToRestore(model.snapshotArnsToRestore);
            tags(model.tags);
            userGroupId(model.userGroupId);
            subnetIds(model.subnetIds);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            dailySnapshotTime(model.dailySnapshotTime);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return cacheUsageLimits != null ? cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSnapshotArnsToRestore() {
            if (snapshotArnsToRestore instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotArnsToRestore;
        }

        public final void setSnapshotArnsToRestore(Collection<String> snapshotArnsToRestore) {
            this.snapshotArnsToRestore = SnapshotArnsListCopier.copy(snapshotArnsToRestore);
        }

        @Override
        public final Builder snapshotArnsToRestore(Collection<String> snapshotArnsToRestore) {
            this.snapshotArnsToRestore = SnapshotArnsListCopier.copy(snapshotArnsToRestore);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArnsToRestore(String... snapshotArnsToRestore) {
            snapshotArnsToRestore(Arrays.asList(snapshotArnsToRestore));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerlessCacheRequest build() {
            return new CreateServerlessCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
