/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the allowed node types you can use to modify your cluster or replication group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAllowedNodeTypeModificationsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<ListAllowedNodeTypeModificationsResponse.Builder, ListAllowedNodeTypeModificationsResponse> {
    private static final SdkField<List<String>> SCALE_UP_MODIFICATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScaleUpModifications")
            .getter(getter(ListAllowedNodeTypeModificationsResponse::scaleUpModifications))
            .setter(setter(Builder::scaleUpModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleUpModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SCALE_DOWN_MODIFICATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScaleDownModifications")
            .getter(getter(ListAllowedNodeTypeModificationsResponse::scaleDownModifications))
            .setter(setter(Builder::scaleDownModifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownModifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_UP_MODIFICATIONS_FIELD,
            SCALE_DOWN_MODIFICATIONS_FIELD));

    private final List<String> scaleUpModifications;

    private final List<String> scaleDownModifications;

    private ListAllowedNodeTypeModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.scaleUpModifications = builder.scaleUpModifications;
        this.scaleDownModifications = builder.scaleDownModifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScaleUpModifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScaleUpModifications() {
        return scaleUpModifications != null && !(scaleUpModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
     * replication group.
     * </p>
     * <p>
     * When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
     * <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScaleUpModifications} method.
     * </p>
     * 
     * @return A string list, each element of which specifies a cache node type which you can use to scale your cluster
     *         or replication group.</p>
     *         <p>
     *         When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
     *         <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code>
     *         parameter.
     */
    public final List<String> scaleUpModifications() {
        return scaleUpModifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScaleDownModifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScaleDownModifications() {
        return scaleDownModifications != null && !(scaleDownModifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
     * replication group. When scaling down a Redis OSS cluster or replication group using ModifyCacheCluster or
     * ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScaleDownModifications} method.
     * </p>
     * 
     * @return A string list, each element of which specifies a cache node type which you can use to scale your cluster
     *         or replication group. When scaling down a Redis OSS cluster or replication group using ModifyCacheCluster
     *         or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter.
     */
    public final List<String> scaleDownModifications() {
        return scaleDownModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScaleUpModifications() ? scaleUpModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScaleDownModifications() ? scaleDownModifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedNodeTypeModificationsResponse)) {
            return false;
        }
        ListAllowedNodeTypeModificationsResponse other = (ListAllowedNodeTypeModificationsResponse) obj;
        return hasScaleUpModifications() == other.hasScaleUpModifications()
                && Objects.equals(scaleUpModifications(), other.scaleUpModifications())
                && hasScaleDownModifications() == other.hasScaleDownModifications()
                && Objects.equals(scaleDownModifications(), other.scaleDownModifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAllowedNodeTypeModificationsResponse")
                .add("ScaleUpModifications", hasScaleUpModifications() ? scaleUpModifications() : null)
                .add("ScaleDownModifications", hasScaleDownModifications() ? scaleDownModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScaleUpModifications":
            return Optional.ofNullable(clazz.cast(scaleUpModifications()));
        case "ScaleDownModifications":
            return Optional.ofNullable(clazz.cast(scaleDownModifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedNodeTypeModificationsResponse, T> g) {
        return obj -> g.apply((ListAllowedNodeTypeModificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAllowedNodeTypeModificationsResponse> {
        /**
         * <p>
         * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
         * replication group.
         * </p>
         * <p>
         * When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
         * <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.
         * </p>
         * 
         * @param scaleUpModifications
         *        A string list, each element of which specifies a cache node type which you can use to scale your
         *        cluster or replication group.</p>
         *        <p>
         *        When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
         *        <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleUpModifications(Collection<String> scaleUpModifications);

        /**
         * <p>
         * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
         * replication group.
         * </p>
         * <p>
         * When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
         * <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.
         * </p>
         * 
         * @param scaleUpModifications
         *        A string list, each element of which specifies a cache node type which you can use to scale your
         *        cluster or replication group.</p>
         *        <p>
         *        When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or
         *        <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleUpModifications(String... scaleUpModifications);

        /**
         * <p>
         * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
         * replication group. When scaling down a Redis OSS cluster or replication group using ModifyCacheCluster or
         * ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter.
         * </p>
         * 
         * @param scaleDownModifications
         *        A string list, each element of which specifies a cache node type which you can use to scale your
         *        cluster or replication group. When scaling down a Redis OSS cluster or replication group using
         *        ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleDownModifications(Collection<String> scaleDownModifications);

        /**
         * <p>
         * A string list, each element of which specifies a cache node type which you can use to scale your cluster or
         * replication group. When scaling down a Redis OSS cluster or replication group using ModifyCacheCluster or
         * ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter.
         * </p>
         * 
         * @param scaleDownModifications
         *        A string list, each element of which specifies a cache node type which you can use to scale your
         *        cluster or replication group. When scaling down a Redis OSS cluster or replication group using
         *        ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleDownModifications(String... scaleDownModifications);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private List<String> scaleUpModifications = DefaultSdkAutoConstructList.getInstance();

        private List<String> scaleDownModifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedNodeTypeModificationsResponse model) {
            super(model);
            scaleUpModifications(model.scaleUpModifications);
            scaleDownModifications(model.scaleDownModifications);
        }

        public final Collection<String> getScaleUpModifications() {
            if (scaleUpModifications instanceof SdkAutoConstructList) {
                return null;
            }
            return scaleUpModifications;
        }

        public final void setScaleUpModifications(Collection<String> scaleUpModifications) {
            this.scaleUpModifications = NodeTypeListCopier.copy(scaleUpModifications);
        }

        @Override
        public final Builder scaleUpModifications(Collection<String> scaleUpModifications) {
            this.scaleUpModifications = NodeTypeListCopier.copy(scaleUpModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleUpModifications(String... scaleUpModifications) {
            scaleUpModifications(Arrays.asList(scaleUpModifications));
            return this;
        }

        public final Collection<String> getScaleDownModifications() {
            if (scaleDownModifications instanceof SdkAutoConstructList) {
                return null;
            }
            return scaleDownModifications;
        }

        public final void setScaleDownModifications(Collection<String> scaleDownModifications) {
            this.scaleDownModifications = NodeTypeListCopier.copy(scaleDownModifications);
        }

        @Override
        public final Builder scaleDownModifications(Collection<String> scaleDownModifications) {
            this.scaleDownModifications = NodeTypeListCopier.copy(scaleDownModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleDownModifications(String... scaleDownModifications) {
            scaleDownModifications(Arrays.asList(scaleDownModifications));
            return this;
        }

        @Override
        public ListAllowedNodeTypeModificationsResponse build() {
            return new ListAllowedNodeTypeModificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
