/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all of the attributes of a specific Redis OSS replication group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroup.Builder, ReplicationGroup> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(ReplicationGroup::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ReplicationGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<GlobalReplicationGroupInfo> GLOBAL_REPLICATION_GROUP_INFO_FIELD = SdkField
            .<GlobalReplicationGroupInfo> builder(MarshallingType.SDK_POJO)
            .memberName("GlobalReplicationGroupInfo")
            .getter(getter(ReplicationGroup::globalReplicationGroupInfo))
            .setter(setter(Builder::globalReplicationGroupInfo))
            .constructor(GlobalReplicationGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupInfo").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReplicationGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ReplicationGroupPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<ReplicationGroupPendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(ReplicationGroup::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(ReplicationGroupPendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<List<String>> MEMBER_CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MemberClusters")
            .getter(getter(ReplicationGroup::memberClusters))
            .setter(setter(Builder::memberClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterId").build()).build()).build()).build();

    private static final SdkField<List<NodeGroup>> NODE_GROUPS_FIELD = SdkField
            .<List<NodeGroup>> builder(MarshallingType.LIST)
            .memberName("NodeGroups")
            .getter(getter(ReplicationGroup::nodeGroups))
            .setter(setter(Builder::nodeGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeGroup")
                            .memberFieldInfo(
                                    SdkField.<NodeGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeGroup").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOTTING_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshottingClusterId").getter(getter(ReplicationGroup::snapshottingClusterId))
            .setter(setter(Builder::snapshottingClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshottingClusterId").build())
            .build();

    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomaticFailover").getter(getter(ReplicationGroup::automaticFailoverAsString))
            .setter(setter(Builder::automaticFailover))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()).build();

    private static final SdkField<String> MULTI_AZ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiAZ").getter(getter(ReplicationGroup::multiAZAsString)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<Endpoint> CONFIGURATION_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigurationEndpoint").getter(getter(ReplicationGroup::configurationEndpoint))
            .setter(setter(Builder::configurationEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationEndpoint").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ReplicationGroup::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(ReplicationGroup::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<Boolean> CLUSTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClusterEnabled").getter(getter(ReplicationGroup::clusterEnabled))
            .setter(setter(Builder::clusterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEnabled").build()).build();

    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeType").getter(getter(ReplicationGroup::cacheNodeType)).setter(setter(Builder::cacheNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()).build();

    private static final SdkField<Boolean> AUTH_TOKEN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AuthTokenEnabled").getter(getter(ReplicationGroup::authTokenEnabled))
            .setter(setter(Builder::authTokenEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenEnabled").build()).build();

    private static final SdkField<Instant> AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("AuthTokenLastModifiedDate")
            .getter(getter(ReplicationGroup::authTokenLastModifiedDate)).setter(setter(Builder::authTokenLastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenLastModifiedDate").build())
            .build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled").getter(getter(ReplicationGroup::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AtRestEncryptionEnabled").getter(getter(ReplicationGroup::atRestEncryptionEnabled))
            .setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build())
            .build();

    private static final SdkField<List<String>> MEMBER_CLUSTERS_OUTPOST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MemberClustersOutpostArns")
            .getter(getter(ReplicationGroup::memberClustersOutpostArns))
            .setter(setter(Builder::memberClustersOutpostArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberClustersOutpostArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReplicationGroupOutpostArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReplicationGroupOutpostArn").build()).build()).build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ReplicationGroup::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ReplicationGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserGroupIds")
            .getter(getter(ReplicationGroup::userGroupIds))
            .setter(setter(Builder::userGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<LogDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(ReplicationGroup::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("LogDeliveryConfiguration")
                            .memberFieldInfo(
                                    SdkField.<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("LogDeliveryConfiguration").build()).build()).build()).build();

    private static final SdkField<Instant> REPLICATION_GROUP_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationGroupCreateTime")
            .getter(getter(ReplicationGroup::replicationGroupCreateTime))
            .setter(setter(Builder::replicationGroupCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupCreateTime").build())
            .build();

    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTiering").getter(getter(ReplicationGroup::dataTieringAsString)).setter(setter(Builder::dataTiering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ReplicationGroup::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ReplicationGroup::networkTypeAsString)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpDiscovery").getter(getter(ReplicationGroup::ipDiscoveryAsString)).setter(setter(Builder::ipDiscovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()).build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryptionMode").getter(getter(ReplicationGroup::transitEncryptionModeAsString))
            .setter(setter(Builder::transitEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build())
            .build();

    private static final SdkField<String> CLUSTER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterMode").getter(getter(ReplicationGroup::clusterModeAsString)).setter(setter(Builder::clusterMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_INFO_FIELD, STATUS_FIELD, PENDING_MODIFIED_VALUES_FIELD,
            MEMBER_CLUSTERS_FIELD, NODE_GROUPS_FIELD, SNAPSHOTTING_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_FIELD, MULTI_AZ_FIELD,
            CONFIGURATION_ENDPOINT_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, CLUSTER_ENABLED_FIELD,
            CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_ENABLED_FIELD, AUTH_TOKEN_LAST_MODIFIED_DATE_FIELD,
            TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, MEMBER_CLUSTERS_OUTPOST_ARNS_FIELD,
            KMS_KEY_ID_FIELD, ARN_FIELD, USER_GROUP_IDS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD,
            REPLICATION_GROUP_CREATE_TIME_FIELD, DATA_TIERING_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, NETWORK_TYPE_FIELD,
            IP_DISCOVERY_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD, CLUSTER_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationGroupId;

    private final String description;

    private final GlobalReplicationGroupInfo globalReplicationGroupInfo;

    private final String status;

    private final ReplicationGroupPendingModifiedValues pendingModifiedValues;

    private final List<String> memberClusters;

    private final List<NodeGroup> nodeGroups;

    private final String snapshottingClusterId;

    private final String automaticFailover;

    private final String multiAZ;

    private final Endpoint configurationEndpoint;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final Boolean clusterEnabled;

    private final String cacheNodeType;

    private final Boolean authTokenEnabled;

    private final Instant authTokenLastModifiedDate;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final List<String> memberClustersOutpostArns;

    private final String kmsKeyId;

    private final String arn;

    private final List<String> userGroupIds;

    private final List<LogDeliveryConfiguration> logDeliveryConfigurations;

    private final Instant replicationGroupCreateTime;

    private final String dataTiering;

    private final Boolean autoMinorVersionUpgrade;

    private final String networkType;

    private final String ipDiscovery;

    private final String transitEncryptionMode;

    private final String clusterMode;

    private ReplicationGroup(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.description = builder.description;
        this.globalReplicationGroupInfo = builder.globalReplicationGroupInfo;
        this.status = builder.status;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.memberClusters = builder.memberClusters;
        this.nodeGroups = builder.nodeGroups;
        this.snapshottingClusterId = builder.snapshottingClusterId;
        this.automaticFailover = builder.automaticFailover;
        this.multiAZ = builder.multiAZ;
        this.configurationEndpoint = builder.configurationEndpoint;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.clusterEnabled = builder.clusterEnabled;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenEnabled = builder.authTokenEnabled;
        this.authTokenLastModifiedDate = builder.authTokenLastModifiedDate;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.memberClustersOutpostArns = builder.memberClustersOutpostArns;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.userGroupIds = builder.userGroupIds;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.replicationGroupCreateTime = builder.replicationGroupCreateTime;
        this.dataTiering = builder.dataTiering;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.clusterMode = builder.clusterMode;
    }

    /**
     * <p>
     * The identifier for the replication group.
     * </p>
     * 
     * @return The identifier for the replication group.
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The user supplied description of the replication group.
     * </p>
     * 
     * @return The user supplied description of the replication group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Global datastore and role of this replication group in the Global datastore.
     * </p>
     * 
     * @return The name of the Global datastore and role of this replication group in the Global datastore.
     */
    public final GlobalReplicationGroupInfo globalReplicationGroupInfo() {
        return globalReplicationGroupInfo;
    }

    /**
     * <p>
     * The current state of this replication group - <code>creating</code>, <code>available</code>,
     * <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
     * </p>
     * 
     * @return The current state of this replication group - <code>creating</code>, <code>available</code>,
     *         <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A group of settings to be applied to the replication group, either immediately or during the next maintenance
     * window.
     * </p>
     * 
     * @return A group of settings to be applied to the replication group, either immediately or during the next
     *         maintenance window.
     */
    public final ReplicationGroupPendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberClusters() {
        return memberClusters != null && !(memberClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all the cache clusters that are part of this replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberClusters} method.
     * </p>
     * 
     * @return The names of all the cache clusters that are part of this replication group.
     */
    public final List<String> memberClusters() {
        return memberClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodeGroups() {
        return nodeGroups != null && !(nodeGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication groups, this
     * is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list contains an entry for
     * each node group (shard).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeGroups} method.
     * </p>
     * 
     * @return A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication
     *         groups, this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list
     *         contains an entry for each node group (shard).
     */
    public final List<NodeGroup> nodeGroups() {
        return nodeGroups;
    }

    /**
     * <p>
     * The cluster ID that is used as the daily snapshot source for the replication group.
     * </p>
     * 
     * @return The cluster ID that is used as the daily snapshot source for the replication group.
     */
    public final String snapshottingClusterId() {
        return snapshottingClusterId;
    }

    /**
     * <p>
     * Indicates the status of automatic failover for this Redis OSS replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates the status of automatic failover for this Redis OSS replication group.
     * @see AutomaticFailoverStatus
     */
    public final AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(automaticFailover);
    }

    /**
     * <p>
     * Indicates the status of automatic failover for this Redis OSS replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticFailover}
     * will return {@link AutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticFailoverAsString}.
     * </p>
     * 
     * @return Indicates the status of automatic failover for this Redis OSS replication group.
     * @see AutomaticFailoverStatus
     */
    public final String automaticFailoverAsString() {
        return automaticFailover;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multiAZ} will
     * return {@link MultiAZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #multiAZAsString}.
     * </p>
     * 
     * @return A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *         Multi-AZ</a>
     * @see MultiAZStatus
     */
    public final MultiAZStatus multiAZ() {
        return MultiAZStatus.fromValue(multiAZ);
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #multiAZ} will
     * return {@link MultiAZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #multiAZAsString}.
     * </p>
     * 
     * @return A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *         Multi-AZ</a>
     * @see MultiAZStatus
     */
    public final String multiAZAsString() {
        return multiAZ;
    }

    /**
     * <p>
     * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
     * replication group.
     * </p>
     * 
     * @return The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
     *         replication group.
     */
    public final Endpoint configurationEndpoint() {
        return configurationEndpoint;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example,
     * if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     * before being deleted.
     * </p>
     * <important>
     * <p>
     * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     * </p>
     * </important>
     * 
     * @return The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
     *         example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained
     *         for 5 days before being deleted.</p> <important>
     *         <p>
     *         If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
     *         </p>
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * <note>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     * </p>
     * </note>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
     *         </p>
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
     * partitioned across multiple shards (API/CLI: node groups).
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
     *         partitioned across multiple shards (API/CLI: node groups).</p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     */
    public final Boolean clusterEnabled() {
        return clusterEnabled;
    }

    /**
     * <p>
     * The name of the compute and memory capacity node type for each node in the replication group.
     * </p>
     * 
     * @return The name of the compute and memory capacity node type for each node in the replication group.
     */
    public final String cacheNodeType() {
        return cacheNodeType;
    }

    /**
     * <p>
     * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean authTokenEnabled() {
        return authTokenEnabled;
    }

    /**
     * <p>
     * The date the auth token was last modified
     * </p>
     * 
     * @return The date the auth token was last modified
     */
    public final Instant authTokenLastModifiedDate() {
        return authTokenLastModifiedDate;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at-rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
     * encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you
     * create a cluster.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at-rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
     *         enable encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to
     *         <code>true</code> when you create a cluster.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
     *         version <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberClustersOutpostArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMemberClustersOutpostArns() {
        return memberClustersOutpostArns != null && !(memberClustersOutpostArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outpost ARNs of the replication group's member clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberClustersOutpostArns} method.
     * </p>
     * 
     * @return The outpost ARNs of the replication group's member clusters.
     */
    public final List<String> memberClustersOutpostArns() {
        return memberClustersOutpostArns;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the disk in the cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the replication group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the replication group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserGroupIds() {
        return userGroupIds != null && !(userGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the user group associated to the replication group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserGroupIds} method.
     * </p>
     * 
     * @return The ID of the user group associated to the replication group.
     */
    public final List<String> userGroupIds() {
        return userGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the destination, format and type of the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return Returns the destination, format and type of the logs.
     */
    public final List<LogDeliveryConfiguration> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * The date and time when the cluster was created.
     * </p>
     * 
     * @return The date and time when the cluster was created.
     */
    public final Instant replicationGroupCreateTime() {
        return replicationGroupCreateTime;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
     *         This parameter must be set to true when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(dataTiering);
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
     *         This parameter must be set to true when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final String dataTieringAsString() {
        return dataTiering;
    }

    /**
     * <p>
     * If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     * </p>
     * 
     * @return If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in
     *         to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final NetworkType networkType() {
        return NetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link NetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkTypeAsString}.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
     *         built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    /**
     * <p>
     * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     *         is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(ipDiscovery);
    }

    /**
     * <p>
     * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
     * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipDiscovery} will
     * return {@link IpDiscovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipDiscoveryAsString}.
     * </p>
     * 
     * @return The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     *         is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on
     *         all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see IpDiscovery
     */
    public final String ipDiscoveryAsString() {
        return ipDiscovery;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(transitEncryptionMode);
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final String transitEncryptionModeAsString() {
        return transitEncryptionMode;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster
     * mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster
     * mode configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled
     *         and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can
     *         then complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final ClusterMode clusterMode() {
        return ClusterMode.fromValue(clusterMode);
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster
     * mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster
     * mode configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled
     *         and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can
     *         then complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final String clusterModeAsString() {
        return clusterMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(globalReplicationGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberClusters() ? memberClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeGroups() ? nodeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshottingClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberClustersOutpostArns() ? memberClustersOutpostArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserGroupIds() ? userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataTieringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(description(), other.description())
                && Objects.equals(globalReplicationGroupInfo(), other.globalReplicationGroupInfo())
                && Objects.equals(status(), other.status())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && hasMemberClusters() == other.hasMemberClusters() && Objects.equals(memberClusters(), other.memberClusters())
                && hasNodeGroups() == other.hasNodeGroups() && Objects.equals(nodeGroups(), other.nodeGroups())
                && Objects.equals(snapshottingClusterId(), other.snapshottingClusterId())
                && Objects.equals(automaticFailoverAsString(), other.automaticFailoverAsString())
                && Objects.equals(multiAZAsString(), other.multiAZAsString())
                && Objects.equals(configurationEndpoint(), other.configurationEndpoint())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(clusterEnabled(), other.clusterEnabled())
                && Objects.equals(cacheNodeType(), other.cacheNodeType())
                && Objects.equals(authTokenEnabled(), other.authTokenEnabled())
                && Objects.equals(authTokenLastModifiedDate(), other.authTokenLastModifiedDate())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && hasMemberClustersOutpostArns() == other.hasMemberClustersOutpostArns()
                && Objects.equals(memberClustersOutpostArns(), other.memberClustersOutpostArns())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(arn(), other.arn())
                && hasUserGroupIds() == other.hasUserGroupIds() && Objects.equals(userGroupIds(), other.userGroupIds())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(replicationGroupCreateTime(), other.replicationGroupCreateTime())
                && Objects.equals(dataTieringAsString(), other.dataTieringAsString())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString())
                && Objects.equals(ipDiscoveryAsString(), other.ipDiscoveryAsString())
                && Objects.equals(transitEncryptionModeAsString(), other.transitEncryptionModeAsString())
                && Objects.equals(clusterModeAsString(), other.clusterModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationGroup").add("ReplicationGroupId", replicationGroupId())
                .add("Description", description()).add("GlobalReplicationGroupInfo", globalReplicationGroupInfo())
                .add("Status", status()).add("PendingModifiedValues", pendingModifiedValues())
                .add("MemberClusters", hasMemberClusters() ? memberClusters() : null)
                .add("NodeGroups", hasNodeGroups() ? nodeGroups() : null).add("SnapshottingClusterId", snapshottingClusterId())
                .add("AutomaticFailover", automaticFailoverAsString()).add("MultiAZ", multiAZAsString())
                .add("ConfigurationEndpoint", configurationEndpoint()).add("SnapshotRetentionLimit", snapshotRetentionLimit())
                .add("SnapshotWindow", snapshotWindow()).add("ClusterEnabled", clusterEnabled())
                .add("CacheNodeType", cacheNodeType()).add("AuthTokenEnabled", authTokenEnabled())
                .add("AuthTokenLastModifiedDate", authTokenLastModifiedDate())
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled())
                .add("MemberClustersOutpostArns", hasMemberClustersOutpostArns() ? memberClustersOutpostArns() : null)
                .add("KmsKeyId", kmsKeyId()).add("ARN", arn()).add("UserGroupIds", hasUserGroupIds() ? userGroupIds() : null)
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("ReplicationGroupCreateTime", replicationGroupCreateTime()).add("DataTiering", dataTieringAsString())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("NetworkType", networkTypeAsString())
                .add("IpDiscovery", ipDiscoveryAsString()).add("TransitEncryptionMode", transitEncryptionModeAsString())
                .add("ClusterMode", clusterModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GlobalReplicationGroupInfo":
            return Optional.ofNullable(clazz.cast(globalReplicationGroupInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "MemberClusters":
            return Optional.ofNullable(clazz.cast(memberClusters()));
        case "NodeGroups":
            return Optional.ofNullable(clazz.cast(nodeGroups()));
        case "SnapshottingClusterId":
            return Optional.ofNullable(clazz.cast(snapshottingClusterId()));
        case "AutomaticFailover":
            return Optional.ofNullable(clazz.cast(automaticFailoverAsString()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZAsString()));
        case "ConfigurationEndpoint":
            return Optional.ofNullable(clazz.cast(configurationEndpoint()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "ClusterEnabled":
            return Optional.ofNullable(clazz.cast(clusterEnabled()));
        case "CacheNodeType":
            return Optional.ofNullable(clazz.cast(cacheNodeType()));
        case "AuthTokenEnabled":
            return Optional.ofNullable(clazz.cast(authTokenEnabled()));
        case "AuthTokenLastModifiedDate":
            return Optional.ofNullable(clazz.cast(authTokenLastModifiedDate()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "AtRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "MemberClustersOutpostArns":
            return Optional.ofNullable(clazz.cast(memberClustersOutpostArns()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserGroupIds":
            return Optional.ofNullable(clazz.cast(userGroupIds()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "ReplicationGroupCreateTime":
            return Optional.ofNullable(clazz.cast(replicationGroupCreateTime()));
        case "DataTiering":
            return Optional.ofNullable(clazz.cast(dataTieringAsString()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        case "IpDiscovery":
            return Optional.ofNullable(clazz.cast(ipDiscoveryAsString()));
        case "TransitEncryptionMode":
            return Optional.ofNullable(clazz.cast(transitEncryptionModeAsString()));
        case "ClusterMode":
            return Optional.ofNullable(clazz.cast(clusterModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroup, T> g) {
        return obj -> g.apply((ReplicationGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroup> {
        /**
         * <p>
         * The identifier for the replication group.
         * </p>
         * 
         * @param replicationGroupId
         *        The identifier for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The user supplied description of the replication group.
         * </p>
         * 
         * @param description
         *        The user supplied description of the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Global datastore and role of this replication group in the Global datastore.
         * </p>
         * 
         * @param globalReplicationGroupInfo
         *        The name of the Global datastore and role of this replication group in the Global datastore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo);

        /**
         * <p>
         * The name of the Global datastore and role of this replication group in the Global datastore.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalReplicationGroupInfo.Builder}
         * avoiding the need to create one manually via {@link GlobalReplicationGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalReplicationGroupInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #globalReplicationGroupInfo(GlobalReplicationGroupInfo)}.
         * 
         * @param globalReplicationGroupInfo
         *        a consumer that will call methods on {@link GlobalReplicationGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalReplicationGroupInfo(GlobalReplicationGroupInfo)
         */
        default Builder globalReplicationGroupInfo(Consumer<GlobalReplicationGroupInfo.Builder> globalReplicationGroupInfo) {
            return globalReplicationGroupInfo(GlobalReplicationGroupInfo.builder().applyMutation(globalReplicationGroupInfo)
                    .build());
        }

        /**
         * <p>
         * The current state of this replication group - <code>creating</code>, <code>available</code>,
         * <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
         * </p>
         * 
         * @param status
         *        The current state of this replication group - <code>creating</code>, <code>available</code>,
         *        <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A group of settings to be applied to the replication group, either immediately or during the next maintenance
         * window.
         * </p>
         * 
         * @param pendingModifiedValues
         *        A group of settings to be applied to the replication group, either immediately or during the next
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * A group of settings to be applied to the replication group, either immediately or during the next maintenance
         * window.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReplicationGroupPendingModifiedValues.Builder} avoiding the need to create one manually via
         * {@link ReplicationGroupPendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationGroupPendingModifiedValues.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingModifiedValues(ReplicationGroupPendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link ReplicationGroupPendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(ReplicationGroupPendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<ReplicationGroupPendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(ReplicationGroupPendingModifiedValues.builder().applyMutation(pendingModifiedValues)
                    .build());
        }

        /**
         * <p>
         * The names of all the cache clusters that are part of this replication group.
         * </p>
         * 
         * @param memberClusters
         *        The names of all the cache clusters that are part of this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClusters(Collection<String> memberClusters);

        /**
         * <p>
         * The names of all the cache clusters that are part of this replication group.
         * </p>
         * 
         * @param memberClusters
         *        The names of all the cache clusters that are part of this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClusters(String... memberClusters);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication groups,
         * this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list contains an
         * entry for each node group (shard).
         * </p>
         * 
         * @param nodeGroups
         *        A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication
         *        groups, this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the
         *        list contains an entry for each node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroups(Collection<NodeGroup> nodeGroups);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication groups,
         * this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list contains an
         * entry for each node group (shard).
         * </p>
         * 
         * @param nodeGroups
         *        A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication
         *        groups, this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the
         *        list contains an entry for each node group (shard).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeGroups(NodeGroup... nodeGroups);

        /**
         * <p>
         * A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication groups,
         * this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list contains an
         * entry for each node group (shard).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.NodeGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.NodeGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.NodeGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #nodeGroups(List<NodeGroup>)}.
         * 
         * @param nodeGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.NodeGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeGroups(java.util.Collection<NodeGroup>)
         */
        Builder nodeGroups(Consumer<NodeGroup.Builder>... nodeGroups);

        /**
         * <p>
         * The cluster ID that is used as the daily snapshot source for the replication group.
         * </p>
         * 
         * @param snapshottingClusterId
         *        The cluster ID that is used as the daily snapshot source for the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshottingClusterId(String snapshottingClusterId);

        /**
         * <p>
         * Indicates the status of automatic failover for this Redis OSS replication group.
         * </p>
         * 
         * @param automaticFailover
         *        Indicates the status of automatic failover for this Redis OSS replication group.
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(String automaticFailover);

        /**
         * <p>
         * Indicates the status of automatic failover for this Redis OSS replication group.
         * </p>
         * 
         * @param automaticFailover
         *        Indicates the status of automatic failover for this Redis OSS replication group.
         * @see AutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomaticFailoverStatus
         */
        Builder automaticFailover(AutomaticFailoverStatus automaticFailover);

        /**
         * <p>
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
         * Multi-AZ</a>
         * </p>
         * 
         * @param multiAZ
         *        A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see
         *        <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing
         *        Downtime: Multi-AZ</a>
         * @see MultiAZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiAZStatus
         */
        Builder multiAZ(String multiAZ);

        /**
         * <p>
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
         * Multi-AZ</a>
         * </p>
         * 
         * @param multiAZ
         *        A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see
         *        <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing
         *        Downtime: Multi-AZ</a>
         * @see MultiAZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiAZStatus
         */
        Builder multiAZ(MultiAZStatus multiAZ);

        /**
         * <p>
         * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
         * replication group.
         * </p>
         * 
         * @param configurationEndpoint
         *        The configuration endpoint for this replication group. Use the configuration endpoint to connect to
         *        this replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationEndpoint(Endpoint configurationEndpoint);

        /**
         * <p>
         * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this
         * replication group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #configurationEndpoint(Endpoint)}.
         * 
         * @param configurationEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationEndpoint(Endpoint)
         */
        default Builder configurationEndpoint(Consumer<Endpoint.Builder> configurationEndpoint) {
            return configurationEndpoint(Endpoint.builder().applyMutation(configurationEndpoint).build());
        }

        /**
         * <p>
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         * example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for
         * 5 days before being deleted.
         * </p>
         * <important>
         * <p>
         * If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         * </p>
         * </important>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For
         *        example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is
         *        retained for 5 days before being deleted.</p> <important>
         *        <p>
         *        If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
         * (shard).
         * </p>
         * <p>
         * Example: <code>05:00-09:00</code>
         * </p>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * </p>
         * <note>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         * </p>
         * </note>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node
         *        group (shard).</p>
         *        <p>
         *        Example: <code>05:00-09:00</code>
         *        </p>
         *        <p>
         *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be
         * partitioned across multiple shards (API/CLI: node groups).
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param clusterEnabled
         *        A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can
         *        be partitioned across multiple shards (API/CLI: node groups).</p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEnabled(Boolean clusterEnabled);

        /**
         * <p>
         * The name of the compute and memory capacity node type for each node in the replication group.
         * </p>
         * 
         * @param cacheNodeType
         *        The name of the compute and memory capacity node type for each node in the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeType(String cacheNodeType);

        /**
         * <p>
         * A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param authTokenEnabled
         *        A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenEnabled(Boolean authTokenEnabled);

        /**
         * <p>
         * The date the auth token was last modified
         * </p>
         * 
         * @param authTokenLastModifiedDate
         *        The date the auth token was last modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to <code>true</code>.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A flag that enables encryption at-rest when set to <code>true</code>.
         * </p>
         * <p>
         * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable
         * encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when
         * you create a cluster.
         * </p>
         * <p>
         * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version
         * <code>3.2.6</code>, <code>4.x</code> or later.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        A flag that enables encryption at-rest when set to <code>true</code>.</p>
         *        <p>
         *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To
         *        enable encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to
         *        <code>true</code> when you create a cluster.
         *        </p>
         *        <p>
         *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS
         *        version <code>3.2.6</code>, <code>4.x</code> or later.
         *        </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The outpost ARNs of the replication group's member clusters.
         * </p>
         * 
         * @param memberClustersOutpostArns
         *        The outpost ARNs of the replication group's member clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClustersOutpostArns(Collection<String> memberClustersOutpostArns);

        /**
         * <p>
         * The outpost ARNs of the replication group's member clusters.
         * </p>
         * 
         * @param memberClustersOutpostArns
         *        The outpost ARNs of the replication group's member clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberClustersOutpostArns(String... memberClustersOutpostArns);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the disk in the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the disk in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the replication group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the user group associated to the replication group.
         * </p>
         * 
         * @param userGroupIds
         *        The ID of the user group associated to the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(Collection<String> userGroupIds);

        /**
         * <p>
         * The ID of the user group associated to the replication group.
         * </p>
         * 
         * @param userGroupIds
         *        The ID of the user group associated to the replication group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupIds(String... userGroupIds);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Returns the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        Returns the destination, format and type of the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(LogDeliveryConfiguration... logDeliveryConfigurations);

        /**
         * <p>
         * Returns the destination, format and type of the logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logDeliveryConfigurations(List<LogDeliveryConfiguration>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<LogDeliveryConfiguration>)
         */
        Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * The date and time when the cluster was created.
         * </p>
         * 
         * @param replicationGroupCreateTime
         *        The date and time when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupCreateTime(Instant replicationGroupCreateTime);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
         * parameter must be set to true when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
         *        This parameter must be set to true when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(String dataTiering);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
         * parameter must be set to true when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
         *        This parameter must be set to true when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(DataTieringStatus dataTiering);

        /**
         * <p>
         * If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to
         * the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to
         *        opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous
         *        versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         * workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
         * on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param networkType
         *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
         *        workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
         *        built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see NetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkType
         */
        Builder networkType(NetworkType networkType);

        /**
         * <p>
         * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
         * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>.
         *        IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version
         *        1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(String ipDiscovery);

        /**
         * <p>
         * The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is
         * supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all
         * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * </p>
         * 
         * @param ipDiscovery
         *        The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>.
         *        IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version
         *        1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
         * @see IpDiscovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpDiscovery
         */
        Builder ipDiscovery(IpDiscovery ipDiscovery);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(String transitEncryptionMode);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and
         * cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then
         * complete cluster mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode
         *        enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode
         *        enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(String clusterMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and
         * cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then
         * complete cluster mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode
         *        enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode
         *        enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(ClusterMode clusterMode);
    }

    static final class BuilderImpl implements Builder {
        private String replicationGroupId;

        private String description;

        private GlobalReplicationGroupInfo globalReplicationGroupInfo;

        private String status;

        private ReplicationGroupPendingModifiedValues pendingModifiedValues;

        private List<String> memberClusters = DefaultSdkAutoConstructList.getInstance();

        private List<NodeGroup> nodeGroups = DefaultSdkAutoConstructList.getInstance();

        private String snapshottingClusterId;

        private String automaticFailover;

        private String multiAZ;

        private Endpoint configurationEndpoint;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private Boolean clusterEnabled;

        private String cacheNodeType;

        private Boolean authTokenEnabled;

        private Instant authTokenLastModifiedDate;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private List<String> memberClustersOutpostArns = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private String arn;

        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<LogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Instant replicationGroupCreateTime;

        private String dataTiering;

        private Boolean autoMinorVersionUpgrade;

        private String networkType;

        private String ipDiscovery;

        private String transitEncryptionMode;

        private String clusterMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroup model) {
            replicationGroupId(model.replicationGroupId);
            description(model.description);
            globalReplicationGroupInfo(model.globalReplicationGroupInfo);
            status(model.status);
            pendingModifiedValues(model.pendingModifiedValues);
            memberClusters(model.memberClusters);
            nodeGroups(model.nodeGroups);
            snapshottingClusterId(model.snapshottingClusterId);
            automaticFailover(model.automaticFailover);
            multiAZ(model.multiAZ);
            configurationEndpoint(model.configurationEndpoint);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            clusterEnabled(model.clusterEnabled);
            cacheNodeType(model.cacheNodeType);
            authTokenEnabled(model.authTokenEnabled);
            authTokenLastModifiedDate(model.authTokenLastModifiedDate);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            memberClustersOutpostArns(model.memberClustersOutpostArns);
            kmsKeyId(model.kmsKeyId);
            arn(model.arn);
            userGroupIds(model.userGroupIds);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            replicationGroupCreateTime(model.replicationGroupCreateTime);
            dataTiering(model.dataTiering);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            networkType(model.networkType);
            ipDiscovery(model.ipDiscovery);
            transitEncryptionMode(model.transitEncryptionMode);
            clusterMode(model.clusterMode);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GlobalReplicationGroupInfo.Builder getGlobalReplicationGroupInfo() {
            return globalReplicationGroupInfo != null ? globalReplicationGroupInfo.toBuilder() : null;
        }

        public final void setGlobalReplicationGroupInfo(GlobalReplicationGroupInfo.BuilderImpl globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo != null ? globalReplicationGroupInfo.build() : null;
        }

        @Override
        public final Builder globalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo) {
            this.globalReplicationGroupInfo = globalReplicationGroupInfo;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ReplicationGroupPendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(ReplicationGroupPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final Collection<String> getMemberClusters() {
            if (memberClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return memberClusters;
        }

        public final void setMemberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
        }

        @Override
        public final Builder memberClusters(Collection<String> memberClusters) {
            this.memberClusters = ClusterIdListCopier.copy(memberClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClusters(String... memberClusters) {
            memberClusters(Arrays.asList(memberClusters));
            return this;
        }

        public final List<NodeGroup.Builder> getNodeGroups() {
            List<NodeGroup.Builder> result = NodeGroupListCopier.copyToBuilder(this.nodeGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeGroups(Collection<NodeGroup.BuilderImpl> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copyFromBuilder(nodeGroups);
        }

        @Override
        public final Builder nodeGroups(Collection<NodeGroup> nodeGroups) {
            this.nodeGroups = NodeGroupListCopier.copy(nodeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(NodeGroup... nodeGroups) {
            nodeGroups(Arrays.asList(nodeGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroups(Consumer<NodeGroup.Builder>... nodeGroups) {
            nodeGroups(Stream.of(nodeGroups).map(c -> NodeGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSnapshottingClusterId() {
            return snapshottingClusterId;
        }

        public final void setSnapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
        }

        @Override
        public final Builder snapshottingClusterId(String snapshottingClusterId) {
            this.snapshottingClusterId = snapshottingClusterId;
            return this;
        }

        public final String getAutomaticFailover() {
            return automaticFailover;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final String getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(String multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public final Builder multiAZ(MultiAZStatus multiAZ) {
            this.multiAZ(multiAZ == null ? null : multiAZ.toString());
            return this;
        }

        public final Endpoint.Builder getConfigurationEndpoint() {
            return configurationEndpoint != null ? configurationEndpoint.toBuilder() : null;
        }

        public final void setConfigurationEndpoint(Endpoint.BuilderImpl configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint != null ? configurationEndpoint.build() : null;
        }

        @Override
        public final Builder configurationEndpoint(Endpoint configurationEndpoint) {
            this.configurationEndpoint = configurationEndpoint;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Boolean getClusterEnabled() {
            return clusterEnabled;
        }

        public final void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        @Override
        public final Builder clusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
            return this;
        }

        public final String getCacheNodeType() {
            return cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final Boolean getAuthTokenEnabled() {
            return authTokenEnabled;
        }

        public final void setAuthTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
        }

        @Override
        public final Builder authTokenEnabled(Boolean authTokenEnabled) {
            this.authTokenEnabled = authTokenEnabled;
            return this;
        }

        public final Instant getAuthTokenLastModifiedDate() {
            return authTokenLastModifiedDate;
        }

        public final void setAuthTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
        }

        @Override
        public final Builder authTokenLastModifiedDate(Instant authTokenLastModifiedDate) {
            this.authTokenLastModifiedDate = authTokenLastModifiedDate;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final Collection<String> getMemberClustersOutpostArns() {
            if (memberClustersOutpostArns instanceof SdkAutoConstructList) {
                return null;
            }
            return memberClustersOutpostArns;
        }

        public final void setMemberClustersOutpostArns(Collection<String> memberClustersOutpostArns) {
            this.memberClustersOutpostArns = ReplicationGroupOutpostArnListCopier.copy(memberClustersOutpostArns);
        }

        @Override
        public final Builder memberClustersOutpostArns(Collection<String> memberClustersOutpostArns) {
            this.memberClustersOutpostArns = ReplicationGroupOutpostArnListCopier.copy(memberClustersOutpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberClustersOutpostArns(String... memberClustersOutpostArns) {
            memberClustersOutpostArns(Arrays.asList(memberClustersOutpostArns));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getUserGroupIds() {
            if (userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userGroupIds;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String... userGroupIds) {
            userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final List<LogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfiguration.Builder> result = LogDeliveryConfigurationListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<LogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfiguration... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<LogDeliveryConfiguration.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> LogDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getReplicationGroupCreateTime() {
            return replicationGroupCreateTime;
        }

        public final void setReplicationGroupCreateTime(Instant replicationGroupCreateTime) {
            this.replicationGroupCreateTime = replicationGroupCreateTime;
        }

        @Override
        public final Builder replicationGroupCreateTime(Instant replicationGroupCreateTime) {
            this.replicationGroupCreateTime = replicationGroupCreateTime;
            return this;
        }

        public final String getDataTiering() {
            return dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public final String getTransitEncryptionMode() {
            return transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final String getClusterMode() {
            return clusterMode;
        }

        public final void setClusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
        }

        @Override
        public final Builder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        @Override
        public final Builder clusterMode(ClusterMode clusterMode) {
            this.clusterMode(clusterMode == null ? null : clusterMode.toString());
            return this;
        }

        @Override
        public ReplicationGroup build() {
            return new ReplicationGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
