/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elasticache.internal.ElastiCacheServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.elasticache.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest;
import software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionResponse;
import software.amazon.awssdk.services.elasticache.model.CacheClusterAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheClusterNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupInUseException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.CacheSubnetQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.CopyServerlessCacheSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopyServerlessCacheSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateServerlessCacheRequest;
import software.amazon.awssdk.services.elasticache.model.CreateServerlessCacheResponse;
import software.amazon.awssdk.services.elasticache.model.CreateServerlessCacheSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateServerlessCacheSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.CreateUserRequest;
import software.amazon.awssdk.services.elasticache.model.CreateUserResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.DefaultUserAssociatedToUserGroupException;
import software.amazon.awssdk.services.elasticache.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSecurityGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteServerlessCacheRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteServerlessCacheResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteServerlessCacheSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteServerlessCacheSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DeleteUserRequest;
import software.amazon.awssdk.services.elasticache.model.DeleteUserResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeGlobalReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCacheSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServerlessCachesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.DuplicateUserNameException;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheException;
import software.amazon.awssdk.services.elasticache.model.ExportServerlessCacheSnapshotRequest;
import software.amazon.awssdk.services.elasticache.model.ExportServerlessCacheSnapshotResponse;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest;
import software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse;
import software.amazon.awssdk.services.elasticache.model.InsufficientCacheClusterCapacityException;
import software.amazon.awssdk.services.elasticache.model.InvalidArnException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheClusterStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheParameterGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCacheSecurityGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidCredentialsException;
import software.amazon.awssdk.services.elasticache.model.InvalidGlobalReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.elasticache.model.InvalidParameterValueException;
import software.amazon.awssdk.services.elasticache.model.InvalidReplicationGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidServerlessCacheSnapshotStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidServerlessCacheStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticache.model.InvalidUserGroupStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidUserStateException;
import software.amazon.awssdk.services.elasticache.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticache.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyServerlessCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyServerlessCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserGroupResponse;
import software.amazon.awssdk.services.elasticache.model.ModifyUserRequest;
import software.amazon.awssdk.services.elasticache.model.ModifyUserResponse;
import software.amazon.awssdk.services.elasticache.model.NoOperationException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsPerReplicationGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.elasticache.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest;
import software.amazon.awssdk.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterRequest;
import software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupAlreadyUnderMigrationException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroupNotUnderMigrationException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodeQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOfferingNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupRequest;
import software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import software.amazon.awssdk.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheQuotaForCustomerExceededException;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshotNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshotQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.SnapshotFeatureNotSupportedException;
import software.amazon.awssdk.services.elasticache.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.elasticache.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.StartMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.StartMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.SubnetInUseException;
import software.amazon.awssdk.services.elasticache.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.elasticache.model.TagNotFoundException;
import software.amazon.awssdk.services.elasticache.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.elasticache.model.TestFailoverRequest;
import software.amazon.awssdk.services.elasticache.model.TestFailoverResponse;
import software.amazon.awssdk.services.elasticache.model.TestMigrationRequest;
import software.amazon.awssdk.services.elasticache.model.TestMigrationResponse;
import software.amazon.awssdk.services.elasticache.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.UserGroupAlreadyExistsException;
import software.amazon.awssdk.services.elasticache.model.UserGroupNotFoundException;
import software.amazon.awssdk.services.elasticache.model.UserGroupQuotaExceededException;
import software.amazon.awssdk.services.elasticache.model.UserNotFoundException;
import software.amazon.awssdk.services.elasticache.model.UserQuotaExceededException;
import software.amazon.awssdk.services.elasticache.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.AuthorizeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchApplyUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.BatchStopUpdateActionRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CompleteMigrationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CopyServerlessCacheSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateServerlessCacheRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateServerlessCacheSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DecreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteServerlessCacheRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteServerlessCacheSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheClustersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeCacheSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeGlobalReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReplicationGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeReservedCacheNodesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeServerlessCacheSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeServerlessCachesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUpdateActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.DisassociateGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ExportServerlessCacheSnapshotRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.FailoverGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.IncreaseReplicaCountRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListAllowedNodeTypeModificationsRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyCacheSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyReplicationGroupShardConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyServerlessCacheRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyUserGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ModifyUserRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.PurchaseReservedCacheNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebalanceSlotsInGlobalReplicationGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RebootCacheClusterRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.ResetCacheParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.RevokeCacheSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.StartMigrationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.TestFailoverRequestMarshaller;
import software.amazon.awssdk.services.elasticache.transform.TestMigrationRequestMarshaller;
import software.amazon.awssdk.services.elasticache.waiters.ElastiCacheWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ElastiCacheClient}.
 *
 * @see ElastiCacheClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElastiCacheClient implements ElastiCacheClient {
    private static final Logger log = Logger.loggerFor(DefaultElastiCacheClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElastiCacheClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in
     * Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Represents the input of an AddTagsToResource operation.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws ReservedCacheNodeNotFoundException
     *         The requested reserved cache node was not found.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AddTagsToResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws CacheClusterNotFoundException, CacheParameterGroupNotFoundException, CacheSecurityGroupNotFoundException,
            CacheSubnetGroupNotFoundException, InvalidReplicationGroupStateException, ReplicationGroupNotFoundException,
            ReservedCacheNodeNotFoundException, SnapshotNotFoundException, UserNotFoundException, UserGroupNotFoundException,
            ServerlessCacheNotFoundException, InvalidServerlessCacheStateException, ServerlessCacheSnapshotNotFoundException,
            InvalidServerlessCacheSnapshotStateException, TagQuotaPerResourceExceededException, InvalidArnException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(AddTagsToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2,
     * and Amazon EC2 security groups are used as the authorization mechanism.
     * </p>
     * <note>
     * <p>
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another
     * region.
     * </p>
     * </note>
     *
     * @param authorizeCacheSecurityGroupIngressRequest
     *        Represents the input of an AuthorizeCacheSecurityGroupIngress operation.
     * @return Result of the AuthorizeCacheSecurityGroupIngress operation returned by the service.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws InvalidCacheSecurityGroupStateException
     *         The current state of the cache security group does not allow deletion.
     * @throws AuthorizationAlreadyExistsException
     *         The specified Amazon EC2 security group is already authorized for the specified cache security group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.AuthorizeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/AuthorizeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AuthorizeCacheSecurityGroupIngressResponse authorizeCacheSecurityGroupIngress(
            AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest)
            throws CacheSecurityGroupNotFoundException, InvalidCacheSecurityGroupStateException,
            AuthorizationAlreadyExistsException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<AuthorizeCacheSecurityGroupIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(AuthorizeCacheSecurityGroupIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeCacheSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeCacheSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeCacheSecurityGroupIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeCacheSecurityGroupIngressRequest, AuthorizeCacheSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeCacheSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeCacheSecurityGroupIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeCacheSecurityGroupIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Apply the service update. For more information on service updates and applying them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service
     * Updates</a>.
     * </p>
     *
     * @param batchApplyUpdateActionRequest
     * @return Result of the BatchApplyUpdateAction operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     *         The service update doesn't exist
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.BatchApplyUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchApplyUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchApplyUpdateActionResponse batchApplyUpdateAction(BatchApplyUpdateActionRequest batchApplyUpdateActionRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<BatchApplyUpdateActionResponse> responseHandler = protocolFactory
                .createResponseHandler(BatchApplyUpdateActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchApplyUpdateActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchApplyUpdateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchApplyUpdateAction");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchApplyUpdateActionRequest, BatchApplyUpdateActionResponse>()
                            .withOperationName("BatchApplyUpdateAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchApplyUpdateActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchApplyUpdateActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stop the service update. For more information on service updates and stopping them, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping
     * Service Updates</a>.
     * </p>
     *
     * @param batchStopUpdateActionRequest
     * @return Result of the BatchStopUpdateAction operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     *         The service update doesn't exist
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.BatchStopUpdateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/BatchStopUpdateAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchStopUpdateActionResponse batchStopUpdateAction(BatchStopUpdateActionRequest batchStopUpdateActionRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<BatchStopUpdateActionResponse> responseHandler = protocolFactory
                .createResponseHandler(BatchStopUpdateActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStopUpdateActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStopUpdateActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStopUpdateAction");

            return clientHandler.execute(new ClientExecutionParams<BatchStopUpdateActionRequest, BatchStopUpdateActionResponse>()
                    .withOperationName("BatchStopUpdateAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchStopUpdateActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchStopUpdateActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Complete the migration of data.
     * </p>
     *
     * @param completeMigrationRequest
     * @return Result of the CompleteMigration operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupNotUnderMigrationException
     *         The designated replication group is not available for data migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CompleteMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CompleteMigration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompleteMigrationResponse completeMigration(CompleteMigrationRequest completeMigrationRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException,
            ReplicationGroupNotUnderMigrationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CompleteMigrationResponse> responseHandler = protocolFactory
                .createResponseHandler(CompleteMigrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeMigrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, completeMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMigration");

            return clientHandler.execute(new ClientExecutionParams<CompleteMigrationRequest, CompleteMigrationResponse>()
                    .withOperationName("CompleteMigration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(completeMigrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CompleteMigrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a copy of an existing serverless cache’s snapshot. Available for Valkey, Redis OSS and Serverless
     * Memcached only.
     * </p>
     *
     * @param copyServerlessCacheSnapshotRequest
     * @return Result of the CopyServerlessCacheSnapshot operation returned by the service.
     * @throws ServerlessCacheSnapshotAlreadyExistsException
     *         A serverless cache snapshot with this name already exists. Available for Valkey, Redis OSS and Serverless
     *         Memcached only.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws ServerlessCacheSnapshotQuotaExceededException
     *         The number of serverless cache snapshots exceeds the customer snapshot quota. Available for Valkey, Redis
     *         OSS and Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CopyServerlessCacheSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopyServerlessCacheSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CopyServerlessCacheSnapshotResponse copyServerlessCacheSnapshot(
            CopyServerlessCacheSnapshotRequest copyServerlessCacheSnapshotRequest)
            throws ServerlessCacheSnapshotAlreadyExistsException, ServerlessCacheSnapshotNotFoundException,
            ServerlessCacheSnapshotQuotaExceededException, InvalidServerlessCacheSnapshotStateException,
            ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CopyServerlessCacheSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyServerlessCacheSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyServerlessCacheSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyServerlessCacheSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyServerlessCacheSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<CopyServerlessCacheSnapshotRequest, CopyServerlessCacheSnapshotResponse>()
                            .withOperationName("CopyServerlessCacheSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(copyServerlessCacheSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CopyServerlessCacheSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note> <important>
     * <p>
     * Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon
     * S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has
     * the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the
     * use of ElastiCache operations, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a>
     * and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access
     * Control</a>.
     * </p>
     * </important>
     * <p>
     * You could receive the following error messages.
     * </p>
     * <p class="title">
     * <b>Error Messages</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is outside of the region.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s does not exist.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.
     * </p>
     * <p>
     * <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket"
     * >Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired
     * activity.
     * </p>
     * <p>
     * <b>Solution:</b> Contact your system administrator to get the needed permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.
     * </p>
     * <p>
     * <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you
     * could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.
     * </p>
     * <p>
     * <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access"
     * >Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param copySnapshotRequest
     *        Represents the input of a <code>CopySnapshotMessage</code> operation.
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     *         You already have a snapshot with the given name.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum number of snapshots.
     * @throws InvalidSnapshotStateException
     *         The current state of the snapshot does not allow the requested operation to occur.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws SnapshotAlreadyExistsException,
            SnapshotNotFoundException, SnapshotQuotaExceededException, InvalidSnapshotStateException,
            TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopySnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                    .withOperationName("CopySnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copySnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either
     * Memcached, Valkey or Redis OSS.
     * </p>
     * <p>
     * This operation is not supported for Valkey or Redis OSS (cluster mode enabled) clusters.
     * </p>
     *
     * @param createCacheClusterRequest
     *        Represents the input of a CreateCacheCluster operation.
     * @return Result of the CreateCacheCluster operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws CacheClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws ClusterQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of clusters per customer.
     * @throws NodeQuotaForClusterExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes in a single
     *         cluster.
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCacheClusterResponse createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, CacheClusterAlreadyExistsException,
            InsufficientCacheClusterCapacityException, CacheSecurityGroupNotFoundException, CacheSubnetGroupNotFoundException,
            ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException,
            NodeQuotaForCustomerExceededException, CacheParameterGroupNotFoundException, InvalidVpcNetworkStateException,
            TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateCacheClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCacheClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCacheClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateCacheClusterRequest, CreateCacheClusterResponse>()
                    .withOperationName("CreateCacheCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCacheClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCacheClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of
     * parameters and their values that are applied to all of the nodes in any cluster or replication group using the
     * CacheParameterGroup.
     * </p>
     * <p>
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the
     * CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of
     * specific parameters. For more information, see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">
     * ModifyCacheParameterGroup</a> in the ElastiCache API Reference.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and
     * Parameter Groups</a> in the ElastiCache User Guide.
     * </p>
     * </li>
     * </ul>
     *
     * @param createCacheParameterGroupRequest
     *        Represents the input of a <code>CreateCacheParameterGroup</code> operation.
     * @return Result of the CreateCacheParameterGroup operation returned by the service.
     * @throws CacheParameterGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum number of cache security groups.
     * @throws CacheParameterGroupAlreadyExistsException
     *         A cache parameter group with the requested name already exists.
     * @throws InvalidCacheParameterGroupStateException
     *         The current state of the cache parameter group does not allow the requested operation to occur.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCacheParameterGroupResponse createCacheParameterGroup(
            CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws CacheParameterGroupQuotaExceededException,
            CacheParameterGroupAlreadyExistsException, InvalidCacheParameterGroupStateException,
            TagQuotaPerResourceExceededException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateCacheParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCacheParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCacheParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCacheParameterGroupRequest, CreateCacheParameterGroupResponse>()
                            .withOperationName("CreateCacheParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCacheParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCacheParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     * </p>
     * <p>
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud
     * (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html"
     * >CreateCacheSubnetGroup</a>.
     * </p>
     *
     * @param createCacheSecurityGroupRequest
     *        Represents the input of a <code>CreateCacheSecurityGroup</code> operation.
     * @return Result of the CreateCacheSecurityGroup operation returned by the service.
     * @throws CacheSecurityGroupAlreadyExistsException
     *         A cache security group with the specified name already exists.
     * @throws CacheSecurityGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache security groups.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCacheSecurityGroupResponse createCacheSecurityGroup(
            CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws CacheSecurityGroupAlreadyExistsException,
            CacheSecurityGroupQuotaExceededException, TagQuotaPerResourceExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateCacheSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCacheSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCacheSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCacheSecurityGroupRequest, CreateCacheSecurityGroupResponse>()
                            .withOperationName("CreateCacheSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCacheSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCacheSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new cache subnet group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * </p>
     *
     * @param createCacheSubnetGroupRequest
     *        Represents the input of a <code>CreateCacheSubnetGroup</code> operation.
     * @return Result of the CreateCacheSubnetGroup operation returned by the service.
     * @throws CacheSubnetGroupAlreadyExistsException
     *         The requested cache subnet group name is already in use by an existing cache subnet group.
     * @throws CacheSubnetGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache subnet groups.
     * @throws CacheSubnetQuotaExceededException
     *         The request cannot be processed because it would exceed the allowed number of subnets in a cache subnet
     *         group.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidSubnetException
     *         An invalid subnet identifier was specified.
     * @throws SubnetNotAllowedException
     *         At least one subnet ID does not match the other subnet IDs. This mismatch typically occurs when a user
     *         sets one subnet ID to a regional Availability Zone and a different one to an outpost. Or when a user sets
     *         the subnet ID to an Outpost when not subscribed on this service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCacheSubnetGroupResponse createCacheSubnetGroup(CreateCacheSubnetGroupRequest createCacheSubnetGroupRequest)
            throws CacheSubnetGroupAlreadyExistsException, CacheSubnetGroupQuotaExceededException,
            CacheSubnetQuotaExceededException, TagQuotaPerResourceExceededException, InvalidSubnetException,
            SubnetNotAllowedException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateCacheSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCacheSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCacheSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCacheSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCacheSubnetGroupRequest, CreateCacheSubnetGroupResponse>()
                            .withOperationName("CreateCacheSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCacheSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCacheSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Global Datastore offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore
     * with Valkey or Redis OSS, you can create cross-region read replica clusters for ElastiCache to enable low-latency
     * reads and disaster recovery across regions. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across
     * Regions Using Global Datastore</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will
     * replicate updates to the secondary cluster.
     * </p>
     * </li>
     * </ul>
     *
     * @param createGlobalReplicationGroupRequest
     * @return Result of the CreateGlobalReplicationGroup operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws GlobalReplicationGroupAlreadyExistsException
     *         The Global datastore name already exists.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGlobalReplicationGroupResponse createGlobalReplicationGroup(
            CreateGlobalReplicationGroupRequest createGlobalReplicationGroupRequest) throws ReplicationGroupNotFoundException,
            InvalidReplicationGroupStateException, GlobalReplicationGroupAlreadyExistsException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<CreateGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateGlobalReplicationGroupRequest, CreateGlobalReplicationGroupResponse>()
                            .withOperationName("CreateGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Valkey or Redis OSS (cluster mode disabled) or a Valkey or Redis OSS (cluster mode enabled) replication
     * group.
     * </p>
     * <p>
     * This API can be used to create a standalone regional replication group or a secondary replication group
     * associated with a Global datastore.
     * </p>
     * <p>
     * A Valkey or Redis OSS (cluster mode disabled) replication group is a collection of nodes, where one of the nodes
     * is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously
     * propagated to the replicas.
     * </p>
     * <p>
     * A Valkey or Redis OSS cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups).
     * Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and
     * 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
     * </p>
     * <p>
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Valkey or Redis OSS engine
     * version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83
     * shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there
     * are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet
     * group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet
     * Group</a>. For versions below 5.0.6, the limit is 250 per cluster.
     * </p>
     * <p>
     * To request a limit increase, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose
     * the limit type <b>Nodes per cluster per instance type</b>.
     * </p>
     * <p>
     * When a Valkey or Redis OSS (cluster mode disabled) replication group has been successfully created, you can add
     * one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number
     * of node groups (console: shards), you can use scaling. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling self-designed
     * clusters</a> in the <i>ElastiCache User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey and Redis OSS only.
     * </p>
     * </note>
     *
     * @param createReplicationGroupRequest
     *        Represents the input of a <code>CreateReplicationGroup</code> operation.
     * @return Result of the CreateReplicationGroup operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws ReplicationGroupAlreadyExistsException
     *         The specified replication group already exists.
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws ClusterQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of clusters per customer.
     * @throws NodeQuotaForClusterExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes in a single
     *         cluster.
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws NodeGroupsPerReplicationGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum allowed number of node groups
     *         (shards) in a single replication group. The default maximum is 90
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReplicationGroupResponse createReplicationGroup(CreateReplicationGroupRequest createReplicationGroupRequest)
            throws CacheClusterNotFoundException, InvalidCacheClusterStateException, ReplicationGroupAlreadyExistsException,
            InvalidUserGroupStateException, UserGroupNotFoundException, InsufficientCacheClusterCapacityException,
            CacheSecurityGroupNotFoundException, CacheSubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException,
            NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, CacheParameterGroupNotFoundException,
            InvalidVpcNetworkStateException, TagQuotaPerResourceExceededException,
            NodeGroupsPerReplicationGroupQuotaExceededException, GlobalReplicationGroupNotFoundException,
            InvalidGlobalReplicationGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationGroupRequest, CreateReplicationGroupResponse>()
                            .withOperationName("CreateReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a serverless cache.
     * </p>
     *
     * @param createServerlessCacheRequest
     * @return Result of the CreateServerlessCache operation returned by the service.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheAlreadyExistsException
     *         A serverless cache with this name already exists.
     * @throws ServerlessCacheQuotaForCustomerExceededException
     *         The number of serverless caches exceeds the customer quota.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidCredentialsException
     *         You must enter valid credentials.
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateServerlessCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateServerlessCache"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateServerlessCacheResponse createServerlessCache(CreateServerlessCacheRequest createServerlessCacheRequest)
            throws ServerlessCacheNotFoundException, InvalidServerlessCacheStateException, ServerlessCacheAlreadyExistsException,
            ServerlessCacheQuotaForCustomerExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, InvalidCredentialsException, InvalidUserGroupStateException,
            UserGroupNotFoundException, TagQuotaPerResourceExceededException, ServiceLinkedRoleNotFoundException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateServerlessCacheResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateServerlessCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createServerlessCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServerlessCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServerlessCache");

            return clientHandler.execute(new ClientExecutionParams<CreateServerlessCacheRequest, CreateServerlessCacheResponse>()
                    .withOperationName("CreateServerlessCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createServerlessCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateServerlessCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API creates a copy of an entire ServerlessCache at a specific moment in time. Available for Valkey, Redis
     * OSS and Serverless Memcached only.
     * </p>
     *
     * @param createServerlessCacheSnapshotRequest
     * @return Result of the CreateServerlessCacheSnapshot operation returned by the service.
     * @throws ServerlessCacheSnapshotAlreadyExistsException
     *         A serverless cache snapshot with this name already exists. Available for Valkey, Redis OSS and Serverless
     *         Memcached only.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheSnapshotQuotaExceededException
     *         The number of serverless cache snapshots exceeds the customer snapshot quota. Available for Valkey, Redis
     *         OSS and Serverless Memcached only.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateServerlessCacheSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateServerlessCacheSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateServerlessCacheSnapshotResponse createServerlessCacheSnapshot(
            CreateServerlessCacheSnapshotRequest createServerlessCacheSnapshotRequest)
            throws ServerlessCacheSnapshotAlreadyExistsException, ServerlessCacheNotFoundException,
            InvalidServerlessCacheStateException, ServerlessCacheSnapshotQuotaExceededException,
            ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateServerlessCacheSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateServerlessCacheSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createServerlessCacheSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createServerlessCacheSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServerlessCacheSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateServerlessCacheSnapshotRequest, CreateServerlessCacheSnapshotResponse>()
                            .withOperationName("CreateServerlessCacheSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createServerlessCacheSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateServerlessCacheSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Represents the input of a <code>CreateSnapshot</code> operation.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     *         You already have a snapshot with the given name.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws SnapshotQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum number of snapshots.
     * @throws SnapshotFeatureNotSupportedException
     *         You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Valkey or Redis OSS cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Valkey or Redis OSS.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest)
            throws SnapshotAlreadyExistsException, CacheClusterNotFoundException, ReplicationGroupNotFoundException,
            InvalidCacheClusterStateException, InvalidReplicationGroupStateException, SnapshotQuotaExceededException,
            SnapshotFeatureNotSupportedException, TagQuotaPerResourceExceededException, InvalidParameterCombinationException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                    .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For Valkey engine version 7.2 onwards and Redis OSS 6.0 and onwards: Creates a user. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws UserAlreadyExistsException
     *         A user with this ID already exists.
     * @throws UserQuotaExceededException
     *         The quota of users has been exceeded.
     * @throws DuplicateUserNameException
     *         A user with this username already exists.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws UserAlreadyExistsException,
            UserQuotaExceededException, DuplicateUserNameException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, TagQuotaPerResourceExceededException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                    .withOperationName("CreateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For Valkey engine version 7.2 onwards and Redis OSS 6.0 onwards: Creates a user group. For more information, see
     * <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>
     * </p>
     *
     * @param createUserGroupRequest
     * @return Result of the CreateUserGroup operation returned by the service.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws DuplicateUserNameException
     *         A user with this username already exists.
     * @throws UserGroupAlreadyExistsException
     *         The user group with this ID already exists.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws DefaultUserRequiredException
     *         You must add default user to a user group.
     * @throws UserGroupQuotaExceededException
     *         The number of users exceeds the user group limit.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.CreateUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserGroupResponse createUserGroup(CreateUserGroupRequest createUserGroupRequest) throws UserNotFoundException,
            DuplicateUserNameException, UserGroupAlreadyExistsException, ServiceLinkedRoleNotFoundException,
            DefaultUserRequiredException, UserGroupQuotaExceededException, InvalidParameterValueException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<CreateUserGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateUserGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateUserGroupRequest, CreateUserGroupResponse>()
                    .withOperationName("CreateUserGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Decreases the number of node groups in a Global datastore
     * </p>
     *
     * @param decreaseNodeGroupsInGlobalReplicationGroupRequest
     * @return Result of the DecreaseNodeGroupsInGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DecreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DecreaseNodeGroupsInGlobalReplicationGroupResponse decreaseNodeGroupsInGlobalReplicationGroup(
            DecreaseNodeGroupsInGlobalReplicationGroupRequest decreaseNodeGroupsInGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DecreaseNodeGroupsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DecreaseNodeGroupsInGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                decreaseNodeGroupsInGlobalReplicationGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                decreaseNodeGroupsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseNodeGroupsInGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DecreaseNodeGroupsInGlobalReplicationGroupRequest, DecreaseNodeGroupsInGlobalReplicationGroupResponse>()
                            .withOperationName("DecreaseNodeGroupsInGlobalReplicationGroup")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(decreaseNodeGroupsInGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DecreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Dynamically decreases the number of replicas in a Valkey or Redis OSS (cluster mode disabled) replication group
     * or the number of replica nodes in one or more node groups (shards) of a Valkey or Redis OSS (cluster mode
     * enabled) replication group. This operation is performed with no cluster down time.
     * </p>
     *
     * @param decreaseReplicaCountRequest
     * @return Result of the DecreaseReplicaCount operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws ClusterQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of clusters per customer.
     * @throws NodeGroupsPerReplicationGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum allowed number of node groups
     *         (shards) in a single replication group. The default maximum is 90
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws NoOperationException
     *         The operation was not performed because no changes were required.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DecreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DecreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DecreaseReplicaCountResponse decreaseReplicaCount(DecreaseReplicaCountRequest decreaseReplicaCountRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException,
            InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException, ClusterQuotaForCustomerExceededException,
            NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException,
            ServiceLinkedRoleNotFoundException, NoOperationException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DecreaseReplicaCountResponse> responseHandler = protocolFactory
                .createResponseHandler(DecreaseReplicaCountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(decreaseReplicaCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, decreaseReplicaCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DecreaseReplicaCount");

            return clientHandler.execute(new ClientExecutionParams<DecreaseReplicaCountRequest, DecreaseReplicaCountResponse>()
                    .withOperationName("DecreaseReplicaCount").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(decreaseReplicaCountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DecreaseReplicaCountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes,
     * node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon
     * ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     * </p>
     * <p>
     * This operation is not valid for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valkey or Redis OSS (cluster mode enabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * Valkey or Redis OSS (cluster mode disabled) clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the last read replica of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is the primary node of a replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A node group (shard) that has Multi-AZ mode enabled
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster from a Valkey or Redis OSS (cluster mode enabled) replication group
     * </p>
     * </li>
     * <li>
     * <p>
     * A cluster that is not in the <code>available</code> state
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteCacheClusterRequest
     *        Represents the input of a <code>DeleteCacheCluster</code> operation.
     * @return Result of the DeleteCacheCluster operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws SnapshotAlreadyExistsException
     *         You already have a snapshot with the given name.
     * @throws SnapshotFeatureNotSupportedException
     *         You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Valkey or Redis OSS cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Valkey or Redis OSS.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.
     * @throws SnapshotQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum number of snapshots.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCacheClusterResponse deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest)
            throws CacheClusterNotFoundException, InvalidCacheClusterStateException, SnapshotAlreadyExistsException,
            SnapshotFeatureNotSupportedException, SnapshotQuotaExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteCacheClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCacheClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCacheClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteCacheClusterRequest, DeleteCacheClusterResponse>()
                    .withOperationName("DeleteCacheCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCacheClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCacheClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with
     * any cache clusters. You cannot delete the default cache parameter groups in your account.
     * </p>
     *
     * @param deleteCacheParameterGroupRequest
     *        Represents the input of a <code>DeleteCacheParameterGroup</code> operation.
     * @return Result of the DeleteCacheParameterGroup operation returned by the service.
     * @throws InvalidCacheParameterGroupStateException
     *         The current state of the cache parameter group does not allow the requested operation to occur.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCacheParameterGroupResponse deleteCacheParameterGroup(
            DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws InvalidCacheParameterGroupStateException,
            CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteCacheParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCacheParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCacheParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheParameterGroupRequest, DeleteCacheParameterGroupResponse>()
                            .withOperationName("DeleteCacheParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCacheParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCacheParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a cache security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a cache security group if it is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSecurityGroupRequest
     *        Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.
     * @return Result of the DeleteCacheSecurityGroup operation returned by the service.
     * @throws InvalidCacheSecurityGroupStateException
     *         The current state of the cache security group does not allow deletion.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteCacheSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCacheSecurityGroupResponse deleteCacheSecurityGroup(
            DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws InvalidCacheSecurityGroupStateException,
            CacheSecurityGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteCacheSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCacheSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCacheSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheSecurityGroupRequest, DeleteCacheSecurityGroupResponse>()
                            .withOperationName("DeleteCacheSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCacheSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCacheSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a cache subnet group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     * </p>
     * </note>
     *
     * @param deleteCacheSubnetGroupRequest
     *        Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.
     * @return Result of the DeleteCacheSubnetGroup operation returned by the service.
     * @throws CacheSubnetGroupInUseException
     *         The requested cache subnet group is currently in use.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCacheSubnetGroupResponse deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest deleteCacheSubnetGroupRequest)
            throws CacheSubnetGroupInUseException, CacheSubnetGroupNotFoundException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DeleteCacheSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCacheSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCacheSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCacheSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCacheSubnetGroupRequest, DeleteCacheSubnetGroupResponse>()
                            .withOperationName("DeleteCacheSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCacheSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCacheSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deleting a Global datastore is a two-step process:
     * </p>
     * <ul>
     * <li>
     * <p>
     * First, you must <a>DisassociateGlobalReplicationGroup</a> to remove the secondary clusters in the Global
     * datastore.
     * </p>
     * </li>
     * <li>
     * <p>
     * Once the Global datastore contains only the primary cluster, you can use the
     * <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary
     * cluster using <code>RetainPrimaryReplicationGroup=true</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the
     * primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when
     * deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteGlobalReplicationGroupRequest
     * @return Result of the DeleteGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGlobalReplicationGroupResponse deleteGlobalReplicationGroup(
            DeleteGlobalReplicationGroupRequest deleteGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteGlobalReplicationGroupRequest, DeleteGlobalReplicationGroupResponse>()
                            .withOperationName("DeleteGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including
     * the primary/primaries and all of the read replicas. If the replication group has only one primary, you can
     * optionally delete only the read replicas, while retaining the primary by setting
     * <code>RetainPrimaryCluster=true</code>.
     * </p>
     * <p>
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the
     * selected resources; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * <code>CreateSnapshot</code> permission is required to create a final snapshot. Without this permission, the API
     * call will fail with an <code>Access Denied</code> exception.
     * </p>
     * </li>
     * <li>
     * <p>
     * This operation is valid for Redis OSS only.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param deleteReplicationGroupRequest
     *        Represents the input of a <code>DeleteReplicationGroup</code> operation.
     * @return Result of the DeleteReplicationGroup operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws SnapshotAlreadyExistsException
     *         You already have a snapshot with the given name.
     * @throws SnapshotFeatureNotSupportedException
     *         You attempted one of the following operations:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Creating a snapshot of a Valkey or Redis OSS cluster running on a <code>cache.t1.micro</code> cache node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creating a snapshot of a cluster that is running Memcached rather than Valkey or Redis OSS.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Neither of these are supported by ElastiCache.
     * @throws SnapshotQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum number of snapshots.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteReplicationGroupResponse deleteReplicationGroup(DeleteReplicationGroupRequest deleteReplicationGroupRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, SnapshotAlreadyExistsException,
            SnapshotFeatureNotSupportedException, SnapshotQuotaExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationGroupRequest, DeleteReplicationGroupResponse>()
                            .withOperationName("DeleteReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified existing serverless cache.
     * </p>
     * <note>
     * <p>
     * <code>CreateServerlessCacheSnapshot</code> permission is required to create a final snapshot. Without this
     * permission, the API call will fail with an <code>Access Denied</code> exception.
     * </p>
     * </note>
     *
     * @param deleteServerlessCacheRequest
     * @return Result of the DeleteServerlessCache operation returned by the service.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheSnapshotAlreadyExistsException
     *         A serverless cache snapshot with this name already exists. Available for Valkey, Redis OSS and Serverless
     *         Memcached only.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidCredentialsException
     *         You must enter valid credentials.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteServerlessCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteServerlessCache"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteServerlessCacheResponse deleteServerlessCache(DeleteServerlessCacheRequest deleteServerlessCacheRequest)
            throws ServerlessCacheNotFoundException, InvalidServerlessCacheStateException,
            ServerlessCacheSnapshotAlreadyExistsException, InvalidParameterValueException, InvalidParameterCombinationException,
            InvalidCredentialsException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DeleteServerlessCacheResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteServerlessCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServerlessCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServerlessCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServerlessCache");

            return clientHandler.execute(new ClientExecutionParams<DeleteServerlessCacheRequest, DeleteServerlessCacheResponse>()
                    .withOperationName("DeleteServerlessCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteServerlessCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteServerlessCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     *
     * @param deleteServerlessCacheSnapshotRequest
     * @return Result of the DeleteServerlessCacheSnapshot operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteServerlessCacheSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteServerlessCacheSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteServerlessCacheSnapshotResponse deleteServerlessCacheSnapshot(
            DeleteServerlessCacheSnapshotRequest deleteServerlessCacheSnapshotRequest) throws ServiceLinkedRoleNotFoundException,
            ServerlessCacheSnapshotNotFoundException, InvalidServerlessCacheSnapshotStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteServerlessCacheSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteServerlessCacheSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteServerlessCacheSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteServerlessCacheSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServerlessCacheSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteServerlessCacheSnapshotRequest, DeleteServerlessCacheSnapshotResponse>()
                            .withOperationName("DeleteServerlessCacheSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteServerlessCacheSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteServerlessCacheSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note>
     *
     * @param deleteSnapshotRequest
     *        Represents the input of a <code>DeleteSnapshot</code> operation.
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws InvalidSnapshotStateException
     *         The current state of the snapshot does not allow the requested operation to occur.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws SnapshotNotFoundException,
            InvalidSnapshotStateException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                    .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For Valkey engine version 7.2 onwards and Redis OSS 6.0 onwards: Deletes a user. The user will be removed from
     * all user groups and in turn removed from all replication groups. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidUserStateException
     *         The user is not in active state.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws DefaultUserAssociatedToUserGroupException
     *         The default user assigned to the user group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidUserStateException,
            UserNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            DefaultUserAssociatedToUserGroupException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withOperationName("DeleteUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For Valkey engine version 7.2 onwards and Redis OSS 6.0 onwards: Deletes a user group. The user group must first
     * be disassociated from the replication group before it can be deleted. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access
     * Control (RBAC)</a>.
     * </p>
     *
     * @param deleteUserGroupRequest
     * @return Result of the DeleteUserGroup operation returned by the service.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DeleteUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserGroupResponse deleteUserGroup(DeleteUserGroupRequest deleteUserGroupRequest)
            throws UserGroupNotFoundException, InvalidUserGroupStateException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DeleteUserGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteUserGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserGroupRequest, DeleteUserGroupResponse>()
                    .withOperationName("DeleteUserGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteUserGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cache cluster if a cluster identifier is supplied.
     * </p>
     * <p>
     * By default, abbreviated information about the clusters is returned. You can use the optional
     * <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the
     * clusters. These details include the DNS address and port for the cache node endpoint.
     * </p>
     * <p>
     * If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the
     * nodes are successfully provisioned.
     * </p>
     * <p>
     * If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.
     * </p>
     * <p>
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the
     * additional nodes are not displayed until they are completely provisioned. When the cluster state is
     * <i>available</i>, the cluster is ready for use.
     * </p>
     * <p>
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is
     * displayed.
     * </p>
     *
     * @param describeCacheClustersRequest
     *        Represents the input of a <code>DescribeCacheClusters</code> operation.
     * @return Result of the DescribeCacheClusters operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheClusters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheClustersResponse describeCacheClusters(DescribeCacheClustersRequest describeCacheClustersRequest)
            throws CacheClusterNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeCacheClustersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheClusters");

            return clientHandler.execute(new ClientExecutionParams<DescribeCacheClustersRequest, DescribeCacheClustersResponse>()
                    .withOperationName("DescribeCacheClusters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCacheClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCacheClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the available cache engines and their versions.
     * </p>
     *
     * @param describeCacheEngineVersionsRequest
     *        Represents the input of a <code>DescribeCacheEngineVersions</code> operation.
     * @return Result of the DescribeCacheEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheEngineVersionsResponse describeCacheEngineVersions(
            DescribeCacheEngineVersionsRequest describeCacheEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeCacheEngineVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheEngineVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheEngineVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResponse>()
                            .withOperationName("DescribeCacheEngineVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCacheEngineVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCacheEngineVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list
     * contains only the descriptions for that group.
     * </p>
     *
     * @param describeCacheParameterGroupsRequest
     *        Represents the input of a <code>DescribeCacheParameterGroups</code> operation.
     * @return Result of the DescribeCacheParameterGroups operation returned by the service.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheParameterGroupsResponse describeCacheParameterGroups(
            DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws CacheParameterGroupNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeCacheParameterGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheParameterGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResponse>()
                            .withOperationName("DescribeCacheParameterGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCacheParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCacheParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cache parameter group.
     * </p>
     *
     * @param describeCacheParametersRequest
     *        Represents the input of a <code>DescribeCacheParameters</code> operation.
     * @return Result of the DescribeCacheParameters operation returned by the service.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheParametersResponse describeCacheParameters(DescribeCacheParametersRequest describeCacheParametersRequest)
            throws CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeCacheParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheParametersRequest, DescribeCacheParametersResponse>()
                            .withOperationName("DescribeCacheParameters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCacheParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCacheParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list
     * contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     * </p>
     *
     * @param describeCacheSecurityGroupsRequest
     *        Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.
     * @return Result of the DescribeCacheSecurityGroups operation returned by the service.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheSecurityGroupsResponse describeCacheSecurityGroups(
            DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws CacheSecurityGroupNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeCacheSecurityGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheSecurityGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheSecurityGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResponse>()
                            .withOperationName("DescribeCacheSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCacheSecurityGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCacheSecurityGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only
     * the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache
     * clusters now launch in VPC by default.
     * </p>
     *
     * @param describeCacheSubnetGroupsRequest
     *        Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.
     * @return Result of the DescribeCacheSubnetGroups operation returned by the service.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeCacheSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeCacheSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCacheSubnetGroupsResponse describeCacheSubnetGroups(
            DescribeCacheSubnetGroupsRequest describeCacheSubnetGroupsRequest) throws CacheSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeCacheSubnetGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCacheSubnetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCacheSubnetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCacheSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCacheSubnetGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResponse>()
                            .withOperationName("DescribeCacheSubnetGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCacheSubnetGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCacheSubnetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified cache engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.
     * @return Result of the DescribeEngineDefaultParameters operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeEngineDefaultParametersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEngineDefaultParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEngineDefaultParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEngineDefaultParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineDefaultParameters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineDefaultParametersRequest, DescribeEngineDefaultParametersResponse>()
                            .withOperationName("DescribeEngineDefaultParameters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEngineDefaultParametersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineDefaultParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events
     * specific to a particular cluster, cache security group, or cache parameter group by providing the name as a
     * parameter.
     * </p>
     * <p>
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days'
     * worth of events if necessary.
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input of a <code>DescribeEvents</code> operation.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeEvents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest)
            throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                    .withOperationName("DescribeEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a particular global replication group. If no identifier is specified, returns
     * information about all Global datastores.
     * </p>
     *
     * @param describeGlobalReplicationGroupsRequest
     * @return Result of the DescribeGlobalReplicationGroups operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeGlobalReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeGlobalReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGlobalReplicationGroupsResponse describeGlobalReplicationGroups(
            DescribeGlobalReplicationGroupsRequest describeGlobalReplicationGroupsRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeGlobalReplicationGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeGlobalReplicationGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGlobalReplicationGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeGlobalReplicationGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalReplicationGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalReplicationGroupsRequest, DescribeGlobalReplicationGroupsResponse>()
                            .withOperationName("DescribeGlobalReplicationGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeGlobalReplicationGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGlobalReplicationGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a particular replication group. If no identifier is specified,
     * <code>DescribeReplicationGroups</code> returns information about all replication groups.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note>
     *
     * @param describeReplicationGroupsRequest
     *        Represents the input of a <code>DescribeReplicationGroups</code> operation.
     * @return Result of the DescribeReplicationGroups operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeReplicationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReplicationGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationGroupsResponse describeReplicationGroups(
            DescribeReplicationGroupsRequest describeReplicationGroupsRequest) throws ReplicationGroupNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeReplicationGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeReplicationGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>()
                            .withOperationName("DescribeReplicationGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReplicationGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     * </p>
     *
     * @param describeReservedCacheNodesRequest
     *        Represents the input of a <code>DescribeReservedCacheNodes</code> operation.
     * @return Result of the DescribeReservedCacheNodes operation returned by the service.
     * @throws ReservedCacheNodeNotFoundException
     *         The requested reserved cache node was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeReservedCacheNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedCacheNodesResponse describeReservedCacheNodes(
            DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws ReservedCacheNodeNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeReservedCacheNodesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeReservedCacheNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedCacheNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedCacheNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedCacheNodes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResponse>()
                            .withOperationName("DescribeReservedCacheNodes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedCacheNodesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedCacheNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists available reserved cache node offerings.
     * </p>
     *
     * @param describeReservedCacheNodesOfferingsRequest
     *        Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.
     * @return Result of the DescribeReservedCacheNodesOfferings operation returned by the service.
     * @throws ReservedCacheNodesOfferingNotFoundException
     *         The requested cache node offering does not exist.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeReservedCacheNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedCacheNodesOfferingsResponse describeReservedCacheNodesOfferings(
            DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest)
            throws ReservedCacheNodesOfferingNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeReservedCacheNodesOfferingsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeReservedCacheNodesOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedCacheNodesOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedCacheNodesOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedCacheNodesOfferings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResponse>()
                            .withOperationName("DescribeReservedCacheNodesOfferings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedCacheNodesOfferingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedCacheNodesOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about serverless cache snapshots. By default, this API lists all of the customer’s serverless
     * cache snapshots. It can also describe a single serverless cache snapshot, or the snapshots associated with a
     * particular serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     *
     * @param describeServerlessCacheSnapshotsRequest
     * @return Result of the DescribeServerlessCacheSnapshots operation returned by the service.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeServerlessCacheSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServerlessCacheSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServerlessCacheSnapshotsResponse describeServerlessCacheSnapshots(
            DescribeServerlessCacheSnapshotsRequest describeServerlessCacheSnapshotsRequest)
            throws ServerlessCacheNotFoundException, ServerlessCacheSnapshotNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeServerlessCacheSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeServerlessCacheSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeServerlessCacheSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeServerlessCacheSnapshotsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServerlessCacheSnapshots");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeServerlessCacheSnapshotsRequest, DescribeServerlessCacheSnapshotsResponse>()
                            .withOperationName("DescribeServerlessCacheSnapshots").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeServerlessCacheSnapshotsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeServerlessCacheSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific serverless cache. If no identifier is specified, then the API returns
     * information on all the serverless caches belonging to this Amazon Web Services account.
     * </p>
     *
     * @param describeServerlessCachesRequest
     * @return Result of the DescribeServerlessCaches operation returned by the service.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeServerlessCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServerlessCaches"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServerlessCachesResponse describeServerlessCaches(
            DescribeServerlessCachesRequest describeServerlessCachesRequest) throws ServerlessCacheNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeServerlessCachesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeServerlessCachesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeServerlessCachesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServerlessCachesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServerlessCaches");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeServerlessCachesRequest, DescribeServerlessCachesResponse>()
                            .withOperationName("DescribeServerlessCaches").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeServerlessCachesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeServerlessCachesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return Result of the DescribeServiceUpdates operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     *         The service update doesn't exist
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServiceUpdatesResponse describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeServiceUpdatesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeServiceUpdatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeServiceUpdatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServiceUpdatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceUpdates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceUpdatesRequest, DescribeServiceUpdatesResponse>()
                            .withOperationName("DescribeServiceUpdates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeServiceUpdatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeServiceUpdatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code>
     * lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with
     * a particular cache cluster.
     * </p>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note>
     *
     * @param describeSnapshotsRequest
     *        Represents the input of a <code>DescribeSnapshotsMessage</code> operation.
     * @return Result of the DescribeSnapshots operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest)
            throws CacheClusterNotFoundException, SnapshotNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");

            return clientHandler.execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                    .withOperationName("DescribeSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details of the update actions
     * </p>
     *
     * @param describeUpdateActionsRequest
     * @return Result of the DescribeUpdateActions operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeUpdateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUpdateActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeUpdateActionsResponse describeUpdateActions(DescribeUpdateActionsRequest describeUpdateActionsRequest)
            throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeUpdateActionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeUpdateActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUpdateActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUpdateActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUpdateActions");

            return clientHandler.execute(new ClientExecutionParams<DescribeUpdateActionsRequest, DescribeUpdateActionsResponse>()
                    .withOperationName("DescribeUpdateActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeUpdateActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUpdateActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of user groups.
     * </p>
     *
     * @param describeUserGroupsRequest
     * @return Result of the DescribeUserGroups operation returned by the service.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUserGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeUserGroupsResponse describeUserGroups(DescribeUserGroupsRequest describeUserGroupsRequest)
            throws UserGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<DescribeUserGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeUserGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUserGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeUserGroupsRequest, DescribeUserGroupsResponse>()
                    .withOperationName("DescribeUserGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeUserGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUserGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws UserNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DescribeUsersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsers");

            return clientHandler.execute(new ClientExecutionParams<DescribeUsersRequest, DescribeUsersResponse>()
                    .withOperationName("DescribeUsers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeUsersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will
     * no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon
     * region.
     * </p>
     *
     * @param disassociateGlobalReplicationGroupRequest
     * @return Result of the DisassociateGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.DisassociateGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DisassociateGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateGlobalReplicationGroupResponse disassociateGlobalReplicationGroup(
            DisassociateGlobalReplicationGroupRequest disassociateGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<DisassociateGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DisassociateGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateGlobalReplicationGroupRequest, DisassociateGlobalReplicationGroupResponse>()
                            .withOperationName("DisassociateGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the functionality to export the serverless cache snapshot data to Amazon S3. Available for Valkey and
     * Redis OSS only.
     * </p>
     *
     * @param exportServerlessCacheSnapshotRequest
     * @return Result of the ExportServerlessCacheSnapshot operation returned by the service.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ExportServerlessCacheSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ExportServerlessCacheSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportServerlessCacheSnapshotResponse exportServerlessCacheSnapshot(
            ExportServerlessCacheSnapshotRequest exportServerlessCacheSnapshotRequest)
            throws ServerlessCacheSnapshotNotFoundException, InvalidServerlessCacheSnapshotStateException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<ExportServerlessCacheSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(ExportServerlessCacheSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportServerlessCacheSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                exportServerlessCacheSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportServerlessCacheSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportServerlessCacheSnapshotRequest, ExportServerlessCacheSnapshotResponse>()
                            .withOperationName("ExportServerlessCacheSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportServerlessCacheSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportServerlessCacheSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all
     * other clusters will become secondary.
     * </p>
     *
     * @param failoverGlobalReplicationGroupRequest
     * @return Result of the FailoverGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.FailoverGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/FailoverGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public FailoverGlobalReplicationGroupResponse failoverGlobalReplicationGroup(
            FailoverGlobalReplicationGroupRequest failoverGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<FailoverGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(FailoverGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(failoverGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                failoverGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<FailoverGlobalReplicationGroupRequest, FailoverGlobalReplicationGroupResponse>()
                            .withOperationName("FailoverGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(failoverGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new FailoverGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Increase the number of node groups in the Global datastore
     * </p>
     *
     * @param increaseNodeGroupsInGlobalReplicationGroupRequest
     * @return Result of the IncreaseNodeGroupsInGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.IncreaseNodeGroupsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseNodeGroupsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public IncreaseNodeGroupsInGlobalReplicationGroupResponse increaseNodeGroupsInGlobalReplicationGroup(
            IncreaseNodeGroupsInGlobalReplicationGroupRequest increaseNodeGroupsInGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<IncreaseNodeGroupsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(IncreaseNodeGroupsInGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                increaseNodeGroupsInGlobalReplicationGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                increaseNodeGroupsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseNodeGroupsInGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<IncreaseNodeGroupsInGlobalReplicationGroupRequest, IncreaseNodeGroupsInGlobalReplicationGroupResponse>()
                            .withOperationName("IncreaseNodeGroupsInGlobalReplicationGroup")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(increaseNodeGroupsInGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new IncreaseNodeGroupsInGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Dynamically increases the number of replicas in a Valkey or Redis OSS (cluster mode disabled) replication group
     * or the number of replica nodes in one or more node groups (shards) of a Valkey or Redis OSS (cluster mode
     * enabled) replication group. This operation is performed with no cluster down time.
     * </p>
     *
     * @param increaseReplicaCountRequest
     * @return Result of the IncreaseReplicaCount operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws ClusterQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of clusters per customer.
     * @throws NodeGroupsPerReplicationGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum allowed number of node groups
     *         (shards) in a single replication group. The default maximum is 90
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws NoOperationException
     *         The operation was not performed because no changes were required.
     * @throws InvalidKmsKeyException
     *         The KMS key supplied is not valid.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.IncreaseReplicaCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/IncreaseReplicaCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public IncreaseReplicaCountResponse increaseReplicaCount(IncreaseReplicaCountRequest increaseReplicaCountRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException,
            InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException, ClusterQuotaForCustomerExceededException,
            NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException,
            InvalidKmsKeyException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException,
            SdkClientException, ElastiCacheException {

        HttpResponseHandler<IncreaseReplicaCountResponse> responseHandler = protocolFactory
                .createResponseHandler(IncreaseReplicaCountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(increaseReplicaCountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, increaseReplicaCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IncreaseReplicaCount");

            return clientHandler.execute(new ClientExecutionParams<IncreaseReplicaCountRequest, IncreaseReplicaCountResponse>()
                    .withOperationName("IncreaseReplicaCount").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(increaseReplicaCountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new IncreaseReplicaCountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all available node types that you can scale with your cluster's replication group's current node type.
     * </p>
     * <p>
     * When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your
     * cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeModificationsRequest
     *        The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.
     * @return Result of the ListAllowedNodeTypeModifications operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ListAllowedNodeTypeModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListAllowedNodeTypeModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAllowedNodeTypeModificationsResponse listAllowedNodeTypeModifications(
            ListAllowedNodeTypeModificationsRequest listAllowedNodeTypeModificationsRequest)
            throws CacheClusterNotFoundException, ReplicationGroupNotFoundException, InvalidParameterCombinationException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ListAllowedNodeTypeModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAllowedNodeTypeModificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAllowedNodeTypeModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAllowedNodeTypeModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAllowedNodeTypeModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResponse>()
                            .withOperationName("ListAllowedNodeTypeModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAllowedNodeTypeModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAllowedNodeTypeModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags currently on a named resource.
     * </p>
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on
     * replication groups, those actions will be replicated to all nodes in the replication group. For more information,
     * see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource
     * -level permissions</a>.
     * </p>
     * <p>
     * If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The input parameters for the <code>ListTagsForResource</code> operation.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws ReservedCacheNodeNotFoundException
     *         The requested reserved cache node was not found.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws CacheClusterNotFoundException, CacheParameterGroupNotFoundException, CacheSecurityGroupNotFoundException,
            CacheSubnetGroupNotFoundException, InvalidReplicationGroupStateException, ReplicationGroupNotFoundException,
            ReservedCacheNodeNotFoundException, SnapshotNotFoundException, UserNotFoundException, UserGroupNotFoundException,
            ServerlessCacheNotFoundException, InvalidServerlessCacheStateException, ServerlessCacheSnapshotNotFoundException,
            InvalidServerlessCacheSnapshotStateException, InvalidArnException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * parameters by specifying the parameters and the new values.
     * </p>
     *
     * @param modifyCacheClusterRequest
     *        Represents the input of a <code>ModifyCacheCluster</code> operation.
     * @return Result of the ModifyCacheCluster operation returned by the service.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidCacheSecurityGroupStateException
     *         The current state of the cache security group does not allow deletion.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws NodeQuotaForClusterExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes in a single
     *         cluster.
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCacheClusterResponse modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest)
            throws InvalidCacheClusterStateException, InvalidCacheSecurityGroupStateException,
            InsufficientCacheClusterCapacityException, CacheClusterNotFoundException, NodeQuotaForClusterExceededException,
            NodeQuotaForCustomerExceededException, CacheSecurityGroupNotFoundException, CacheParameterGroupNotFoundException,
            InvalidVpcNetworkStateException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyCacheClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCacheClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCacheClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheCluster");

            return clientHandler.execute(new ClientExecutionParams<ModifyCacheClusterRequest, ModifyCacheClusterResponse>()
                    .withOperationName("ModifyCacheCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyCacheClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyCacheClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by
     * submitting a list parameter name and value pairs.
     * </p>
     *
     * @param modifyCacheParameterGroupRequest
     *        Represents the input of a <code>ModifyCacheParameterGroup</code> operation.
     * @return Result of the ModifyCacheParameterGroup operation returned by the service.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidCacheParameterGroupStateException
     *         The current state of the cache parameter group does not allow the requested operation to occur.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCacheParameterGroupResponse modifyCacheParameterGroup(
            ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws CacheParameterGroupNotFoundException,
            InvalidCacheParameterGroupStateException, InvalidParameterValueException, InvalidParameterCombinationException,
            InvalidGlobalReplicationGroupStateException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyCacheParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCacheParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCacheParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResponse>()
                            .withOperationName("ModifyCacheParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCacheParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCacheParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing cache subnet group.
     * </p>
     *
     * @param modifyCacheSubnetGroupRequest
     *        Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.
     * @return Result of the ModifyCacheSubnetGroup operation returned by the service.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws CacheSubnetQuotaExceededException
     *         The request cannot be processed because it would exceed the allowed number of subnets in a cache subnet
     *         group.
     * @throws SubnetInUseException
     *         The requested subnet is being used by another cache subnet group.
     * @throws InvalidSubnetException
     *         An invalid subnet identifier was specified.
     * @throws SubnetNotAllowedException
     *         At least one subnet ID does not match the other subnet IDs. This mismatch typically occurs when a user
     *         sets one subnet ID to a regional Availability Zone and a different one to an outpost. Or when a user sets
     *         the subnet ID to an Outpost when not subscribed on this service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyCacheSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyCacheSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCacheSubnetGroupResponse modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest modifyCacheSubnetGroupRequest)
            throws CacheSubnetGroupNotFoundException, CacheSubnetQuotaExceededException, SubnetInUseException,
            InvalidSubnetException, SubnetNotAllowedException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyCacheSubnetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCacheSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCacheSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCacheSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCacheSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCacheSubnetGroupRequest, ModifyCacheSubnetGroupResponse>()
                            .withOperationName("ModifyCacheSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCacheSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCacheSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for a Global datastore.
     * </p>
     *
     * @param modifyGlobalReplicationGroupRequest
     * @return Result of the ModifyGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyGlobalReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyGlobalReplicationGroupResponse modifyGlobalReplicationGroup(
            ModifyGlobalReplicationGroupRequest modifyGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyGlobalReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyGlobalReplicationGroupRequest, ModifyGlobalReplicationGroupResponse>()
                            .withOperationName("ModifyGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyGlobalReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for a replication group. This is limited to Valkey and Redis OSS 7 and above.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">
     * Scaling for Valkey or Redis OSS (cluster mode enabled)</a> in the ElastiCache User Guide
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html"
     * >ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This operation is valid for Valkey or Redis OSS only.
     * </p>
     * </note>
     *
     * @param modifyReplicationGroupRequest
     *        Represents the input of a <code>ModifyReplicationGroups</code> operation.
     * @return Result of the ModifyReplicationGroup operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidCacheSecurityGroupStateException
     *         The current state of the cache security group does not allow deletion.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws NodeQuotaForClusterExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes in a single
     *         cluster.
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws InvalidKmsKeyException
     *         The KMS key supplied is not valid.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyReplicationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyReplicationGroupResponse modifyReplicationGroup(ModifyReplicationGroupRequest modifyReplicationGroupRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidUserGroupStateException,
            UserGroupNotFoundException, InvalidCacheClusterStateException, InvalidCacheSecurityGroupStateException,
            InsufficientCacheClusterCapacityException, CacheClusterNotFoundException, NodeQuotaForClusterExceededException,
            NodeQuotaForCustomerExceededException, CacheSecurityGroupNotFoundException, CacheParameterGroupNotFoundException,
            InvalidVpcNetworkStateException, InvalidKmsKeyException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyReplicationGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationGroupRequest, ModifyReplicationGroupResponse>()
                            .withOperationName("ModifyReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyReplicationGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance
     * the keyspaces among existing shards.
     * </p>
     *
     * @param modifyReplicationGroupShardConfigurationRequest
     *        Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.
     * @return Result of the ModifyReplicationGroupShardConfiguration operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidVpcNetworkStateException
     *         The VPC network is in an invalid state.
     * @throws InsufficientCacheClusterCapacityException
     *         The requested cache node type is not available in the specified Availability Zone. For more information,
     *         see <a href=
     *         "http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY"
     *         >InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.
     * @throws NodeGroupsPerReplicationGroupQuotaExceededException
     *         The request cannot be processed because it would exceed the maximum allowed number of node groups
     *         (shards) in a single replication group. The default maximum is 90
     * @throws NodeQuotaForCustomerExceededException
     *         The request cannot be processed because it would exceed the allowed number of cache nodes per customer.
     * @throws InvalidKmsKeyException
     *         The KMS key supplied is not valid.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyReplicationGroupShardConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyReplicationGroupShardConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyReplicationGroupShardConfigurationResponse modifyReplicationGroupShardConfiguration(
            ModifyReplicationGroupShardConfigurationRequest modifyReplicationGroupShardConfigurationRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException, InvalidCacheClusterStateException,
            InvalidVpcNetworkStateException, InsufficientCacheClusterCapacityException,
            NodeGroupsPerReplicationGroupQuotaExceededException, NodeQuotaForCustomerExceededException, InvalidKmsKeyException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<ModifyReplicationGroupShardConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyReplicationGroupShardConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                modifyReplicationGroupShardConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyReplicationGroupShardConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationGroupShardConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationGroupShardConfigurationRequest, ModifyReplicationGroupShardConfigurationResponse>()
                            .withOperationName("ModifyReplicationGroupShardConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(modifyReplicationGroupShardConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyReplicationGroupShardConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API modifies the attributes of a serverless cache.
     * </p>
     *
     * @param modifyServerlessCacheRequest
     * @return Result of the ModifyServerlessCache operation returned by the service.
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidCredentialsException
     *         You must enter valid credentials.
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyServerlessCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyServerlessCache"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyServerlessCacheResponse modifyServerlessCache(ModifyServerlessCacheRequest modifyServerlessCacheRequest)
            throws ServerlessCacheNotFoundException, InvalidServerlessCacheStateException, InvalidParameterValueException,
            InvalidParameterCombinationException, InvalidCredentialsException, InvalidUserGroupStateException,
            UserGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<ModifyServerlessCacheResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyServerlessCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyServerlessCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyServerlessCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyServerlessCache");

            return clientHandler.execute(new ClientExecutionParams<ModifyServerlessCacheRequest, ModifyServerlessCacheResponse>()
                    .withOperationName("ModifyServerlessCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyServerlessCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyServerlessCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param modifyUserRequest
     * @return Result of the ModifyUser operation returned by the service.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws InvalidUserStateException
     *         The user is not in active state.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyUserResponse modifyUser(ModifyUserRequest modifyUserRequest) throws UserNotFoundException,
            InvalidUserStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ModifyUserResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyUser");

            return clientHandler.execute(new ClientExecutionParams<ModifyUserRequest, ModifyUserResponse>()
                    .withOperationName("ModifyUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(modifyUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the list of users that belong to the user group.
     * </p>
     *
     * @param modifyUserGroupRequest
     * @return Result of the ModifyUserGroup operation returned by the service.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws DuplicateUserNameException
     *         A user with this username already exists.
     * @throws ServiceLinkedRoleNotFoundException
     *         The specified service linked role (SLR) was not found.
     * @throws DefaultUserRequiredException
     *         You must add default user to a user group.
     * @throws InvalidUserGroupStateException
     *         The user group is not in an active state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ModifyUserGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ModifyUserGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyUserGroupResponse modifyUserGroup(ModifyUserGroupRequest modifyUserGroupRequest)
            throws UserGroupNotFoundException, UserNotFoundException, DuplicateUserNameException,
            ServiceLinkedRoleNotFoundException, DefaultUserRequiredException, InvalidUserGroupStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<ModifyUserGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyUserGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyUserGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyUserGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyUserGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyUserGroupRequest, ModifyUserGroupResponse>()
                    .withOperationName("ModifyUserGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyUserGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyUserGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with
     * Reserved Nodes</a>.
     * </p>
     *
     * @param purchaseReservedCacheNodesOfferingRequest
     *        Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.
     * @return Result of the PurchaseReservedCacheNodesOffering operation returned by the service.
     * @throws ReservedCacheNodesOfferingNotFoundException
     *         The requested cache node offering does not exist.
     * @throws ReservedCacheNodeAlreadyExistsException
     *         You already have a reservation with the given identifier.
     * @throws ReservedCacheNodeQuotaExceededException
     *         The request cannot be processed because it would exceed the user's cache node quota.
     * @throws TagQuotaPerResourceExceededException
     *         The request cannot be processed because it would cause the resource to have more than the allowed number
     *         of tags. The maximum number of tags permitted on a resource is 50.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.PurchaseReservedCacheNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/PurchaseReservedCacheNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PurchaseReservedCacheNodesOfferingResponse purchaseReservedCacheNodesOffering(
            PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest)
            throws ReservedCacheNodesOfferingNotFoundException, ReservedCacheNodeAlreadyExistsException,
            ReservedCacheNodeQuotaExceededException, TagQuotaPerResourceExceededException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<PurchaseReservedCacheNodesOfferingResponse> responseHandler = protocolFactory
                .createResponseHandler(PurchaseReservedCacheNodesOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseReservedCacheNodesOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedCacheNodesOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedCacheNodesOffering");

            return clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedCacheNodesOfferingRequest, PurchaseReservedCacheNodesOfferingResponse>()
                            .withOperationName("PurchaseReservedCacheNodesOffering").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(purchaseReservedCacheNodesOfferingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PurchaseReservedCacheNodesOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     * </p>
     *
     * @param rebalanceSlotsInGlobalReplicationGroupRequest
     * @return Result of the RebalanceSlotsInGlobalReplicationGroup operation returned by the service.
     * @throws GlobalReplicationGroupNotFoundException
     *         The Global datastore does not exist
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.RebalanceSlotsInGlobalReplicationGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebalanceSlotsInGlobalReplicationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RebalanceSlotsInGlobalReplicationGroupResponse rebalanceSlotsInGlobalReplicationGroup(
            RebalanceSlotsInGlobalReplicationGroupRequest rebalanceSlotsInGlobalReplicationGroupRequest)
            throws GlobalReplicationGroupNotFoundException, InvalidGlobalReplicationGroupStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<RebalanceSlotsInGlobalReplicationGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(RebalanceSlotsInGlobalReplicationGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebalanceSlotsInGlobalReplicationGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rebalanceSlotsInGlobalReplicationGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebalanceSlotsInGlobalReplicationGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<RebalanceSlotsInGlobalReplicationGroupRequest, RebalanceSlotsInGlobalReplicationGroupResponse>()
                            .withOperationName("RebalanceSlotsInGlobalReplicationGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(rebalanceSlotsInGlobalReplicationGroupRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RebalanceSlotsInGlobalReplicationGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache
     * parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary
     * outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     * </p>
     * <p>
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     * </p>
     * <p>
     * When the reboot is complete, a cluster event is created.
     * </p>
     * <p>
     * Rebooting a cluster is currently supported on Memcached, Valkey and Redis OSS (cluster mode disabled) clusters.
     * Rebooting is not supported on Valkey or Redis OSS (cluster mode enabled) clusters.
     * </p>
     * <p>
     * If you make changes to parameters that require a Valkey or Redis OSS (cluster mode enabled) cluster reboot for
     * the changes to be applied, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a>
     * for an alternate process.
     * </p>
     *
     * @param rebootCacheClusterRequest
     *        Represents the input of a <code>RebootCacheCluster</code> operation.
     * @return Result of the RebootCacheCluster operation returned by the service.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.RebootCacheCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RebootCacheCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RebootCacheClusterResponse rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest)
            throws InvalidCacheClusterStateException, CacheClusterNotFoundException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<RebootCacheClusterResponse> responseHandler = protocolFactory
                .createResponseHandler(RebootCacheClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootCacheClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootCacheClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootCacheCluster");

            return clientHandler.execute(new ClientExecutionParams<RebootCacheClusterRequest, RebootCacheClusterResponse>()
                    .withOperationName("RebootCacheCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootCacheClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootCacheClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair
     * where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache
     * resources, with the exception of global replication group. When you add or remove tags on replication groups,
     * those actions will be replicated to all nodes in the replication group. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html"
     * >Resource-level permissions</a>.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Represents the input of a <code>RemoveTagsFromResource</code> operation.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws CacheClusterNotFoundException
     *         The requested cluster ID does not refer to an existing cluster.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws CacheSubnetGroupNotFoundException
     *         The requested cache subnet group name does not refer to an existing cache subnet group.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws ReservedCacheNodeNotFoundException
     *         The requested reserved cache node was not found.
     * @throws SnapshotNotFoundException
     *         The requested snapshot name does not refer to an existing snapshot.
     * @throws UserNotFoundException
     *         The user does not exist or could not be found.
     * @throws UserGroupNotFoundException
     *         The user group was not found or does not exist
     * @throws ServerlessCacheNotFoundException
     *         The serverless cache was not found or does not exist.
     * @throws InvalidServerlessCacheStateException
     *         The account for these credentials is not currently active.
     * @throws ServerlessCacheSnapshotNotFoundException
     *         This serverless cache snapshot could not be found or does not exist. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidServerlessCacheSnapshotStateException
     *         The state of the serverless cache snapshot was not received. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     * @throws InvalidArnException
     *         The requested Amazon Resource Name (ARN) does not refer to an existing resource.
     * @throws TagNotFoundException
     *         The requested tag was not found on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RemoveTagsFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws CacheClusterNotFoundException, CacheParameterGroupNotFoundException, CacheSecurityGroupNotFoundException,
            CacheSubnetGroupNotFoundException, InvalidReplicationGroupStateException, ReplicationGroupNotFoundException,
            ReservedCacheNodeNotFoundException, SnapshotNotFoundException, UserNotFoundException, UserGroupNotFoundException,
            ServerlessCacheNotFoundException, InvalidServerlessCacheStateException, ServerlessCacheSnapshotNotFoundException,
            InvalidServerlessCacheSnapshotStateException, InvalidArnException, TagNotFoundException, AwsServiceException,
            SdkClientException, ElastiCacheException {

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveTagsFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsFromResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeTagsFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the
     * <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.
     * </p>
     *
     * @param resetCacheParameterGroupRequest
     *        Represents the input of a <code>ResetCacheParameterGroup</code> operation.
     * @return Result of the ResetCacheParameterGroup operation returned by the service.
     * @throws InvalidCacheParameterGroupStateException
     *         The current state of the cache parameter group does not allow the requested operation to occur.
     * @throws CacheParameterGroupNotFoundException
     *         The requested cache parameter group name does not refer to an existing cache parameter group.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws InvalidGlobalReplicationGroupStateException
     *         The Global datastore is not available or in primary-only state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.ResetCacheParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ResetCacheParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResetCacheParameterGroupResponse resetCacheParameterGroup(
            ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws InvalidCacheParameterGroupStateException,
            CacheParameterGroupNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            InvalidGlobalReplicationGroupStateException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<ResetCacheParameterGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetCacheParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetCacheParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetCacheParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetCacheParameterGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResponse>()
                            .withOperationName("ResetCacheParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(resetCacheParameterGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResetCacheParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security
     * group that had been previously authorized.
     * </p>
     *
     * @param revokeCacheSecurityGroupIngressRequest
     *        Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.
     * @return Result of the RevokeCacheSecurityGroupIngress operation returned by the service.
     * @throws CacheSecurityGroupNotFoundException
     *         The requested cache security group name does not refer to an existing cache security group.
     * @throws AuthorizationNotFoundException
     *         The specified Amazon EC2 security group is not authorized for the specified cache security group.
     * @throws InvalidCacheSecurityGroupStateException
     *         The current state of the cache security group does not allow deletion.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.RevokeCacheSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/RevokeCacheSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RevokeCacheSecurityGroupIngressResponse revokeCacheSecurityGroupIngress(
            RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest)
            throws CacheSecurityGroupNotFoundException, AuthorizationNotFoundException, InvalidCacheSecurityGroupStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            ElastiCacheException {

        HttpResponseHandler<RevokeCacheSecurityGroupIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(RevokeCacheSecurityGroupIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeCacheSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                revokeCacheSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeCacheSecurityGroupIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<RevokeCacheSecurityGroupIngressRequest, RevokeCacheSecurityGroupIngressResponse>()
                            .withOperationName("RevokeCacheSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(revokeCacheSecurityGroupIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RevokeCacheSecurityGroupIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Start the migration of data.
     * </p>
     *
     * @param startMigrationRequest
     * @return Result of the StartMigration operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupAlreadyUnderMigrationException
     *         The targeted replication group is not available.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.StartMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/StartMigration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartMigrationResponse startMigration(StartMigrationRequest startMigrationRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException,
            ReplicationGroupAlreadyUnderMigrationException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ElastiCacheException {

        HttpResponseHandler<StartMigrationResponse> responseHandler = protocolFactory
                .createResponseHandler(StartMigrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMigration");

            return clientHandler.execute(new ClientExecutionParams<StartMigrationRequest, StartMigrationResponse>()
                    .withOperationName("StartMigration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startMigrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartMigrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Represents the input of a <code>TestFailover</code> operation which tests automatic failover on a specified node
     * group (called shard in the console) in a replication group (called cluster in the console).
     * </p>
     * <p>
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not
     * designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster.
     * Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     * </p>
     * <p class="title">
     * <b>Note the following</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * A customer can use this operation to test automatic failover on up to 15 shards (called node groups in the
     * ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * </p>
     * </li>
     * <li>
     * <p>
     * If calling this operation on shards in different clusters (called replication groups in the API and CLI), the
     * calls can be made concurrently.
     * </p>
     * <p>
     * </p></li>
     * <li>
     * <p>
     * If calling this operation multiple times on different shards in the same Valkey or Redis OSS (cluster mode
     * enabled) replication group, the first node replacement must complete before a subsequent call can be made.
     * </p>
     * </li>
     * <li>
     * <p>
     * To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console,
     * the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in
     * order of occurrance:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Replication group message:
     * <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information see:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache
     * Events</a> in the <i>ElastiCache User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents
     * </a> in the ElastiCache API Reference
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Also see, <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing
     * Multi-AZ </a> in the <i>ElastiCache User Guide</i>.
     * </p>
     *
     * @param testFailoverRequest
     * @return Result of the TestFailover operation returned by the service.
     * @throws ApiCallRateForCustomerExceededException
     *         The customer has exceeded the allowed rate of API calls.
     * @throws InvalidCacheClusterStateException
     *         The requested cluster is not in the <code>available</code> state.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws NodeGroupNotFoundException
     *         The node group specified by the <code>NodeGroupId</code> parameter could not be found. Please verify that
     *         the node group exists and that you spelled the <code>NodeGroupId</code> value correctly.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws TestFailoverNotAvailableException
     *         The <code>TestFailover</code> action is not available.
     * @throws InvalidKmsKeyException
     *         The KMS key supplied is not valid.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws InvalidParameterCombinationException
     *         Two or more incompatible parameters were specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.TestFailover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestFailover" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestFailoverResponse testFailover(TestFailoverRequest testFailoverRequest)
            throws ApiCallRateForCustomerExceededException, InvalidCacheClusterStateException,
            InvalidReplicationGroupStateException, NodeGroupNotFoundException, ReplicationGroupNotFoundException,
            TestFailoverNotAvailableException, InvalidKmsKeyException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, ElastiCacheException {

        HttpResponseHandler<TestFailoverResponse> responseHandler = protocolFactory
                .createResponseHandler(TestFailoverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testFailoverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testFailoverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestFailover");

            return clientHandler.execute(new ClientExecutionParams<TestFailoverRequest, TestFailoverResponse>()
                    .withOperationName("TestFailover").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testFailoverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestFailoverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Async API to test connection between source and target replication group.
     * </p>
     *
     * @param testMigrationRequest
     * @return Result of the TestMigration operation returned by the service.
     * @throws ReplicationGroupNotFoundException
     *         The specified replication group does not exist.
     * @throws InvalidReplicationGroupStateException
     *         The requested replication group is not in the <code>available</code> state.
     * @throws ReplicationGroupAlreadyUnderMigrationException
     *         The targeted replication group is not available.
     * @throws InvalidParameterValueException
     *         The value for a parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElastiCacheException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElastiCacheClient.TestMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/TestMigration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestMigrationResponse testMigration(TestMigrationRequest testMigrationRequest)
            throws ReplicationGroupNotFoundException, InvalidReplicationGroupStateException,
            ReplicationGroupAlreadyUnderMigrationException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ElastiCacheException {

        HttpResponseHandler<TestMigrationResponse> responseHandler = protocolFactory
                .createResponseHandler(TestMigrationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "ElastiCache");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestMigration");

            return clientHandler.execute(new ClientExecutionParams<TestMigrationRequest, TestMigrationResponse>()
                    .withOperationName("TestMigration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testMigrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestMigrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link ElastiCacheWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElastiCacheWaiter}
     */
    @Override
    public ElastiCacheWaiter waiter() {
        return ElastiCacheWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ElastiCacheServiceClientConfigurationBuilder serviceConfigBuilder = new ElastiCacheServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(CacheSubnetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetInUse")
                                .exceptionBuilderSupplier(SubnetInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheClusterAlreadyExists")
                                .exceptionBuilderSupplier(CacheClusterAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSecurityGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheSecurityGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGlobalReplicationGroupState")
                                .exceptionBuilderSupplier(InvalidGlobalReplicationGroupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheSnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(ServerlessCacheSnapshotAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheSnapshotQuotaExceededFault")
                                .exceptionBuilderSupplier(ServerlessCacheSnapshotQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidCacheSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuotaExceeded.CacheSecurityGroup")
                                .exceptionBuilderSupplier(CacheSecurityGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(CacheParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodesOfferingNotFound")
                                .exceptionBuilderSupplier(ReservedCacheNodesOfferingNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupNotUnderMigrationFault")
                                .exceptionBuilderSupplier(ReplicationGroupNotUnderMigrationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidARN")
                                .exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault")
                                .exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault")
                                .exceptionBuilderSupplier(InvalidKmsKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateUserName")
                                .exceptionBuilderSupplier(DuplicateUserNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheParameterGroupNotFound")
                                .exceptionBuilderSupplier(CacheParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault")
                                .exceptionBuilderSupplier(SubnetNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault")
                                .exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotFound")
                                .exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeGroupNotFoundFault")
                                .exceptionBuilderSupplier(NodeGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalReplicationGroupNotFoundFault")
                                .exceptionBuilderSupplier(GlobalReplicationGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCredentialsException")
                                .exceptionBuilderSupplier(InvalidCredentialsException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCacheClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientCacheClusterCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeNotFound")
                                .exceptionBuilderSupplier(ReservedCacheNodeNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupInUse")
                                .exceptionBuilderSupplier(CacheSubnetGroupInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidServerlessCacheStateFault")
                                .exceptionBuilderSupplier(InvalidServerlessCacheStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupNotFoundFault")
                                .exceptionBuilderSupplier(ReplicationGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheAlreadyExistsFault")
                                .exceptionBuilderSupplier(ServerlessCacheAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoOperationFault")
                                .exceptionBuilderSupplier(NoOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeGroupsPerReplicationGroupQuotaExceeded")
                                .exceptionBuilderSupplier(NodeGroupsPerReplicationGroupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeQuotaExceeded")
                                .exceptionBuilderSupplier(ReservedCacheNodeQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedCacheNodeAlreadyExists")
                                .exceptionBuilderSupplier(ReservedCacheNodeAlreadyExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheClusterNotFound")
                                .exceptionBuilderSupplier(CacheClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GlobalReplicationGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(GlobalReplicationGroupAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValue")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupQuotaExceeded")
                                .exceptionBuilderSupplier(UserGroupQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplicationGroupState")
                                .exceptionBuilderSupplier(InvalidReplicationGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupAlreadyExists")
                                .exceptionBuilderSupplier(UserGroupAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheSnapshotNotFoundFault")
                                .exceptionBuilderSupplier(ServerlessCacheSnapshotNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultUserRequired")
                                .exceptionBuilderSupplier(DefaultUserRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceeded")
                                .exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserAlreadyExists")
                                .exceptionBuilderSupplier(UserAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheNotFoundFault")
                                .exceptionBuilderSupplier(ServerlessCacheNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserGroupState")
                                .exceptionBuilderSupplier(InvalidUserGroupStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagNotFound")
                                .exceptionBuilderSupplier(TagNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceeded")
                                .exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServerlessCacheQuotaForCustomerExceededFault")
                                .exceptionBuilderSupplier(ServerlessCacheQuotaForCustomerExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceeded")
                                .exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceeded")
                                .exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault")
                                .exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheClusterState")
                                .exceptionBuilderSupplier(InvalidCacheClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(CacheSubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotFeatureNotSupportedFault")
                                .exceptionBuilderSupplier(SnapshotFeatureNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSnapshotState")
                                .exceptionBuilderSupplier(InvalidSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyUnderMigrationFault")
                                .exceptionBuilderSupplier(ReplicationGroupAlreadyUnderMigrationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(CacheSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(CacheSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationGroupAlreadyExists")
                                .exceptionBuilderSupplier(ReplicationGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultUserAssociatedToUserGroup")
                                .exceptionBuilderSupplier(DefaultUserAssociatedToUserGroupException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombination")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidServerlessCacheSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidServerlessCacheSnapshotStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserState")
                                .exceptionBuilderSupplier(InvalidUserStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserGroupNotFound")
                                .exceptionBuilderSupplier(UserGroupNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault")
                                .exceptionBuilderSupplier(SnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserQuotaExceeded")
                                .exceptionBuilderSupplier(UserQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CacheSecurityGroupNotFound")
                                .exceptionBuilderSupplier(CacheSecurityGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCacheParameterGroupState")
                                .exceptionBuilderSupplier(InvalidCacheParameterGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded")
                                .exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(ElastiCacheException::builder).build();
    }

    @Override
    public final ElastiCacheServiceClientConfiguration serviceClientConfiguration() {
        return new ElastiCacheServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
