/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings to be applied to the Valkey or Redis OSS replication group, either immediately or during the next
 * maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroupPendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroupPendingModifiedValues.Builder, ReplicationGroupPendingModifiedValues> {
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryClusterId").getter(getter(ReplicationGroupPendingModifiedValues::primaryClusterId))
            .setter(setter(Builder::primaryClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()).build();

    private static final SdkField<String> AUTOMATIC_FAILOVER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomaticFailoverStatus")
            .getter(getter(ReplicationGroupPendingModifiedValues::automaticFailoverStatusAsString))
            .setter(setter(Builder::automaticFailoverStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverStatus").build())
            .build();

    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField
            .<ReshardingStatus> builder(MarshallingType.SDK_POJO).memberName("Resharding")
            .getter(getter(ReplicationGroupPendingModifiedValues::resharding)).setter(setter(Builder::resharding))
            .constructor(ReshardingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()).build();

    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthTokenStatus").getter(getter(ReplicationGroupPendingModifiedValues::authTokenStatusAsString))
            .setter(setter(Builder::authTokenStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()).build();

    private static final SdkField<UserGroupsUpdateStatus> USER_GROUPS_FIELD = SdkField
            .<UserGroupsUpdateStatus> builder(MarshallingType.SDK_POJO).memberName("UserGroups")
            .getter(getter(ReplicationGroupPendingModifiedValues::userGroups)).setter(setter(Builder::userGroups))
            .constructor(UserGroupsUpdateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroups").build()).build();

    private static final SdkField<List<PendingLogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<PendingLogDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("LogDeliveryConfigurations")
            .getter(getter(ReplicationGroupPendingModifiedValues::logDeliveryConfigurations))
            .setter(setter(Builder::logDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingLogDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingLogDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TransitEncryptionEnabled")
            .getter(getter(ReplicationGroupPendingModifiedValues::transitEncryptionEnabled))
            .setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build())
            .build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryptionMode")
            .getter(getter(ReplicationGroupPendingModifiedValues::transitEncryptionModeAsString))
            .setter(setter(Builder::transitEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build())
            .build();

    private static final SdkField<String> CLUSTER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterMode").getter(getter(ReplicationGroupPendingModifiedValues::clusterModeAsString))
            .setter(setter(Builder::clusterMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_CLUSTER_ID_FIELD,
            AUTOMATIC_FAILOVER_STATUS_FIELD, RESHARDING_FIELD, AUTH_TOKEN_STATUS_FIELD, USER_GROUPS_FIELD,
            LOG_DELIVERY_CONFIGURATIONS_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD,
            CLUSTER_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryClusterId;

    private final String automaticFailoverStatus;

    private final ReshardingStatus resharding;

    private final String authTokenStatus;

    private final UserGroupsUpdateStatus userGroups;

    private final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations;

    private final Boolean transitEncryptionEnabled;

    private final String transitEncryptionMode;

    private final String clusterMode;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
        this.resharding = builder.resharding;
        this.authTokenStatus = builder.authTokenStatus;
        this.userGroups = builder.userGroups;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.clusterMode = builder.clusterMode;
    }

    /**
     * <p>
     * The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or during
     * the next maintenance window.
     * </p>
     * 
     * @return The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified),
     *         or during the next maintenance window.
     */
    public final String primaryClusterId() {
        return primaryClusterId;
    }

    /**
     * <p>
     * Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticFailoverStatus} will return {@link PendingAutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #automaticFailoverStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
     * @see PendingAutomaticFailoverStatus
     */
    public final PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(automaticFailoverStatus);
    }

    /**
     * <p>
     * Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automaticFailoverStatus} will return {@link PendingAutomaticFailoverStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #automaticFailoverStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
     * @see PendingAutomaticFailoverStatus
     */
    public final String automaticFailoverStatusAsString() {
        return automaticFailoverStatus;
    }

    /**
     * <p>
     * The status of an online resharding operation.
     * </p>
     * 
     * @return The status of an online resharding operation.
     */
    public final ReshardingStatus resharding() {
        return resharding;
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public final AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(authTokenStatus);
    }

    /**
     * <p>
     * The auth token status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authTokenStatus}
     * will return {@link AuthTokenUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authTokenStatusAsString}.
     * </p>
     * 
     * @return The auth token status
     * @see AuthTokenUpdateStatus
     */
    public final String authTokenStatusAsString() {
        return authTokenStatus;
    }

    /**
     * <p>
     * The user group being modified.
     * </p>
     * 
     * @return The user group being modified.
     */
    public final UserGroupsUpdateStatus userGroups() {
        return userGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogDeliveryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLogDeliveryConfigurations() {
        return logDeliveryConfigurations != null && !(logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log delivery configurations being modified
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogDeliveryConfigurations} method.
     * </p>
     * 
     * @return The log delivery configurations being modified
     */
    public final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations() {
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to true.
     * </p>
     * 
     * @return A flag that enables in-transit encryption when set to true.
     */
    public final Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(transitEncryptionMode);
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitEncryptionMode} will return {@link TransitEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #transitEncryptionModeAsString}.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * @see TransitEncryptionMode
     */
    public final String transitEncryptionModeAsString() {
        return transitEncryptionMode;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode enabled
     * and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode enabled, you can
     * then complete cluster mode configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode
     *         enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode
     *         enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final ClusterMode clusterMode() {
        return ClusterMode.fromValue(clusterMode);
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode enabled
     * and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode enabled, you can
     * then complete cluster mode configuration and set the cluster mode to Enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterMode} will
     * return {@link ClusterMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterModeAsString}.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode
     *         enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode
     *         enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */
    public final String clusterModeAsString() {
        return clusterMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFailoverStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resharding());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues) obj;
        return Objects.equals(primaryClusterId(), other.primaryClusterId())
                && Objects.equals(automaticFailoverStatusAsString(), other.automaticFailoverStatusAsString())
                && Objects.equals(resharding(), other.resharding())
                && Objects.equals(authTokenStatusAsString(), other.authTokenStatusAsString())
                && Objects.equals(userGroups(), other.userGroups())
                && hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations()
                && Objects.equals(logDeliveryConfigurations(), other.logDeliveryConfigurations())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(transitEncryptionModeAsString(), other.transitEncryptionModeAsString())
                && Objects.equals(clusterModeAsString(), other.clusterModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationGroupPendingModifiedValues").add("PrimaryClusterId", primaryClusterId())
                .add("AutomaticFailoverStatus", automaticFailoverStatusAsString()).add("Resharding", resharding())
                .add("AuthTokenStatus", authTokenStatusAsString()).add("UserGroups", userGroups())
                .add("LogDeliveryConfigurations", hasLogDeliveryConfigurations() ? logDeliveryConfigurations() : null)
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("TransitEncryptionMode", transitEncryptionModeAsString()).add("ClusterMode", clusterModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryClusterId":
            return Optional.ofNullable(clazz.cast(primaryClusterId()));
        case "AutomaticFailoverStatus":
            return Optional.ofNullable(clazz.cast(automaticFailoverStatusAsString()));
        case "Resharding":
            return Optional.ofNullable(clazz.cast(resharding()));
        case "AuthTokenStatus":
            return Optional.ofNullable(clazz.cast(authTokenStatusAsString()));
        case "UserGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "LogDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(logDeliveryConfigurations()));
        case "TransitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "TransitEncryptionMode":
            return Optional.ofNullable(clazz.cast(transitEncryptionModeAsString()));
        case "ClusterMode":
            return Optional.ofNullable(clazz.cast(clusterModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupPendingModifiedValues, T> g) {
        return obj -> g.apply((ReplicationGroupPendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        /**
         * <p>
         * The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or
         * during the next maintenance window.
         * </p>
         * 
         * @param primaryClusterId
         *        The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was
         *        specified), or during the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryClusterId(String primaryClusterId);

        /**
         * <p>
         * Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
         * </p>
         * 
         * @param automaticFailoverStatus
         *        Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
         * @see PendingAutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAutomaticFailoverStatus
         */
        Builder automaticFailoverStatus(String automaticFailoverStatus);

        /**
         * <p>
         * Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
         * </p>
         * 
         * @param automaticFailoverStatus
         *        Indicates the status of automatic failover for this Valkey or Redis OSS replication group.
         * @see PendingAutomaticFailoverStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAutomaticFailoverStatus
         */
        Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus);

        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * 
         * @param resharding
         *        The status of an online resharding operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resharding(ReshardingStatus resharding);

        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReshardingStatus.Builder} avoiding the
         * need to create one manually via {@link ReshardingStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReshardingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #resharding(ReshardingStatus)}.
         * 
         * @param resharding
         *        a consumer that will call methods on {@link ReshardingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resharding(ReshardingStatus)
         */
        default Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return resharding(ReshardingStatus.builder().applyMutation(resharding).build());
        }

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(String authTokenStatus);

        /**
         * <p>
         * The auth token status
         * </p>
         * 
         * @param authTokenStatus
         *        The auth token status
         * @see AuthTokenUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTokenUpdateStatus
         */
        Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus);

        /**
         * <p>
         * The user group being modified.
         * </p>
         * 
         * @param userGroups
         *        The user group being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(UserGroupsUpdateStatus userGroups);

        /**
         * <p>
         * The user group being modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserGroupsUpdateStatus.Builder} avoiding
         * the need to create one manually via {@link UserGroupsUpdateStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserGroupsUpdateStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #userGroups(UserGroupsUpdateStatus)}.
         * 
         * @param userGroups
         *        a consumer that will call methods on {@link UserGroupsUpdateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userGroups(UserGroupsUpdateStatus)
         */
        default Builder userGroups(Consumer<UserGroupsUpdateStatus.Builder> userGroups) {
            return userGroups(UserGroupsUpdateStatus.builder().applyMutation(userGroups).build());
        }

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        The log delivery configurations being modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations);

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * 
         * @param logDeliveryConfigurations
         *        The log delivery configurations being modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration... logDeliveryConfigurations);

        /**
         * <p>
         * The log delivery configurations being modified
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #logDeliveryConfigurations(List<PendingLogDeliveryConfiguration>)}.
         * 
         * @param logDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfigurations(java.util.Collection<PendingLogDeliveryConfiguration>)
         */
        Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder>... logDeliveryConfigurations);

        /**
         * <p>
         * A flag that enables in-transit encryption when set to true.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        A flag that enables in-transit encryption when set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(String transitEncryptionMode);

        /**
         * <p>
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * </p>
         * 
         * @param transitEncryptionMode
         *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         * @see TransitEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitEncryptionMode
         */
        Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode
         * enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode
         * enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both
         *        cluster mode enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to
         *        use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to
         *        Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(String clusterMode);

        /**
         * <p>
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
         * Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode
         * enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode
         * enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
         * </p>
         * 
         * @param clusterMode
         *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster
         *        mode to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both
         *        cluster mode enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to
         *        use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to
         *        Enabled.
         * @see ClusterMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterMode
         */
        Builder clusterMode(ClusterMode clusterMode);
    }

    static final class BuilderImpl implements Builder {
        private String primaryClusterId;

        private String automaticFailoverStatus;

        private ReshardingStatus resharding;

        private String authTokenStatus;

        private UserGroupsUpdateStatus userGroups;

        private List<PendingLogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean transitEncryptionEnabled;

        private String transitEncryptionMode;

        private String clusterMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            primaryClusterId(model.primaryClusterId);
            automaticFailoverStatus(model.automaticFailoverStatus);
            resharding(model.resharding);
            authTokenStatus(model.authTokenStatus);
            userGroups(model.userGroups);
            logDeliveryConfigurations(model.logDeliveryConfigurations);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            transitEncryptionMode(model.transitEncryptionMode);
            clusterMode(model.clusterMode);
        }

        public final String getPrimaryClusterId() {
            return primaryClusterId;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final String getAutomaticFailoverStatus() {
            return automaticFailoverStatus;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus == null ? null : automaticFailoverStatus.toString());
            return this;
        }

        public final ReshardingStatus.Builder getResharding() {
            return resharding != null ? resharding.toBuilder() : null;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final String getAuthTokenStatus() {
            return authTokenStatus;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final UserGroupsUpdateStatus.Builder getUserGroups() {
            return userGroups != null ? userGroups.toBuilder() : null;
        }

        public final void setUserGroups(UserGroupsUpdateStatus.BuilderImpl userGroups) {
            this.userGroups = userGroups != null ? userGroups.build() : null;
        }

        @Override
        public final Builder userGroups(UserGroupsUpdateStatus userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public final List<PendingLogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<PendingLogDeliveryConfiguration.Builder> result = PendingLogDeliveryConfigurationListCopier
                    .copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(
                Collection<PendingLogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration... logDeliveryConfigurations) {
            logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(
                Consumer<PendingLogDeliveryConfiguration.Builder>... logDeliveryConfigurations) {
            logDeliveryConfigurations(Stream.of(logDeliveryConfigurations)
                    .map(c -> PendingLogDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final String getTransitEncryptionMode() {
            return transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final String getClusterMode() {
            return clusterMode;
        }

        public final void setClusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
        }

        @Override
        public final Builder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        @Override
        public final Builder clusterMode(ClusterMode clusterMode) {
            this.clusterMode(clusterMode == null ? null : clusterMode.toString());
            return this;
        }

        @Override
        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
