/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServerlessCacheSnapshotRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DeleteServerlessCacheSnapshotRequest.Builder, DeleteServerlessCacheSnapshotRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheSnapshotName")
            .getter(getter(DeleteServerlessCacheSnapshotRequest::serverlessCacheSnapshotName))
            .setter(setter(Builder::serverlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD));

    private final String serverlessCacheSnapshotName;

    private DeleteServerlessCacheSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * Idenfitier of the snapshot to be deleted. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return Idenfitier of the snapshot to be deleted. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String serverlessCacheSnapshotName() {
        return serverlessCacheSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServerlessCacheSnapshotRequest)) {
            return false;
        }
        DeleteServerlessCacheSnapshotRequest other = (DeleteServerlessCacheSnapshotRequest) obj;
        return Objects.equals(serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteServerlessCacheSnapshotRequest")
                .add("ServerlessCacheSnapshotName", serverlessCacheSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServerlessCacheSnapshotRequest, T> g) {
        return obj -> g.apply((DeleteServerlessCacheSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServerlessCacheSnapshotRequest> {
        /**
         * <p>
         * Idenfitier of the snapshot to be deleted. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheSnapshotName
         *        Idenfitier of the snapshot to be deleted. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServerlessCacheSnapshotRequest model) {
            super(model);
            serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
        }

        public final String getServerlessCacheSnapshotName() {
            return serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServerlessCacheSnapshotRequest build() {
            return new DeleteServerlessCacheSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
