/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServerlessCacheSnapshotsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeServerlessCacheSnapshotsRequest.Builder, DescribeServerlessCacheSnapshotsRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(DescribeServerlessCacheSnapshotsRequest::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheSnapshotName")
            .getter(getter(DescribeServerlessCacheSnapshotsRequest::serverlessCacheSnapshotName))
            .setter(setter(Builder::serverlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName")
                    .build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(DescribeServerlessCacheSnapshotsRequest::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServerlessCacheSnapshotsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeServerlessCacheSnapshotsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, SNAPSHOT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String serverlessCacheName;

    private final String serverlessCacheSnapshotName;

    private final String snapshotType;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeServerlessCacheSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
        this.snapshotType = builder.snapshotType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of serverless cache. If this parameter is specified, only snapshots associated with that specific
     * serverless cache are described. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The identifier of serverless cache. If this parameter is specified, only snapshots associated with that
     *         specific serverless cache are described. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * The identifier of the serverless cache’s snapshot. If this parameter is specified, only this snapshot is
     * described. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The identifier of the serverless cache’s snapshot. If this parameter is specified, only this snapshot is
     *         described. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String serverlessCacheSnapshotName() {
        return serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * The type of snapshot that is being described. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The type of snapshot that is being described. Available for Valkey, Redis OSS and Serverless Memcached
     *         only.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * An optional marker returned from a prior request to support pagination of results from this operation. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * max-results. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return An optional marker returned from a prior request to support pagination of results from this operation. If
     *         this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by max-results. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified max-results
     * value, a market is included in the response so that remaining results can be retrieved. Available for Valkey,
     * Redis OSS and Serverless Memcached only.The default is 50. The Validation Constraints are a maximum of 50.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         max-results value, a market is included in the response so that remaining results can be retrieved.
     *         Available for Valkey, Redis OSS and Serverless Memcached only.The default is 50. The Validation
     *         Constraints are a maximum of 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCacheSnapshotsRequest)) {
            return false;
        }
        DescribeServerlessCacheSnapshotsRequest other = (DescribeServerlessCacheSnapshotsRequest) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServerlessCacheSnapshotsRequest").add("ServerlessCacheName", serverlessCacheName())
                .add("ServerlessCacheSnapshotName", serverlessCacheSnapshotName()).add("SnapshotType", snapshotType())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "ServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshotName()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCacheSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeServerlessCacheSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServerlessCacheSnapshotsRequest> {
        /**
         * <p>
         * The identifier of serverless cache. If this parameter is specified, only snapshots associated with that
         * specific serverless cache are described. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheName
         *        The identifier of serverless cache. If this parameter is specified, only snapshots associated with
         *        that specific serverless cache are described. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * The identifier of the serverless cache’s snapshot. If this parameter is specified, only this snapshot is
         * described. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheSnapshotName
         *        The identifier of the serverless cache’s snapshot. If this parameter is specified, only this snapshot
         *        is described. Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName);

        /**
         * <p>
         * The type of snapshot that is being described. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param snapshotType
         *        The type of snapshot that is being described. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * An optional marker returned from a prior request to support pagination of results from this operation. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by max-results. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param nextToken
         *        An optional marker returned from a prior request to support pagination of results from this operation.
         *        If this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by max-results. Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * max-results value, a market is included in the response so that remaining results can be retrieved. Available
         * for Valkey, Redis OSS and Serverless Memcached only.The default is 50. The Validation Constraints are a
         * maximum of 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        max-results value, a market is included in the response so that remaining results can be retrieved.
         *        Available for Valkey, Redis OSS and Serverless Memcached only.The default is 50. The Validation
         *        Constraints are a maximum of 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheName;

        private String serverlessCacheSnapshotName;

        private String snapshotType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCacheSnapshotsRequest model) {
            super(model);
            serverlessCacheName(model.serverlessCacheName);
            serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
            snapshotType(model.snapshotType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getServerlessCacheSnapshotName() {
            return serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServerlessCacheSnapshotsRequest build() {
            return new DescribeServerlessCacheSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
