/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyServerlessCacheRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<ModifyServerlessCacheRequest.Builder, ModifyServerlessCacheRequest> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(ModifyServerlessCacheRequest::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModifyServerlessCacheRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField
            .<CacheUsageLimits> builder(MarshallingType.SDK_POJO).memberName("CacheUsageLimits")
            .getter(getter(ModifyServerlessCacheRequest::cacheUsageLimits)).setter(setter(Builder::cacheUsageLimits))
            .constructor(CacheUsageLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()).build();

    private static final SdkField<Boolean> REMOVE_USER_GROUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveUserGroup").getter(getter(ModifyServerlessCacheRequest::removeUserGroup))
            .setter(setter(Builder::removeUserGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveUserGroup").build()).build();

    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(ModifyServerlessCacheRequest::userGroupId))
            .setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ModifyServerlessCacheRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ModifyServerlessCacheRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DailySnapshotTime").getter(getter(ModifyServerlessCacheRequest::dailySnapshotTime))
            .setter(setter(Builder::dailySnapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ModifyServerlessCacheRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(ModifyServerlessCacheRequest::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            DESCRIPTION_FIELD, CACHE_USAGE_LIMITS_FIELD, REMOVE_USER_GROUP_FIELD, USER_GROUP_ID_FIELD, SECURITY_GROUP_IDS_FIELD,
            SNAPSHOT_RETENTION_LIMIT_FIELD, DAILY_SNAPSHOT_TIME_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD));

    private final String serverlessCacheName;

    private final String description;

    private final CacheUsageLimits cacheUsageLimits;

    private final Boolean removeUserGroup;

    private final String userGroupId;

    private final List<String> securityGroupIds;

    private final Integer snapshotRetentionLimit;

    private final String dailySnapshotTime;

    private final String engine;

    private final String majorEngineVersion;

    private ModifyServerlessCacheRequest(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.removeUserGroup = builder.removeUserGroup;
        this.userGroupId = builder.userGroupId;
        this.securityGroupIds = builder.securityGroupIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
    }

    /**
     * <p>
     * User-provided identifier for the serverless cache to be modified.
     * </p>
     * 
     * @return User-provided identifier for the serverless cache to be modified.
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * User provided description for the serverless cache. Default = NULL, i.e. the existing description is not
     * removed/modified. The description has a maximum length of 255 characters.
     * </p>
     * 
     * @return User provided description for the serverless cache. Default = NULL, i.e. the existing description is not
     *         removed/modified. The description has a maximum length of 255 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Modify the cache usage limit for the serverless cache.
     * </p>
     * 
     * @return Modify the cache usage limit for the serverless cache.
     */
    public final CacheUsageLimits cacheUsageLimits() {
        return cacheUsageLimits;
    }

    /**
     * <p>
     * The identifier of the UserGroup to be removed from association with the Valkey and Redis OSS serverless cache.
     * Available for Valkey and Redis OSS only. Default is NULL.
     * </p>
     * 
     * @return The identifier of the UserGroup to be removed from association with the Valkey and Redis OSS serverless
     *         cache. Available for Valkey and Redis OSS only. Default is NULL.
     */
    public final Boolean removeUserGroup() {
        return removeUserGroup;
    }

    /**
     * <p>
     * The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and Redis OSS
     * only. Default is NULL - the existing UserGroup is not removed.
     * </p>
     * 
     * @return The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and
     *         Redis OSS only. Default is NULL - the existing UserGroup is not removed.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new list of VPC security groups to be associated with the serverless cache. Populating this list means the
     * current VPC security groups will be removed. This security group is used to authorize traffic access for the VPC
     * end-point (private-link). Default = NULL - the existing list of VPC security groups is not removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The new list of VPC security groups to be associated with the serverless cache. Populating this list
     *         means the current VPC security groups will be removed. This security group is used to authorize traffic
     *         access for the VPC end-point (private-link). Default = NULL - the existing list of VPC security groups is
     *         not removed.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The number of days for which Elasticache retains automatic snapshots before deleting them. Available for Valkey,
     * Redis OSS and Serverless Memcached only. Default = NULL, i.e. the existing snapshot-retention-limit will not be
     * removed or modified. The maximum value allowed is 35 days.
     * </p>
     * 
     * @return The number of days for which Elasticache retains automatic snapshots before deleting them. Available for
     *         Valkey, Redis OSS and Serverless Memcached only. Default = NULL, i.e. the existing
     *         snapshot-retention-limit will not be removed or modified. The maximum value allowed is 35 days.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time during which Elasticache begins taking a daily snapshot of the serverless cache. Available for
     * Valkey, Redis OSS and Serverless Memcached only. The default is NULL, i.e. the existing snapshot time configured
     * for the cluster is not removed.
     * </p>
     * 
     * @return The daily time during which Elasticache begins taking a daily snapshot of the serverless cache. Available
     *         for Valkey, Redis OSS and Serverless Memcached only. The default is NULL, i.e. the existing snapshot time
     *         configured for the cluster is not removed.
     */
    public final String dailySnapshotTime() {
        return dailySnapshotTime;
    }

    /**
     * <p>
     * Modifies the engine listed in a serverless cache request. The options are redis, memcached or valkey.
     * </p>
     * 
     * @return Modifies the engine listed in a serverless cache request. The options are redis, memcached or valkey.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Modifies the engine vesion listed in a serverless cache request.
     * </p>
     * 
     * @return Modifies the engine vesion listed in a serverless cache request.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(removeUserGroup());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(dailySnapshotTime());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyServerlessCacheRequest)) {
            return false;
        }
        ModifyServerlessCacheRequest other = (ModifyServerlessCacheRequest) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(description(), other.description())
                && Objects.equals(cacheUsageLimits(), other.cacheUsageLimits())
                && Objects.equals(removeUserGroup(), other.removeUserGroup())
                && Objects.equals(userGroupId(), other.userGroupId()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(dailySnapshotTime(), other.dailySnapshotTime()) && Objects.equals(engine(), other.engine())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyServerlessCacheRequest").add("ServerlessCacheName", serverlessCacheName())
                .add("Description", description()).add("CacheUsageLimits", cacheUsageLimits())
                .add("RemoveUserGroup", removeUserGroup()).add("UserGroupId", userGroupId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("DailySnapshotTime", dailySnapshotTime())
                .add("Engine", engine()).add("MajorEngineVersion", majorEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CacheUsageLimits":
            return Optional.ofNullable(clazz.cast(cacheUsageLimits()));
        case "RemoveUserGroup":
            return Optional.ofNullable(clazz.cast(removeUserGroup()));
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "DailySnapshotTime":
            return Optional.ofNullable(clazz.cast(dailySnapshotTime()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyServerlessCacheRequest, T> g) {
        return obj -> g.apply((ModifyServerlessCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyServerlessCacheRequest> {
        /**
         * <p>
         * User-provided identifier for the serverless cache to be modified.
         * </p>
         * 
         * @param serverlessCacheName
         *        User-provided identifier for the serverless cache to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * User provided description for the serverless cache. Default = NULL, i.e. the existing description is not
         * removed/modified. The description has a maximum length of 255 characters.
         * </p>
         * 
         * @param description
         *        User provided description for the serverless cache. Default = NULL, i.e. the existing description is
         *        not removed/modified. The description has a maximum length of 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Modify the cache usage limit for the serverless cache.
         * </p>
         * 
         * @param cacheUsageLimits
         *        Modify the cache usage limit for the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits);

        /**
         * <p>
         * Modify the cache usage limit for the serverless cache.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheUsageLimits.Builder} avoiding the
         * need to create one manually via {@link CacheUsageLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheUsageLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheUsageLimits(CacheUsageLimits)}.
         * 
         * @param cacheUsageLimits
         *        a consumer that will call methods on {@link CacheUsageLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheUsageLimits(CacheUsageLimits)
         */
        default Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return cacheUsageLimits(CacheUsageLimits.builder().applyMutation(cacheUsageLimits).build());
        }

        /**
         * <p>
         * The identifier of the UserGroup to be removed from association with the Valkey and Redis OSS serverless
         * cache. Available for Valkey and Redis OSS only. Default is NULL.
         * </p>
         * 
         * @param removeUserGroup
         *        The identifier of the UserGroup to be removed from association with the Valkey and Redis OSS
         *        serverless cache. Available for Valkey and Redis OSS only. Default is NULL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeUserGroup(Boolean removeUserGroup);

        /**
         * <p>
         * The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and Redis
         * OSS only. Default is NULL - the existing UserGroup is not removed.
         * </p>
         * 
         * @param userGroupId
         *        The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and
         *        Redis OSS only. Default is NULL - the existing UserGroup is not removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * The new list of VPC security groups to be associated with the serverless cache. Populating this list means
         * the current VPC security groups will be removed. This security group is used to authorize traffic access for
         * the VPC end-point (private-link). Default = NULL - the existing list of VPC security groups is not removed.
         * </p>
         * 
         * @param securityGroupIds
         *        The new list of VPC security groups to be associated with the serverless cache. Populating this list
         *        means the current VPC security groups will be removed. This security group is used to authorize
         *        traffic access for the VPC end-point (private-link). Default = NULL - the existing list of VPC
         *        security groups is not removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The new list of VPC security groups to be associated with the serverless cache. Populating this list means
         * the current VPC security groups will be removed. This security group is used to authorize traffic access for
         * the VPC end-point (private-link). Default = NULL - the existing list of VPC security groups is not removed.
         * </p>
         * 
         * @param securityGroupIds
         *        The new list of VPC security groups to be associated with the serverless cache. Populating this list
         *        means the current VPC security groups will be removed. This security group is used to authorize
         *        traffic access for the VPC end-point (private-link). Default = NULL - the existing list of VPC
         *        security groups is not removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The number of days for which Elasticache retains automatic snapshots before deleting them. Available for
         * Valkey, Redis OSS and Serverless Memcached only. Default = NULL, i.e. the existing snapshot-retention-limit
         * will not be removed or modified. The maximum value allowed is 35 days.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which Elasticache retains automatic snapshots before deleting them. Available
         *        for Valkey, Redis OSS and Serverless Memcached only. Default = NULL, i.e. the existing
         *        snapshot-retention-limit will not be removed or modified. The maximum value allowed is 35 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time during which Elasticache begins taking a daily snapshot of the serverless cache. Available for
         * Valkey, Redis OSS and Serverless Memcached only. The default is NULL, i.e. the existing snapshot time
         * configured for the cluster is not removed.
         * </p>
         * 
         * @param dailySnapshotTime
         *        The daily time during which Elasticache begins taking a daily snapshot of the serverless cache.
         *        Available for Valkey, Redis OSS and Serverless Memcached only. The default is NULL, i.e. the existing
         *        snapshot time configured for the cluster is not removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySnapshotTime(String dailySnapshotTime);

        /**
         * <p>
         * Modifies the engine listed in a serverless cache request. The options are redis, memcached or valkey.
         * </p>
         * 
         * @param engine
         *        Modifies the engine listed in a serverless cache request. The options are redis, memcached or valkey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Modifies the engine vesion listed in a serverless cache request.
         * </p>
         * 
         * @param majorEngineVersion
         *        Modifies the engine vesion listed in a serverless cache request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serverlessCacheName;

        private String description;

        private CacheUsageLimits cacheUsageLimits;

        private Boolean removeUserGroup;

        private String userGroupId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Integer snapshotRetentionLimit;

        private String dailySnapshotTime;

        private String engine;

        private String majorEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyServerlessCacheRequest model) {
            super(model);
            serverlessCacheName(model.serverlessCacheName);
            description(model.description);
            cacheUsageLimits(model.cacheUsageLimits);
            removeUserGroup(model.removeUserGroup);
            userGroupId(model.userGroupId);
            securityGroupIds(model.securityGroupIds);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            dailySnapshotTime(model.dailySnapshotTime);
            engine(model.engine);
            majorEngineVersion(model.majorEngineVersion);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return cacheUsageLimits != null ? cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final Boolean getRemoveUserGroup() {
            return removeUserGroup;
        }

        public final void setRemoveUserGroup(Boolean removeUserGroup) {
            this.removeUserGroup = removeUserGroup;
        }

        @Override
        public final Builder removeUserGroup(Boolean removeUserGroup) {
            this.removeUserGroup = removeUserGroup;
            return this;
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyServerlessCacheRequest build() {
            return new ModifyServerlessCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
