/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.DataStorage;
import software.amazon.awssdk.services.elasticache.model.ECPUPerSecond;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheUsageLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheUsageLimits> {
    private static final SdkField<DataStorage> DATA_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStorage").getter(CacheUsageLimits.getter(CacheUsageLimits::dataStorage)).setter(CacheUsageLimits.setter(Builder::dataStorage)).constructor(DataStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()}).build();
    private static final SdkField<ECPUPerSecond> ECPU_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ECPUPerSecond").getter(CacheUsageLimits.getter(CacheUsageLimits::ecpuPerSecond)).setter(CacheUsageLimits.setter(Builder::ecpuPerSecond)).constructor(ECPUPerSecond::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ECPUPerSecond").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_STORAGE_FIELD, ECPU_PER_SECOND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheUsageLimits.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataStorage dataStorage;
    private final ECPUPerSecond ecpuPerSecond;

    private CacheUsageLimits(BuilderImpl builder) {
        this.dataStorage = builder.dataStorage;
        this.ecpuPerSecond = builder.ecpuPerSecond;
    }

    public final DataStorage dataStorage() {
        return this.dataStorage;
    }

    public final ECPUPerSecond ecpuPerSecond() {
        return this.ecpuPerSecond;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecpuPerSecond());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheUsageLimits)) {
            return false;
        }
        CacheUsageLimits other = (CacheUsageLimits)obj;
        return Objects.equals(this.dataStorage(), other.dataStorage()) && Objects.equals(this.ecpuPerSecond(), other.ecpuPerSecond());
    }

    public final String toString() {
        return ToString.builder((String)"CacheUsageLimits").add("DataStorage", (Object)this.dataStorage()).add("ECPUPerSecond", (Object)this.ecpuPerSecond()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataStorage": {
                return Optional.ofNullable(clazz.cast(this.dataStorage()));
            }
            case "ECPUPerSecond": {
                return Optional.ofNullable(clazz.cast(this.ecpuPerSecond()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataStorage", DATA_STORAGE_FIELD);
        map.put("ECPUPerSecond", ECPU_PER_SECOND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheUsageLimits, T> g) {
        return obj -> g.apply((CacheUsageLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataStorage dataStorage;
        private ECPUPerSecond ecpuPerSecond;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheUsageLimits model) {
            this.dataStorage(model.dataStorage);
            this.ecpuPerSecond(model.ecpuPerSecond);
        }

        public final DataStorage.Builder getDataStorage() {
            return this.dataStorage != null ? this.dataStorage.toBuilder() : null;
        }

        public final void setDataStorage(DataStorage.BuilderImpl dataStorage) {
            this.dataStorage = dataStorage != null ? dataStorage.build() : null;
        }

        @Override
        public final Builder dataStorage(DataStorage dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final ECPUPerSecond.Builder getEcpuPerSecond() {
            return this.ecpuPerSecond != null ? this.ecpuPerSecond.toBuilder() : null;
        }

        public final void setEcpuPerSecond(ECPUPerSecond.BuilderImpl ecpuPerSecond) {
            this.ecpuPerSecond = ecpuPerSecond != null ? ecpuPerSecond.build() : null;
        }

        @Override
        public final Builder ecpuPerSecond(ECPUPerSecond ecpuPerSecond) {
            this.ecpuPerSecond = ecpuPerSecond;
            return this;
        }

        public CacheUsageLimits build() {
            return new CacheUsageLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheUsageLimits> {
        public Builder dataStorage(DataStorage var1);

        default public Builder dataStorage(Consumer<DataStorage.Builder> dataStorage) {
            return this.dataStorage((DataStorage)((DataStorage.Builder)DataStorage.builder().applyMutation(dataStorage)).build());
        }

        public Builder ecpuPerSecond(ECPUPerSecond var1);

        default public Builder ecpuPerSecond(Consumer<ECPUPerSecond.Builder> ecpuPerSecond) {
            return this.ecpuPerSecond((ECPUPerSecond)((ECPUPerSecond.Builder)ECPUPerSecond.builder().applyMutation(ecpuPerSecond)).build());
        }
    }
}

