/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of one of the following operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AuthorizeCacheSecurityGroupIngress</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateCacheSecurityGroup</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RevokeCacheSecurityGroupIngress</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheSecurityGroup.Builder, CacheSecurityGroup> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(CacheSecurityGroup::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSecurityGroupName").getter(getter(CacheSecurityGroup::cacheSecurityGroupName))
            .setter(setter(Builder::cacheSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CacheSecurityGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField
            .<List<EC2SecurityGroup>> builder(MarshallingType.LIST)
            .memberName("EC2SecurityGroups")
            .getter(getter(CacheSecurityGroup::ec2SecurityGroups))
            .setter(setter(Builder::ec2SecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EC2SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<EC2SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EC2SecurityGroup").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(CacheSecurityGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            CACHE_SECURITY_GROUP_NAME_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUPS_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String cacheSecurityGroupName;

    private final String description;

    private final List<EC2SecurityGroup> ec2SecurityGroups;

    private final String arn;

    private CacheSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The Amazon account ID of the cache security group owner.
     * </p>
     * 
     * @return The Amazon account ID of the cache security group owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The name of the cache security group.
     * </p>
     * 
     * @return The name of the cache security group.
     */
    public final String cacheSecurityGroupName() {
        return cacheSecurityGroupName;
    }

    /**
     * <p>
     * The description of the cache security group.
     * </p>
     * 
     * @return The description of the cache security group.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2SecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SecurityGroups() {
        return ec2SecurityGroups != null && !(ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon EC2 security groups that are associated with this cache security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SecurityGroups} method.
     * </p>
     * 
     * @return A list of Amazon EC2 security groups that are associated with this cache security group.
     */
    public final List<EC2SecurityGroup> ec2SecurityGroups() {
        return ec2SecurityGroups;
    }

    /**
     * <p>
     * The ARN of the cache security group,
     * </p>
     * 
     * @return The ARN of the cache security group,
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SecurityGroups() ? ec2SecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSecurityGroup)) {
            return false;
        }
        CacheSecurityGroup other = (CacheSecurityGroup) obj;
        return Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(cacheSecurityGroupName(), other.cacheSecurityGroupName())
                && Objects.equals(description(), other.description()) && hasEc2SecurityGroups() == other.hasEc2SecurityGroups()
                && Objects.equals(ec2SecurityGroups(), other.ec2SecurityGroups()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheSecurityGroup").add("OwnerId", ownerId())
                .add("CacheSecurityGroupName", cacheSecurityGroupName()).add("Description", description())
                .add("EC2SecurityGroups", hasEc2SecurityGroups() ? ec2SecurityGroups() : null).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CacheSecurityGroupName":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EC2SecurityGroups":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroups()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("CacheSecurityGroupName", CACHE_SECURITY_GROUP_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EC2SecurityGroups", EC2_SECURITY_GROUPS_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheSecurityGroup, T> g) {
        return obj -> g.apply((CacheSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheSecurityGroup> {
        /**
         * <p>
         * The Amazon account ID of the cache security group owner.
         * </p>
         * 
         * @param ownerId
         *        The Amazon account ID of the cache security group owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The name of the cache security group.
         * </p>
         * 
         * @param cacheSecurityGroupName
         *        The name of the cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupName(String cacheSecurityGroupName);

        /**
         * <p>
         * The description of the cache security group.
         * </p>
         * 
         * @param description
         *        The description of the cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of Amazon EC2 security groups that are associated with this cache security group.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        A list of Amazon EC2 security groups that are associated with this cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups);

        /**
         * <p>
         * A list of Amazon EC2 security groups that are associated with this cache security group.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        A list of Amazon EC2 security groups that are associated with this cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups);

        /**
         * <p>
         * A list of Amazon EC2 security groups that are associated with this cache security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2SecurityGroups(List<EC2SecurityGroup>)}.
         * 
         * @param ec2SecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2SecurityGroups(java.util.Collection<EC2SecurityGroup>)
         */
        Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups);

        /**
         * <p>
         * The ARN of the cache security group,
         * </p>
         * 
         * @param arn
         *        The ARN of the cache security group,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String cacheSecurityGroupName;

        private String description;

        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSecurityGroup model) {
            ownerId(model.ownerId);
            cacheSecurityGroupName(model.cacheSecurityGroupName);
            description(model.description);
            ec2SecurityGroups(model.ec2SecurityGroups);
            arn(model.arn);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCacheSecurityGroupName() {
            return cacheSecurityGroupName;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            List<EC2SecurityGroup.Builder> result = EC2SecurityGroupListCopier.copyToBuilder(this.ec2SecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups) {
            ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups) {
            ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> EC2SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public CacheSecurityGroup build() {
            return new CacheSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
