/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerlessCacheResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<CreateServerlessCacheResponse.Builder, CreateServerlessCacheResponse> {
    private static final SdkField<ServerlessCache> SERVERLESS_CACHE_FIELD = SdkField
            .<ServerlessCache> builder(MarshallingType.SDK_POJO).memberName("ServerlessCache")
            .getter(getter(CreateServerlessCacheResponse::serverlessCache)).setter(setter(Builder::serverlessCache))
            .constructor(ServerlessCache::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCache").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServerlessCache serverlessCache;

    private CreateServerlessCacheResponse(BuilderImpl builder) {
        super(builder);
        this.serverlessCache = builder.serverlessCache;
    }

    /**
     * <p>
     * The response for the attempt to create the serverless cache.
     * </p>
     * 
     * @return The response for the attempt to create the serverless cache.
     */
    public final ServerlessCache serverlessCache() {
        return serverlessCache;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCache());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerlessCacheResponse)) {
            return false;
        }
        CreateServerlessCacheResponse other = (CreateServerlessCacheResponse) obj;
        return Objects.equals(serverlessCache(), other.serverlessCache());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServerlessCacheResponse").add("ServerlessCache", serverlessCache()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCache":
            return Optional.ofNullable(clazz.cast(serverlessCache()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessCache", SERVERLESS_CACHE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServerlessCacheResponse, T> g) {
        return obj -> g.apply((CreateServerlessCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServerlessCacheResponse> {
        /**
         * <p>
         * The response for the attempt to create the serverless cache.
         * </p>
         * 
         * @param serverlessCache
         *        The response for the attempt to create the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCache(ServerlessCache serverlessCache);

        /**
         * <p>
         * The response for the attempt to create the serverless cache.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerlessCache.Builder} avoiding the
         * need to create one manually via {@link ServerlessCache#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessCache.Builder#build()} is called immediately and its
         * result is passed to {@link #serverlessCache(ServerlessCache)}.
         * 
         * @param serverlessCache
         *        a consumer that will call methods on {@link ServerlessCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessCache(ServerlessCache)
         */
        default Builder serverlessCache(Consumer<ServerlessCache.Builder> serverlessCache) {
            return serverlessCache(ServerlessCache.builder().applyMutation(serverlessCache).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private ServerlessCache serverlessCache;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerlessCacheResponse model) {
            super(model);
            serverlessCache(model.serverlessCache);
        }

        public final ServerlessCache.Builder getServerlessCache() {
            return serverlessCache != null ? serverlessCache.toBuilder() : null;
        }

        public final void setServerlessCache(ServerlessCache.BuilderImpl serverlessCache) {
            this.serverlessCache = serverlessCache != null ? serverlessCache.build() : null;
        }

        @Override
        public final Builder serverlessCache(ServerlessCache serverlessCache) {
            this.serverlessCache = serverlessCache;
            return this;
        }

        @Override
        public CreateServerlessCacheResponse build() {
            return new CreateServerlessCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
