/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerlessCacheSnapshotResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<CreateServerlessCacheSnapshotResponse.Builder, CreateServerlessCacheSnapshotResponse> {
    private static final SdkField<ServerlessCacheSnapshot> SERVERLESS_CACHE_SNAPSHOT_FIELD = SdkField
            .<ServerlessCacheSnapshot> builder(MarshallingType.SDK_POJO).memberName("ServerlessCacheSnapshot")
            .getter(getter(CreateServerlessCacheSnapshotResponse::serverlessCacheSnapshot))
            .setter(setter(Builder::serverlessCacheSnapshot)).constructor(ServerlessCacheSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshot").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVERLESS_CACHE_SNAPSHOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServerlessCacheSnapshot serverlessCacheSnapshot;

    private CreateServerlessCacheSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.serverlessCacheSnapshot = builder.serverlessCacheSnapshot;
    }

    /**
     * <p>
     * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Valkey,
     * Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
     *         Valkey, Redis OSS and Serverless Memcached only.
     */
    public final ServerlessCacheSnapshot serverlessCacheSnapshot() {
        return serverlessCacheSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerlessCacheSnapshotResponse)) {
            return false;
        }
        CreateServerlessCacheSnapshotResponse other = (CreateServerlessCacheSnapshotResponse) obj;
        return Objects.equals(serverlessCacheSnapshot(), other.serverlessCacheSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServerlessCacheSnapshotResponse")
                .add("ServerlessCacheSnapshot", serverlessCacheSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheSnapshot":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessCacheSnapshot", SERVERLESS_CACHE_SNAPSHOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServerlessCacheSnapshotResponse, T> g) {
        return obj -> g.apply((CreateServerlessCacheSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServerlessCacheSnapshotResponse> {
        /**
         * <p>
         * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
         * Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheSnapshot
         *        The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available
         *        for Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshot(ServerlessCacheSnapshot serverlessCacheSnapshot);

        /**
         * <p>
         * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
         * Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerlessCacheSnapshot.Builder} avoiding
         * the need to create one manually via {@link ServerlessCacheSnapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessCacheSnapshot.Builder#build()} is called immediately
         * and its result is passed to {@link #serverlessCacheSnapshot(ServerlessCacheSnapshot)}.
         * 
         * @param serverlessCacheSnapshot
         *        a consumer that will call methods on {@link ServerlessCacheSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessCacheSnapshot(ServerlessCacheSnapshot)
         */
        default Builder serverlessCacheSnapshot(Consumer<ServerlessCacheSnapshot.Builder> serverlessCacheSnapshot) {
            return serverlessCacheSnapshot(ServerlessCacheSnapshot.builder().applyMutation(serverlessCacheSnapshot).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private ServerlessCacheSnapshot serverlessCacheSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerlessCacheSnapshotResponse model) {
            super(model);
            serverlessCacheSnapshot(model.serverlessCacheSnapshot);
        }

        public final ServerlessCacheSnapshot.Builder getServerlessCacheSnapshot() {
            return serverlessCacheSnapshot != null ? serverlessCacheSnapshot.toBuilder() : null;
        }

        public final void setServerlessCacheSnapshot(ServerlessCacheSnapshot.BuilderImpl serverlessCacheSnapshot) {
            this.serverlessCacheSnapshot = serverlessCacheSnapshot != null ? serverlessCacheSnapshot.build() : null;
        }

        @Override
        public final Builder serverlessCacheSnapshot(ServerlessCacheSnapshot serverlessCacheSnapshot) {
            this.serverlessCacheSnapshot = serverlessCacheSnapshot;
            return this;
        }

        @Override
        public CreateServerlessCacheSnapshotResponse build() {
            return new CreateServerlessCacheSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
