/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUserGroupResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DeleteUserGroupResponse.Builder, DeleteUserGroupResponse> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(DeleteUserGroupResponse::userGroupId)).setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeleteUserGroupResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DeleteUserGroupResponse::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIds")
            .getter(getter(DeleteUserGroupResponse::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumEngineVersion").getter(getter(DeleteUserGroupResponse::minimumEngineVersion))
            .setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final SdkField<UserGroupPendingChanges> PENDING_CHANGES_FIELD = SdkField
            .<UserGroupPendingChanges> builder(MarshallingType.SDK_POJO).memberName("PendingChanges")
            .getter(getter(DeleteUserGroupResponse::pendingChanges)).setter(setter(Builder::pendingChanges))
            .constructor(UserGroupPendingChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingChanges").build()).build();

    private static final SdkField<List<String>> REPLICATION_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroups")
            .getter(getter(DeleteUserGroupResponse::replicationGroups))
            .setter(setter(Builder::replicationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVERLESS_CACHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ServerlessCaches")
            .getter(getter(DeleteUserGroupResponse::serverlessCaches))
            .setter(setter(Builder::serverlessCaches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCaches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(DeleteUserGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD,
            STATUS_FIELD, ENGINE_FIELD, USER_IDS_FIELD, MINIMUM_ENGINE_VERSION_FIELD, PENDING_CHANGES_FIELD,
            REPLICATION_GROUPS_FIELD, SERVERLESS_CACHES_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userGroupId;

    private final String status;

    private final String engine;

    private final List<String> userIds;

    private final String minimumEngineVersion;

    private final UserGroupPendingChanges pendingChanges;

    private final List<String> replicationGroups;

    private final List<String> serverlessCaches;

    private final String arn;

    private DeleteUserGroupResponse(BuilderImpl builder) {
        super(builder);
        this.userGroupId = builder.userGroupId;
        this.status = builder.status;
        this.engine = builder.engine;
        this.userIds = builder.userIds;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.pendingChanges = builder.pendingChanges;
        this.replicationGroups = builder.replicationGroups;
        this.serverlessCaches = builder.serverlessCaches;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the user group.
     * </p>
     * 
     * @return The ID of the user group.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * <p>
     * Indicates user group status. Can be "creating", "active", "modifying", "deleting".
     * </p>
     * 
     * @return Indicates user group status. Can be "creating", "active", "modifying", "deleting".
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The current supported value is Redis user.
     * </p>
     * 
     * @return The current supported value is Redis user.
     */
    public final String engine() {
        return engine;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserIds() {
        return userIds != null && !(userIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs that belong to the user group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIds} method.
     * </p>
     * 
     * @return The list of user IDs that belong to the user group.
     */
    public final List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * The minimum engine version required, which is Redis OSS 6.0
     * </p>
     * 
     * @return The minimum engine version required, which is Redis OSS 6.0
     */
    public final String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    /**
     * <p>
     * A list of updates being applied to the user group.
     * </p>
     * 
     * @return A list of updates being applied to the user group.
     */
    public final UserGroupPendingChanges pendingChanges() {
        return pendingChanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationGroups() {
        return replicationGroups != null && !(replicationGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication groups that the user group can access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroups} method.
     * </p>
     * 
     * @return A list of replication groups that the user group can access.
     */
    public final List<String> replicationGroups() {
        return replicationGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerlessCaches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerlessCaches() {
        return serverlessCaches != null && !(serverlessCaches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which serverless caches the specified user group is associated with. Available for Valkey, Redis OSS
     * and Serverless Memcached only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerlessCaches} method.
     * </p>
     * 
     * @return Indicates which serverless caches the specified user group is associated with. Available for Valkey,
     *         Redis OSS and Serverless Memcached only.
     */
    public final List<String> serverlessCaches() {
        return serverlessCaches;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user group.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIds() ? userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pendingChanges());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroups() ? replicationGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServerlessCaches() ? serverlessCaches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserGroupResponse)) {
            return false;
        }
        DeleteUserGroupResponse other = (DeleteUserGroupResponse) obj;
        return Objects.equals(userGroupId(), other.userGroupId()) && Objects.equals(status(), other.status())
                && Objects.equals(engine(), other.engine()) && hasUserIds() == other.hasUserIds()
                && Objects.equals(userIds(), other.userIds())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion())
                && Objects.equals(pendingChanges(), other.pendingChanges())
                && hasReplicationGroups() == other.hasReplicationGroups()
                && Objects.equals(replicationGroups(), other.replicationGroups())
                && hasServerlessCaches() == other.hasServerlessCaches()
                && Objects.equals(serverlessCaches(), other.serverlessCaches()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteUserGroupResponse").add("UserGroupId", userGroupId()).add("Status", status())
                .add("Engine", engine()).add("UserIds", hasUserIds() ? userIds() : null)
                .add("MinimumEngineVersion", minimumEngineVersion()).add("PendingChanges", pendingChanges())
                .add("ReplicationGroups", hasReplicationGroups() ? replicationGroups() : null)
                .add("ServerlessCaches", hasServerlessCaches() ? serverlessCaches() : null).add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        case "PendingChanges":
            return Optional.ofNullable(clazz.cast(pendingChanges()));
        case "ReplicationGroups":
            return Optional.ofNullable(clazz.cast(replicationGroups()));
        case "ServerlessCaches":
            return Optional.ofNullable(clazz.cast(serverlessCaches()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserGroupId", USER_GROUP_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("UserIds", USER_IDS_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        map.put("PendingChanges", PENDING_CHANGES_FIELD);
        map.put("ReplicationGroups", REPLICATION_GROUPS_FIELD);
        map.put("ServerlessCaches", SERVERLESS_CACHES_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserGroupResponse, T> g) {
        return obj -> g.apply((DeleteUserGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUserGroupResponse> {
        /**
         * <p>
         * The ID of the user group.
         * </p>
         * 
         * @param userGroupId
         *        The ID of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * Indicates user group status. Can be "creating", "active", "modifying", "deleting".
         * </p>
         * 
         * @param status
         *        Indicates user group status. Can be "creating", "active", "modifying", "deleting".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The current supported value is Redis user.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The list of user IDs that belong to the user group.
         * </p>
         * 
         * @param userIds
         *        The list of user IDs that belong to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The minimum engine version required, which is Redis OSS 6.0
         * </p>
         * 
         * @param minimumEngineVersion
         *        The minimum engine version required, which is Redis OSS 6.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);

        /**
         * <p>
         * A list of updates being applied to the user group.
         * </p>
         * 
         * @param pendingChanges
         *        A list of updates being applied to the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingChanges(UserGroupPendingChanges pendingChanges);

        /**
         * <p>
         * A list of updates being applied to the user group.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserGroupPendingChanges.Builder} avoiding
         * the need to create one manually via {@link UserGroupPendingChanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserGroupPendingChanges.Builder#build()} is called immediately
         * and its result is passed to {@link #pendingChanges(UserGroupPendingChanges)}.
         * 
         * @param pendingChanges
         *        a consumer that will call methods on {@link UserGroupPendingChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingChanges(UserGroupPendingChanges)
         */
        default Builder pendingChanges(Consumer<UserGroupPendingChanges.Builder> pendingChanges) {
            return pendingChanges(UserGroupPendingChanges.builder().applyMutation(pendingChanges).build());
        }

        /**
         * <p>
         * A list of replication groups that the user group can access.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups that the user group can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(Collection<String> replicationGroups);

        /**
         * <p>
         * A list of replication groups that the user group can access.
         * </p>
         * 
         * @param replicationGroups
         *        A list of replication groups that the user group can access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroups(String... replicationGroups);

        /**
         * <p>
         * Indicates which serverless caches the specified user group is associated with. Available for Valkey, Redis
         * OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCaches
         *        Indicates which serverless caches the specified user group is associated with. Available for Valkey,
         *        Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCaches(Collection<String> serverlessCaches);

        /**
         * <p>
         * Indicates which serverless caches the specified user group is associated with. Available for Valkey, Redis
         * OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCaches
         *        Indicates which serverless caches the specified user group is associated with. Available for Valkey,
         *        Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCaches(String... serverlessCaches);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the user group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String userGroupId;

        private String status;

        private String engine;

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private String minimumEngineVersion;

        private UserGroupPendingChanges pendingChanges;

        private List<String> replicationGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> serverlessCaches = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserGroupResponse model) {
            super(model);
            userGroupId(model.userGroupId);
            status(model.status);
            engine(model.engine);
            userIds(model.userIds);
            minimumEngineVersion(model.minimumEngineVersion);
            pendingChanges(model.pendingChanges);
            replicationGroups(model.replicationGroups);
            serverlessCaches(model.serverlessCaches);
            arn(model.arn);
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Collection<String> getUserIds() {
            if (userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final UserGroupPendingChanges.Builder getPendingChanges() {
            return pendingChanges != null ? pendingChanges.toBuilder() : null;
        }

        public final void setPendingChanges(UserGroupPendingChanges.BuilderImpl pendingChanges) {
            this.pendingChanges = pendingChanges != null ? pendingChanges.build() : null;
        }

        @Override
        public final Builder pendingChanges(UserGroupPendingChanges pendingChanges) {
            this.pendingChanges = pendingChanges;
            return this;
        }

        public final Collection<String> getReplicationGroups() {
            if (replicationGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationGroups;
        }

        public final void setReplicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
        }

        @Override
        public final Builder replicationGroups(Collection<String> replicationGroups) {
            this.replicationGroups = UGReplicationGroupIdListCopier.copy(replicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroups(String... replicationGroups) {
            replicationGroups(Arrays.asList(replicationGroups));
            return this;
        }

        public final Collection<String> getServerlessCaches() {
            if (serverlessCaches instanceof SdkAutoConstructList) {
                return null;
            }
            return serverlessCaches;
        }

        public final void setServerlessCaches(Collection<String> serverlessCaches) {
            this.serverlessCaches = UGServerlessCacheIdListCopier.copy(serverlessCaches);
        }

        @Override
        public final Builder serverlessCaches(Collection<String> serverlessCaches) {
            this.serverlessCaches = UGServerlessCacheIdListCopier.copy(serverlessCaches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCaches(String... serverlessCaches) {
            serverlessCaches(Arrays.asList(serverlessCaches));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DeleteUserGroupResponse build() {
            return new DeleteUserGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
