/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeReservedCacheNodesOfferings</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedCacheNodesOfferingsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeReservedCacheNodesOfferingsResponse.Builder, DescribeReservedCacheNodesOfferingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedCacheNodesOfferingsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReservedCacheNodesOffering>> RESERVED_CACHE_NODES_OFFERINGS_FIELD = SdkField
            .<List<ReservedCacheNodesOffering>> builder(MarshallingType.LIST)
            .memberName("ReservedCacheNodesOfferings")
            .getter(getter(DescribeReservedCacheNodesOfferingsResponse::reservedCacheNodesOfferings))
            .setter(setter(Builder::reservedCacheNodesOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedCacheNodesOffering")
                            .memberFieldInfo(
                                    SdkField.<ReservedCacheNodesOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedCacheNodesOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedCacheNodesOffering").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            RESERVED_CACHE_NODES_OFFERINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings;

    private DescribeReservedCacheNodesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedCacheNodesOfferings = builder.reservedCacheNodesOfferings;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedCacheNodesOfferings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedCacheNodesOfferings() {
        return reservedCacheNodesOfferings != null && !(reservedCacheNodesOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of reserved cache node offerings. Each element in the list contains detailed information about one
     * offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedCacheNodesOfferings} method.
     * </p>
     * 
     * @return A list of reserved cache node offerings. Each element in the list contains detailed information about one
     *         offering.
     */
    public final List<ReservedCacheNodesOffering> reservedCacheNodesOfferings() {
        return reservedCacheNodesOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedCacheNodesOfferings() ? reservedCacheNodesOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCacheNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedCacheNodesOfferingsResponse other = (DescribeReservedCacheNodesOfferingsResponse) obj;
        return Objects.equals(marker(), other.marker())
                && hasReservedCacheNodesOfferings() == other.hasReservedCacheNodesOfferings()
                && Objects.equals(reservedCacheNodesOfferings(), other.reservedCacheNodesOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedCacheNodesOfferingsResponse").add("Marker", marker())
                .add("ReservedCacheNodesOfferings", hasReservedCacheNodesOfferings() ? reservedCacheNodesOfferings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReservedCacheNodesOfferings":
            return Optional.ofNullable(clazz.cast(reservedCacheNodesOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("ReservedCacheNodesOfferings", RESERVED_CACHE_NODES_OFFERINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCacheNodesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedCacheNodesOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedCacheNodesOfferingsResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param marker
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of reserved cache node offerings. Each element in the list contains detailed information about one
         * offering.
         * </p>
         * 
         * @param reservedCacheNodesOfferings
         *        A list of reserved cache node offerings. Each element in the list contains detailed information about
         *        one offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings);

        /**
         * <p>
         * A list of reserved cache node offerings. Each element in the list contains detailed information about one
         * offering.
         * </p>
         * 
         * @param reservedCacheNodesOfferings
         *        A list of reserved cache node offerings. Each element in the list contains detailed information about
         *        one offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering... reservedCacheNodesOfferings);

        /**
         * <p>
         * A list of reserved cache node offerings. Each element in the list contains detailed information about one
         * offering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #reservedCacheNodesOfferings(List<ReservedCacheNodesOffering>)}.
         * 
         * @param reservedCacheNodesOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedCacheNodesOfferings(java.util.Collection<ReservedCacheNodesOffering>)
         */
        Builder reservedCacheNodesOfferings(Consumer<ReservedCacheNodesOffering.Builder>... reservedCacheNodesOfferings);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReservedCacheNodesOffering> reservedCacheNodesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCacheNodesOfferingsResponse model) {
            super(model);
            marker(model.marker);
            reservedCacheNodesOfferings(model.reservedCacheNodesOfferings);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ReservedCacheNodesOffering.Builder> getReservedCacheNodesOfferings() {
            List<ReservedCacheNodesOffering.Builder> result = ReservedCacheNodesOfferingListCopier
                    .copyToBuilder(this.reservedCacheNodesOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedCacheNodesOfferings(
                Collection<ReservedCacheNodesOffering.BuilderImpl> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copyFromBuilder(reservedCacheNodesOfferings);
        }

        @Override
        public final Builder reservedCacheNodesOfferings(Collection<ReservedCacheNodesOffering> reservedCacheNodesOfferings) {
            this.reservedCacheNodesOfferings = ReservedCacheNodesOfferingListCopier.copy(reservedCacheNodesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(ReservedCacheNodesOffering... reservedCacheNodesOfferings) {
            reservedCacheNodesOfferings(Arrays.asList(reservedCacheNodesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCacheNodesOfferings(
                Consumer<ReservedCacheNodesOffering.Builder>... reservedCacheNodesOfferings) {
            reservedCacheNodesOfferings(Stream.of(reservedCacheNodesOfferings)
                    .map(c -> ReservedCacheNodesOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedCacheNodesOfferingsResponse build() {
            return new DescribeReservedCacheNodesOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
