/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the destination, format and type of the logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogDeliveryConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<LogDeliveryConfigurationRequest.Builder, LogDeliveryConfigurationRequest> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(LogDeliveryConfigurationRequest::logTypeAsString))
            .setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(LogDeliveryConfigurationRequest::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()).build();

    private static final SdkField<DestinationDetails> DESTINATION_DETAILS_FIELD = SdkField
            .<DestinationDetails> builder(MarshallingType.SDK_POJO).memberName("DestinationDetails")
            .getter(getter(LogDeliveryConfigurationRequest::destinationDetails)).setter(setter(Builder::destinationDetails))
            .constructor(DestinationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDetails").build())
            .build();

    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFormat").getter(getter(LogDeliveryConfigurationRequest::logFormatAsString))
            .setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(LogDeliveryConfigurationRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD,
            DESTINATION_TYPE_FIELD, DESTINATION_DETAILS_FIELD, LOG_FORMAT_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logType;

    private final String destinationType;

    private final DestinationDetails destinationDetails;

    private final String logFormat;

    private final Boolean enabled;

    private LogDeliveryConfigurationRequest(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destinationType = builder.destinationType;
        this.destinationDetails = builder.destinationDetails;
        this.logFormat = builder.logFormat;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     * </p>
     * 
     * @return Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     */
    public final DestinationDetails destinationDetails() {
        return destinationDetails;
    }

    /**
     * <p>
     * Specifies either JSON or TEXT
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Specifies either JSON or TEXT
     * @see LogFormat
     */
    public final LogFormat logFormat() {
        return LogFormat.fromValue(logFormat);
    }

    /**
     * <p>
     * Specifies either JSON or TEXT
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Specifies either JSON or TEXT
     * @see LogFormat
     */
    public final String logFormatAsString() {
        return logFormat;
    }

    /**
     * <p>
     * Specify if log delivery is enabled. Default <code>true</code>.
     * </p>
     * 
     * @return Specify if log delivery is enabled. Default <code>true</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDeliveryConfigurationRequest)) {
            return false;
        }
        LogDeliveryConfigurationRequest other = (LogDeliveryConfigurationRequest) obj;
        return Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationDetails(), other.destinationDetails())
                && Objects.equals(logFormatAsString(), other.logFormatAsString()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogDeliveryConfigurationRequest").add("LogType", logTypeAsString())
                .add("DestinationType", destinationTypeAsString()).add("DestinationDetails", destinationDetails())
                .add("LogFormat", logFormatAsString()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DestinationDetails":
            return Optional.ofNullable(clazz.cast(destinationDetails()));
        case "LogFormat":
            return Optional.ofNullable(clazz.cast(logFormatAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogType", LOG_TYPE_FIELD);
        map.put("DestinationType", DESTINATION_TYPE_FIELD);
        map.put("DestinationDetails", DESTINATION_DETAILS_FIELD);
        map.put("LogFormat", LOG_FORMAT_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogDeliveryConfigurationRequest, T> g) {
        return obj -> g.apply((LogDeliveryConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogDeliveryConfigurationRequest> {
        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
         * </p>
         * 
         * @param destinationType
         *        Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
         * </p>
         * 
         * @param destinationType
         *        Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * 
         * @param destinationDetails
         *        Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDetails(DestinationDetails destinationDetails);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationDetails.Builder} avoiding the
         * need to create one manually via {@link DestinationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationDetails(DestinationDetails)}.
         * 
         * @param destinationDetails
         *        a consumer that will call methods on {@link DestinationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDetails(DestinationDetails)
         */
        default Builder destinationDetails(Consumer<DestinationDetails.Builder> destinationDetails) {
            return destinationDetails(DestinationDetails.builder().applyMutation(destinationDetails).build());
        }

        /**
         * <p>
         * Specifies either JSON or TEXT
         * </p>
         * 
         * @param logFormat
         *        Specifies either JSON or TEXT
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(String logFormat);

        /**
         * <p>
         * Specifies either JSON or TEXT
         * </p>
         * 
         * @param logFormat
         *        Specifies either JSON or TEXT
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(LogFormat logFormat);

        /**
         * <p>
         * Specify if log delivery is enabled. Default <code>true</code>.
         * </p>
         * 
         * @param enabled
         *        Specify if log delivery is enabled. Default <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String logType;

        private String destinationType;

        private DestinationDetails destinationDetails;

        private String logFormat;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LogDeliveryConfigurationRequest model) {
            logType(model.logType);
            destinationType(model.destinationType);
            destinationDetails(model.destinationDetails);
            logFormat(model.logFormat);
            enabled(model.enabled);
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final DestinationDetails.Builder getDestinationDetails() {
            return destinationDetails != null ? destinationDetails.toBuilder() : null;
        }

        public final void setDestinationDetails(DestinationDetails.BuilderImpl destinationDetails) {
            this.destinationDetails = destinationDetails != null ? destinationDetails.build() : null;
        }

        @Override
        public final Builder destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public final String getLogFormat() {
            return logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormat logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public LogDeliveryConfigurationRequest build() {
            return new LogDeliveryConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
